/* This file was generated by mib2c and is intended for use as a mib module
   for the ucd-snmp snmpd agent. */


#ifdef IN_UCD_SNMP_SOURCE
/* If we're compiling this file inside the ucd-snmp source tree */


/* This should always be included first before anything else */
#include <config.h>


/* minimal include directives */
#include "mibincl.h"
#include "util_funcs.h"




#else /* !IN_UCD_SNMP_SOURCE */


#include <ucd-snmp/ucd-snmp-config.h>
#include <ucd-snmp/ucd-snmp-includes.h>
#include <ucd-snmp/ucd-snmp-agent-includes.h>


#endif /* !IN_UCD_SNMP_SOURCE */


#include "nctuSnmp.h"

#include "apmib.h"
#include "mibtbl.h"
#include <sys/types.h>
#include <signal.h>

typedef unsigned short 		char_t;

#define WEB_PID_FILE "/var/run/webs.pid" 



/* 
 * nctuSnmp_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */




oid nctuSnmp_variables_oid[] = { 1,3,6,1,4,1,1234,1 };



/* 
 * variable2 nctuSnmp_variables:
 *   this variable defines function callbacks and type return information 
 *   for the nctuSnmp mib section 
 */


struct variable2 nctuSnmp_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define   REINITIALIZATION      1
  { REINITIALIZATION    , ASN_INTEGER   , RWRITE, var_nctuSnmp, 1, { 1 } },
#define   SUBMIT                2
  { SUBMIT              , ASN_INTEGER   , RWRITE, var_nctuSnmp, 1, { 2 } },
#define   RWCOMMUNITY           3
  { RWCOMMUNITY         , ASN_OCTET_STR , RWRITE, var_nctuSnmp, 1, { 3 } },
#define   ROCOMMUNITY           4
  { ROCOMMUNITY         , ASN_OCTET_STR , RWRITE, var_nctuSnmp, 1, { 4 } },

};
/*    (L = length of the oidsuffix) */


/*
 * init_nctuSnmp():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void init_nctuSnmp(void) {

  unsigned char buffer[100];
  /* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("nctuSnmp", nctuSnmp_variables, variable2,
               nctuSnmp_variables_oid);

}

void deinit_nctuSnmp(void) {
    DEBUGMSGTL(("realtekPropMib","unloading\n"));
    unregister_mib(nctuSnmp_variables_oid,
                   sizeof(nctuSnmp_variables_oid)/sizeof(oid));
}
/*
#define PRINT_PARAMETER snmp_log(LOG_INFO, "var_len = %d\n", *length);\
	snmp_log(LOG_INFO, "var_len = %d\n", *var_len);\
	snmp_log(LOG_INFO, "exact = %d\n", exact);\
	for(i = 0; i < *length; i++){\
		snmp_log(LOG_INFO, ".%d", name[i]);\
	}\
    snmp_log(LOG_INFO, "\n");
*/


/*
 * var_nctuSnmp():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_nctuSnmp(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{


  /* variables we may use later */
  static long long_ret;
  static u_long ulong_ret;
  static unsigned char string[SPRINT_MAX_LEN];
  static oid objid[MAX_OID_LEN];
  static struct counter64 c64;
  
  int i;
  
//  snmp_log(LOG_INFO, "=========before header_simple_table=======\n");\
//  PRINT_PARAMETER;


  if (header_generic(vp,name,length,exact,var_len,write_method)
                                  == MATCH_FAILED ){
//  	snmp_log(LOG_INFO, "=========return by header_generic=======\n");
//    PRINT_PARAMETER;
								  
    	return NULL;
  }

//	snmp_log(LOG_INFO, "=========after header_generic=======\n");
//	PRINT_PARAMETER;


  /* 
   * this is where we do the value assignments for the mib results.
   */

	
  switch(vp->magic) {


    case REINITIALIZATION:
        *write_method = write_reinitialization;
        long_ret = 0;
        return (unsigned char *) &long_ret;

    case SUBMIT:
        *write_method = write_submit;
        long_ret = 0;
        return (unsigned char *) &long_ret;

    case RWCOMMUNITY:
        *write_method = write_rwCommunity;
		apmib_get(MIB_SNMP_RWCOMMUNITY,string);
        *var_len = strlen(string);		
        return (unsigned char *) string;

    case ROCOMMUNITY:
        *write_method = write_roCommunity;
		apmib_get(MIB_SNMP_ROCOMMUNITY,string);
        *var_len = strlen(string);		
        return (unsigned char *) string;


    default:
      ERROR_MSG("");
  }
  return NULL;
}





int
write_reinitialization(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static long *long_ret;
  int size;


  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_INTEGER){
              fprintf(stderr, "write to reinitialization not ASN_INTEGER\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(long_ret)){
              fprintf(stderr,"write to reinitialization: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;

        case RESERVE2:
        case FREE:
        case COMMIT:
        case UNDO:
          break;
        case ACTION:
		{
      		FILE *fp;
	   		char_t line[30];
	   		pid_t pid;
	   		if ((fp = fopen(WEB_PID_FILE, "r")) != NULL) {
		   		fgets(line, sizeof(line), fp);
		   		if ( sscanf(line, "%d", &pid) ) {
			   		if (pid > 1){
			   			//kill(pid, SIGTERM);
			   			sprintf(line, "kill -USR1 %d", pid);
						snmp_log(LOG_INFO, "reinitialization %s\n", line);
			   			system(line);
			   		}
					else
						return SNMP_ERR_BADVALUE;
		   		}
				else
					return SNMP_ERR_BADVALUE;
				
		   		fclose(fp);
	   		}
			else{
				return SNMP_NOSUCHINSTANCE;
			}
        }
        
          break;
  }
  return SNMP_ERR_NOERROR;
}



int
write_submit(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static long *long_ret;
  int size;


  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_INTEGER){
              fprintf(stderr, "write to submit not ASN_INTEGER\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(long_ret)){
              fprintf(stderr,"write to submit: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;


        case RESERVE2:
        case FREE:
        case UNDO:
        case COMMIT:
          break;

        case ACTION:
		  apmib_update(CURRENT_SETTING);


		  {
		    FILE *fp;
	   		char_t line[30];
	   		pid_t pid;
	   		if ((fp = fopen(WEB_PID_FILE, "r")) != NULL) {
		   		fgets(line, sizeof(line), fp);
		   		if ( sscanf(line, "%d", &pid) ) {
			   		if (pid > 1){
			   			//kill(pid, SIGTERM);
			   			sprintf(line, "kill -USR1 %d", pid);
						snmp_log(LOG_INFO, "reinitialization %s\n", line);
			   			system(line);
			   		}
					else
						return SNMP_ERR_BADVALUE;
		   		}
				else
					return SNMP_ERR_BADVALUE;
				
		   		fclose(fp);
	   		}
			else{
				return SNMP_NOSUCHINSTANCE;
			}
		  }
          break;

  }
  return SNMP_ERR_NOERROR;
}




int
write_rwCommunity(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  //static unsigned char *new_string = 0, *old_string = 0;
  //static size_t size, old_size;
  char buffer[128];
  int i;

 /* this long complex series of "action"s is to preserve proper
    transaction handling with other transactions in the same set
    request. */


  switch ( action ) {
        case RESERVE1:
          /* check to see that everything is possible */
          if (var_val_type != ASN_OCTET_STR){
              fprintf(stderr, "write to ustSSSimpleString not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          break;

        case RESERVE2:
          /* allocate memory needed here. */
          //size = var_val_len;
          //new_string = (char *) malloc(size+1);
          //if (new_string == NULL) {
          //  return SNMP_ERR_GENERR; /* malloc failed! */
          //}
          break;

        case ACTION:
			/* Actually make the change requested.  Note that
			anything done here must be reversable in the UNDO case */
          memcpy(buffer, var_val, var_val_len);
          buffer[var_val_len] = 0;

          if(!apmib_set(MIB_SNMP_RWCOMMUNITY,buffer))
              return SNMP_NOSUCHINSTANCE;
          break;

        case UNDO:
        case COMMIT:
        case FREE:
          break;

  }
  return SNMP_ERR_NOERROR;
}




int
write_roCommunity(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
	char buffer[128];

  switch ( action ) {
        case RESERVE1:
          /* check to see that everything is possible */
          if (var_val_type != ASN_OCTET_STR){
              fprintf(stderr, "write to ustSSSimpleString not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          break;

        case RESERVE2:
          break;

        case ACTION:
			/* Actually make the change requested.  Note that
			anything done here must be reversable in the UNDO case */
          memcpy(buffer, var_val, var_val_len);
          buffer[var_val_len] = 0;

          if(!apmib_set(MIB_SNMP_ROCOMMUNITY,buffer))
              return SNMP_NOSUCHINSTANCE;
          break;

        case UNDO:
        case COMMIT:
        case FREE:
          break;

  }
  return SNMP_ERR_NOERROR;
}
