#!/bin/sh
#
# script file to start network
#
# Usage: init.sh {gw | ap} {all | bridge | wan}
#

if [ $# -lt 2 ]; then echo "Usage: $0 {gw | ap} {all | bridge | wan}"; exit 1 ; fi

TOOL=flash
GETMIB="$TOOL get"
LOADDEF="$TOOL default"
LOADDEFSW="$TOOL default-sw"
LOADDS="$TOOL reset"
SET_IP=fixedip.sh
START_DHCP_SERVER=dhcpd.sh
START_DHCP_CLIENT=dhcpc.sh
START_BRIDGE=bridge.sh
START_WLAN=wlan.sh
START_PPPOE=pppoe.sh
START_FIREWALL=firewall.sh
START_WLAN_APP=wlanapp.sh
START_PPTP=pptp.sh
START_NTP=ntp.sh
START_DDNS=ddns.sh
WLAN_PREFIX=wlan
PLUTO_PID=/var/run/pluto.pid
RESOLV_CONF="/etc/resolv.conf"
# Query number of wlan interface
WLAN_INTERFACE=
NUM=0

DATA=`ifconfig -a | grep $WLAN_PREFIX`
LINE=`echo $DATA | grep $WLAN_PREFIX$NUM`
NAME=`echo $LINE | cut -b -5`
while [ -n "$NAME" ] 
do
	WLAN_INTERFACE="$WLAN_INTERFACE $WLAN_PREFIX$NUM"
	NUM=`expr $NUM + 1`
	LINE=`echo $DATA | grep $WLAN_PREFIX$NUM`
	NAME=`echo $LINE | cut -b -5`
done
NUM_INTERFACE=$NUM

# See if flash data is valid
$TOOL test-hwconf
if [ $? != 0 ]; then
	echo 'HW configuration invalid, reset default!'
	$LOADDEF
fi

$TOOL test-dsconf
if [ $? != 0 ]; then
	echo 'Default configuration invalid, reset default!'
	$LOADDEFSW
fi

$TOOL test-csconf
if [ $? != 0 ]; then
	echo 'Current configuration invalid, reset to default configuration!'
	$LOADDS
fi

eval `$GETMIB OP_MODE`
eval `$GETMIB WISP_WAN_ID`
if [ $1 = 'ap' ]; then
### bridge (eth0+wlan0) confiuration #########
	GATEWAY='false'
	BR_INTERFACE=br0
	BR_LAN1_INTERFACE=eth0	
	if [ "$OP_MODE" = '1' ];then
		BR_LAN2_INTERFACE=eth1
	fi	
##############################################
fi

if [ $1 = 'gw' ]; then
### gateway (eth0+eth1+wlan0) configuration ##
	GATEWAY='true'
	if [ "$OP_MODE" = '2' ];then
		WAN_INTERFACE=wlan$WISP_WAN_ID
	else
		WAN_INTERFACE=eth1
	fi
	BR_INTERFACE=br0	
	BR_LAN1_INTERFACE=eth0
	if [ "$OP_MODE" = '1' ] || [ "$OP_MODE" = '2' ]; then
		BR_LAN2_INTERFACE=eth1
	fi
##############################################
fi

if [ $2 = 'all' ]; then
	ENABLE_WAN=1
	ENABLE_BR=1
elif [ $2 = 'wan' ]; then
	ENABLE_WAN=1
	# for miniigd patch	
	ENABLE_BR=1
elif [ $2 = 'bridge' ]; then
	# if WISP mode , restart wan  for pppoe  ,pptp
	# if [ "$OP_MODE" = '2' ]; then 
		#ENABLE_WAN=1
	#else
		#ENABLE_WAN=0
	#fi
	# for miniigd patch	
		ENABLE_WAN=1
	ENABLE_BR=1
elif [ $2 = 'wlan_app' ]; then
	$START_WLAN_APP start $WLAN_INTERFACE $BR_INTERFACE
	exit 0	
else
	echo "Usage: $0 {all | bridge | wan}"; exit 1
fi


# Set Ethernet 0 MAC address
eval `$GETMIB ELAN_MAC_ADDR`
if [ "$ELAN_MAC_ADDR" = "000000000000" ]; then
	eval `$GETMIB HW_NIC0_ADDR`
	ELAN_MAC_ADDR=$HW_NIC0_ADDR
fi
ifconfig $BR_LAN1_INTERFACE hw ether $ELAN_MAC_ADDR

# Set Ethernet 1 MAC Address for bridge mode and WISP
eval `$GETMIB ELAN_MAC_ADDR`
if [ "$OP_MODE" = '1' ]  || [ "$OP_MODE" = '2' ]; then
	if [ "$ELAN_MAC_ADDR" = "000000000000" ]; then
		eval `$GETMIB HW_NIC1_ADDR`
		ELAN_MAC_ADDR=$HW_NIC1_ADDR
	fi
	ifconfig $BR_LAN2_INTERFACE hw ether $ELAN_MAC_ADDR
fi

# Disable DELAY_RX in Ethernet driver when do WIFI test
eval `$GETMIB WIFI_SPECIFIC`
if [  "$WIFI_SPECIFIC" != 0 ]; then
	echo 1 > /proc/eth_flag
fi

#don't setup WAN in bridge mode
if [ "$GATEWAY" = 'true' ] && [ "$OP_MODE" != '1' ] ; then 
	eval `$GETMIB WAN_MAC_ADDR`
	if [ "$WAN_MAC_ADDR" = "000000000000" ]; then
		if [ "$OP_MODE" = '2' ]; then  #wireless ISP, use the WLAN mac address
			eval `$GETMIB wlan$WISP_WAN_ID HW_WLAN_ADDR`
			WAN_MAC_ADDR=$HW_WLAN_ADDR		
		else
			eval `$GETMIB HW_NIC1_ADDR`
			WAN_MAC_ADDR=$HW_NIC1_ADDR
		fi
	fi
	ifconfig $WAN_INTERFACE hw ether $WAN_MAC_ADDR
fi

# for miniigd patch	
if [ "$GATEWAY" = 'true' ]; then
	IGD_PID_FILE=/var/run/miniupnpd.pid
	killall -15 miniigd 2> /dev/null
	if [ -f "$IGD_PID_FILE" ]; then
		rm -f $IGD_PID_FILE
	fi
fi

if [ $ENABLE_WAN = 1 -a "$GATEWAY" = 'true' ]; then  #disconnect all wan  for vpn and wisp
	# stop vpn if enabled
	if [ -f $PLUTO_PID ];then
		ipsec setup stop
	fi	
	killall -9 pptp.sh
	killall -9 pppoe.sh
	rm -f /etc/ppp/first*
	disconnect.sh all
fi

# Start WLAN interface
NUM=0
while [ $NUM -lt $NUM_INTERFACE -a $ENABLE_BR = 1  ]
do
	echo 'Initialize '$WLAN_PREFIX$NUM' interface'
	$TOOL set_mib $WLAN_PREFIX$NUM
	if [ $? != 0 ] ; then
		echo 'Using wlan script...'
		$START_WLAN $WLAN_PREFIX$NUM
	fi
	NUM=`expr $NUM + 1`
done		

# check repeater interface for wlan0
WLAN_INTERFACE_REPEATER=$WLAN_INTERFACE
eval `$GETMIB REPEATER_ENABLED1`
eval `$GETMIB wlan0 MODE`
eval `$GETMIB wlan0 NETWORK_TYPE`
ifconfig wlan0-vxd down
if  [ "$REPEATER_ENABLED1" != 0 ] && [ "$MODE" != 2 ]; then
	if [ "$MODE" != 1 ] || [ "$MODE" = 1  -a "$NETWORK_TYPE" != 1 ]; then
		WLAN_INTERFACE_REPEATER="$WLAN_INTERFACE_REPEATER wlan0-vxd"	
	fi
fi

# check repeater interface for wlan1
if [ $NUM_INTERFACE -lt 1  ]; then
	ifconfig wlan1-vxd down
	eval `$GETMIB wlan1 MODE`
	eval `$GETMIB wlan1 NETWORK_TYPE`	
	eval `$GETMIB REPEATER_ENABLED2`
	if  [ "$REPEATER_ENABLED2" != 0 ] && [ "$MODE" != 2 ]; then
		if [ "$MODE" != 1 ] || [ "$MODE" = 1  -a "$NETWORK_TYPE" != 1 ]; then
			WLAN_INTERFACE_REPEATER="$WLAN_INTERFACE_REPEATER wlan1-vxd"	
		fi
	fi
fi	

if [ "$GATEWAY" = 'true' ]; then
	if [ $ENABLE_BR = 1 ]; then
		echo 'Setup BRIDGE interface'
		PIDFILE=/etc/udhcpc/udhcpc-$BR_INTERFACE.pid
		if [ -f $PIDFILE ] ; then
			PID=`cat $PIDFILE`
			if [ $PID != 0 ]; then
				kill -9 $PID
			fi
			rm -f $PIDFILE
		fi
		#kill syslogd and klogd
		killall syslogd
		killall klogd
		#Initialize bridge interface
		$START_BRIDGE $BR_INTERFACE $BR_LAN1_INTERFACE $WLAN_INTERFACE_REPEATER $BR_LAN2_INTERFACE
		eval `$GETMIB SCRLOG_ENABLED`
		if [ $SCRLOG_ENABLED != 0 -a $SCRLOG_ENABLED != 2 ] &&
			[ $SCRLOG_ENABLED != 4 -a $SCRLOG_ENABLED != 6 ] &&
			[ $SCRLOG_ENABLED != 8 -a $SCRLOG_ENABLED != 10 ] &&
			[ $SCRLOG_ENABLED != 12 -a  $SCRLOG_ENABLED != 14 ]; then			
			eval `$GETMIB REMOTELOG_ENABLED`
			eval `$GETMIB REMOTELOG_SERVER`
			if [ $REMOTELOG_ENABLED = "1" ] ;then
				SYSLOG_PARA="-R $REMOTELOG_SERVER"
			fi 
			syslogd -L $SYSLOG_PARA &
			klogd &
		fi

		# Set fixed IP or start DHCP server
		PIDFILE=/var/run/udhcpd.pid
		if [ -f $PIDFILE ] ; then
			PID=`cat $PIDFILE`
			if [ $PID != 0 ]; then
				kill -16 $PID
				sleep 1
				kill -9 $PID
	        	fi
        		rm -f $PIDFILE
		fi

		eval `$GETMIB DHCP`
		if [ "$DHCP" = '0' ]; then
			eval `$GETMIB IP_ADDR`
			eval `$GETMIB SUBNET_MASK`
			eval `$GETMIB DEFAULT_GATEWAY`			
			$SET_IP $BR_INTERFACE $IP_ADDR $SUBNET_MASK $DEFAULT_GATEWAY
			$START_WLAN_APP start $WLAN_INTERFACE $BR_INTERFACE		

		elif [ "$DHCP" = '2' ]; then		
			# caculate wait time
			NUM=0
			WAIT_TIME=0
			while [ $NUM -lt $NUM_INTERFACE  ]
			do				
				eval `$GETMIB $WLAN_PREFIX$NUM WDS_ENABLED`				
				if [ "$WDS_ENABLED" != 0 ]; then
					WAIT_TIME=`expr $WAIT_TIME + 5`
				else				
					WAIT_TIME=`expr $WAIT_TIME + 1`
				fi				
				NUM=`expr $NUM + 1`
			done				
			sleep $WAIT_TIME
			
			$START_DHCP_SERVER $BR_INTERFACE gw
			$START_WLAN_APP start $WLAN_INTERFACE $BR_INTERFACE
		fi
	fi

	if [ $ENABLE_WAN = 1 ]; then
		if [ "$OP_MODE" != '1' ];then
			echo 'Setup WAN interface'
		fi		

		# Initialize WAN interface
		# Delete DHCP client process
		DHCPC_WAN="$WLAN_INTERFACE eth1"
		for INTF in $DHCPC_WAN ; do
			PIDFILE=/etc/udhcpc/udhcpc-$INTF.pid
			if [ -f $PIDFILE ] ; then
				PID=`cat $PIDFILE`
				if [ $PID != 0 ]; then
					kill -9 $PID
				fi
				rm -f $PIDFILE
			fi
		done

		PIDFILE=/var/run/dnrd.pid
		if [ -f $PIDFILE ] ; then
			PID=`cat $PIDFILE`
			if [ $PID != 0 ]; then
				kill -9 $PID
	        	fi
        		rm -f $PIDFILE
		fi
		
		eval `$GETMIB WAN_DHCP`
###Re-set iptables rules, we accept lan packet only when wan is not available###		
		iptables -F 
		iptables -F -t nat
		if [ $WAN_DHCP = 0 ] || [ $WAN_DHCP = 1 ]; then
			IFACE=eth1
		fi
		if [ $WAN_DHCP = 3 ] || [ $WAN_DHCP = 4 ]; then
			IFACE=ppp0
		fi
		iptables -A INPUT -i ! $IFACE -j ACCEPT
##################################################
		
		if [ "$OP_MODE" != '1' ];then  # not bridge mode
		
################################################################		
# When WISP mode and WPA/WPA2 enabled, set keep_rsnie mib before 
# reinit wlan interface
			if [ "$OP_MODE" = '2' ];then		
				eval `$GETMIB ENCRYPT`
				if [ "$ENCRYPT" != "0" ]; then
					iwpriv $WAN_INTERFACE set_mib keep_rsnie=1
				fi
			fi
##################################################### 12-18-2006
			
			ifconfig $WAN_INTERFACE down
			ifconfig $WAN_INTERFACE up
						
			# Realtek fast pptp forwarding
			if [ $WAN_DHCP = 4 ]; then
				echo "1" > /proc/fast_pptp
			else
				echo "0" > /proc/fast_pptp
			fi						
						
			if [ "$WAN_DHCP" = '0' ]; then
				eval `$GETMIB WAN_IP_ADDR`
				eval `$GETMIB WAN_SUBNET_MASK`
				eval `$GETMIB WAN_DEFAULT_GATEWAY`
				eval `$GETMIB FIXED_IP_MTU_SIZE`				
				$SET_IP $WAN_INTERFACE $WAN_IP_ADDR $WAN_SUBNET_MASK $WAN_DEFAULT_GATEWAY
				ifconfig $WAN_INTERFACE mtu $FIXED_IP_MTU_SIZE					

				# start DNS relay
				eval `$GETMIB DNS1`
				DNS="--cache=off"
				if [ "$DNS1" != '0.0.0.0' ]; then
					DNS="$DNS -s $DNS1"
					echo nameserver $DNS1 >> $RESOLV_CONF
				fi
				eval `$GETMIB DNS2`
				if [ "$DNS2" != '0.0.0.0' ]; then
					DNS="$DNS -s $DNS2"
					echo nameserver $DNS2 >> $RESOLV_CONF
				fi
				eval `$GETMIB DNS3`
				if [ "$DNS3" != '0.0.0.0' ]; then
					DNS="$DNS -s $DNS3"
					echo nameserver $DNS3 >> $RESOLV_CONF
				fi
				echo start DNS Relay Daemon
				dnrd $DNS

				# for miniigd patch	
				upnp.sh init
			elif [ "$WAN_DHCP" = '1' ]; then				
				eval `$GETMIB DHCP_MTU_SIZE`
				ifconfig $WAN_INTERFACE mtu $DHCP_MTU_SIZE
				$START_DHCP_CLIENT $WAN_INTERFACE wait&				
				
				# for miniigd patch	
				upnp.sh init
			elif [ "$WAN_DHCP" = '3' ]; then
				echo 'start PPPoE daemon'
				
				# for miniigd patch	
				upnp.sh init
				$START_PPPOE all $WAN_INTERFACE
			elif [ "$WAN_DHCP" = '4' ]; then
				echo 'start PPTP daemon'
				
				# for miniigd patch	
				upnp.sh init
				$START_PPTP $WAN_INTERFACE &
			else
				echo 'Invalid DHCP MIB value for WAN interface!'
			fi
		fi

		# enable firewall when static ip
		if [ "$WAN_DHCP" = '0' ] || [ "$OP_MODE" = '1' ]; then
			echo 'Setup Firewall'
			#echo 2 > /proc/fast_nat 
			$START_FIREWALL
		fi
		# static ip 	
		if [ -f /bin/vpn.sh ] && [ "$WAN_DHCP" != '4' ] && [ "$OP_MODE" != '1' ] &&  [ "$WAN_DHCP" = '0' ] ; then 
			echo 'Setup VPN'
			vpn.sh all
		fi

		#enable ntp daemon , not brige mode
		if [ "$OP_MODE" != '1' ]; then
			killall $START_NTP 2> /dev/null
			$START_NTP
			$START_DDNS all &
		fi
                
	fi

else
	# Delete DHCP server/client process
	PIDFILE=/etc/udhcpc/udhcpc-$BR_INTERFACE.pid
	if [ -f $PIDFILE ] ; then
		PID=`cat $PIDFILE`
		if [ $PID != 0 ]; then
			kill -9 $PID
	       	fi
      		rm -f $PIDFILE
	fi

	PIDFILE=/var/run/udhcpd.pid
	if [ -f $PIDFILE ] ; then
		PID=`cat $PIDFILE`
		if [ $PID != 0 ]; then
			kill -16 $PID
				sleep 1
			kill -9 $PID
       		fi
      		rm -f $PIDFILE
	fi

	#kill syslogd and klogd
	killall syslogd
	killall klogd


	if [ "$OP_MODE" = '1' ];then
		$START_BRIDGE $BR_INTERFACE $BR_LAN1_INTERFACE $WLAN_INTERFACE_REPEATER $BR_LAN2_INTERFACE
	else		
		$START_BRIDGE $BR_INTERFACE $BR_LAN1_INTERFACE $WLAN_INTERFACE_REPEATER
	fi
	
	eval `$GETMIB SCRLOG_ENABLED`	
	if [ $SCRLOG_ENABLED != 0 -a $SCRLOG_ENABLED != 2 ] &&
			[ $SCRLOG_ENABLED != 4 -a $SCRLOG_ENABLED != 6 ] &&
			[ $SCRLOG_ENABLED != 8 -a $SCRLOG_ENABLED != 10 ] &&
			[ $SCRLOG_ENABLED != 12 -a  $SCRLOG_ENABLED != 14 ]; then			
		eval `$GETMIB REMOTELOG_ENABLED`
		eval `$GETMIB REMOTELOG_SERVER`
		if [ $REMOTELOG_ENABLED = "1" ] ;then
			SYSLOG_PARA="-R $REMOTELOG_SERVER"
		fi 
		syslogd -L $SYSLOG_PARA &
		klogd &
	fi

	eval `$GETMIB DHCP`
	if [ "$DHCP" = '2' ]; then
		sleep 1
		$START_DHCP_SERVER $BR_INTERFACE ap
	fi

	if [ "$DHCP" = '0' ] || [ "$DHCP" = '2' ]; then
		$START_WLAN_APP start $WLAN_INTERFACE $BR_INTERFACE
	fi
fi

# start auto-discovery daemon
PIDFILE=/var/run/disc_server.pid
if [ -f $PIDFILE ] ; then
	PID=`cat $PIDFILE`
	if [ $PID != 0 ]; then
		kill -9 $PID
	fi
	rm -f $PIDFILE
fi

eval `$GETMIB AUTODISCOVERY_ENABLED`
if [ "$AUTODISCOVERY_ENABLED" != 0 ]; then
	disc_server $BR_INTERFACE &
fi

# start mini_upnpd shared daemon
killall -9 mini_upnpd 2> /dev/null

eval `$GETMIB WSC_DISABLE`
_CMD=
if [ $WSC_DISABLE = 0 ]; then
	_CMD="$_CMD -wsc /tmp/wscd_config"
fi

if [ "$GATEWAY" = 'true' ] && [ "$OP_MODE" != '1' ]; then
	eval `$GETMIB UPNP_ENABLED`
	if [ $UPNP_ENABLED != 0 ]; then
		_CMD="$_CMD -igd /tmp/igd_config"
	fi
fi	
	
if [ "$_CMD" != "" ]; then
	mini_upnpd $_CMD &
fi	

# for LLTD
if [ "$GATEWAY" = 'true' ]; then
	#killall lld2d 2>/dev/null
	#rm /var/run/lld2d-br0.pid 2>/dev/null
	#lld2d br0
	if [ "$WAN_DHCP" = '0' ]; then	
		# enable IGMP proxy daemon
		killall -9 igmpproxy 2> /dev/null
		igmpproxy $WAN_INTERFACE br0 &
		echo 1 > /proc/br_igmpsnoop
	fi
fi	
# SNMP daemon
if [ -f /bin/snmpd ]; then
	snmpd.sh restart
fi