/*
 * FILE NAME rtl_gpio.c
 *
 * BRIEF MODULE DESCRIPTION
 *  GPIO For Flash Reload Default
 *
 *  Author: jimmylin@realtek.com.tw
 *
 * Copyright 2005 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/reboot.h>
#include <linux/kmod.h>
#include <linux/proc_fs.h>

#define AUTO_CONFIG

#define READ_RF_SWITCH_GPIO

#include <linux/netdevice.h>
extern void set_wireless_LED_steady_on(int led_num, struct net_device *dev);
extern void recover_wireless_LED(struct net_device *dev);

#ifdef CONFIG_RTL_EB8186
	#define RTL_GPIO_PABDIR		0xbd010124
	#define RTL_GPIO_PABDATA	0xbd010120
	#define RESET_BTN_PIN		0
	#define AUTOCFG_BTN_PIN		1
	#define RESET_LED_PIN		2
	#define AUTOCFG_LED_PIN		3
	#define AUTOCFG_LED_OFF		0
	#define AUTOCFG_LED_ON		1
	#define AUTOCFG_LED_BLINK	2
#else
	#define RTL_GPIO_PABDIR		0xbd010040
	#define RTL_GPIO_PABDATA	0xbd010044
	#define RTL_WLAN_CR9346		0xbd400050
	#define RTL_WLAN_CONFIG0	0xbd400051
	#define RTL_WLAN_PSR		0xbd40005e
	#define RESET_BTN_PIN		10
#endif

#ifdef CONFIG_RTL8186_KB  
	#define PROBE_TIME	5
	#define RTL_GPIO_PCDDIR		0xbd010134
	#define RTL_GPIO_PCDDATA	0xbd010130
	#define WPS_LED_PIN					0
	#define WAN_INTERNET_LED_PIN		3
	#define WAN_INTERNET_LED_OFF		0
	#define WAN_INTERNET_LED_ON			1
	#define WAN_INTERNET_LED_BLINK		2
	#define WAN_INTERNET_ABNORMAL_LED_PIN            1
#else
	#define PROBE_TIME	5	
#endif

#define PROBE_NULL		0
#define PROBE_ACTIVE	1
#define PROBE_RESET		2
#define PROBE_RELOAD	3
#define RTL_R32(addr)		(*(volatile unsigned long *)(addr))
#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#define RTL_R8(addr)		(*(volatile unsigned char*)(addr))
#define RTL_W8(addr, l)		((*(volatile unsigned char*)(addr)) = (l))

//#define  GPIO_DEBUG
#ifdef GPIO_DEBUG
/* note: prints function name for you */
#  define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
#  define DPRINTK(fmt, args...)
#endif

static struct timer_list probe_timer;
static unsigned int    probe_counter;
static unsigned int    probe_state;

static char default_flag='0';

#ifndef CONFIG_RTL_EB8186
unsigned int led0enable;
#endif

#ifdef CONFIG_RTL8186_KB
int	disable_power_led_blink=0;
int    update_flash_timestamp=0;
#endif

#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)
int	system_led_blink=0;
extern int flash_write_flag;
unsigned int sys_keep_alive = 0;
#endif

#if defined(CONFIG_RTL8186_KB) 
/* 
 * Forrest added for WPS LED Feedback Patterns, 2007.10.31.
 * Note: The GPIO PIN used is the same as AUTOCFG_LED !! 
 */
static unsigned int		WanInternet_LED_Blink;
static unsigned int		WanInternet_LED_Toggle;

void WanInternet_Fail_gpio_init(void)
{
	// Set GPIOC ping 2 as output pin for auto config led
	RTL_W32(RTL_GPIO_PCDDIR, (RTL_R32(RTL_GPIO_PCDDIR) | (1 << WAN_INTERNET_ABNORMAL_LED_PIN)));

	// turn off auto config led in the beginning
	RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) | (1 << WAN_INTERNET_ABNORMAL_LED_PIN)));
}


void WanInternet_Fail_gpio_off(void)
{
	RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) | (1 << WAN_INTERNET_ABNORMAL_LED_PIN)));
	
}


void WanInternet_Fail_gpio_on(void)
{
	RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) & (~(1 << WAN_INTERNET_ABNORMAL_LED_PIN))));
}


void WanInternet_gpio_init(void)
{
	// Set GPIOC ping 2 as output pin for auto config led
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | (1 << WAN_INTERNET_LED_PIN)));

	// turn off auto config led in the beginning
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << WAN_INTERNET_LED_PIN)));
}


void WanInternet_gpio_off(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << WAN_INTERNET_LED_PIN)));
	WanInternet_LED_Blink = 0;
}


void WanInternet_gpio_on(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << WAN_INTERNET_LED_PIN))));
	WanInternet_LED_Blink = 0;
}


void WanInternet_gpio_blink(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << WAN_INTERNET_LED_PIN))));
	WanInternet_LED_Blink = 1;
	WanInternet_LED_Toggle = 1;
}

/* 
 * Forrest added for WPS LED Feedback Patterns, 2007.10.31.
 * Note: The GPIO PIN used is the same as POWER_LED !! 
 */
#define WPS_LED_MODE_END		0 
#define WPS_LED_MODE_PROGRESS	1
#define WPS_LED_MODE_ERROR		2
#define WPS_LED_MODE_OVERLAP	3
#define WPS_LED_MODE_SUCCESS	4
 
static unsigned int		WPS_LED_Tick;
static unsigned int		WPS_LED_Toggle;
static unsigned int		WPS_LED_Mode;

static void WPS_LED_gpio_init(void)
{
	// Set GPIOA ping 3 as output pin for WPS LED.
	RTL_W32(RTL_GPIO_PCDDIR, (RTL_R32(RTL_GPIO_PCDDIR) | (1 << WPS_LED_PIN)));
	// Turn off WPS LED in the beginning
	RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) | (1 << WPS_LED_PIN)));	
	WPS_LED_Toggle = 0;
}

static void WPS_LED_gpio_on(void)
{
	if (!WPS_LED_Toggle) {		
		RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) & (~(1 << WPS_LED_PIN))));
	}
	WPS_LED_Toggle = 1;
}
	
static void WPS_LED_gpio_off(void)
{
	if (WPS_LED_Toggle) {
		RTL_W32(RTL_GPIO_PCDDATA, (RTL_R32(RTL_GPIO_PCDDATA) | (1 << WPS_LED_PIN)));
	}
	WPS_LED_Toggle = 0;
}

static void WPS_LED_gpio_Progress(void)
{	
	WPS_LED_Tick++;
	if (WPS_LED_Tick < 3) {
		WPS_LED_gpio_on();
	} else {
		WPS_LED_gpio_off();
		WPS_LED_Tick = 0;
	}	
}

static void WPS_LED_gpio_Error(void)
{
	WPS_LED_Tick++;
	if (WPS_LED_Tick < 2) {
		WPS_LED_gpio_on();
	} else {
		WPS_LED_gpio_off();
		WPS_LED_Tick = 0;
	}
}

static void WPS_LED_gpio_Overlap(void)
{
	WPS_LED_Tick++;		
	if (WPS_LED_Tick < 10) {
		if (WPS_LED_Tick & 0x01) {
			WPS_LED_gpio_on();			
		} else {
			WPS_LED_gpio_off();
		}			
	} else if (WPS_LED_Tick < 15) {
		WPS_LED_gpio_off();
	} else {
		WPS_LED_gpio_off();
		WPS_LED_Tick = 0;
	}
}

static void WPS_LED_gpio_mode(int mode)
{
	WPS_LED_gpio_init();
	WPS_LED_Tick = 0;
	WPS_LED_Mode = mode;
}	

static void WPS_LED_gpio_timer(void)
{
	if (WPS_LED_Mode == WPS_LED_MODE_END) {
		WPS_LED_gpio_on();
	} else if (WPS_LED_Mode == WPS_LED_MODE_PROGRESS) {
		WPS_LED_gpio_Progress();		
	} else if (WPS_LED_Mode == WPS_LED_MODE_ERROR) {
		WPS_LED_gpio_Error();
	} else if (WPS_LED_Mode == WPS_LED_MODE_OVERLAP) {
		WPS_LED_gpio_Overlap();		
	} else if (WPS_LED_Mode == WPS_LED_MODE_SUCCESS) {
		WPS_LED_gpio_on();
	}	
}
#endif





#if defined(CONFIG_RTL_EB8186) && defined(AUTO_CONFIG)
static unsigned int		AutoCfg_LED_Blink;
static unsigned int		AutoCfg_LED_Toggle;

void autoconfig_gpio_init(void)
{
	// Set GPIOA pin 1 as input pin for auto config button
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) & (~(1 << AUTOCFG_BTN_PIN))));
	// Set GPIOA ping 3 as output pin for auto config led
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | (1 << AUTOCFG_LED_PIN)));

	// turn off auto config led in the beginning
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
}


void autoconfig_gpio_off(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
	AutoCfg_LED_Blink = 0;
}


void autoconfig_gpio_on(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 0;
}


void autoconfig_gpio_blink(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 1;
	AutoCfg_LED_Toggle = 1;
}

#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)
void autoconfig_gpio_blink_quick(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 2;
	AutoCfg_LED_Toggle = 1;
}
#endif
#endif

#if 0
static int reset_flash_default(void *data)
{
	char *argv[3], *envp[1] = {NULL};
	int i = 0;
	int reset_default=(int)data;

	argv[i++] = "/bin/flash";
	argv[i++] = "reset";
	argv[i] = NULL;

	if(reset_default)
	{
		if (call_usermodehelper(argv[0], argv, envp,1))
			printk("failed to Reset to default\n");
	}
	machine_restart(0);
	return 0;
}
#endif

static void rtl_gpio_timer(unsigned long data)
{
	unsigned int pressed=1;
	static int cnt = 0;

#if (defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)) && defined(AUTO_CONFIG)
	if (AutoCfg_LED_Blink == 2)
	{
		if (AutoCfg_LED_Toggle) {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
		}
		else {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
		}
		AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
	}

	if (cnt++%4)
		goto ret_timer;
/* --- Forrest added for WPS LED Feedback Patterns, 2007.10.31. */
#elif defined(CONFIG_RTL8186_KB)
	WPS_LED_gpio_timer();
	if (cnt++ < 10) {
		goto ret_timer;
	} else {
		cnt = 0;
	}
#endif
/* Forrest added for WPS LED Feedback Patterns, 2007.10.31. --- */

	if ((RTL_R32(RTL_GPIO_PABDATA) & (1 << RESET_BTN_PIN))){
		pressed = 0;
#ifdef CONFIG_RTL_EB8186
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL8186_EC)
		//turn off LED0
		RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | ((1 << RESET_LED_PIN))));
#endif		
#endif
	}
	else
	{
		DPRINTK("Key pressed %d!\n", probe_counter+1);
	}

	if (probe_state == PROBE_NULL)
	{
		if (pressed)
		{
			probe_state = PROBE_ACTIVE;
			probe_counter++;
		}
		else
			probe_counter = 0;
	}
	else if (probe_state == PROBE_ACTIVE)
	{
		if (pressed)
		{
			probe_counter++;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)		
			if ((probe_counter >=1 ) && (probe_counter <=PROBE_TIME))
#else
			if ((probe_counter >=2 ) && (probe_counter <=PROBE_TIME))
#endif				
			{
#ifndef CONFIG_RTL_EB8186
				led0enable=1;
				// turn on LED0
				RTL_W8(RTL_WLAN_CR9346, 0xc0);
				RTL_W8(RTL_WLAN_CONFIG0, 0x10);
				RTL_W8(RTL_WLAN_PSR,(RTL_R8(RTL_WLAN_PSR)&0xEF));
#else
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL8186_EC)
				DPRINTK("2-5 turn on led\n");
				//turn on LED0
				RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << RESET_LED_PIN))));
#endif				
#endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
#ifndef CONFIG_RTL_EB8186
				led0enable=1;
				RTL_W8(RTL_WLAN_CR9346, 0xc0);
				RTL_W8(RTL_WLAN_CONFIG0, 0x10);
				// sparkling LED0
				if (probe_counter & 1)
					RTL_W8(RTL_WLAN_PSR, (RTL_R8(RTL_WLAN_PSR)|0x10));
				else
					RTL_W8(RTL_WLAN_PSR, (RTL_R8(RTL_WLAN_PSR)&0xEF));
#else
				// sparkling LED0
				DPRINTK(">5 \n");
				
#ifdef CONFIG_RTL8186_KB		
				disable_power_led_blink=0; //brad modify 20071022
#elif !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL8186_EC)
				if (probe_counter & 1)
					RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | ((1 << RESET_LED_PIN))));
				else
					RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << RESET_LED_PIN))));		
#endif // CONFIG_RTL8186_KB		
#endif // CONFIG_RTL_EB8186
			}
		}
		else
		{
			if (probe_counter < 2)
			{
				probe_state = PROBE_NULL;
				probe_counter = 0;
				DPRINTK("<2 \n");
			}
			else if (probe_counter >= PROBE_TIME)
			{
#ifndef CONFIG_RTL_EB8186
				led0enable=1;
#endif

#ifdef CONFIG_RTL8186_KB			
				disable_power_led_blink=0; //brad modify 20071022
#endif
				//reload default
			        default_flag='1';	
	//			kernel_thread(reset_flash_default, (void *)1, SIGCHLD);
				return;

			}
			else
			{
#ifndef CONFIG_RTL_EB8186
				RTL_W8(RTL_WLAN_PSR , (RTL_R8(RTL_WLAN_PSR)|0x10));
				RTL_W8(RTL_WLAN_CONFIG0, (RTL_R8(RTL_WLAN_CONFIG0)&(~0x10)));
#endif
				DPRINTK("2-5 reset\n");
				kill_proc(1,SIGTERM,1);
		//		kernel_thread(reset_flash_default, 0, SIGCHLD);
				return;
			}
		}
	}

#if defined(CONFIG_RTL_EB8186) && defined(AUTO_CONFIG)
	if (AutoCfg_LED_Blink==1)
	{
		if (AutoCfg_LED_Toggle) {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
		}
		else {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
		}
		AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
	}
#endif
#if defined(CONFIG_RTL8186_KB)
	if (WanInternet_LED_Blink==1)
	{
		if (WanInternet_LED_Toggle) {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << WAN_INTERNET_LED_PIN)));
		}
		else {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << WAN_INTERNET_LED_PIN))));
		}
		WanInternet_LED_Toggle = WanInternet_LED_Toggle? 0 : 1;
	}
#endif

#if (defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)) && defined(AUTO_CONFIG)
ret_timer:
	mod_timer(&probe_timer, jiffies + 25);
#elif defined(CONFIG_RTL8186_KB)
ret_timer:
	mod_timer(&probe_timer, jiffies + 10);
#else
	mod_timer(&probe_timer, jiffies + 100);
#endif
}


#ifdef AUTO_CONFIG
static int read_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(RTL_GPIO_PABDATA) & (1 << AUTOCFG_BTN_PIN))
		flag = '0';
	else
		flag = '1';
	len = sprintf(page, "%c\n", flag);


	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}

#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)
static int read_wps_led_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(RTL_GPIO_PABDATA) & (1 << AUTOCFG_LED_PIN))
		flag = '0';
	else
		flag = '1';
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#endif

static int write_proc(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	char flag;

	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);
	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		if (flag == 'E')
			autoconfig_gpio_init();
		else if (flag == '0')
			autoconfig_gpio_off();
		else if (flag == '1')
			autoconfig_gpio_on();
		else if (flag == '2')
			autoconfig_gpio_blink();
			
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)			
		else if (flag == '3') // update flash in special case		
			flash_write_flag = 0x8000;				
		else if (flag == '4') // enable system led blinking 
			system_led_blink = 1;	
		else if (flag == '5') // disable system led blinking 
			system_led_blink = 0;			
		else if (flag == '6')
			autoconfig_gpio_blink_quick();
		else if (flag == '7') // disable system led 
			system_led_blink = 2;		
		else if(flag =='8'){ //update keep alive flag
			//printk("update keep alive flag\n");
			sys_keep_alive++;							
		}
#elif defined(CONFIG_RTL8186_KB)
		/* --- Forrest added for WPS LED Feedback Patterns, 2007.10.31. */
		else if (flag == 'b')
			WPS_LED_gpio_mode(WPS_LED_MODE_PROGRESS);
		else if (flag == 'c')
			WPS_LED_gpio_mode(WPS_LED_MODE_END);
		else if (flag == 'd')
			WPS_LED_gpio_mode(WPS_LED_MODE_OVERLAP);
		else if (flag == 'e')
			WPS_LED_gpio_mode(WPS_LED_MODE_ERROR);
		else if (flag == 'f')
			WPS_LED_gpio_mode(WPS_LED_MODE_SUCCESS);
		/* Forrest added for WPS LED Feedback Patterns, 2007.10.31. --- */	
		else if (flag == 'F')
			WanInternet_gpio_init();
		else if (flag == '6')
			WanInternet_gpio_off();
		else if (flag == '7')
			WanInternet_gpio_on();
		else if (flag == 'a')
			WanInternet_gpio_blink();
		else if (flag == '3')
			disable_power_led_blink=1;
		else if (flag == 'X')
			WanInternet_Fail_gpio_init();
		else if (flag == 'Y')
			WanInternet_Fail_gpio_off();
		else if (flag == 'Z')
			WanInternet_Fail_gpio_on();			
		else if (flag == '4')
			disable_power_led_blink=0;			
		else if(flag== '9')
			update_flash_timestamp=jiffies;			
#ifdef CONFIG_SQUASHFS
		else if (flag == '5') {		
			disable_power_led_blink=3; // set power-led off
#if 0			
			extern int init_squashfs_fs(void);
			extern void exit_squashfs_fs(void);		
			exit_squashfs_fs();
			init_squashfs_fs();
#endif			
		}
#endif		
#else
		else if (flag >= '3' && flag <= '5') {
			struct net_device *wlan_dev;
			wlan_dev = __dev_get_by_name("wlan0");
			switch (flag)
			{
				case '3' :
					set_wireless_LED_steady_on(0, wlan_dev); // wireless LED 0
					break;
				case '4' :
					recover_wireless_LED(wlan_dev);
					break;
				case '5' :
					set_wireless_LED_steady_on(1, wlan_dev); // wireless LED 1
					break;
				default :
					break;
			}
		}
#endif
		else
			{}

		return count;
	}
	else
		return -EFAULT;
}
#endif // AUTO_CONFIG

static int default_read_proc(char *page, char **start, off_t off,
                     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%c\n", default_flag);
      if (len <= off+count) *eof = 1;
          *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
          return len;

}

static int default_write_proc(struct file *file, const char *buffer,
                      unsigned long count, void *data)
{
      if (count < 2)
         return -EFAULT;
      if (buffer && !copy_from_user(&default_flag, buffer, 1)) {
         return count;
         }
      return -EFAULT;
}

#ifdef READ_RF_SWITCH_GPIO
static int rf_switch_read_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(RTL_GPIO_PABDATA) & (1 << 6))
		flag = '1';
	else
		flag = '0';
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#endif


int __init rtl_gpio_init(void)
{
	struct proc_dir_entry *res=NULL;

	printk("Realtek GPIO Driver for Flash Reload Default\n");

	// Set GPIOA pin 10(8181)/0(8186) as input pin for reset button
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) & (~(1 << RESET_BTN_PIN))));
#ifdef CONFIG_RTL_EB8186
	// Set GPIOA ping 2 as output pin for reset led
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | ((1 << RESET_LED_PIN))));
#endif

#ifdef AUTO_CONFIG
	res = create_proc_entry("gpio", 0, NULL);
	if (res) {
		res->read_proc = read_proc;
		res->write_proc = write_proc;
	}
	else {
		printk("Realtek GPIO Driver, create proc failed!\n");
	}

#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_EC)
	res = create_proc_entry("wps_led", 0, NULL);
	if (res) 
		res->read_proc = read_wps_led_proc;
	else 
		printk("create wps led proc failed!\n");
#endif	
#endif

	res = create_proc_entry("load_default", 0, NULL);
        if (res) {
                res->read_proc=default_read_proc;
	        res->write_proc=default_write_proc;
	        }

#ifdef READ_RF_SWITCH_GPIO	        
	res = create_proc_entry("rf_switch", 0, NULL);
	if (res) {
		res->read_proc=rf_switch_read_proc;
		res->write_proc=NULL;
	}	            
#endif	

	init_timer (&probe_timer);
	probe_counter = 0;
	probe_state = PROBE_NULL;
	probe_timer.expires = jiffies + 100;
	probe_timer.data = (unsigned long)NULL;
	probe_timer.function = &rtl_gpio_timer;
	mod_timer(&probe_timer, jiffies + 100);

	return 0;
}


static void __exit rtl_gpio_exit(void)
{
	printk("Unload Realtek GPIO Driver \n");
	del_timer_sync(&probe_timer);
}


module_exit(rtl_gpio_exit);
module_init(rtl_gpio_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("GPIO driver for Reload default");
