/* hfload.c
 *
 * This file is subject to the terms and conditions of the GNU
 * General Public License.  See the file "COPYING" in the main
 * directory of this archive for more details.
 *
 * Copyright (C) 2000, Jay Carlson
 */

/*
 * Boot loader main program.
 */

#include <unistd.h>
#include <linux/elf.h>
#include "hfload.h"

#ifdef CONFIG_RTL8186_KB
	#define PATCH_8306_CTRL_LED_BY_CPU
#endif	

#ifdef PATCH_8306_CTRL_LED_BY_CPU
#define ETHBASE	0xBD300000   
#define rtl8305_inl(offset)			(*(volatile unsigned long *)(ETHBASE+offset))
#define rtl8305_outl(offset,val)	(*(volatile unsigned long *)(ETHBASE+offset) = val)
#define udelay(usecs) __udelay((usecs),__udelay_val)
#define __udelay_val loops_per_jiffy

unsigned long loops_per_jiffy = (1<<12);

void __delay(unsigned long loops)
 {
 	int i; 	
	for (i=0; i<loops; i++);
 }
 
void __udelay(unsigned long usecs, unsigned long lpj)
{
         unsigned long lo;
 
         usecs *= 0x00068db8;            /* 2**32 / (1000000 / HZ) */
         __asm__("multu\t%2,%3"
                 :"=h" (usecs), "=l" (lo)
                 :"r" (usecs),"r" (lpj));
         __delay(usecs);
} 
#endif // PATCH_8306_CTRL_LED_BY_CPU

int file_offset;

int old_stack_pointer;

#define MAX_PHDRS_SIZE 8

Elf32_Ehdr header;
Elf32_Phdr phdrs[MAX_PHDRS_SIZE];

extern void flush_cache(void);

void
zero_region(char *start, char *end)
{
	char *addr;
	int count;

	count = end - start;
#ifndef __DO_QUIET__
	printf("zeroing from %08x to to %08x, 0x%x bytes\n", start, end, count);
#endif

#ifndef FAKE_COPYING
	memset(start, 0, count);
#endif
}

void
load_phdr(Elf32_Phdr *phdr)
{
	char *addr, *end;
	
	seek_forward(phdr->p_offset);
	
	addr = (char *)phdr->p_vaddr;
	end = ((char *)addr) + phdr->p_memsz;
	
	copy_to_region(addr, phdr->p_filesz);
	
	addr = ((char *)addr) + phdr->p_filesz;
	
	zero_region(addr, end);
}

#ifdef PATCH_8306_CTRL_LED_BY_CPU
static void MII_write(unsigned short int phyaddr, unsigned short int regaddr, unsigned short int data, unsigned char eth)
{
	unsigned int phy_addr_data, MII_reg;
	unsigned long flags;

	phy_addr_data = (1<<31) | (phyaddr<<26) | (regaddr<<16) | data;
	
	if (eth == 0)
		MII_reg = 0x005c;
	else
		MII_reg = 0x005c;
		
	rtl8305_outl(MII_reg, phy_addr_data);
	while (1) {	
		udelay(300);
		if ((rtl8305_inl(MII_reg) & 0x80000000) == 0) 
			break;		
	}				
	return;
}

static unsigned short int MII_read(unsigned short int phyaddr, unsigned short int regaddr, unsigned char eth)
{
	unsigned int phy_addr, MII_reg;
		
	phy_addr = (0<<31) | (phyaddr<<26) | (regaddr<<16);
	
	if (eth == 0)
		MII_reg = 0x005c;
	else
		MII_reg = 0x005c;
		
	rtl8305_outl(MII_reg, phy_addr);
	while (1) {	
		udelay(300);
		if ((rtl8305_inl(MII_reg) & 0x80000000)) 		
			break;		
	}				
	return rtl8305_inl(MII_reg)&0x0000ffff;
}

static void rtl8306_page_select(unsigned int pagenumber)
{	
	pagenumber = (pagenumber + 2) & 0x03;
	MII_write(0,16,(MII_read(0,16,0)&0x7ffd)|(pagenumber&0x02)|((pagenumber&0x01)<<15),0);	
}
#endif // PATCH_8306_CTRL_LED_BY_CPU

void main(unsigned long stack_start_addr)
{
	int i;
	file_offset = 0;

#ifdef PATCH_8306_CTRL_LED_BY_CPU
	rtl8306_page_select(3);
	MII_write(2, 21, MII_read(2 ,21, 0)|0x780, 0); 
#endif

#ifndef __DO_QUIET__
	printf("decompressing kernel:\n");
#endif

#ifndef BZ2_COMPRESS
	decompress_kernel(UNCOMPRESS_OUT, stack_start_addr+4096, FREEMEM_END, 0);
#else
	decompress_kernel(UNCOMPRESS_OUT, stack_start_addr+4096, FREEMEM_END, 0);
#endif

#ifndef __DO_QUIET__
	printf("done decompressing kernel.\n");
#endif

	flush_cache();
	start_kernel(0x80000000);
}
