#include "swplatform.h"

#include <timers.h>

int ub_state = 0;
int timer_ticks = 0;
int alive_counter = 0;
int alive_led_status = 0;

#define C_ERR_TREG 129

//
// timer shall tick in 10msec intervals
//
#define C_TICK_LENGTH 10
//
// show alive sign every 1000 msec
//
#define C_ALIVE_INTERVAL 100

void error_halt(int errcod) {
    led_turn_all_off(drv_led_1);
    int i;
    for (i=0; i<=7; i++) {
      if (errcod&1)
        led_turn_on(drv_led_1,LEDS_LED0_R+(i*3));
      else
        led_turn_off(drv_led_1,LEDS_LED0_R+(i*3));
      errcod /= 2;
    }
    while (1);
}
void init_leds() {
    led_turn_all_off(drv_led_1);
    led_turn_on(drv_led_1,LEDS_LED0_B);
}

void check_alive() {
    alive_counter++;
    if (alive_counter>=C_ALIVE_INTERVAL) {
        alive_counter = 0;
        if (alive_led_status==0) {
            alive_led_status = 1;
            led_turn_on(drv_led_1, LEDS_LED7_G);
        }
        else {
            alive_led_status = 0;
            led_turn_off(drv_led_1, LEDS_LED7_G);
        }
    }
}

void tick(void * timerctx) {
    timer_ticks++;
    timer_register_handler(0,C_TICK_LENGTH,tick);
    check_alive();
}

void init_ub() {
    ub_state = 0;
    timer_ticks=0;
    void * timer_id = timer_register_handler(0,C_TICK_LENGTH,tick);
    if (!timer_id) {
        error_halt(C_ERR_TREG);
    }
}

void check_ub() {
    int ub_act = ioport_get_value(drv_ioport_2,0);
    int i;
    for (i=0; i<5; i++) {
        if ((ub_act & (1<<i)) != 0)
          led_turn_on(drv_led_1,LEDS_LED1_B+(3*i));
        else
          led_turn_off(drv_led_1,LEDS_LED1_B+(3*i));
    }
}

void main() {
  swplatform_init_stacks();
  init_leds();
  init_ub();
  led_turn_off(drv_led_1,LEDS_LED0_B);
  led_turn_on(drv_led_1,LEDS_LED0_G);
  while (1) {
    check_ub();
  }
}
