#include "swplatform.h"

#include <timers.h>

#define C_SCAN_ROWS 8
#define C_SCAN_COLS 8
#define C_SCAN_MASK 1<<C_SCAN_COLS-1

typedef struct ent {
    struct ent * nextptr;
    struct ent * prevptr;
} ent;

typedef struct keymsg {
    struct ent * nextptr;
    struct ent * prevptr;
    int row;
    int column;
    int close;
} keymsg;

struct ent key_queue;

int ub_state = 0;
int timer_ticks = 0;
int alive_counter = 0;
int alive_led_status = 0;
int scanrow = 0;
int scanstat1[C_SCAN_ROWS];
int scanstat2[C_SCAN_ROWS];

// error starting tick timer
#define C_ERR_TREG 130
// key message buffer space exhausted
#define C_ERR_KMEX 131

//
// timer shall tick in 10msec intervals
//
#define C_TICK_LENGTH 10000
//
// show alive sign every 1000 msec
//
#define C_ALIVE_INTERVAL 100

void error_halt(int errcod) {
    led_turn_all_off(drv_led_1);
    int i;
    for (i=0; i<=7; i++) {
      if (errcod&1)
        led_turn_on(drv_led_1,LEDS_LED0_R+(i*3));
      else
        led_turn_off(drv_led_1,LEDS_LED0_R+(i*3));
      errcod /= 2;
    }
    while (1);
}
void init_leds() {
    led_turn_all_off(drv_led_1);
    led_turn_on(drv_led_1,LEDS_LED0_B);
}

void init_queue(struct ent * queptr) {
    queptr->nextptr=0;
    queptr->prevptr=0;
}

int que_has_entries(struct ent * queptr) {
    if (queptr->nextptr!=0) {
        return true;
    }
    else {
        return false;
    }
}

void insert_queue_last(struct ent * queptr, struct ent * entptr) {
    if (queptr->nextptr!=0) {
        entptr->nextptr=queptr->prevptr;
        queptr->prevptr->prevptr=entptr;
        queptr->prevptr=entptr;
        entptr->prevptr=0;
    }
    else {
        queptr->nextptr=entptr;
        queptr->prevptr=entptr;
        entptr->nextptr=0;
        entptr->prevptr=0;
    }
}

ent * get_queue_first(struct ent * queptr) {
    if (!queue_has_entries(queptr)) {
        return 0;
    }
    else {
        struct ent * entptr;
        entptr = queptr->nextptr;
        queptr->nextptr=queptr->nextptr->nextptr;
    }
}

void check_alive() {
    alive_counter++;
    if (alive_counter>=C_ALIVE_INTERVAL) {
        alive_counter = 0;
        if (alive_led_status==0) {
            alive_led_status = 1;
            led_turn_on(drv_led_1, LEDS_LED7_G);
        }
        else {
            alive_led_status = 0;
            led_turn_off(drv_led_1, LEDS_LED7_G);
        }
    }
}

void init_scanpoints() {
    scanrow = 0;
    int i = 0;
    for (i=0;i<C_SCAN_ROWS;i++) {
        scanstat1[i]=0;
        scanstat2[i]=0;
        ioport_set_value(drv_ioport_1,KEY_MATRIX_SCAN,1<<scanrow);
    }
}

void check_scanpoints() {
    int krow = ioport_get_value(drv_ioport_1,KEY_MATRIX_RET);
    krow ^= 0x0FF;
    krow &= KEY_RET_MASK;
    krow &= scanstat1[scanrow];
    if (scanstat1[scanrow]!=scanstat2[scanrow]) {
      int scancol=0;
      int keystat=0;
      int oldstat=0;
      int newstat=0;
      int colmask=0;
      for (scancol=0; scancol<C_SCAN_COLS; scancol++) {
        colmask = 1<<scancol;
        oldstat = scanstat2[scanrow] & colmask;
        newstat = scanstat1[scanrow] & colmask;
        if (oldstat!=newstat) {
          struct keymsg * kmptr = malloc(sizeof(struct keymsg));
          if (!kmptr) {
            error_halt(C_ERR_KMEX);
          }
          kmptr->row=scanrow;
          kmptr->column=scancol;
          if (newstat!=0) {
            kmptr->closed=true;
          }
          else {
            kmptr->closed=false;
          }
          insert_queue_last(&key_queue,(struct ent*)kmptr);
        }
      }
      scanstat2[scanrow]=scanstat1[scanrow];
    }
    scanrow++;
    if (scanrow>=C_SCAN_ROWS) {
        scanrow=0;
    }
    ioport_set_value(drv_ioport_1,KEY_MATRIX_SCAN,1<<scanrow);
}

void tick(void * timerctx) {
    timer_ticks++;
    // timer_register_handler(0,C_TICK_LENGTH,tick);
    check_alive();
    check_scanpoints();
}

void init_ub() {
    ub_state = 0;
    timer_ticks=0;
    void * timer_id = timer_register_handler(1000,C_TICK_LENGTH,tick);
    if (!timer_id) {
        error_halt(C_ERR_TREG);
    }
    init_scanpoints();
    init_queue(&key_queue);
}

void check_ub() {
    int ub_act = ioport_get_value(drv_ioport_2,0);
    int i;
    for (i=0; i<5; i++) {
        if ((ub_act & (1<<i)) != 0)
          led_turn_on(drv_led_1,LEDS_LED1_B+(3*i));
        else
          led_turn_off(drv_led_1,LEDS_LED1_B+(3*i));
    }
}

void main() {
  swplatform_init_stacks();
  init_leds();
  init_ub();
  led_turn_off(drv_led_1,LEDS_LED0_B);
  led_turn_on(drv_led_1,LEDS_LED0_G);
  while (1) {
    check_ub();
  }
}
