# BH1750 模块

##引用
```lua
bh1750 = require("bh1750")
```
## 释放
```lua
bh1750 = nil
package.loaded["bh1750"]=nil
```
<a id="bh1750_init"></a>
##init()
####描述
设置BH1750所在的I2C引脚<br />

####语法
init(sda, scl)

####参数
sda: 1~12, IO index.<br />
scl: 1~12, IO index.<br />

####返回值
nil

####示例
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####参见
**-**   []()

<a id="bh1750_read"></a>
##read()
####描述
从bh1750中读取光线传感器数据（Lux勒克斯）.<br />

####语法
read()

####参数
nil.<br />

####返回值
nil.<br />

####示例
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)
bh1750.read()

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####参见
**-**   []()

<a id="bh1750_getlux"></a>
##getlux()
####描述
从BH1750中提取数据.<br />

####语法
getlux()

####参数
nil.<br />

####返回值
l: 整数，Lux计数
####示例
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)
bh1750.read()
l = bh1750.getlux()
print("lux: "..(l / 100).."."..(l % 100).." lx")

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####参见
**-**   []()
