<?php
/**
 * Internationalisation file for the QuestyCaptcha module of the ConfirmEdit
 * extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English */
$messages['en'] = array(
	'questycaptcha-desc' => 'Questy CAPTCHA generator for Confirm Edit',
	'questycaptcha-addurl' => 'Your edit includes new external links.
To help protect against automated spam, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptcha-badlogin' => 'To help protect against automated password cracking, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptcha-createaccount' => 'To help protect against automated account creation, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptcha-create' => 'To create the page, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptcha-edit' => 'To edit this page, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptcha-sendemail' => 'To help protect against automated spamming, please answer the question that appears below ([[Special:Captcha/help|more info]]):',
	'questycaptchahelp-text' => 'Web sites that accept contributions from the public, like this wiki, are often abused by spammers who use automated tools to add their links to many sites.
While these spam links can be removed, they are a significant nuisance.

Sometimes, especially when adding new web links to a page, the wiki may ask you to answer a question.
Since this is a task that is hard to automate, it will allow most real humans to make their contributions while stopping most spammers and other robotic attackers.

Please contact the [[{{MediaWiki:Grouppage-sysop}}|site administrators]] for assistance if this is unexpectedly preventing you from making legitimate contributions.

Click the "back" button in your browser to return to the page editor.',
);

/** Message documentation (Message documentation)
 * @author Fryed-peach
 * @author Hamilton Abreu
 * @author Shirayuki
 */
$messages['qqq'] = array(
	'questycaptcha-desc' => '{{Optional}}
{{desc}}',
	'questycaptcha-addurl' => '{{Related|ConfirmEdit-addurl}}',
	'questycaptcha-badlogin' => '{{Related|ConfirmEdit-badlogin}}',
	'questycaptcha-createaccount' => '{{Related|ConfirmEdit-createaccount}}',
	'questycaptcha-create' => '{{Related|ConfirmEdit-create}}',
	'questycaptcha-edit' => '{{Related|ConfirmEdit-edit}}',
	'questycaptcha-sendemail' => '{{Related|ConfirmEdit-sendemail}}',
	'questycaptchahelp-text' => 'See also {{msg-mw|Captchahelp-text}}.',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'questycaptcha-addurl' => 'Your redakto përfshin të jashtme lidhje të reja. Për të ndihmuar në mbrojtjen kundër spam automatizuar, ju lutem përgjigje pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptcha-badlogin' => 'Për të ndihmuar në mbrojtjen kundër fjalëkalimin automatizuar plasaritje, ju lutem përgjigje pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptcha-createaccount' => 'Për të ndihmuar në mbrojtjen kundër krijimit llogari e automatizuar, ju lutemi përgjigje pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptcha-create' => 'Për të krijuar një faqe, ju lutem përgjigje të pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptcha-edit' => 'Për të redaktuar këtë faqe, ju lutem përgjigje të pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptcha-sendemail' => 'Për të ndihmuar në mbrojtjen kundër spamming automatizuar, ju lutem përgjigje pyetjes që duket më poshtë ([[Special:Captcha/help|më shumë informacion]]):',
	'questycaptchahelp-text' => "Web faqet që të pranojë kontribute nga publiku, si ky wiki, shpesh keqtrajtohen nga spammers që përdorin mjete të automatizuar për të shtuar lidhjet e tyre me shumë vende. Përderisa këto lidhje spam mund të hiqen, ata janë një ngatërresë të rëndësishme. Ndonjëherë, sidomos kur duke shtuar të reja web lidhje me një faqe, wiki mund të kërkojë që për t'iu përgjigjur një pyetje. Ngaqë kjo është një detyrë që është e vështirë për të automatizuar, ajo do të lejojë të vërtetë njerëzit më të japin kontribute të tyre, ndërsa ndaluar spammers më dhe robotik sulmuesit të tjera. Ju lutem kontaktoni [[{{MediaWiki:Grouppage-sysop}}|faqe administratorët]] për ndihmë, nëse kjo është e papritur në parandalimin e ju nga bërja e kontributeve të ligjshme. Kliko 'butonin mbrapa në shfletuesin tuaj për t'u kthyer në faqen e redaktorit.",
);

/** Arabic (العربية)
 * @author Ciphers
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'questycaptcha-desc' => 'مولد كويستي كابتشا لConfirm Edit',
	'questycaptcha-addurl' => 'يحتوي تعديلك على وصلات خارجية جديدة.
للمساعدة في الحماية من السبام التلقائي، من فضلك أجب على السؤال الذي يظهر أدناه ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'questycaptcha-badlogin' => 'للمساعدة في الحماية من السبام التلقائي، من فضلك أجب على السؤال الذي يظهر أدناه ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'questycaptcha-createaccount' => 'للمساعدة في الحماية من إنشاء الحسابات التلقائي، من فضلك أجب على السؤال الذي يظهر أدناه ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'questycaptcha-create' => 'لتنشئ الصفحة، من فضلك أجب على السؤال الذي يظهر أدناه ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'questycaptcha-edit' => 'لتحرّر هذه الصفحة، من فضلك أجب على السؤال الذي يظهر أدناه ([[Special:Captcha/help|مزيد من المعلومات]]):',
	'questycaptcha-sendemail' => 'للمساعدة في الحماية ضد البريد الإلكتروني الآلي المرغوب فيه، الرجاء الإجابة على السؤال الذي يظهر أدناه ([[Special:Captcha/help|المزيد من المعلومات]]):',
	'questycaptchahelp-text' => "عادة ما يتم في المواقع التي تقبل الردود والرسائل من العامة، كهذا الويكي، تخريب الموقع عن طريق الأشخاص الذين يستعملون آليات معينة لإرسال وصلاتهم لمواقع متعددة بصورة آلية.
وعلى الرغم من أن هذا يمكن إزالته ولكنه مزعج للغاية.

في بعض الأحيان، خصوصا عند إضافة وصلات لصفحة، ربما يعرض الويكي صورة ملونة أو مشوشة ويطلب منك إدخال كلمات موجودة بالصورة أو يعرض عليك مسألة رياضية عشوائية ويطلب منك حلها.
ولأن هذه المهمة صعبة للغاية لأن يقوم بها برنامج، سيسمح هذا للأشخاص الآدميين بإضافة تحريراتهم بينما ستوقف البرامج التخريبية والهجمات الآلية الأخرى.

للأسف سيكون هذا صعبا بالنسبة لمستخدمي المتصفحات المحدودة أو التي تعتمد على النصوص فقط أو قراءة النصوص.
في الوقت الحالي لا يوجد لدينا بديل سمعي.
من فضلك راسل [[{{MediaWiki:Grouppage-sysop}}|إداريي الموقع]] للمساعدة إذا كان هذا الأمر يمنعك من التعديل ووضع وصلات قانونية.

إذا كنت تحرر صفحة معينة: اضغط زر 'العودة' في متصفحك للعودة إلى التحرير.",
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'questycaptcha-addurl' => "La to edición inclúi nuevos enllaces esternos. P'aidar a protexer escontra'l spam automatizáu, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptcha-badlogin' => "P'ayudar a protexer escontra'l descifráu automáticu de claves, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptcha-createaccount' => "P'ayudar a protexer escontra la creación automática de cuentes, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptcha-create' => "Pa crear la páxina, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptcha-edit' => "Pa editar la páxina, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptcha-sendemail' => "P'ayudar a protexer escontra'l corréu puxarra automáticu, por favor conteste la entruga qu'apaez embaxo ([[Special:Captcha/help|más información]]):",
	'questycaptchahelp-text' => "Los sitios web qu'aceuten collaboración del públicu, como esta wiki, sufren de vezu l'abusu de «spammers» qu'usen ferramientes automátiques p'amestar los sos enllaces en munchos sitios.
Mentanto qu'esos enllaces puen desaniciase, suponen una bultable molestia.

Dacuando, especialmente al amestar enllaces nuevos a una páxina, la wiki pue pidi-y que conteste una entruga.
Como esta ye una xera difícil d'automatizar, permitirá que la mayor parte de persones faiga collaboraciones mentanto torga a la mayor parte de «spammers» y otros atacantes robotizaos .

Por favor, pongase'n contautu colos [[{{MediaWiki:Grouppage-sysop}}|alministradores del sitiu]] pa pidir ayuda si esto ta torgando-y de mou inesperáu facer collaboraciones llexítimes.

Calque nel botón «atrás» del navegador pa volver al editor de páxines.",
);

/** Bashkir (башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'questycaptcha-addurl' => 'Һеҙҙең текстығыҙҙа яңы тышҡы һылтанмалар бар.
Автоматик спамдан һаҡлау маҡсатында, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptcha-badlogin' => 'Паролде автоматик ватыуҙан һаҡлау маҡсатында, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptcha-createaccount' => 'Иҫәп яҙмаларын автоматик булдырыуҙан һаҡлау маҡсатында, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptcha-create' => 'Яңы бит булдырыу өсөн, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptcha-edit' => 'Был битте мөхәррирләү өсөн, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptcha-sendemail' => 'Автоматик спамдан һаҡлау маҡсатында, зинһар, түбәндә килтерелгән һорауға яуап бирегеҙ ([[Special:Captcha/help|тулыраҡ мәғлүмәт]]):',
	'questycaptchahelp-text' => 'Үҙенә эстәлек өҫтәргә һәм эстәлеген мөхәррирләргә мөмкинлек биргән веб-сайттар, шул иҫәптән был вики, йыш ҡына сайттарға автоматик һылтанмалар өҫтәү өсөн программалар ҡулланған спамлаусыларҙың маҡсатына әйләнә.
Бындай һылтанмалар юйыла ала, әммә улар һиҙелерлек уңайһыҙлыҡ килтерә.

Ҡайһы бер ғәмәлдәрҙе башҡарған ваҡытта — мәҫәлән, биткә һылтанма өҫтәгән ваҡытта — вики һеҙгә һорауға яуап бирергә тәҡдим итә ала. Был мәсьәләне автоматик рәүештә сисеү ауыр булғанға күрә, ул күпселек кешеләргә мөхәррирләүҙе башҡарырға мөмкинлек бирәсәк, һәм шул уҡ ваҡытта спамлаусыларҙың һәм башҡа автоматлаштырылған зыян килтереүселәрҙең күпселеген туҡтатасаҡ.

Зинһар, әгәр бындай тикшереү һеҙгә сайтта намыҫ менән эшләргә ҡамасаулаһа, [[{{MediaWiki:Grouppage-sysop}}|хәкимдәргә]] мөрәжәғәт итегеҙ.

Мөхәррирләүгә кире ҡайтыу өсөн, браузерығыҙҙа кире ҡайтыу төймәһенә баҫығыҙ.',
);

/** Belarusian (Taraškievica orthography) (беларуская (тарашкевіца)‎)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'questycaptcha-addurl' => 'Вашае рэдагаваньне ўтрымлівае вонкавыя спасылкі.
Каб абараніцца да аўтаматычнага спаму, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptcha-badlogin' => 'Для абароны супраць аўтаматычнага падбору пароля, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptcha-createaccount' => 'Для абароны супраць аўтаматычнага стварэньня рахункаў, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptcha-create' => 'Для стварэньня старонкі, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptcha-edit' => 'Для рэдагаваньня гэтай старонкі, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptcha-sendemail' => 'У мэтах абароны супраць аўтаматычнага спаму, калі ласка, адкажыце на пытаньне, паказанае ніжэй ([[Special:Captcha/help|дадатковая інфармацыя]]):',
	'questycaptchahelp-text' => 'Вэб-сайты, якія прымаюць запісы ад грамадзкасьці, падобныя на {{GRAMMAR:вінавальны|{{SITENAME}}}}, часта атакуюцца спамэрамі, якія ўжываюць аўтаматызаваныя інструмэнты, каб зьмяшчаць свае спасылкі на шмат сайтаў.
І хаця гэтыя спасылкі могуць быць прыбраныя, яны выклікаюць значныя нязручнасьці.

Часам, асабліва калі Вы дадаеце новыя вонкавыя спасылкі на старонку, {{SITENAME}} можа паказаць Вам выяву з каляровым ці скажоным тэкстам і папрасіць увесьці гэты тэкст.
Праз тое, што гэтае заданьне цяжка аўтаматызаваць, яно дазволіць большасьці рэальных людзей рабіць запісы, але спыніць большасьць спамэраў і іншых аўтаматызаваных робатаў.

На жаль, гэта можа выклікаць нязручнасьці для ўдзельнікаў з абмежаваньнямі па зроку і для тых, хто ўжывае тэкставыя ці моўныя браўзэры.
На гэты момант мы ня маем аўдыё-альтэрнатывы гэтай праверцы.
Калі ласка, зьвяжыцеся з [[{{MediaWiki:Grouppage-sysop}}|адміністратарамі]], калі гэтая праверка перашкаджае Вам рабіць слушныя запісы.

Націсьніце кнопку «назад» у Вашым браўзэры, каб вярнуцца да рэдагаваньня старонкі.',
);

/** Breton (brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'questycaptcha-addurl' => "Degaset hoc'h liammoù diavaez nevez.
A-benn hor skoazellañ da stourm a-enep d'ar strob emgefre, respontit d'ar goulenn a-is ([[Special:Captcha/help|muioc'h a ditouroù]]) :",
	'questycaptcha-badlogin' => "A-benn hor skoazellañ da stourm a-enep ar freuzañ gerioù-tremen gant ardivinkoù, respontit d'ar goulenn a-is ([[Special:Captcha/help|muioc'h a ditouroù]]) :",
	'questycaptcha-createaccount' => "A-benn hor skoazellañ da stourm a-enep ar c'hrouiñ kontoù emgefre, respontit d'ar goulenn a-is ([[Special:Captcha/help|muioc'h a ditouroù]]) :",
	'questycaptcha-create' => "A-benn gellout krouiñ ar bajenn, respontit d'ar goulenn a-is ([[Special:Captcha/help|muioc'h a ditouroù]]) :",
	'questycaptcha-edit' => "A-benn gellout degas kemmoù er bajenn-mañ, respontit d'ar goulenn a-is ([[Special:Captcha/help|muioc'h a ditouroù]]) :",
	'questycaptcha-sendemail' => "Evit hor skoazellañ da zizarbenn ar strob emgefre, respontit d'ar goulenn skrivet dindan ([[Special:Captcha/help|gouzout hiroc'h]]) :",
	'questycaptchahelp-text' => "Alies e vez taget al lec'hiennoù a zegemer kemennadennoù a-berzh an holl, evel ar wiki-mañ, gant ar stroberien a implij ostilhoù emgefre evit postañ o liammoù war-du lec'hiennoù a bep seurt. Ha pa c'hallfent bezañ diverket, kazus-mat ez eo ar stroboù-se memes tra.

A-wezhioù, dreist-holl pa vez ouzhpennet liammoù Web nevez war ur bajenn, e c'hallo ar wiki-mañ sevel ur goulenn ouzhoc'h. 
Un trevell start da emgefrekaat eo hemañ. Gant se e c'hallo an implijerien wirion postañ ar pezh a fell dezho tra ma vo lakaet un harz d'an darn vrasañ eus ar stroberien pe d'an dagerien robotek all.

Kit e darempred gant [[{{MediaWiki:Grouppage-sysop}}|merourien al lec'hienn]] evit bezañ skoazellet m'hoc'h eus diaesterioù da gemer perzh da vat abalamour d'an teknik-se.

Pouezit war bouton 'kent' ho merdeer evit distreiñ d'ar bajenn gemmañ.",
);

/** Bosnian (bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'questycaptcha-addurl' => 'Vaša izmjena uključuje nove vanjske linkove.
Da bi pomogli protiv automatskog spama, molimo odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptcha-badlogin' => 'Da bi pomogli u sprječavanju protiv automatskog probijanja šifre, molimo Vas da odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptcha-createaccount' => 'Da bi pomogli u sprječavanju automatskog pravljenja računa, molimo Vas da odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptcha-create' => 'Da bi ste napravili stranicu, molimo Vas da odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptcha-edit' => 'Da bi ste uredili ovu stranicu, molimo Vas da odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptcha-sendemail' => 'Da bi pomogli u zaštiti protiv automatskog spamovanja, molimo Vas da odgovorite na pitanje koje je prikazano ispod ([[Special:Captcha/help|više informacija]]):',
	'questycaptchahelp-text' => "Websajtovi koji podržavaju doprinose iz javnosti, kao što je ovaj viki, često zloupotrebljavaju vandali koji koriste automatizovane alate da šalju svoje linkove ka mnogim sajtovima.
Iako se ovi neželjeni linkovi mogu ukloniti, oni ipak zadaju veliku muku.

Ponekad, pogotovo kad se dodaju novi internet linkovi na stranicu, wiki može tražiti od Vas da odgovorite na pitanje. Pošto je teško automatizovati ovakav zadatak, on omogućuje svim pravim ljudima da vrše svoje izmjene, ali će zato spriječiti vandale i ostale robotske napadače.

Molimo Vas da kontaktirate [[{{MediaWiki:Grouppage-sysop}}|administratore stranice]] za pomoć ako je ovo prepreka za Vas da pravite uobičajene izmjene.

Kliknite 'nazad' ('back') dugme vašeg preglednika da se vratite na polje za unos teksta.",
);

/** Catalan (català)
 * @author Paucabot
 * @author Toniher
 */
$messages['ca'] = array(
	'questycaptcha-addurl' => "L'edició inclou enllaços externs nous.
Per ajudar a protegir-se contra la brossa automàtica, responeu la pregunta que apareix a continuació ([[Special:Captcha/help|més informació]]):",
	'questycaptcha-create' => 'Per crear la pàgina, per favor responeu la pregunta que apareix a continuació ([[Special:Captcha/help|més informació]]):',
);

/** Czech (česky)
 * @author Mormegil
 */
$messages['cs'] = array(
	'questycaptcha-addurl' => 'Vaše editace obsahuje nové externí odkazy.
V zájmu ochrany před automatickým spamováním musíte zodpovědět níže uvedenou otázku ([[Special:Captcha/help|další informace]]):',
	'questycaptcha-badlogin' => 'V rámci ochrany proti automatickým pokusům uhodnout heslo musíte zodpovědět níže uvedenou otázku ([[Special:Captcha/help|další informace]]):',
	'questycaptcha-createaccount' => 'V rámci ochrany před automatickým vytvářením účtů musíte pro provedení registrace zodpovědět níže uvedenou otázku ([[Special:Captcha/help|další informace]]):',
	'questycaptcha-create' => 'Abyste mohli založit stránku, musíte zodpovědět níže uvedenou otázku ([[Special:Captcha/help|další informace]]):',
	'questycaptcha-edit' => 'Abyste mohli editovat tuto stránku, musíte zodpovědět níže uvedenou otázku ([[Special:Captcha/help|další informace]]):',
	'questycaptcha-sendemail' => 'V rámci ochrany proti automatickému spamování musíte zodpovědět níže zobrazenou otázku ([[Special:Captcha/help|více informací]]):',
	'questycaptchahelp-text' => 'Webové stránky, do kterých mohou přispívat jejich návštěvníci (jako například tato wiki), jsou často terčem spammerů, kteří pomocí automatických nástrojů vkládají své odkazy na velké množství stránek. Přestože lze tento spam odstranit, představuje nepříjemné obtěžování.

Někdy, zvláště při přidávání nových webových odkazů, vás wiki může požádat o zodpovězení otázky.
Jelikož takovou úlohu lze jen těžko automatizovat, skuteční lidé mohou dále přispívat, zatímco většinu spammerů a jiných robotických útočníků to zastaví.

Pokud vám to brání v užitečných příspěvcích a potřebujete pomoc, kontaktujte laskavě [[{{MediaWiki:Grouppage-sysop}}|správce serveru]].

Pro návrat na předchozí stránku stiskněte ve svém prohlížeči tlačítko „zpět“.',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'questycaptcha-addurl' => 'Mae eich golygiad yn cynnwys o leiaf un cyswllt allanol newydd.
Er mwyn ceisio rhwystro peiriannau sbam, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):',
	'questycaptcha-badlogin' => 'Er mwyn ceisio rhwystro peiriannau datrys cyfrineiriau, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):',
	'questycaptcha-createaccount' => 'Er mwyn ceisio rhwystro peiriannau creu cyfrifon, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):',
	'questycaptcha-create' => "Er mwyn dechrau'r dudalen, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'questycaptcha-edit' => "Er mwyn golygu'r dudalen, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):",
	'questycaptcha-sendemail' => 'Er mwyn cyfrannu at ddiogelu rhag sbamio awtomatig, byddwch gystal ag ateb y cwestiwn a welwch isod ([[Special:Captcha/help|rhagor o wybodaeth]]):',
);

/** German (Deutsch)
 * @author Geitost
 * @author Kghbln
 * @author Pill
 * @author Umherirrender
 */
$messages['de'] = array(
	'questycaptcha-desc' => 'Questy-CAPTCHA-Generator für die Erweiterung „Confirm Edit“',
	'questycaptcha-addurl' => 'Deine Bearbeitung enthält neue externe Links.
Zum Schutz vor automatisiertem Spam, beantworte bitte die untenstehende Frage, um die Seite speichern zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-badlogin' => 'Zum Schutz vor einer Kompromittierung deines Benutzerkontos, beantworte bitte die untenstehende Frage, um dich anmelden zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-createaccount' => 'Zum Schutz vor einer automatisierten Anlage von Benutzerkonten ist es erforderlich, die folgende Frage zu beantworten ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-create' => 'Bitte beantworte die folgende Frage, um diese Seite erstellen zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-edit' => 'Bitte beantworte die folgende Frage, um diese Seite speichern zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-sendemail' => 'Zum Schutz vor automatisiertem Spam bitte die untenstehende Frage beantworten ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptchahelp-text' => 'Internetangebote, die — wie dieses Wiki — für Beiträge von praktisch jedem offen sind, werden häufig von Spammern missbraucht, welche versuchen, mithilfe entsprechender Werkzeuge ihre Links automatisch auf vielen Webseiten zu platzieren.
Zwar können derartige Spam-Links wieder entfernt werden, doch stellen sie trotzdem ein erhebliches Ärgernis dar.

In manchen Fällen, meist beim Versuch, neue Weblinks zu einer Seite hinzuzufügen, kann es vorkommen, dass du um die Beantwortung einer Frage gebeten wirst.
Da es kaum möglich ist, dies zu automatisieren, können hierdurch die meisten Spammer aufgehalten werden. Menschlichen Benutzer sollten ihre Bearbeitungen hingegen durchführen können.

Sollte dich dieses Verfahren beim Vornehmen erwünschter Bearbeitungen behindern, wende dich bitte an einen [[{{MediaWiki:Grouppage-sysop}}|Administrator]], um Unterstützung zu erhalten.

Die Schaltfläche „Zurück“ des Browsers führt zurück zum vorherigen Bearbeitungsfenster.',
);

/** German (formal address) (Deutsch (Sie-Form)‎)
 * @author Imre
 * @author Umherirrender
 */
$messages['de-formal'] = array(
	'questycaptcha-addurl' => 'Ihre Bearbeitung enthält neue externe Links.
Zum Schutz vor automatisiertem Spam beantworten Sie bitte die untenstehende Frage ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-badlogin' => 'Zum Schutz vor einer Kompromittierung Ihres Benutzerkontos beantworten Sie bitte die folgende Frage ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-create' => 'Bitte beantworten Sie die folgende Frage, um diese Seite erstellen zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-edit' => 'Bitte beantworten Sie die folgende Frage, um diese Seite bearbeiten zu können ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptcha-sendemail' => 'Zum Schutz vor automatisiertem Spam bitten wir Sie, die folgende Frage zu beantworten ([[Special:Captcha/help|weitere Informationen]]):',
	'questycaptchahelp-text' => 'Internetangebote, die — wie dieses Wiki — für Beiträge von praktisch jedem offen sind, werden häufig von Spammern missbraucht, welche versuchen, mithilfe entsprechender Werkzeuge ihre Links automatisch auf vielen Webseiten zu platzieren.
Zwar können derartige Spam-Links wieder entfernt werden, doch stellen sie trotzdem ein erhebliches Ärgernis dar.

In manchen Fällen, meist beim Versuch, neue Weblinks zu einer Seite hinzuzufügen, kann es vorkommen, dass Sie um die Beantwortung einer Frage gebeten wirst.
Da es kaum möglich ist, dies zu automatisieren, können hierdurch die meisten Spammer aufgehalten werden. Menschlichen Benutzer sollten ihre Bearbeitungen hingegen durchführen können.

Sollte Sie dieses Verfahren beim Vornehmen erwünschter Bearbeitungen behindern, wenden Sie sich bitte an einen [[{{MediaWiki:Grouppage-sysop}}|Administrator]], um Unterstützung zu erhalten.

Der „Zurück“-Knopf des Browsers führt zurück zum Bearbeitungsfenster.',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'questycaptcha-addurl' => 'Twója změna wopśimujo nowe eksterne wótkaze.
Za šćit pśeśiwo zawtomatizěrowanemu spamoju, wótegroń pšosym na pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptcha-badlogin' => 'Za šćit pśeśiwo zawtomatizěrowanemu wusnuchlenjeju gronidła, wótegroń pšosym na pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptcha-createaccount' => 'Za šćit pśeśiwo zawtomatizěrowanemu napóranjeju kontow, wótegroń pšosym na pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptcha-create' => 'Aby napórał bok, wótegroń pšosym na pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptcha-edit' => 'Aby wobźěłał toś ten bok, wótegroń pšosym na pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptcha-sendemail' => 'Za šćit pśeśiwo awtomatiskemu spamowanjeju, wótegroń pšosym pšašanje, kótarež pokazujo se dołojce ([[Special:Captcha/help|dalšne informacije]]):',
	'questycaptchahelp-text' => 'Websedła, kótarež akceptěruju zjawne pśinoski, ako toś ten wiki, znjewužywaju se cesto wót spamowarjow, kótarež wužywaju zawtomatizěrowane rědy, aby pśidali swóje wótkaze na wjele sedłow. Lěcrownož toś te spamowe wótkaze daju se wótpóraś, su wóne bejna pógóršota. 

Wótergi, wósebnje, gaž se nowe wótkaze pśidawaju bokoju, jo móžno, až se śi wiki něco pšaša. 
Dokulaž to jo nadawk, kótaryž dajo se śěžko awtomatizěrowaś, dowólujo to napšawdnym luźam jich pśinoski wótpósłaś, nejwěcej spamowarjow a robotowe ataki pak se zaźaržyju. 

Staj se pšosym z [[{{MediaWiki:Grouppage-sysop}}|administratorami sedła]] z pšosbu wó pomoc do zwiska, jolic to śi njewócakane zawobarujo słanje legitimnych pśinoskow. 

Klikni na tłocašk "Slědk" we swójom wobglědowaku, aby wróśił se k wobźěłowańskemu woknoju.',
);

/** Greek (Ελληνικά)
 * @author Omnipaedista
 */
$messages['el'] = array(
	'questycaptcha-addurl' => 'Η επεξεργασία σας περιέχει νέους εξωτερικούς συνδέσμους.
Για να μας βοηθήσετε στην προστασία κατά των αυτοματοποιημένων σπαμ, παρακαλώ απαντήστε στην παρακάτω ερώτηση ([[Special:Captcha/help|περισσότερες πληροφορίες]]):',
);

/** Esperanto (Esperanto)
 * @author Castelobranco
 */
$messages['eo'] = array(
	'questycaptcha-addurl' => 'Via redakto entenas novajn eksterajn ligilojn. 
Por helpi protekti kontraŭ aŭtomatan spamadon, bonvolu respondu la demandon sube ([[Special:Captcha/help|pli da informo]]):',
	'questycaptcha-badlogin' => 'Por helpi protekti kontraŭ aŭtomata divenado de pasvortoj, bonvolu respondu la demandon sube ([[Special:Captcha/help|pli da informo]]):',
	'questycaptcha-createaccount' => 'Por helpi protekti kontraŭ aŭtomata konto-kreado, bonvolu respondu la demandon sube ([[Special:Captcha/help|pli da informo]]):',
	'questycaptcha-create' => 'Por krei la paĝon, bonvolu respondu la demandon sube ([[Special:Captcha/help|pli da informo]]):',
	'questycaptcha-edit' => 'Por redakti ĉi tiun paĝon, bonvolu respondu la demandon sube ([[Special:Captcha/help|pli da informo]]):',
	'questycaptchahelp-text' => "Retejoj kiuj akcepti informon de publiko, kiel ĉi tiu vikio, estas ofte misuzitaj de spamistoj kiu uzas aŭtomatajn ilojn por afiŝi ligilojn al multaj retejoj. Kvankam ĉi tiu spam-ligiloj estas forigeblaj, ili estas granda ĝeno.

Iufoje, ja kiam aldonante novajn retligilojn al paĝo, la vikio eble petos al vi respondi demandon. Tial ĉi tiu tasko estas malfacila por fari aŭtomate, ebligos al realaj homoj fari aldonaĵojn, kaj malebligos spamistojn kaj aliajn robotajn atakilojn.

Bonvolu kontakti la [[{{MediaWiki:Grouppage-sysop}}|administrantojn de la retejo]] por helpo se ĉi tio malebligas al vi fari bonan aldonon.

Klaku la 'reiru' butonon en via retumilo por reiri al la paĝo-redaktilo.",
);

/** Spanish (español)
 * @author Crazymadlover
 * @author Pertile
 */
$messages['es'] = array(
	'questycaptcha-addurl' => 'Tu edición incluye nuevos vínculos externos.
Para ayudar a proteger contra spam automático, por favor responde la pregunta que aparece abajo ([[Special:Captcha/help|más información]]):',
	'questycaptcha-badlogin' => 'Para ayudar a proteger contra craqueo de contraseña, por favor responde la pregunta que aparece abajo ([[Special:Captcha/help|más información]]):',
	'questycaptcha-createaccount' => 'Para ayudar a proteger contra la creación automática de cuentas, por favor responde la pregunta que aparece abajo ([[Special:Captcha/help|más información]]):',
	'questycaptcha-create' => 'Para crear la página, por favor responde la pregunta que aparece abajo ([[Special:Captcha/help|más información]]):',
	'questycaptcha-edit' => 'Para editar esta página, por favor responde la pregunta que aparece abajo ([[Special:Captcha/help|más información]]):',
	'questycaptcha-sendemail' => 'Para protegernos contra el spam automatizado por favor conteste la pregunta que aparece a continuación ([[Special:Captcha/help|más información]]):',
	'questycaptchahelp-text' => "Sitios Web que aceptan contribuciones del público, como este wiki, son constantemente abusadas por enviadores de spam quienes usan herramientas automáticas para agregar sus enlaces a muchos sitios.
Así estos enlaces spam puedan ser borrados, son una molestia significativa.

A veces, especialmente cuando se agregan nuevos enlaces web a una página, el wiki puede pedirte que respondas a una pregunta.
Ya que esta es una tarea que es difícil de automatizar, eso permitirá que más seres humanos reales hagan sus contribuciones mientras detiene a la mayor parte de enviadores de spam y otros atacantes robóticos.

Por favor contacta a los [[{{MediaWiki:Grouppage-sysop}}|administradores del sitio]] para asistencia si esto está impidiéndote hacer contribuciones legítimas.

Haz click en el botón 'atrás' en tu navegador para regresar al editor de página.",
);

/** Estonian (eesti)
 * @author Pikne
 */
$messages['et'] = array(
	'questycaptcha-addurl' => 'Sinu muudatus sisaldab uusi välislinke.
Palun vasta alljärgnevale küsimusele. Abinõu on kaitseks automaadistatud rämpsmuudatuste eest ([[Special:Captcha/help|lisateave]]):',
	'questycaptcha-badlogin' => 'Palun vasta alljärgnevale küsimusele. Abinõu on kaitseks automaatsete parooliäraarvajate eest ([[Special:Captcha/help|lisateave]]):',
	'questycaptcha-createaccount' => 'Palun vasta alljärgnevale küsimusele. Abinõu on kaitseks kontode automaatse loomise eest ([[Special:Captcha/help|lisateave]]):',
	'questycaptcha-create' => 'Lehekülje loomiseks vasta palun alljärgnevale küsimusele ([[Special:Captcha/help|lisateave]]):',
	'questycaptcha-edit' => 'Selle lehekülje muutmiseks vasta palun alljärgnevale küsimusele ([[Special:Captcha/help|lisateave]]):',
	'questycaptcha-sendemail' => 'Palun vasta alljärgnevale küsimusele. Abinõu on kaitseks automaadistatud rämpsmuudatuste eest ([[Special:Captcha/help|lisateave]]):',
	'questycaptchahelp-text' => "Võrgukohti, mis lubavad külastajatel sisu muuta, nagu ka see viki, kasutavad sageli rämpsposti levitajad, lisades näiteks lehekülgedele reklaamilinke. Kuigi neid linke saab eemaldada, on nad siiski tülikad.

Kasutajakontot registreerides või mõnele lehele uusi internetiaadresse postitades võidakse paluda sul küsimusele vastata.
Kuna sellist tegevust on raske automaadistada, on see efektiivseks kaitseks rämpspostirobotite vastu ja lubab samas tavakasutajatel rahus muudatusi teha.

Kui sul tekib raskusi muudatuste tegemisel, võta palun ühendust selle võrgukoha [[{{MediaWiki:Grouppage-sysop}}|administraatoritega]].

Redigeerimislehele naasmiseks klõpsa võrgulehitseja ''tagasi''-nuppu.",
);

/** Basque (euskara)
 * @author Kobazulo
 */
$messages['eu'] = array(
	'questycaptcha-create' => 'Orrialdea sortzeko, behean agertzen den galdera erantzun ezazu mesedez ([[Special:Captcha/help|informazio gehiago]]):',
	'questycaptcha-edit' => 'Orrialde hau aldatzeko, behean agertzen den galdera erantzun ezazu mesedez ([[Special:Captcha/help|informazio gehiago]]):',
);

/** Finnish (suomi)
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'questycaptcha-addurl' => 'Muokkauksesi sisältää uusia ulkoisia linkkejä.
Automatisoitujen roskamuokkausten välttämiseksi vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptcha-badlogin' => 'Automatisoidun salasanan murtamisen estämiseksi vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptcha-createaccount' => 'Automaattisen käyttäjätunnusten luonnin estämiseksi vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptcha-create' => 'Luodaksesi sivun vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptcha-edit' => 'Muokataksesi tätä sivua vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptcha-sendemail' => 'Automatisoidun roskapostin lähettämisen estämiseksi vastaa alla olevaan kysymykseen ([[Special:Captcha/help|lisätietoja]]):',
	'questycaptchahelp-text' => 'Web-sivustot, jotka hyväksyvät materiaalia yleisöltä, kuten tämä wiki, joutuvat usein automaattisia työkaluja käyttävien "spämmääjien" kohteeksi jotka lisäävät linkkejä eri sivustoille. Vaikka nämä roskalinkit voidaan poistaa, ne ovat merkittävä haittatekijä.

Joskus, erityisesti kun lisäät uusia Web-linkkejä sivulle, wiki saattaa pyytää sinua vastaamaan kysymykseen.
Koska tämä on vaikeasti automatisoitava tehtävä, se antaa useimpien oikeiden henkilöiden osallistua estäen roskamuokkausten ja muiden automaattisten hyökkäysten tekijöitä.

Ota yhteyttä [[{{MediaWiki:Grouppage-sysop}}|ylläpitäjiin]] saadaksesi avustusta jos tämä odottamattomasti estää sinua tekemästä asiallisia muokkauksia.

Napsauta selaimesi \'takaisin\'-painiketta palataksesi sivumuokkaimeen.',
);

/** French (français)
 * @author IAlex
 * @author Nicolas NALLET
 * @author Verdy p
 */
$messages['fr'] = array(
	'questycaptcha-desc' => "Générateur de questions ''captcha'' pour confirmer les modifications",
	'questycaptcha-addurl' => 'Votre modification inclut de nouveaux liens externes.
Pour nous aider dans la protection contre le pourriel automatisé, veuillez répondre à la question ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptcha-badlogin' => 'Afin de nous aider à prévenir le cassage des mots de passe par des automates, veuillez répondre à la question ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptcha-createaccount' => 'Afin de nous aider à lutter contre les créations automatiques de comptes, veuillez répondre à la question qui apparaît ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptcha-create' => 'Pour créer la page, veuillez répondre à la question ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptcha-edit' => 'Pour créer, modifier ou publier cette page, veuillez répondre à la question ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptcha-sendemail' => 'Afin de nous aider à prévenir le spam automatique, veuillez répondre à la question ci-dessous ([[Special:Captcha/help|plus d’informations]]) :',
	'questycaptchahelp-text' => 'Les sites web qui acceptent des contributions du public, tels que ce wiki, sont souvent victimes de polluposteurs qui utilisent des outils automatisés pour placer de nombreux liens vers leurs sites.
Même si cette pollution peut être effacée, elle n’en reste pas moins irritante.

Parfois, particulièrement lors de l’ajout de nouveaux liens externes dans une page, le wiki peut vous demander de répondre à une question.
Cette tâche étant difficile à accomplir de façon automatisée, cela permet à la plupart des humains de réaliser leurs contributions tout en stoppant la plupart des polluposteurs et autres attaquants robotisés.

Veuillez contacter [[{{MediaWiki:Grouppage-sysop}}|les administrateurs du site]] si cela vous empêche de façon inattendue de faire des contributions légitimes.

Cliquez sur le bouton « Précédent » de votre navigateur pour revenir à la page de modification.',
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'questycaptcha-desc' => 'Xerador de preguntas CAPTCHA para Confirm Edit',
	'questycaptcha-addurl' => 'A súa edición inclúe novas ligazóns externas.
Para axudar na protección contra o spam automatizado, conteste a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptcha-badlogin' => 'Para axudar na protección contra o descifrado automatizado de contrasinais, conteste a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptcha-createaccount' => 'Para axudar na protección contra a creación automática de contas, conteste a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptcha-create' => 'Para crear a páxina, conteste a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptcha-edit' => 'Para editar esta páxina, conteste a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptcha-sendemail' => 'Para contribuír na protección contra o spam automatizado, responda a pregunta que aparece a continuación ([[Special:Captcha/help|máis información]]):',
	'questycaptchahelp-text' => 'Os sitios web que aceptan publicar as contribucións dos usuarios, coma este wiki, sofren, con frecuencia, o abuso por parte de spammers que usan ferramentas que automatizan a inclusión de lixo en forma de ligazóns publicitarias, nunha chea de páxinas, en pouco tempo.
Mentres as devanditas ligazóns non son eliminadas supoñen unha molestia e unha perda de tempo.

En ocasións, en particular cando engada algunha nova ligazón externa, o wiki pode pedirlle que conteste unha pregunta.
Como esta tarefa é difícil de automatizar, permite distinguir entre persoas e robots e dificulta os ataques automatizados dos spammers.

Por favor, póñase en contacto cun [[{{MediaWiki:Grouppage-sysop}}|administrador do sitio]] para solicitar axuda se o sistema lle impide rexistrarse para facer contribucións lexítimas.

Prema no botón "Atrás" do seu navegador para volver á páxina de edición.',
);

/** Swiss German (Alemannisch)
 * @author Als-Chlämens
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'questycaptcha-addurl' => 'In Dynere Bearbeitig het s neji extärni Links.
As Schutz gege automatischi Spam, beantwort bitte d Frog, wu do unter gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptcha-badlogin' => 'As Schutz gege ne automatisch Passwort-Knacke, beantwort bitte d Frog, wu do unte gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptcha-createaccount' => 'As Schutz gege ne automatisch Aalege vu Benutzerkonte, beantwort bitte d Frog, wu do unte gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptcha-create' => 'Go d Syte aalege, beantwort bitte d Frog, wu do unte gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptcha-edit' => 'Go die Syte bearbeite, beantwort bitte d Frog, wu do unte gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptcha-sendemail' => 'As Schutz gege e automatischs Spamming, beantwort bitte d Frog, wu do unte gnännt wird ([[Special:Captcha/help|meh Informatione]]):',
	'questycaptchahelp-text' => "Websyte, wu jede cha byytrage, wie des Wiki, wäre vylmol missbrucht vu Spammer, wu automatischi Wärchzyg bruche go ihri Gleicher (Links) in meglischt vyli Syte yyfiege.
Au wänn die Spamgleicher chenne wider uusegnuu wäre, sin si einewäg e zimlig Ärgernis.

Ab un zue, vor allem wänn neji Netzgleicher (Weblinks) in e Syte yygfiegt wäre, forderet s Wiki Di villicht uf, e Frog z beantworte.
Wel des e Ufgab isch, wu mer schwär cha automatisiere, isch des e Megligkeit, Spammer un anderi automatischi Attacke z verhindere, derwylscht di meischte mänschlige Benutzer ihri Bearbeitige chenne byytrage.

Bitte nimm Kontakt uf zue dr [[{{MediaWiki:Grouppage-sysop}}|Website-Administratore]] fir Hilf, wänn des unerwarteterwys verhinderet, ass Du chasch rächtmäßigi Bearbeitige mache.

Druck dr 'Zruck'-Chnopf in Dyym Browser go zuem Bearbeitigsfänschter zruckgoh.",
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author YaronSh
 */
$messages['he'] = array(
	'questycaptcha-addurl' => 'עריכתכם כוללת קישורים חיצוניים חדשים.
כהגנה מפני ספאם אוטומטי, אנא ענו על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptcha-badlogin' => 'כהגנה מפני פריצת סיסמאות אוטומטית, אנא ענו על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptcha-createaccount' => 'כהגנה מפני יצירת חשבונות אוטומטית, אנא ענו על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptcha-create' => 'כדי ליצור את הדף, אנא ענו על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptcha-edit' => 'כדי לערוך את הדף, אנא ענו על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptcha-sendemail' => 'כדי לסייע בהגנה מפני הודעות ספאם אוטומטיות, נא לענות על השאלה המופיעה להלן ([[Special:Captcha/help|מידע נוסף]]):',
	'questycaptchahelp-text' => "פעמים רבות מנצלים ספאמרים אתרים שמקבלים תוכן מהציבור, כמו אתר הוויקי הזה, כדי להוסיף את הקישורים שלהם לאתרים רבים באינטרנט, באמצעות כלים אוטומטיים.
אמנם ניתן להסיר את קישורי הספאם הללו, אך הם מהווים מטרד משמעותי.

לעתים, בעיקר כשאתם מכניסים קישורי אינטרנט חדשים לתוך עמוד, אתר הוויקי עשוי לבקש מכם לענות על שאלה.
כיוון שזו משימה שקשה לבצעה בצורה אוטומטית, הדבר יאפשר לבני־אדם אמיתיים לשלוח את הדפים, אך יעצור את רוב הספאמרים והמתקיפים הרובוטיים האחרים.

אנא צרו קשר עם [[{{MediaWiki:Grouppage-sysop}}|מפעילי המערכת]] לעזרה אם המערכת מונעת מכם באופן בלתי צפוי לבצע עריכות לגיטימיות.

לחצו על הכפתור 'Back' בדפדפן שלכם כדי לחזור לדף העריכה.",
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'questycaptcha-addurl' => 'Twoja změna wobsahuje nowe eksterne wotkazy.
Za škit přećiwo awtomatizowanemu spamej, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalše informacije]]):',
	'questycaptcha-badlogin' => 'Za škit přećiwo awtomatiskemu kradnjenju hesła, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalše informacije]]):',
	'questycaptcha-createaccount' => 'Za škit přećiwo awtomatizowanemu tworjenju kontow, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalš informacije]]):',
	'questycaptcha-create' => 'Zo by stronu wutworił, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalše informacije]]):',
	'questycaptcha-edit' => 'Zo by tutu stronu změnił, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalše informacije]]):',
	'questycaptcha-sendemail' => 'Za škit přećiwo awtomatiskemu spamowanju, wotmołw prošu na prašenje, kotrež so deleka jewi ([[Special:Captcha/help|dalše informacije]]):',
	'questycaptchahelp-text' => 'Websydła, kotrež přinoški ze zjawnosće akceptuja, kaž tutón wiki, so často wot spamarjow znjewužiwaja, kotřiž awtomatizowane nastroje wužiwaja, zo bychu swoje wotkazy wjele sydłam přidali. Hačrunjež so tute spamowe wotkazy hodźa wotstronić, su wone njesnadne mjerzanje.

Druhdy, wosebje, hdyž so nowe webwotkazy stronje přidawaja, wiki so ći něčeho praša.
Dokelž to je nadawk, kotryž hodźi so jenož ćežko awtomatizować, dowoluje to woprawdźitym wosobam swoje přinoški wotpósłać, mjeztym zo so najwjace spamarjow a druhich nadpadowacych botow blokuje. 

Prošu staj so z [[{{MediaWiki:Grouppage-sysop}}|administratorami sydła]] z prostwu wo pomoc do zwiska, jeli to će haći legitimne přinoški pósłać. 

Klikń na tłócatko "Wróćo" w swojim wobhladowaku, zo by so k wobdźěłowanskemu woknu wróćił.',
);

/** Hungarian (magyar)
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'questycaptcha-addurl' => 'A szerkesztésed új külső hivatkozásokat tartalmaz.
Segíts az automatikus spamek elleni védekezésben, kérlek válaszolj az alábbi kérdésre ([[Special:Captcha/help|további információk]]):',
	'questycaptcha-badlogin' => 'Segíts az automatikus jelszófeltörés kivédésében, kérlek válaszolj az alábbi kérdésre ([[Special:Captcha/help|további információk]]):',
	'questycaptcha-createaccount' => 'Segíts az automatikus felhasználói fiók készítés kivédésében, kérlek válszolj az alábbi kérdésre ([[Special:Captcha/help|további információk]]):',
	'questycaptcha-create' => 'Kérlek válaszolj az alábbi kérdésre a lap létrehozásához ([[Special:Captcha/help|további információk]]):',
	'questycaptcha-edit' => 'A lap szerkesztéséhez kérlek válaszolj az alábbi kérdésre ([[Special:Captcha/help|további információk]]):',
	'questycaptcha-sendemail' => 'Hogy segíts az automatikus spammelés elleni védekezésben, kérünk válaszolj az alábbi kérdésre ([[Special:Captcha/help|segítség]]):',
	'questycaptchahelp-text' => 'Az olyan weboldalakat, amelyekre bárki írhat, gyakran támadják meg spammerek olyan eszközök felhasználásával, amelyek képesek automatikusan, emberi felügyelet nélkül elhelyezni hivatkozásokat sok különböző oldalon. 

Néha, különösen ha egy új külső hivatkozást teszel egy szócikkbe, a wiki egy egy kérdés megválaszolására kérhet.
Mivel ezt nehéz automatizálni, a valódi szerkesztőknek lehetőségük lesz szerkeszteni, miközben kiszűri a legtöbb spammert és más automatizált kártevőket.

Ha ez nem várt módon akadályoz a hasznos közreműködéseidben, segítségért kérlek vedd fel a kapcsolatot [[{{MediaWiki:Grouppage-sysop}}|az oldal adminisztrátoraival]].

Használd a böngésződ „vissza” gombját a szöveg szerkesztéséhez való visszalépéshez.',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'questycaptcha-addurl' => 'Tu modification include nove ligamines externe.
Pro adjutar nos in le protection contra le spam automatisate, per favor responde al question ci infra ([[Special:Captcha/help|plus info]]):',
	'questycaptcha-badlogin' => 'Pro adjutar nos in le protection contra le deciframento automatisate de contrasignos, per favor responde al question ci infra ([[Special:Captcha/help|plus info]]):',
	'questycaptcha-createaccount' => 'Pro adjutar nos in le protection contra le creation automatisate de contos, per favor responde al question ci infra ([[Special:Captcha/help|plus info]]):',
	'questycaptcha-create' => 'Pro crear le pagina, per favor responde al question ci infra ([[Special:Captcha/help|plus info]]):',
	'questycaptcha-edit' => 'Pro modificar iste pagina, per favor responde al question ci infra ([[Special:Captcha/help|plus info]]):',
	'questycaptcha-sendemail' => 'Pro adjutar nos in le protection contra le spam automatic, per favor responde al question hic infra ([[Special:Captcha/help|plus info]]):',
	'questycaptchahelp-text' => "Le sitos web que accepta contributiones del publico, como iste wiki, es frequentemente abusate per spammatores que usa instrumentos automatic pro publicar lor ligamines in multe sitos.
Ben que iste ligamines spam pote esser eliminate, illos constitue un considerabile molestia.

Alcun vices, specialmente quando tu adde nove ligamines web a un pagina, le wiki pote demandar te de responder a un question.
Post que isto es un carga difficile de automatisar, isto permittera al major parte del humanos real de facer lor contributiones, durante que le major parte del spammatores e altere attaccatores robotic es stoppate.

Per favor contacta le [[{{MediaWiki:Grouppage-sysop}}|administratores del sito]] pro assistentia si isto insperatemente te impedi de facer contributiones legitime.

Clicca le button 'retro' in tu navigator pro retornar al editor de paginas.",
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Irwangatot
 * @author IvanLanin
 * @author Iwan Novirion
 */
$messages['id'] = array(
	'questycaptcha-addurl' => 'Suntingan Anda menambahkan pranala eksternal yang baru.
Untuk melindungi dari spam otomatis, mohon jawab pertanyaan di bawah ini
([[Special:Captcha/help|info lebih lanjut]]):',
	'questycaptcha-badlogin' => 'Untuk melindungi dari pemecah kata sandi otomatis, mohon jawab pertanyaan di bawah ini
([[Special:Captcha/help|info lebih lanjut]]):',
	'questycaptcha-createaccount' => 'Untuk melindungi dari pembuatan akun otomatis, mohon jawab pertanyaan di bawah ini
([[Special:Captcha/help|info lebih lanjut]]):',
	'questycaptcha-create' => 'Untuk membuat halaman, mohon jawab pertanyaan di bawah ini
([[Special:Captcha/help|info lebih lanjut]]):',
	'questycaptcha-edit' => 'Untuk menyunting halaman ini, mohon jawab pertanyaan di bawah ini
([[Special:Captcha/help|info lebih lanjut]]):',
	'questycaptcha-sendemail' => 'Sebagai pelindungan terhadap spam otomatis, silahkan jawab pertanyaan di bawah ini ([[Special:Captcha/help|info lengkap]]):',
	'questycaptchahelp-text' => "Situs-situs web yang menerima tulisan dari publik, seperti wiki ini, kerapkali disalahgunakan oleh pengguna-pengguna yang tidak bertanggungjawab untuk mengirimkan spam dengan menggunakan program-program otomatis guna membahkan prnala mereka pada berbagai situs web.
Walaupun pranala-pranala spam tersebut dapat dibuang, tetapi tetap saja menimbulkan gangguan yang berarti.

Kadang-kadang, terutama sat menambahkan pranala web baru ke suatu halaman, wiki akan meminta anda menjawab suatu pertanyaan. 
Karena ini merupakan suatu pekerjaan yang sulit diotomatisasi, pembatasan ini akan dapat dengan mudah dilalui oleh manusia, sekaligus juga dapat menghentikan hampir semua serangan spam dan robot otomatis lainnya.

Silakan hubungi [[{{MediaWiki:Grouppage-sysop}}|pengurus]] untuk meminta bantuan jika hal ini menghambat anda untuk mengirimkan suntingan yang layak.

Tekan tombol 'back' di penjelajah web Anda untuk kembali ke halaman penyuntingan.",
);

/** Iloko (Ilokano)
 * @author Lam-ang
 */
$messages['ilo'] = array(
	'questycaptcha-addurl' => 'Ti inurnos mo ket adda nagyan na a baro a panilpo ti ruar.
Tapno  makasalaknib kadagiti automatiko a spam, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptcha-badlogin' => 'Tapno  makasalaknib kadagiti automatiko a pinagsulbar ti kontrasenias, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptcha-createaccount' => 'Tapno  makasalaknib kadagiti automatiko a pinagaramid ti pakabilangan, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptcha-create' => 'Tapno makaaramid ti panid, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptcha-edit' => 'Tapno makaurnoy ditoya panid, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptcha-sendemail' => 'Tapno  makasalaknib kadagiti automatiko a pinagspam, pangaasim a sungbatan ti saludsud a nagparang dita baba. ([[Special:Captcha/help|adu pay a pakaammo]]):',
	'questycaptchahelp-text' => "Dagiti sapot a pagsaadan nga agaw-awat kadagiti maipablaak iti publiko, kasla daytoy a wiki, ket kanayon nga inabuso dagiti spammers nga agus-usar ti automatiko a ramramit ti pinagipablaak da kadagiti kukua da a panilpo ti adu a pagsasaadan. 
Maikkat met dagitoy a panilpo, mgen makariri da unay.

No sagpaminsan pay, nangruna no agikabil kadagiti baro a panilpo ti sapot iti panid, ti wiki ket agdamag kenka nga agsungbat ti maysa a saludsod. 
Yantangay daytoy ket obra a narigat a ma-automatiko, agpalubos kadagiti agpayso a tattao ti agipablaak bayat nga agpasardeng ti kaaduan a spammers ken dagiti robot nga agraraut.

Pangngaasi a kontaken ti [[{{MediaWiki:Grouppage-sysop}}|administrador ti pagsaadan ]] para iti pannulong no daytoy ket saan a napadpadaanan a pawilan na ti agpayso a pinagbaplaak mo.

Peslen ti 'agsubli' a buton dita pagbasabasam (browser) ti agsubli idiay panid ti pinagurnos.",
);

/** Italian (italiano)
 * @author Beta16
 * @author Darth Kule
 * @author Nemo bis
 */
$messages['it'] = array(
	'questycaptcha-addurl' => "La modifica richiesta aggiunge dei collegamenti esterni alla pagina; come misura precauzionale contro l'inserimento automatico di spam, si prega di rispondere alla domanda che compare di seguito ([[Special:Captcha/help|come funziona?]]):",
	'questycaptcha-badlogin' => 'Come misura precauzionale contro i tentativi di forzatura automatica della password, si prega di rispondere alla domanda che compare di seguito ([[Special:Captcha/help|come funziona?]]):',
	'questycaptcha-createaccount' => 'Come misura precauzionale contro i tentativi di creazione automatica degli account, si prega di rispondere alla domanda che compare di seguito ([[Special:Captcha/help|come funziona?]]):',
	'questycaptcha-create' => 'Per creare la pagina si prega di rispondere alla domanda che compare di seguito ([[Special:Captcha/help|come funziona?]]):',
	'questycaptcha-edit' => 'Per modificare questa pagina si prega di rispondere alla domanda che compare di seguito ([[Special:Captcha/help|come funziona?]]):',
	'questycaptcha-sendemail' => 'Come misura precauzionale nei confronti dei messaggi di spam automatici, si prega di inserire nella casella sottostante le parole che compaiono di seguito ([[Special:Captcha/help|come funziona?]]):',
	'questycaptchahelp-text' => 'Capita spesso che i siti web che accettano contributi pubblici, come questo wiki, siano presi di mira da persone che usano strumenti automatici per inserire collegamenti pubblicitari verso un gran numero di siti (spam). Per quanto i collegamenti indesiderati si possano rimuovere, si tratta comunque di una seccatura non indifferente. 

In alcuni casi, ad esempio quando si tenta di aggiungere nuovi collegamenti web in una pagina, il software wiki può richiedere di rispondere a una domanda. Poiché si tratta di un\'azione difficile da replicare da parte di un computer, questo meccanismo consente a (quasi tutti) gli utenti reali di effettuare i proprio contributi, impedendo l\'accesso alla maggior parte degli spammer e degli altri attacchi automatizzati. 

Se queste procedure impediscono contributi che si ritengono legittimi, si prega di contattare gli [[{{MediaWiki:Grouppage-sysop}}|amministratori del sito]] e chiedere loro assistenza. 

Fare clic sul pulsante "indietro" del browser per tornare alla pagina di modifica.',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Shirayuki
 */
$messages['ja'] = array(
	'questycaptcha-desc' => 'Confirm Edit 用の質問形式 CAPTCHA ジェネレーター',
	'questycaptcha-addurl' => 'あなたは新しい外部リンクを追加しようとしています。
自動でのスパム攻撃を防ぐため、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptcha-badlogin' => '自動でのパスワードクラック攻撃を防ぐため、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptcha-createaccount' => 'アカウントの自動登録を防ぐため、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptcha-create' => 'ページを新規作成するには、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptcha-edit' => 'このページを編集するには、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptcha-sendemail' => '自動でのスパム攻撃を防ぐため、下記の確認用の質問に回答してください ([[Special:Captcha/help|詳細]]):',
	'questycaptchahelp-text' => '一般からの投稿を受け付けるこのウィキのようなウェブサイトは、自動投稿ツールを使って多くのサイトにリンクを張ってまわるスパマーにより荒らされがちです。このようなスパムは除去できるものの、その作業は大変に面倒なものです。

このため、このウィキではときどき、特に新しい外部リンクがページに追加されたときなどに、質問に答えていただくようお願いすることがあります。この作業は自動化が難しいため、スパマーなどのプログラムを用いた攻撃をほぼ阻止しつつ、大半の生身の人間による投稿を可能にします。

正当な投稿をするにあたって本機能が障害となっている場合、[[{{MediaWiki:Grouppage-sysop}}|サイト管理者]]に連絡して協力を求めてください。

ページの編集に戻るには、ブラウザーの「戻る」ボタンを押してください。',
);

/** Korean (한국어)
 * @author Kwj2772
 * @author 아라
 */
$messages['ko'] = array(
	'questycaptcha-desc' => '편집 확인에 대한 탐구적인 CAPCHA(캡차) 생성기',
	'questycaptcha-addurl' => '편집에 새로운 바깥 링크가 포함되어 있습니다.
자동화된 스팸으로부터 보호하기 위해, 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptcha-badlogin' => '자동화된 비밀번호 깨기로부터 보호하기 위해, 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptcha-createaccount' => '자동화된 계정 만들기로부터 보호하기 위해, 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptcha-create' => '문서를 만드려면 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptcha-edit' => '이 문서를 편집하려면 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptcha-sendemail' => '자동화된 스팸으로부터 보호하기 위해, 아래에 보이는 질문에 답해주세요 ([[Special:Captcha/help|자세한 정보]]):',
	'questycaptchahelp-text' => '이 위키와 같이 사람의 공개적인 참여가 가능한 웹 사이트에서는 자동 프로그램이 스팸을 뿌리는 경우가 있습니다.
물론 이러한 스팸은 제거할 수는 있지만 번거로운 작업이 늘어납니다.

이러한 스팸을 방지하기 위해서, 이 위키의 문서에 웹 사이트 주소를 추가하는 등의 행동을 할 경우에는 질문에 답해달라고 하는 경우가 있습니다.
이 글자 입력 작업은 자동 프로그램을 만들기가 힘들기 때문에 스팸을 효과적으로 막으면서 일반 사용자를 막지 않을 수 있습니다.

예기치않게 정당한 행동을 하지 못하도록 막는다면 [[{{MediaWiki:Grouppage-sysop}}|사이트 관리자]]에게 도움을 요청해 주세요.

이전 화면으로 돌아가려면 웹 브라우저의 "뒤로" 버튼을 클릭하세요.',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'questycaptcha-addurl' => 'Ding Änderung säz neu Lengks noh ußerhallef vum Wiki.
Öm uns jäje der automattesch dobeijedonn <i lang="en">SPAM</i> ze hellefe,
bes esu joot un donn di Frooch be_anntwoode, di heh dronger shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptcha-badlogin' => 'Öm uns jäje et automattesche Paßwootknacke ze hellefe,
bes esu joot un donn di Frooch be_anntwoode, di heh dronge shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptcha-createaccount' => 'Öm uns jäje et maßesch automattesch neu Metmaacher Aanlääje ze hellefe,
bes esu joot un donn di Frooch be_anntwoode, di heh dronger shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptcha-create' => 'Öm di Sigg aanzelääje,
bes esu joot, donn di Frooch be_anntwoode, di heh dronge shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptcha-edit' => 'Öm di Sigg ze änderee,
bes esu joot, donn di Frooch be_anntwoode, di heh dronge shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptcha-sendemail' => 'Öm et Wiki jääje automattesch enjedraare SPAM ze schötze,
bes esu joot, donn di Frooch be_anntwoode, di heh dronger shteiht.
([[Special:Captcha/help|Mieh Enfommazjuhne]])',
	'questycaptchahelp-text' => 'Websigge, di Beijdrääsch vun de Öffentleschkeit aannämme, wi dat Wiki heh,
wääde öff vun <i lang="en">SPAM</i>mer heimjesöhk. Di bruche Projramme
för ier Lengks udder annder Jedrieße automattesch en dousende Wikis erin
ze bränge. Der <i lang="en">SPAM</i> kam_mer wider fott maache, ävver dä
blief e Ärjeneß.

Manschmohl, besönders, wann De neu Lengks en en Sigg donn wells, künnt et
Wiki Desch bedde, en Frooch ze be_antwoode. Nohdämm dat schwiiresch mem
automattesche Projramm henzekrijje es, löht et de Minsche ier Beidrääsch
maache, deiht ävver de miehßte <i lang="en">SPAM</i>mer un ander Robots affhallde.

Donn Desh aan de [[{{MediaWiki:Grouppage-sysop}}|Köbeße vum Wiki]] wende,
wann et Der trozdämm en de Fööß kütt, un De Dinge aanshtändejje Beijdraach
nit en et Wiki kriß!

Dä „Retuur“-Lengk udder -Knopp vun Dingem Brauser brängk Desch wider op
di Sigg zom Ändere, woh De jraad wohß.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'questycaptcha-addurl' => "An Ärer Ännerung sinn nei extern Linken.
Fir d'Protectioun géint automatesche Spam ze vergréisseren, beäntwert w.e.g. déi Fro hei ënnendrënner ([[Special:Captcha/help|méi Informatiounen]]):",
	'questycaptcha-badlogin' => "Fir d'Protectioun géint d'automatiséiert Knacke vu Passwierder ze vergréisseren, beäntwert w.e.g. déi Fro hei ënnedrënner ([[Special:Captcha/help|méi Informatiounen]]):",
	'questycaptcha-createaccount' => "Fir d'Protectioun géint d'automatiséiert Uleeë vu Benotzerkonten ze vergréisseren, beäntwert w.e.g. déi Fro hei ënnendrënner ([[Special:Captcha/help|méi Informatiounen]]):",
	'questycaptcha-create' => "Fir d'Säit unzeleeën, beäntwert w.e.g. déi Fro hei ënnedrënner ([[Special:Captcha/help|méi Informatiounen]]):",
	'questycaptcha-edit' => "Fir dës Säit z'änneren, beäntwert w.e.g. déi Fro hei ënnedrënner ([[Special:Captcha/help|méi Informatiounen]]):",
	'questycaptcha-sendemail' => 'Fir ze hëllefe eis géint automatiséierte Spam ze schütze, beäntwert w.e.g. déi Fro hei ënnendrënner ([[Special:Captcha/help|méi Informatiounen]]):',
	'questycaptchahelp-text' => "Websäiten, déi et jiddwerengem erlaben Ännerunge virzehuelen, sou wéi dës Wiki, ginn dacks vu sougenannte Spammer mëssbraucht, déi automatiséiert hir Linken op vill Internetsäite setzen.
Esou Spam-Linke kënne wuel geläscht ginn, mä si sinn trotzdem eng grouss Plo.

Heiandsdo, besonnesch wann nei Internet-Linken op eng Säit derbäigesat ginn, freet dës Wiki Iech eng Fro ze beäntwerten.
Well dëst eng Aufgab ass déi schwéier z'automatiséieren ass, erlaabt dëst datt Mënschen hir Ännerunge kënnen agi wärend déi meescht Spammer an aner Roboter-Attacke kënnen ofgewiert ginn.

Kontaktéiert w.e.g. d'[[{{MediaWiki:Grouppage-sysop}}|Administrateure vun dësem Site]] fir Hëllef wann dëst Iech onerwaarter Weis vu legitimen Editen ofhält.

Dréckt op den 'Zréck' Knäppche vun ärem Browser fir an d'Beaarbechtungsfënster zréckzekommen.",
);

/** Minangkabau (Baso Minangkabau)
 * @author Iwan Novirion
 */
$messages['min'] = array(
	'questycaptchahelp-text' => 'Laman-laman web nan manarimo tulisan dari urang banyak (publik), samacam wiki ko, acok kali disalahgunoan dek pangguno-pangguno nan indak batangguang-jawek untuak mangiriman spam manggunoan program-program otomatis. Walaupun pautan-pautan spam tasabuik dapek sajo dihapuih, tapi tatap sajo manimbulan gangguan.

Kadang-kadang, sangkek tangah manambahan pautan web baru ka suatu laman, wiki ko akan mangagiah sabuah patanyaan untuak Sanak jawek.
Dek iko marupoan suatu karajo nan sulik untuak dibuek sacaro otomatis, pakaro ko akan mudah dilalui dek urang (manusia), sakaliguih dapek manghantian hampiang kasado sarangan spam dan robot otomatis lainnyo.

Silakan hubuangi panguruih untuak mintak bantuan koq pakaro ko manghambaik Sanak untuak mambuek suntiangan nan layak.

Takan tombol "back" di paramban web Sanak untuak baliak ka laman panyuntiangan.', # Fuzzy
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'questycaptcha-desc' => 'Создавач CAPTCHA со текнувало за потврда на уредувања',
	'questycaptcha-addurl' => 'Вашето уредување содржи нови надворешни врски.
За да ни помогнете да се заштитиме од автоматизиран спам, одговорете на прашањето подолу ([[Special:Captcha/help|повеќе инфо]]):',
	'questycaptcha-badlogin' => 'За да ни помогнете да се заштитиме од автоматизирано пробивање на лозинки, одговорете на прашањето подолу ([[Special:Captcha/help|повеќе инфо]]):',
	'questycaptcha-createaccount' => 'За да ни помогнете да се заштитиме од автоматизирано создавање на сметки, одговорете на прашањето подолу ([[Special:Captcha/help|повеќе инфо]]):',
	'questycaptcha-create' => 'За да ја создадете страницата, одговорете на прашањето подолу ([[Special:Captcha/help|повеќе инфо]]):',
	'questycaptcha-edit' => 'За да ја уредите страницава, одговорете на прашањето подолу ([[Special:Captcha/help|повеќе инфо]]):',
	'questycaptcha-sendemail' => 'За да се заштитиме од автоматизирано спамирање, одговорете на долупоставеното прашање ([[Special:Captcha/help|повеќе информации]]):',
	'questycaptchahelp-text' => 'Мрежните места  кои прифаќаат учество на јавноста, како ова вики, честопати страдаат од спамери кои користат автоматизирани алатки за да ги додаваат нивните врски на голем број мрежни места.
Иако врските на спамерот може да се отстранат, тие значително ја пореметуваат нашата работа.

Понекогаш, особено кога додава нови врски на страница, викито може да ви побара да одговорите на прашање.
Бидејќи ова е задача која е тешко да се автоматизира, им овозможува вистинските корисници да придонесуваат, а им попречува на спамерите и другите роботски напаѓачи.

Контактирајте ги [[{{MediaWiki:Grouppage-sysop}}|администраторите на страната]] за помош доколку ова неочекувано ве спречува во правењето на искрени придонеси.

Кликнете на копчето „назад“ во вашиот прелисувач за да се вратите на уредувањето на страницата.',
);

/** Malayalam (മലയാളം)
 * @author Junaidpv
 */
$messages['ml'] = array(
	'questycaptcha-addurl' => 'താങ്കളുടെ തിരുത്തലുകളിൽ പുറം കണ്ണികൾ ഉൾപ്പെട്ടിരിക്കുന്നു.
യാന്ത്രിക സ്പാമിനെതിരെയുള്ള സം‌രക്ഷണത്തിന്റെ ഭാഗമായി, താഴെ കാണുന്ന വാക്കുകൾ പെട്ടിയിൽ ടൈപ്പു ചെയ്യുക  ([[Special:Captcha/help|കൂടുതൽ വിവരങ്ങൾ]]):',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'questycaptcha-addurl' => 'Suntingan anda mengandungi pautan luar baru.
Untuk membanteras kegiatan spam automatik, anda diminta menjawab soalan yang berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptcha-badlogin' => 'Untuk membanteras kegiatan meneka kata laluan secara automatik, anda diminta menjawab soalan berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptcha-createaccount' => 'Untuk membanteras kegiatan pembukaan akaun secara automatik, anda diminta menjawab soalan berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptcha-create' => 'Untuk mencipta laman ini, anda diminta menjawab soalan berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptcha-edit' => 'Untuk menyunting laman ini, anda diminta menjawab soalan berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptcha-sendemail' => 'Untuk membanteras kegiatan spam secara automatik, anda diminta menjawab soalan berikut ([[Special:Captcha/help|maklumat lanjut]]):',
	'questycaptchahelp-text' => "Tapak-tapak web yang menerima sumbangan awam, misalnya wiki ini, sering disalah guna oleh pembuat spam yang menggunakan peralatan berautomasi untuk membubuh pautan mereka di banyak tapak.
Walaupun pautan-pautan spam ini boleh dipadamkan, namun ia amat menyusahkan.

Adakalanya, terutamanya apabila membubuh pautan web baru pada sesuatu laman, wiki ini mungkin akan menanya anda satu soalan.
Memandangkan ini ialah tugas yang sukar diautomasi, ia akan membolehkan kebanyakan manusia sebenar untuk membuat sumbangan, sambil menghalang spam dan serangan robotik yang seumpamanya.

Sila hubungi [[{{MediaWiki:Grouppage-sysop}}|pentadbir laman]] untuk mendapatkan bantuan jika ia menghalang anda daripada membuat sumbangan yang munasabah tanpa dijangka.

Klik butang '←' untuk kembali ke editor laman.",
);

/** Maltese (Malti)
 * @author Chrisportelli
 */
$messages['mt'] = array(
	'questycaptcha-addurl' => 'Il-modifika tiegħek tinkludi ħoloq esterni ġodda.
Sabiex tipproteġi kontra spam awtomatiku, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):',
	'questycaptcha-badlogin' => 'Bħala prekawzjoni kontra l-infurzar awtomatiku tal-password, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):',
	'questycaptcha-createaccount' => "Bħala miżura ta' prekawzjoni kontra l-ħolqien awtomatiku tal-kontijiet, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):",
	'questycaptcha-create' => 'Sabiex toħloq din il-paġna, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):',
	'questycaptcha-edit' => 'Sabiex timmodifika din il-paġna, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):',
	'questycaptcha-sendemail' => 'Bħala prekawzjoni kontra l-ispam awtomatiku, jekk jogħġbok irrispondi l-mistoqsija li tidher hawn taħt ([[Special:Captcha/help|aktar informazzjoni]]):',
	'questycaptchahelp-text' => "Siti elettroniċi li jaċċettaw kontribuzzjonijiet mill-pubbliku, bħal din il-wiki, huma ħafna drabi abbużati minn ''spammers'' li jużaw għodda awtomatiċi sabiex idaħħlu ħoloq lejn ħafna siti.
Waqt li dawn il-ħoloq ta' spam jistgħu jitneħħew, dan huwa xorta waħda xogħol għalxejn.

Xi drabi, speċjalment meta żżid ħoloq esterni ġodda f'paġna, il-paġna wiki tista' tistaqsik biex tirrispondi mistoqsija.
Minħabba li din hija azzjoni li diffiċli li tiġi replikata min-naħa ta' kompjuter, dan il-mekkaniżmu jippermetti lil (kważi) kull utent li jeżisti li jagħmel il-kontribuzzjonijiet tiegħu waqt li ħafna ''spammers'' u attakki awtomatiċi jiġu mwaqqfa.

Jekk jogħġbok ikkuntatja lill-[[{{MediaWiki:Grouppage-sysop}}|amministraturi tas-sit]] għall-għajnuna fuq jekk din il-proċedura hix qed tipprevjeni milli tagħmel kontribuzzjonijiet leġittimi.

Iklikkja fuq il-buttuna 'lura' tal-browżer tiegħek sabiex tirritorna għall-editur ta-paġna.",
);

/** Norwegian Bokmål (norsk (bokmål)‎)
 * @author Helland
 * @author Nghtwlkr
 * @author Simny
 */
$messages['nb'] = array(
	'questycaptcha-addurl' => 'Din endring inneholder nye eksterne lenker.
For å beskytte mot automatisert spam, vennligst svar på spørsmålet som vises under ([[Special:Captcha/help|mer informasjon]]):',
	'questycaptcha-badlogin' => 'For å hindre passordtyveri, vær vennlig og svar på spørsmålet under ([[Special:Captcha/help|mer informasjon]]):',
	'questycaptcha-createaccount' => 'For å beskytte mot automatisert spam, vennligst svar på spørsmålet som vises under ([[Special:Captcha/help|mer informasjon]]):',
	'questycaptcha-create' => 'For å opprette siden, vennligst svar på spørsmålet som vises under ([[Special:Captcha/help|mer informasjon]]):',
	'questycaptcha-edit' => 'For å endre denne siden, vennligst svar på spørsmålet som vises under ([[Special:Captcha/help|mer informasjon]]):',
	'questycaptcha-sendemail' => 'For å beskytte mot automatisert søppelpost, svar på spørsmålet som vises nedenfor ([[Special:Captcha/help|mer info]]):',
	'questycaptchahelp-text' => "Nettsteder som tar imot bidrag fra allmennheten, som denne wikien, er ofte utsatt for angrep fra spammere som bruker automatiserte verktøy for å legge til lenker til mange sider.
Selv om disse spam-lenkene kan fjernes er de en stor plage.

Iblant, spesielt ved tillegg av nye lenker til en side, kan wikien be deg svare på et spørsmål.
Siden dette er en oppgave som er vanskelig å automatisere, vil den tillate de fleste virkelige personer å bidra mens den stopper de fleste spammere og andre robotangrep.

Vennligst kontakt [[{{MediaWiki:Grouppage-sysop}}|sideadministratorer]] for hjelp dersom dette er uventet hindrer deg fra å bidra med legitime bidrag.

Klikk på 'tilbake'-knappen i nettleseren din for å gå tilbake til sideeditoren.",
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'questycaptcha-addurl' => 'Uw bewerking bevat nieuwe externe koppelingen.
Beantwoord de onderstaande vraag als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'questycaptcha-badlogin' => 'Beantwoord de onderstaande vraag als bescherming tegen geautomatiseerde wachtwoordaanvallen ([[Special:Captcha/help|meer informatie]]):',
	'questycaptcha-createaccount' => 'Beantwoord de onderstaande vraag als bescherming tegen het geautomatiseerd aanmaken van gebruikers ([[Special:Captcha/help|meer informatie]]):',
	'questycaptcha-create' => 'Beantwoord de onderstaande vraag om de pagina aan te maken ([[Special:Captcha/help|meer informatie]]):',
	'questycaptcha-edit' => 'Beantwoord de onderstaande vraag om deze pagina te bewerken ([[Special:Captcha/help|meer informatie]]):',
	'questycaptcha-sendemail' => 'Beantwoord de onderstaande vraag als bescherming tegen geautomatiseerde spam ([[Special:Captcha/help|meer informatie]]):',
	'questycaptchahelp-text' => 'Websites die vrij te bewerken zijn, zoals deze wiki, worden vaak misbruikt door spammers die er met hun programma\'s automatisch koppelingen op zetten naar vele websites.
Hoewel deze externe koppelingen weer verwijderd kunnen worden, leveren ze wel veel hinder en administratief werk op.

Soms, en in het bijzonder bij het toevoegen van externe koppelingen op pagina\'s, vraag de wiki u een vraag te beantwoorden.
Omdat dit proces lastig te automatiseren is, zijn vrijwel alleen mensen in staat dit proces succesvol te doorlopen en worden hiermee spammers en andere geautomatiseerde aanvallen geweerd.

Vraag assistentie van de [[{{MediaWiki:Grouppage-sysop}}|sitebeheerders]] als dit proces u verhindert een nuttige bijdrage te leveren.

Klik op de knop "terug" in uw browser om terug te gaan naar het tekstbewerkingsscherm.',
);

/** Nederlands (informeel)‎ (Nederlands (informeel)‎)
 * @author Siebrand
 */
$messages['nl-informal'] = array(
	'questycaptcha-addurl' => 'Je bewerking bevat nieuwe externe koppelingen.
Beantwoord de onderstaande vraag als bescherming tegen automatische spam ([[Special:Captcha/help|meer informatie]]):',
	'questycaptchahelp-text' => 'Websites die vrij te bewerken zijn, zoals deze wiki, worden vaak misbruikt door spammers die er met hun programma\'s automatisch koppelingen op zetten naar vele websites.
Hoewel deze externe koppelingen weer verwijderd kunnen worden, leveren ze wel veel hinder en administratief werk op.

Soms, en in het bijzonder bij het toevoegen van externe koppelingen op pagina\'s, vraag de wiki je een vraag te beantwoorden.
Omdat dit proces lastig te automatiseren is, zijn vrijwel alleen mensen in staat dit proces succesvol te doorlopen en worden hiermee spammers en andere geautomatiseerde aanvallen geweerd.

Vraag assistentie van de [[{{MediaWiki:Grouppage-sysop}}|sitebeheerders]] als dit proces je verhindert een nuttige bijdrage te leveren.

Klik op de knop "terug" in je browser om terug te gaan naar het tekstbewerkingsscherm.',
);

/** Norwegian Nynorsk (norsk (nynorsk)‎)
 * @author Gunnernett
 */
$messages['nn'] = array(
	'questycaptcha-addurl' => 'Endringa di inneheld nye lenkjer ut. 
Som ei hjelp til å unngå automatisert spam, ver venleg og skiv inn spørsmålet som er synt nedanfor ([[Special:Captcha/help|meir informasjon]]):',
	'questycaptcha-createaccount' => 'For å hjelpa til med å hindra automatisk kontooppretting, ver venleg og svar på spørsmålet nedanfor ([[Special:Captcha/help|more info]]):',
	'questycaptcha-create' => 'For å oppretta sida, ver venleg og svar på spørsmålet nedanfor ([[Special:Captcha/help|meir informasjon]]):',
	'questycaptcha-edit' => 'For å endra sida, ver venleg og svar på spørsmålet som er synt nedanfor ([[Special:Captcha/help|meir informasjon]]):',
);

/** Occitan (occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'questycaptcha-addurl' => 'Vòstra modificacion inclutz de ligams extèrnes novèls.
Per nos ajudar dins la proteccion contra lo spam automatizat, respondètz a la question çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :',
	'questycaptcha-badlogin' => "Per nos ajudar a prevenir la copadura dels senhals per d'automats, respondètz a la question çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :",
	'questycaptcha-createaccount' => "Per nos ajudar a luchar contra las creacions automaticas de comptes, respondètz a la question qu'apareis çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :",
	'questycaptcha-create' => 'Per crear la pagina, respondètz a la question çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :',
	'questycaptcha-edit' => 'Per modificar aquesta pagina, respondètz a la question çaijós ([[Special:Captcha/help|mai d’entresenhas]]) :',
	'questycaptcha-sendemail' => "Per tal de nos ajudar a prevenir lo spam automatic, entratz los mots qu'apareisson dins la bóstia çaijós ([[Special:Captcha/help|mai d’informacions]]) :",
	'questycaptchahelp-text' => "Los sites web qu'acceptan de contribucions del public, coma aqueste wiki, son sovent victimas de polluposteires qu'utilizan d'espleches automatizats per plaçar de ligams nombroses cap a lors sites.
Quitament s'aquesta pollucion pòt èsser escafada, es irritanta.

De còps, particularament al moment de l’apondon de ligams extèrnes novèls dins una pagina, lo wiki vos pòt demandar de respondre a una question.
Aqueste prètzfach es pas de bon acomplir d'un biais automatizat, aquò permet a la màger part dels umans de realizar lors contribucions tot en empachant la màger part dels polluposteires e autres atacants robotizats.

Contactatz [[{{MediaWiki:Grouppage-sysop}}|los administrators del site]] s'aquò vos empacha de faiçon imprevista de far de contribucions legitimas.

Clicatz sul boton « Precedent » de vòstre navigador per tornar a la pagina de modificacion.",
);

/** Polish (polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'questycaptcha-addurl' => 'Edycja zawiera nowe linki zewnętrzne. 
Ochrona przed zautomatyzowanym spamem wymaga odpowiedzi na poniższe pytanie ([[Special:Captcha/help|więcej informacji]])',
	'questycaptcha-badlogin' => 'Ochrona przed zautomatyzowanym łamaniem haseł wymaga odpowiedzi na poniższe pytanie ([[Special:Captcha/help|więcej informacji]])',
	'questycaptcha-createaccount' => 'Ochrona przed zautomatyzowanym tworzeniem kont wymaga odpowiedzi na poniższe pytanie ([[Special:Captcha/help|więcej informacji]])',
	'questycaptcha-create' => 'Utworzenie strony jest możliwe po udzieleniu odpowiedzi na poniższe pytanie ([[Special:Captcha/help|więcej informacji]])',
	'questycaptcha-edit' => 'Edycja strony jest możliwa po udzieleniu odpowiedzi na poniższe pytanie ([[Special:Captcha/help|więcej informacji]])',
	'questycaptcha-sendemail' => 'Z uwagi na ochronę przed automatycznym spamem, należy odpowiedzieć na znajdujące się poniżej pytanie ([[Special:Captcha/help|pomoc]])',
	'questycaptchahelp-text' => "Witryny, które publicznie udostępniają możliwość wprowadzania zmian, tak jak ta wiki, często są wykorzystywane przez spamerów, którzy korzystają ze zautomatyzowanych narzędzi, aby dodawać swoje linki do wielu stron.
Pomimo tego, że takie linki mogą zostać usunięte, jest to jednak uciążliwe.

Czasami, zwłaszcza jeśli dodano nowe linki zewnętrzne, wiki może poprosić o udzielenie odpowiedzi na pytanie.
Ponieważ odpowiadanie na pytania jest czynnością trudną do zautomatyzowania, pozwala większości ludziom na wykonywanie edycji, zarazem uniemożliwiając ją spamerom i innym atakującym automatom.

Skontaktuj się z [[{{MediaWiki:Grouppage-sysop}}|administratorami]], jeśli potrzebujesz pomocy ponieważ mechanizm ten uniemożliwia Ci dokonywania uzasadnionych edycji.

Kliknij przycisk 'wstecz' w przeglądarce, aby wrócić do strony edycji.",
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'questycaptcha-addurl' => 'Toa modìfica a conten na neuva anliura esterna.
Për giuté a protegi contra spam automàtich, për piasì arspond a la custion che a-i é sì sota ([[Special:Captcha/help|për savèjne ëd pì]]):',
	'questycaptcha-badlogin' => 'Për giuté a protegi contra ël crack ëd ciav automatisà, për piasì arspond a la custion che a ven fòra sota ([[Special:Captcha/help|për savèjne ëd pì]]):',
	'questycaptcha-createaccount' => 'Për giuté a protegi contra la creassion automàtica ëd cont, për piasì arspond a la custion che a ven fòra sota ([[Special:Captcha/help|për savejne ëd pì]]):',
	'questycaptcha-create' => 'Për creé la pàgina, për piasì arspond a la custion che a ven fòra sota: ([[Special:Captcha/help|për savejne ëd pì]]):',
	'questycaptcha-edit' => 'Për modifiché sta pàgina-sì, për piasì arspond a la custion che a ven fòra sota ([[Special:Captcha/help|për savejne ëd pì]]):',
	'questycaptcha-sendemail' => "Për giuté a protegi contra la rumenta automàtica, për piasì ch'a risponda a la chestion ch'as vëdd sì-sota ([[Special:Captcha/help|për savèjne ëd pi]]):",
	'questycaptchahelp-text' => "Soèns a-i riva che ij sit dla Ragnà che la gent a peul dovré për ëscrive chèich-còs, coma sta wiki-sì, a resto ambërlifà ëd reclam da màchine che a carìo soa ròba dadsà e dadlà n'automàtich. 
Për tant che sta reclam un a peula peuj gavela, a resta sempe un gran fastudi. 

Dle vire, dzortut quand un a caria dj'anliure esterne neuve ansime a na pàgina, la wiki a peul ciamete d'arsponde a na custion. 
Da già ch'a l'é grama scrive un programa ch'a lo fasa, a ven che la pì gran part dla gent a-i la fa a scrive, ma la ói part dle màchine a-i la fa pa. 

Për piasì contata j'[[{{MediaWiki:Grouppage-sysop}}|aministrador dël sit]] për assistensa se sòn-sì a l'ha nen lassate fé na contribussion legìtima.

Ch'a-i bata ansima al boton 'andré' ant sò navigator për torné andré a l'editor dla pàgina.",
);

/** Portuguese (português)
 * @author Crazymadlover
 * @author Giro720
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'questycaptcha-addurl' => "A sua edição introduziu links externos novos.
Para ajudar a prevenir o ''spam'' automatizado, por favor, responda à questão apresentada abaixo ([[Special:Captcha/help|mais informações]]):",
	'questycaptcha-badlogin' => 'Para ajudar a prevenir mecanismos automatizados de descoberta de palavras-chave, por favor, responda à questão apresentada abaixo ([[Special:Captcha/help|mais informações]]):',
	'questycaptcha-createaccount' => 'Para ajudar a prevenir a criação de contas automatizada, por favor, responda à questão apresentada abaixo ([[Special:Captcha/help|mais informações]]):',
	'questycaptcha-create' => 'Para criar a página, por favor, responda à questão apresentada abaixo ([[Special:Captcha/help|mais informações]]):',
	'questycaptcha-edit' => 'Para editar esta página, por favor, responda à questão apresentada abaixo ([[Special:Captcha/help|mais informações]]):',
	'questycaptcha-sendemail' => "Para ajudar a prevenir o ''spam'' automatizado, por favor, responda à seguinte pergunta ([[Special:Captcha/help|mais informações]]):",
	'questycaptchahelp-text' => "Sites na internet abertos a edição pública, como é o caso desta wiki, são frequentemente abusados por ''spammers'' que utilizam ferramentas automatizadas para inserção em massa de links em muitos sites.
Embora esses links possam ser removidos, representam um incómodo significativo.

Por vezes, especialmente quando introduzir links externos novos numa página, a wiki pedirá que responda a uma pergunta.
Porque esta é uma tarefa difícil de automatizar, permite que a maioria das pessoas façam as suas edições, ao mesmo tempo que inibe edições feitas por ''spammers'' e outros mecanismos automatizados.

Por favor, contacte os [[{{MediaWiki:Grouppage-sysop}}|administradores]] para assistência, caso esta funcionalidade esteja a impedi-lo de fazer edições legítimas.

Clique o botão 'voltar' do seu browser para voltar à página de edição.",
);

/** Brazilian Portuguese (português do Brasil)
 * @author Eduardo.mps
 * @author Giro720
 * @author 555
 */
$messages['pt-br'] = array(
	'questycaptcha-addurl' => 'Sua edição inclui novas ligações externas.
Para proteção contra spam automático, por favor responda a questão que aparece abaixo ([[Special:Captcha/help|mais informações]]):',
	'questycaptcha-badlogin' => 'Para proteger contra quebra automatizada de palavra-chave, por favor responda a questão que aparece abaixo ([[Special:Captcha/help|more info]]):',
	'questycaptcha-createaccount' => 'Para proteger contra criação automática de contas, por favor responda as questões que aparecem abaixo ([[Special:Captcha/help|more info]]):',
	'questycaptcha-create' => 'Para criar a página, por favor responda a questão que aparece abaixo ([[Special:Captcha/help|more info]]):',
	'questycaptcha-edit' => 'Para editar esta página, por favor responda a questão que aparece abaixo ([[Special:Captcha/help|more info]]):',
	'questycaptcha-sendemail' => "Para ajudar a prevenir o ''spam'' automatizado, por favor, responda à seguinte pergunta ([[Special:Captcha/help|mais informações]]):",
	'questycaptchahelp-text' => "Sites que aceitam contribuições públicas, como este wiki, são vulneráveis a spammers que utilizam ferramentas automatizadas para inserir os seus links em diversos locais. 
Apesar de ser possível remover tais links, eles são um incômodo significativo.

Algumas vezes, especialmente ao adicionar novos links externos a uma página, o wiki pode pedir a você que responda a uma pergunta. 
Uma vez que essa é uma tarefa um tanto difícil de ser automatizada, ela possibilita que a maioria dos humanos faça as suas contribuições ao mesmo tempo que inibe as que forem feitas por spammers e mecanismos automatizados.

Entre em contato com os [[{{MediaWiki:Grouppage-sysop}}|administradores do site]] para pedir ajuda caso isso esteja te impedindo de realizar contribuições legítimas.

Clique no botão 'voltar' de seu navegador para retornar ao editor de páginas.",
);

/** Romanian (română)
 * @author Minisarm
 */
$messages['ro'] = array(
	'questycaptcha-addurl' => 'Modificarea dumneavoastră include legături externe noi.
Pentru a împiedica roboții de spam, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptcha-badlogin' => 'Pentru a împiedica spargerea automată a parolelor, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptcha-createaccount' => 'Pentru a împiedica crearea automată de conturi, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptcha-create' => 'Pentru a crea pagina, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptcha-edit' => 'Pentru a modifica această pagină, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptcha-sendemail' => 'Pentru a împiedica roboții de spam, vă rugăm să răspundeți la întrebarea de mai jos ([[Special:Captcha/help|mai multe detalii]]):',
	'questycaptchahelp-text' => 'Siturile web care acceptă contribuții din partea publicului, precum acest wiki, sunt de obicei victime ale persoanelor care folosesc unelte automate pentru a introduce legături către multe alte situri. 
Deși aceste legături de spam pot fi îndepărtate, acest lucru reprezintă o bătaie de cap semnificativă.

Uneori, mai ales la adăugarea de noi legături web într-o pagină, situl wiki vă poate cere să răspundeți la o anumită întrebare. Întrucât rezolvarea acestei cerințe este dificil de automatizat, ea permite majorității persoanelor reale să-și trimită contribuțiile și va opri majoritatea atacatorilor.

În cazul în care această practică vă împiedică în mod neașteptat să faceți contribuții legitime, vă rugăm să contactați [[{{MediaWiki:Grouppage-sysop}}|administratorii sitului]].

Apăsați butonul „Înapoi” al navigatorului pentru a vă reîntoarce la pagina de editare.',
);

/** tarandíne (tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'questycaptcha-addurl' => "'U cangiamende tue inglude de le collegaminde esterne.
Pe aiutà a proteggere condre a 'u spam automateche, pe piacere respunne a 'a domande ca combare sotte ([[Special:Captcha/help|cchiù 'mbormaziune]]):",
	'questycaptcha-badlogin' => "Pe aiutà a proteggere condre a futteminde automatece de password, pe piacere respunne a 'a domande ca combare aqquà sotte ([[Special:Captcha/help|more info]]):",
	'questycaptcha-createaccount' => "Pe aiutà a proteggere condre a ccreazione automateche de cunde utinde, pe piacere respunne a 'a domande ca combare aqquà sotte ([[Special:Captcha/help|more info]]):",
	'questycaptcha-create' => "Pe ccrejà sta pàgene, pe piacere respunne a 'a domande ca combare aqquà sotte ([[Special:Captcha/help|more info]]):",
	'questycaptcha-edit' => "Pe cangià sta pàgene, pe piacere respunne a 'a domande ca combare aqquà sotte ([[Special:Captcha/help|more info]]):",
	'questycaptcha-sendemail' => "Pe aiutà a proteggere condre a spam automatece, pe piacere respunne a 'a domande ca combare aqquà sotte ([[Special:Captcha/help|cchiù 'mbormaziune]]):",
	'questycaptchahelp-text' => "Le site web ca accettane condrebbute da 'u pubbleche, cumme sta Uicchi, sonde spesse abusate da le ''spammer'' ca ausane struminde automatece e aggiungene le lore collegaminde a 'nu sacche de site.<br />
Pure ca chiste collegaminde de spam ponne essere luate, lore sò sembre 'nu scassamende de palle.<br />
<br />
Certe vote, specialmende quanne aggiunge 'nu nuève collegamende web a 'na pàgene, Uicchi te pò chiedere de responnere a 'na domande.<br />
Accussì addeviene 'nu combete cchiù defficile da automatizzà, accussì se permette a le cristiane de fà cangiaminde reale e se blocchene de cchiù le ''spammer'' e otre attacche de robot.<br />
<br />
Pe piacere condatte le [[{{MediaWiki:Grouppage-sysop}}|amministrature d'u site]] pe assistenze ce stu fatte non ge funzione accume se deve e no te face fà le cangiaminde legittime.<br />
<br />
Cazze 'u buttone 'rrete' jndr'à 'u browser tue pe turnà 'a pàgene d'u cangiamende.",
);

/** Russian (русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'questycaptcha-addurl' => 'Ваша правка содержит новые внешние ссылки.
В целях защиты от автоматического спама, пожалуйста, ответьте на приведённый ниже вопрос ([[Special:Captcha/help|подробнее]]):',
	'questycaptcha-badlogin' => 'В целях защиты от автоматического подбора пароля, пожалуйста, ответьте на приведённый ниже вопрос  ([[Special:Captcha/help|подробнее]]):',
	'questycaptcha-createaccount' => 'В целях защиты от автоматического создания учётных записей, пожалуйста, ответьте на приведённый ниже вопрос  ([[Special:Captcha/help|подробнее]]):',
	'questycaptcha-create' => 'Для создания страницы, пожалуйста, ответьте на приведённый ниже вопрос  ([[Special:Captcha/help|подробнее]]):',
	'questycaptcha-edit' => 'Чтобы изменить эту страницу, пожалуйста, ответьте на приведённый ниже вопрос  ([[Special:Captcha/help|подробнее]]):',
	'questycaptcha-sendemail' => 'В целях защиты от автоматического спама, пожалуйста, ответьте на приведённый ниже вопрос ([[Special:Captcha/help|подробнее]]):',
	'questycaptchahelp-text' => 'Веб-сайты позволяющие изменять своё содержимое, как эта вики, часто становятся целью спамеров, использующих автоматические инструменты для добавления ссылок на другие сайты.
Несмотря на то, что такие ссылки могут быть удалены, они являются заметной помехой.

Иногда, в частности при добавлении на страницу новых веб-ссылок, вики может попросить вас ответить на вопрос.
Так как эта задача, которую сложно автоматизировать, то это позволит большинству людей сделать данную правку, и в тоже время остановит большинство спамеров и других роботизированных недоброжелателей.

Пожалуйста, обратитесь к [[{{MediaWiki:Grouppage-sysop}}|администраторам сайта]] за помощь, если данная система не позволяет вам вносить допустимые изменения.

Нажмите в вашем браузере кнопку «назад», чтобы вернуться к странице редактирования.',
);

/** Slovak (slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'questycaptcha-addurl' => 'Vaša úprava obsahuje nové externé odkazy.
Ako opatrenie proti automatizovanému spamu musíte zodpovedať dolu uvedenú otázku
([[Special:Captcha/help|ďalšie informácie]]):',
	'questycaptcha-badlogin' => 'Ako opatrenie proti automatizovanému lámaniu hesiel musíte zodpovedať dolu uvedenú otázku
([[Special:Captcha/help|ďalšie informácie]]):',
	'questycaptcha-createaccount' => 'Ako opatrenie proti automatizovanému vytváraniu účtov musíte zodpovedať dolu uvedenú otázku
([[Special:Captcha/help|ďalšie informácie]]):',
	'questycaptcha-create' => 'Ak chcete vytvoriť stránku, musíte zodpovedať dolu uvedenú otázku
([[Special:Captcha/help|ďalšie informácie]]):',
	'questycaptcha-edit' => 'Ak chcete upraviť túto stránku, musíte zodpovedať dolu uvedenú otázku
([[Special:Captcha/help|ďalšie informácie]]):',
	'questycaptchahelp-text' => 'Webstránky, ktoré prijímajú príspevky od verejnosti ako táto wiki, sú často cieľom zneužitia spammermi, ktorí používajú automatizované nástroje na pridávanie odkazov na svoje stránku na mnohé lokality.
Hoci je možné odkazy na spam odstrániť, je to významná nepríjemnosť.

Niekedy, obzvlášť pri pridávaní nových webových odkazov na stránku, vás wiki môže požiadať o zodpovedanie otázky.
Pretože takúto úlohu je ťažké zautomatizovať, umožní väčšine skutočných ľudí prispievať a zastaví vačšinu spammerov a robotických útočníkov.

Kontaktujte prosím [[{{MediaWiki:Grouppage-sysop}}|správcov lokality]] ak potrebujete pomoc v prípade, že vám táto funkcia neočakávaným spôsobom bráni v právoplatných príspevkoch.

Späť na úpravu stránky sa vrátite kliknutím na tlačidlo „Späť“ vo vašom prehliadači.',
);

/** Slovenian (slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'questycaptcha-addurl' => 'Vaše urejanje vključuje nove zunanje povezave.
Zaradi zaščite pred samodejnim smetjem prosimo, da odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptcha-badlogin' => 'Zaradi zaščite pred samodejnim ugotavljanjem gesel prosimo, da odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptcha-createaccount' => 'Zaradi zaščite pred samodejnim ustvarjanjem računov prosimo, da odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptcha-create' => 'Če želite ustvariti stran, prosimo odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptcha-edit' => 'Če želite urediti stran, prosimo odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptcha-sendemail' => 'Zaradi zaščite pred samodejnim smetenjem prosimo, da odgovorite na spodaj zastavljeno vprašanje ([[Special:Captcha/help|več informacij]]):',
	'questycaptchahelp-text' => 'Spletne strani, ki omogočajo prispevanje širši javnosti, kot na primer ta wiki, pogosto zlorabljajo spamerji, ki za dodajanje svojih povezav na mnoge strani uporabljajo avtomatizirana orodja.
Čeprav je neželene povezave mogoče odstraniti, so precejšnja nadloga.

Včasih, zlasti pri dodajanju novih spletnih povezav na stran, vam bo wiki morda zastavil vprašanje.
Ker je to opravilo težko avtomatizirati, bo s tem večini ljudi prispevanje dovoljeno, spamerji in drugi robotski napadalci pa bodo ustavljeni.

Če vam to nepričakovano preprečuje legitimno prispevanje, prosimo, da se obrnete na [[{{MediaWiki:Grouppage-sysop}}|administratorje spletišča]].

Za vrnitev v urejevalnik izberite gumb »nazaj« v vašem brskalniku.',
);

/** Somali (Soomaaliga)
 * @author Abshirdheere
 */
$messages['so'] = array(
	'questycaptcha-createaccount' => "Si aad u caawiso dhowritaanka in la iska samaysto Akoon,Fadlan ka jawaan su'aalahaan hoos ku qoran ([[Special:Captcha/help|Macluumaad dheeraad ah]]):",
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎)
 * @author Rancher
 */
$messages['sr-ec'] = array(
	'questycaptcha-desc' => 'Стварач сликовног кода за потврду уређивања',
);

/** Serbian (Latin script) (srpski (latinica)‎)
 */
$messages['sr-el'] = array(
	'questycaptcha-desc' => 'Stvarač slikovnog koda za potvrdu uređivanja',
);

/** Swedish (svenska)
 * @author Boivie
 */
$messages['sv'] = array(
	'questycaptcha-addurl' => 'Din redigering inkluderar nya externa länkar.
För att hjälpa till i skyddet mot automatisk spam, vänligen svara på frågan som finns nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptcha-badlogin' => 'För att hjälpa till i skyddet mot automatisk lösenordsknäckning, vänligen svara på frågan som finns nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptcha-createaccount' => 'För att hjälpa till i skyddet mot automatiskt kontoskapande, vänligen svara på frågan som finns nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptcha-create' => 'För att skapa sidan, vänligen svara på frågan som finns nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptcha-edit' => 'För att redigera denna sida, vänligen svara på frågan som finns nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptcha-sendemail' => 'För att skydda mot automatisk spamning, vänligen svara på frågan som visas nedan ([[Special:Captcha/help|mer information]]):',
	'questycaptchahelp-text' => "Webbplatser som accepterar bidrag från allmänheten, som denna wiki, blir ofta utnyttjade av spammare som använder automatiska verktyg för att lägga till sina linkar till många sajter.
Även om dessa spam-länkar kan tas bort är de väldigt störande.

Ibland, särskilt vid tillägg av nya webblänkar till en sida, kan wikin be dig svara på en fråga.
Eftersom denna uppgift är svår att automatisera, låter den de flesta riktiga människor göra sina bidrag medan den stoppar de flesta spammare och andra robotattackerare.

Vänligen kontakta [[{{MediaWiki:Grouppage-sysop}}|sajtens administratörer]] för hjälp ifall detta oväntat förhindrar dig från att göra tillåtna bidrag.

Klicka 'tillbaka'-knappen i din webbläsare för att återvända till sidredigeraren.",
);

/** Telugu (తెలుగు)
 * @author Kiranmayee
 * @author Veeven
 */
$messages['te'] = array(
	'questycaptcha-addurl' => 'మీరు చేసిన మార్పులో కొత్త బయటి లింకులు ఉన్నాయి.
ఆటోమేటెడ్ స్పాము నుండి రక్షణకై, క్రింద కనిపించే ప్రశ్నకు సమాధానమివ్వండి ([[Special:Captcha/help|మరింత సమాచారం]]):',
	'questycaptcha-edit' => 'ఈ పేజీని సరిదిద్దడానికి, క్రింద కనిపించే ప్రశ్నకి జవాబివ్వండి ([[Special:Captcha/help|మరింత సమాచారం]]):',
);

/** Thai (ไทย)
 * @author Harley Hartwell
 */
$messages['th'] = array(
	'questycaptchahelp-text' => "เว็บไซต์ที่บุคคลภายนอกเข้ามาช่วยเขียนได้ เช่น วิกินี้ มักถูกสแปมโดยผู้ใช้ที่ใช้บอตหรือโปรแกรมอัตโนมัติเพื่อเพิ่มลิงก์ไปยังเว็บไซต์หลาย ๆ เว็บไซต์ แม้เราจะสามารถนำลิงก์ที่สแปมออกได้ก็ตาม แต่ก็ย่ิอมก่อให้เกิดความรำคาญต่อผู้ใช้ได้เช่นกัน

เนื่องจากการใส่ลิงก์เป็นเรื่องยากในการดูแลโดยอัตโนมัติ ในบางครั้ง โดยเฉพาะเมื่อคุณใส่ลิงก์เว็บภายนอก ระบบวิกิอาจขอให้คุณตอบคำถาม เพื่อป้องกันนักสแปมและโรบอตโจมตีอื่น ๆ ทำการแก้ไข แต่จะอนุญาตให้ผู้ที่ใกล้เคียงมนุษย์มากทีุ่สุดแก้ไขได้

กรุณาติดต่อ [[{{MediaWiki:Grouppage-sysop}}|ผู้ดูแลระบบ]] หากกระบวนการนี้ไม่สามารถทำให้คุณแก้ไขข้อมูลให้ถูกต้องได้

กดปุ่ม 'Back' บนเบราเซอร์ของคุณเพื่อกลับไปยังหน้าแก้ไข",
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'questycaptcha-desc' => 'Kaakit-akit na panlikha ng CAPTCHA na Questy para sa Pagtiyak ng Pagbago',
	'questycaptcha-addurl' => 'Kasali sa pagbago mo ang bagong panglabas na mga kawing.
Upang makatulong sa pagsanggalang laban sa kusang panglulusob, pakisagot ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|more info]]):',
	'questycaptcha-badlogin' => 'Upang makatulong sa pagsasanggalang laban sa mga kusang paglutas ng hudyat, pakisagot lamang ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|marami pang kabatiran]]):',
	'questycaptcha-createaccount' => 'Upang makatulong sa pagsasanggalang laban sa kusang paglikha ng akawnt, pakisagot ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|marami pang kabatiran]]):',
	'questycaptcha-create' => 'Upang malikha ang pahina, pakisagot ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|marami pang kabatiran]]):',
	'questycaptcha-edit' => 'Upang mabago ang pahina, pakisagot ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|marami pang kabatiran]]):',
	'questycaptcha-sendemail' => 'Upang makatulong sa pagsasanggalang laban sa mga kusang paglusob, pakisagot lamang ang tanong na nakalitaw sa ibaba ([[Special:Captcha/help|marami pang kabatiran]]):',
	'questycaptchahelp-text' => "Ang mga websayt na tumatanggap ng mga ambag mula sa madla, katulad ng wiking ito, ay madalas abusuhin ng mga manlulusob na gumagamit ng kasangkapang pangkusa upang madagdag ang kanilang mga kawing sa maraming mga sayt.

Kung minsan, partikular na kapag nagdaragdag ng bagong mga kawing pangweb sa isang pahina, maaaring humiling ang wiki na sagutin mo ang isang tanong.  
Dahil isa itong gawaing mahirap ikusa, magpapahintulot ito ng karamihan sa tunay na mga tao na gawin ang kanilang mga kontribusyon habang pinahihinto ang karamihan sa mga ispamer at iba pang mga makarobot na mga panglusob.

Mangyaring makipag-ugnayan sa [[{{MediaWiki:Grouppage-sysop}}|mga tagapangasiwa ng sayt]] para sa pagtulong kung hindi inaasahang pigilan ka mula sa paggawa ng tunay na mga ambag.

Pindutin ang pindutang 'bumalik' sa iyong pantingin-tingin upang makabalik sa pambago ng pahina.",
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'questycaptcha-addurl' => 'Değişikliğiniz yeni dış bağlantı içeriyor.
Otomatik reklama karşı korunmaya yardımcı olmak için, lütfen ([[Special:Captcha/help|daha fazla bilgi]]) bölümünün altında yer alan soruya cevap verin:',
	'questycaptcha-badlogin' => 'Otomatik şifre kırmaya karşı korunmaya yardımcı olmak için, lütfen ([[Special:Captcha/help|daha fazla bilgi]]) bölümünün altında yer alan soruya cevap verin:',
	'questycaptcha-createaccount' => 'Otomatik hesap oluşturmaya karşı korunmaya yardımcı olmak için, lütfen ([[Special:Captcha/help|daha fazla bilgi]]) bölümünün altında yer alan soruya cevap verin:',
	'questycaptcha-create' => 'Sayfayı oluşturmak için, lütfen ([[Special:Captcha/help|daha fazla bilgi]]) bölümünün altında yer alan soruya cevap verin:',
	'questycaptcha-edit' => 'Sayfayı değiştirmek için, lütfen ([[Special:Captcha/help|daha fazla bilgi]]) bölümünün altında yer alan soruya cevap verin:',
	'questycaptcha-sendemail' => 'Otomatik spamlerden korunmaya yardımcı olmak için, lütfen aşağıda görünen soruyu cevaplayın ([[Special:Captcha/help|daha fazla bilgi]]):',
	'questycaptchahelp-text' => "Bu viki gibi herkesin katkı yapmasına izin veren web siteleri, genellikle bir çok siteye verilen bağlantıları ekleyen otomatik araçlar kullanan reklam amaçlı kullanıcılar tarafından istismar edilmektedir.
Bu reklam bağlantıları kaldırılabiliyor olsa da, önemli bir sıkıntı yaratmaktadırlar.

Bazen, özellikle bir sayfaya yeni web bağlantıları eklenirken, viki size bir soru sorabilir.
Bu, otomatikleştirilmesi zor bir iş olduğu için, insanların katkılarını yapmasını mümkün kılarken çoğu reklam amaçlı kullanıcıyı ya da robot saldırganı durduracaktır.

Bu durumun sizi normal katkılarınızı yapmaktan olağandışı bir şekilde alıkoyması halinde, lütfen destek için [[{{MediaWiki:Grouppage-sysop}}|site hizmetlileri]] ile irtibata geçin.

Sayfa editörüne dönmek için tarayıcınızın 'geri' düğmesine tıklayın.",
);

/** Ukrainian (українська)
 * @author Diemon.ukr
 */
$messages['uk'] = array(
	'questycaptcha-addurl' => 'Ваше редагування містить нові зовнішні посилання.
Із метою захисту від спаму, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptcha-badlogin' => 'Із метою захисту від автоматичного підбору пароля, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptcha-createaccount' => 'Із метою захисту від автоматичного створення облікових записів, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptcha-create' => 'Щоб створити сторінку, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptcha-edit' => 'Щоб редагувати цю сторінку, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptcha-sendemail' => 'Із метою захисту від автоматичного спаму, будь ласка, дайте відповідь на питання, що наводиться нижче ([[Special:Captcha/help|докладніше]]):',
	'questycaptchahelp-text' => 'Сайти, які надають можливість змінювати свій зміст, як це вікі, часто є місцем зловживання спамерів, які використовують автоматизовані інструменти для додавання посилань на інші сайти. 
Хоча ці спам-посилання можуть бути вилучені, вони є суттєвим негативним чинником. 

Іноді, особливо при додаванні нових посилань веб-сторінки, вікі може попросити вас відповісти на запитання. 
Це є завданням, яке важко автоматизувати, тому воно дозволить більшості реальних людей зробити свій внесок, і в той же час зупинить більшість спамерів та інших роботизованих нападників. 

Будь ласка, зв\'яжіться з [[{{MediaWiki:Grouppage-sysop}}|адміністраторами сайту]] по допомогу, якщо ця система не дозволяє вам робити допустимий внесок. 

Натисніть на кнопку "назад" у браузері, щоб повернутися на сторінку редагування.',
);

/** Walloon (walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'questycaptcha-addurl' => "Dins vos candjmints i gn a des dfoûtrinnès hårdêyes (URL).
Po s' mete a houte des robots di spam, nos vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula respondez al kesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'questycaptcha-badlogin' => "Po s' mete a houte des des robots ki sayèt d' adviner les screts, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula respondez al kesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'questycaptcha-createaccount' => "Po s' mete a houte des des robots k' ahivèt des contes otomaticmint, nos  vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula respondez al kesse chal pa dzi ([[Special:Captcha/help|pus di racsegnes]]):",
	'questycaptcha-create' => "Por vos poleur ahiver l' pådje, vos dvoz responde al kesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'questycaptcha-edit' => 'Po candjî cisse pådje ci, vos dvoz responde al kesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):',
	'questycaptcha-sendemail' => "Po s' mete a houte des robots di spam, nos vs dimandans d' acertiner ki vos estoz bén ene djin, po çoula respondez al kesse chal pa dzo ([[Special:Captcha/help|pus di racsegnes]]):",
	'questycaptchahelp-text' => "Les waibes k' acceptèt des messaedjes do publik, come ci wiki chal, sont sovint eployîs pa des må-fjhants spameus, po pleur mete, avou des usteyes otomatikes, des loyéns di rclame viè les sites da zels.
Bén seur, on pout todi les disfacer al mwin, mins c' est on soyant ovraedje.

Adon, pa côps, copurade cwand vos radjoutez des hårdêyes a ene pådje, on eployrè ene passete d' acertinaedje, dj' ô bén k' on vs dimandrè d' responde a ene kesse. Come çoula est ene sacwè d' målåjheye a fé otomaticmint pa on robot, çoula permete di leyî les vraiyès djins fé leus candjmints tot arestant l' plupårt des spameus et des sfwaitès atakes pa robot.

S' i vs plait contactez les [[{{MediaWiki:Grouppage-sysop}}|manaedjeus do site]] po d' l' aidance si çoula vos espaitche di fé vos candjmints ledjitimes.

Clitchîz sol boton «En erî» di vosse betchteu waibe po rivni al pådje di dvant.",
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'questycaptcha-create' => 'צו שאַפֿן דעם בלאַט, ביטע ענטפֿערט די פֿראַגע אונטן  ([[Special:Captcha/help|מער אינפֿארמאַציע]]):',
);

/** Simplified Chinese (中文（简体）‎)
 * @author Cwek
 */
$messages['zh-hans'] = array(
	'questycaptcha-addurl' => '您的编辑内容中含有本网站以外的连结。为防止不当程式大量破坏，请回答以下的问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptcha-badlogin' => '为防止不当程式破解密码，请回答以下的问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptcha-createaccount' => '为防止不当程式大量建立帐户，请回答以下的问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptcha-create' => '为防止不当程式大量建立页面，请回答以下问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptcha-edit' => '为防破坏，如您想要编辑此页面，请回答以下的问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptcha-sendemail' => '为防止不当程式破解密码，请回答下列问题（[[Special:Captcha/help|相关资讯]]）：',
	'questycaptchahelp-text' => '像本站一样，对公众开放编辑的网站经常被垃圾连结骚扰。那些人使用自动化垃圾程序将他们的连结张贴到很多网站。虽然这些连结可以被清除，但是这些东西确实令人十分讨厌。

有时，特别是当给一个页面添加新的网页链接时，本站会让你看一幅有颜色的或者有变形文字的图像，并且要你输入所显示的文字。因为这是难以自动完成的一项任务，它将允许人保存他们的编辑，同时阻止大多数发送垃圾邮件者和其他机器人的攻击。

令人遗憾是，这会使得视力不好的人，或者使用基於文本或者基於声音的浏览器的用户感到不便。而目前我们还没有提供的音频的选择。如果这正好阻止你进行正常的编辑，请和[[{{MediaWiki:Grouppage-sysop}}|站点管理员]]联系获得帮助。

点击浏览器中的“后退”按钮返回你所编辑的页面。',
);

/** Traditional Chinese (中文（繁體）‎)
 * @author Horacewai2
 * @author Waihorace
 */
$messages['zh-hant'] = array(
	'questycaptcha-addurl' => '您的編輯內容中含有本網站以外的連結。為防止不當程式大量破壞，請回答以下的問題（[[Special:Captcha/help|相關資訊]]）：',
	'questycaptcha-badlogin' => '為防止不當程式破解密碼，請回答以下的問題（[[Special:Captcha/help|相關資訊]]）：',
	'questycaptcha-createaccount' => '為防止不當程式大量建立帳戶，請回答以下的問題（[[Special:Captcha/help|相關資訊]]）：',
	'questycaptcha-create' => '為防止不當程式大量建立頁面，請回答以下問題（[[Special:Captcha/help|相關資訊]]）：',
	'questycaptcha-edit' => '為防破壞，如您想要編輯此頁面，請回答以下的問題（[[Special:Captcha/help|相關資訊]]）：',
	'questycaptcha-sendemail' => '為防止不當程式破解密碼，請回答下列問題（[[Special:Captcha/help|相關資訊]]）：',
);
