<?php
/**
 * Several types of messages.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 * @ingroup MaintenanceLanguage
 */

/** Ignored messages, which should exist only in the English messages file. */
$wgIgnoredMessages = array(
	'sidebar',
	'accesskey-pt-userpage',
	'accesskey-pt-anonuserpage',
	'accesskey-pt-mytalk',
	'accesskey-pt-anontalk',
	'accesskey-pt-preferences',
	'accesskey-pt-watchlist',
	'accesskey-pt-mycontris',
	'accesskey-pt-login',
	'accesskey-pt-anonlogin',
	'accesskey-pt-logout',
	'accesskey-ca-talk',
	'accesskey-ca-edit',
	'accesskey-ca-addsection',
	'accesskey-ca-viewsource',
	'accesskey-ca-history',
	'accesskey-ca-protect',
	'accesskey-ca-unprotect',
	'accesskey-ca-delete',
	'accesskey-ca-undelete',
	'accesskey-ca-move',
	'accesskey-ca-watch',
	'accesskey-ca-unwatch',
	'accesskey-search',
	'accesskey-search-go',
	'accesskey-search-fulltext',
	'accesskey-p-logo',
	'accesskey-n-mainpage',
	'accesskey-n-mainpage-description',
	'accesskey-n-portal',
	'accesskey-n-currentevents',
	'accesskey-n-recentchanges',
	'accesskey-n-randompage',
	'accesskey-n-help',
	'accesskey-t-whatlinkshere',
	'accesskey-t-recentchangeslinked',
	'accesskey-feed-rss',
	'accesskey-feed-atom',
	'accesskey-t-contributions',
	'accesskey-t-emailuser',
	'accesskey-t-permalink',
	'accesskey-t-print',
	'accesskey-t-upload',
	'accesskey-t-specialpages',
	'accesskey-ca-nstab-main',
	'accesskey-ca-nstab-user',
	'accesskey-ca-nstab-media',
	'accesskey-ca-nstab-special',
	'accesskey-ca-nstab-project',
	'accesskey-ca-nstab-image',
	'accesskey-ca-nstab-mediawiki',
	'accesskey-ca-nstab-template',
	'accesskey-ca-nstab-help',
	'accesskey-ca-nstab-category',
	'accesskey-minoredit',
	'accesskey-save',
	'accesskey-preview',
	'accesskey-diff',
	'accesskey-compareselectedversions',
	'accesskey-watch',
	'accesskey-upload',
	'accesskey-preferences-save',
	'accesskey-summary',
	'accesskey-userrights-set',
	'accesskey-blockip-block',
	'accesskey-export',
	'accesskey-import',
	'accesskey-watchlistedit-normal-submit',
	'accesskey-watchlistedit-raw-submit',
	'addsection',
	'talkpageheader',
	'anonnotice',
	'autoblock_whitelist',
	'searchmenu-help',
	'searchmenu-new-nocreate',
	'googlesearch',
	'opensearch-desc',
	'exif-make-value',
	'exif-model-value',
	'exif-software-value',
	'exif-software-version-value',
	'history_copyright',
	'licenses',
	'loginstart',
	'loginend-https',
	'loginend',
	'loginlanguagelinks',
	'pear-mail-error',
	'php-mail-error',
	'markaspatrolledlink',
	'newarticletextanon',
	'newsectionheaderdefaultlevel',
	'mainpage-nstab',
	'newtalkseparator',
	'noarticletextanon',
	'number_of_watching_users_RCview',
	'pagecategorieslink',
	'pubmedurl',
	'randompage-url',
	'recentchanges-url',
	'recentchangestext',
	'revision-info-current',
	'revision-nav',
	'rfcurl',
	'shareddescriptionfollows',
	'signature-anon',
	'signupstart',
	'signupend',
	'signupend-https',
	'sitenotice',
	'sitesubtitle',
	'sitetitle',
	'sp-contributions-footer',
	'sp-contributions-footer-anon',
	'sp-contributions-footer-newbies',
	'statistics-summary',
	'statistics-footer',
	'talkpagetext',
	'uploadfooter',
	'listgrouprights-link',
	'search-interwiki-custom',
	'allpages-summary',
	'booksources-summary',
	'categories-summary',
	'blocklist-summary',
	'protectedtitles-summary',
	'listusers-summary',
	'longpages-summary',
	'preferences-summary',
	'specialpages-summary',
	'whatlinkshere-summary',
	'listredirects-summary',
	'uncategorizedpages-summary',
	'uncategorizedcategories-summary',
	'uncategorizedimages-summary',
	'uncategorizedtemplates-summary',
	'popularpages-summary',
	'wantedcategories-summary',
	'wantedfiles-summary',
	'wantedpages-summary',
	'watchlist-summary',
	'mostlinked-summary',
	'mostlinkedcategories-summary',
	'mostlinkedtemplates-summary',
	'mostcategories-summary',
	'mostimages-summary',
	'mostinterwikis-summary',
	'mostrevisions-summary',
	'prefixindex-summary',
	'shortpages-summary',
	'newpages-summary',
	'ancientpages-summary',
	'unwatchedpages-summary',
	'userrights-summary',
	'brokenredirects-summary',
	'deadendpages-summary',
	'protectedpages-summary',
	'disambiguations-summary',
	'pageswithprop-summary',
	'doubleredirects-summary',
	'lonelypages-summary',
	'unusedtemplates-summary',
	'fewestrevisions-summary',
	'upload-summary',
	'wantedtemplates-summary',
	'activeusers-summary',
	'search-summary',
	'editpage-head-copy-warn',
	'editpage-tos-summary',
	'addsection-preload',
	'addsection-editintro',
	'longpage-hint',
	'javascripttest-backlink',
	'javascripttest-qunit-name',
	'revdelete-logentry',
	'logdelete-logentry',
	'revdelete-content',
	'revdelete-summary',
	'revdelete-uname',
	'revdelete-hid',
	'revdelete-unhid',
	'revdelete-log-message',
	'logdelete-log-message',
	'deletedarticle',
	'suppressedarticle',
	'undeletedarticle',
	'patrol-log-line',
	'patrol-log-auto',
	'patrol-log-diff',
	'1movedto2',
	'1movedto2_redir',
	'move-redirect-suppressed',
	'newuserlog-create-entry',
	'newuserlog-create2-entry',
	'newuserlog-autocreate-entry',
	'rightslogentry',
	'rightslogentry-autopromote',
	'suppressedarticle',
	'deletedarticle',
	// 'uploadedimage',
	// 'overwroteimage',
	'userlogout-summary',
	'changeemail-summary',
	'changepassword-summary',
	'unusedcategories-summary',
	'unusedimages-summary',
	'deletedcontributions-summary',
	'linksearch-summary',
	'emailuser-summary',
	'undelete-summary',
	'contributions-summary',
	'unblock-summary',
	'movepage-summary',
	'export-summary',
	'import-summary',
	'editwatchlist-summary',
	'version-summary',
	'tags-summary',
	'comparepages-summary',
	'version-entrypoints-index-php',
	'version-entrypoints-api-php',
	'version-entrypoints-load-php',
	'ipb-default-expiry',
	'pageinfo-header',
	'pageinfo-footer',
);

/** Optional messages, which may be translated only if changed in the target language. */
$wgOptionalMessages = array(
	'linkprefix',
	'editsection-brackets',
	'feed-atom',
	'feed-rss',
	'unit-pixel',
	'userrights-irreversible-marker',
	'tog-noconvertlink',
	'variantname-zh-hans',
	'variantname-zh-hant',
	'variantname-zh-cn',
	'variantname-zh-tw',
	'variantname-zh-hk',
	'variantname-zh-mo',
	'variantname-zh-my',
	'variantname-zh-sg',
	'variantname-zh',
	'variantname-gan-hans',
	'variantname-gan-hant',
	'variantname-gan',
	'variantname-sr-ec',
	'variantname-sr-el',
	'variantname-sr',
	'variantname-kk-arab',
	'variantname-kk-cyrl',
	'variantname-kk-latn',
	'variantname-kk-tr',
	'variantname-kk-kz',
	'variantname-kk-cn',
	'variantname-kk',
	'variantname-ku-latn',
	'variantname-ku-arab',
	'variantname-ku',
	'variantname-tg-cyrl',
	'variantname-tg-latn',
	'variantname-tg',
	'variantname-ike-cans',
	'variantname-ike-latn',
	'variantname-iu',
	'variantname-shi-tfng',
	'variantname-shi-latn',
	'variantname-shi',
	'rc-change-size',
	'resetpass_text',
	'image_sample',
	'media_sample',
	'skinname-standard',
	'skinname-nostalgia',
	'skinname-cologneblue',
	'skinname-monobook',
	'skinname-myskin',
	'skinname-chick',
	'skinname-simple',
	'skinname-modern',
	'skinname-vector',
	'common.css',
	'standard.css',
	'nostalgia.css',
	'cologneblue.css',
	'monobook.css',
	'myskin.css',
	'chick.css',
	'simple.css',
	'modern.css',
	'vector.css',
	'print.css',
	'handheld.css',
	'noscript.css',
	'group-autoconfirmed.css',
	'group-bot.css',
	'group-sysop.css',
	'group-bureaucrat.css',
	'common.js',
	'standard.js',
	'nostalgia.js',
	'cologneblue.js',
	'monobook.js',
	'myskin.js',
	'chick.js',
	'simple.js',
	'modern.js',
	'vector.js',
	'group-autoconfirmed.js',
	'group-bot.js',
	'group-sysop.js',
	'group-bureaucrat.js',
	'widthheight',
	'exif-fnumber-format',
	'exif-focallength-format',
	'exif-compression-5',
	'exif-compression-6',
	'exif-compression-7',
	'exif-compression-8',
	'exif-compression-32773',
	'exif-compression-32946',
	'exif-compression-34712',
	'exif-photometricinterpretation-2',
	'exif-photometricinterpretation-6',
	'exif-xyresolution-i',
	'exif-xyresolution-c',
	'exif-colorspace-1',
	'exif-componentsconfiguration-1',
	'exif-componentsconfiguration-2',
	'exif-componentsconfiguration-3',
	'exif-componentsconfiguration-4',
	'exif-componentsconfiguration-5',
	'exif-componentsconfiguration-6',
	'exif-contact-value',
	'exif-coordinate-format',
	'exif-lightsource-20',
	'exif-lightsource-21',
	'exif-lightsource-22',
	'exif-lightsource-23',
	'exif-maxaperturevalue-value',
	'exif-subjectnewscode-value',
	'booksources-isbn',
	'protect-summary-desc',
	'sp-contributions-explain',
	'sorbs',
	'video-dims',
	'seconds-abbrev',
	'minutes-abbrev',
	'hours-abbrev',
	'days-abbrev',
	'pagetitle',
	'filename-prefix-blacklist',
	'edittools',
	'edittools-upload',
	'size-bytes',
	'size-kilobytes',
	'size-megabytes',
	'size-gigabytes',
	'size-terabytes',
	'size-petabytes',
	'size-exabytes',
	'size-zetabytes',
	'size-yottabytes',
	'bitrate-bits',
	'bitrate-kilobits',
	'bitrate-megabits',
	'bitrate-gigabits',
	'bitrate-terabits',
	'bitrate-petabits',
	'bitrate-exabits',
	'bitrate-zetabits',
	'bitrate-yottabits',
	'iranian-calendar-m1',
	'iranian-calendar-m2',
	'iranian-calendar-m3',
	'iranian-calendar-m4',
	'iranian-calendar-m5',
	'iranian-calendar-m6',
	'iranian-calendar-m7',
	'iranian-calendar-m8',
	'iranian-calendar-m9',
	'iranian-calendar-m10',
	'iranian-calendar-m11',
	'iranian-calendar-m12',
	'hijri-calendar-m1',
	'hijri-calendar-m2',
	'hijri-calendar-m3',
	'hijri-calendar-m4',
	'hijri-calendar-m5',
	'hijri-calendar-m6',
	'hijri-calendar-m7',
	'hijri-calendar-m8',
	'hijri-calendar-m9',
	'hijri-calendar-m10',
	'hijri-calendar-m11',
	'hijri-calendar-m12',
	'hebrew-calendar-m1',
	'hebrew-calendar-m2',
	'hebrew-calendar-m3',
	'hebrew-calendar-m4',
	'hebrew-calendar-m5',
	'hebrew-calendar-m6',
	'hebrew-calendar-m6a',
	'hebrew-calendar-m6b',
	'hebrew-calendar-m7',
	'hebrew-calendar-m8',
	'hebrew-calendar-m9',
	'hebrew-calendar-m10',
	'hebrew-calendar-m11',
	'hebrew-calendar-m12',
	'hebrew-calendar-m1-gen',
	'hebrew-calendar-m2-gen',
	'hebrew-calendar-m3-gen',
	'hebrew-calendar-m4-gen',
	'hebrew-calendar-m5-gen',
	'hebrew-calendar-m6-gen',
	'hebrew-calendar-m6a-gen',
	'hebrew-calendar-m6b-gen',
	'hebrew-calendar-m7-gen',
	'hebrew-calendar-m8-gen',
	'hebrew-calendar-m9-gen',
	'hebrew-calendar-m10-gen',
	'hebrew-calendar-m11-gen',
	'hebrew-calendar-m12-gen',
	'version-api',
	'version-svn-revision',
	'semicolon-separator',
	'comma-separator',
	'colon-separator',
	'pipe-separator',
	'word-separator',
	'ellipsis',
	'percent',
	'parentheses',
	'brackets',
	'autocomment-prefix',
	'listgrouprights-right-display',
	'listgrouprights-right-revoked',
	'timezone-utc',
	'unpatrolledletter',
	'diff-with-additional',
	'pagetitle-view-mainpage',
	'backlinksubtitle',
	'prefs-registration-date-time',
	'prefs-memberingroups-type',
	'userrights-groupsmember-type',
	'shared-repo-name-wikimediacommons',
	'usermessage-template',
	'filepage.css',
	'metadata-langitem',
	'metadata-langitem-default',
	'nocookiesforlogin',
	'version-entrypoints-articlepath',
	'version-entrypoints-scriptpath',
	'mergehistory-revisionrow',
	'categoryviewer-pagedlinks',
	'undelete-revisionrow',
	'pageinfo-redirects-value',
	'created', // @deprecated. Remove in MediaWiki 1.23.
	'changed', // @deprecated. Remove in MediaWiki 1.23.
);

/** EXIF messages, which may be set as optional in several checks, but are generally mandatory */
$wgEXIFMessages = array(
	'exif-imagewidth',
	'exif-imagelength',
	'exif-bitspersample',
	'exif-compression',
	'exif-photometricinterpretation',
	'exif-orientation',
	'exif-samplesperpixel',
	'exif-planarconfiguration',
	'exif-ycbcrsubsampling',
	'exif-ycbcrpositioning',
	'exif-xresolution',
	'exif-yresolution',
	'exif-stripoffsets',
	'exif-rowsperstrip',
	'exif-stripbytecounts',
	'exif-jpeginterchangeformat',
	'exif-jpeginterchangeformatlength',
	'exif-whitepoint',
	'exif-primarychromaticities',
	'exif-ycbcrcoefficients',
	'exif-referenceblackwhite',
	'exif-datetime',
	'exif-imagedescription',
	'exif-make',
	'exif-model',
	'exif-software',
	'exif-artist',
	'exif-copyright',
	'exif-exifversion',
	'exif-flashpixversion',
	'exif-colorspace',
	'exif-componentsconfiguration',
	'exif-compressedbitsperpixel',
	'exif-pixelydimension',
	'exif-pixelxdimension',
	'exif-usercomment',
	'exif-relatedsoundfile',
	'exif-datetimeoriginal',
	'exif-datetimedigitized',
	'exif-subsectime',
	'exif-subsectimeoriginal',
	'exif-subsectimedigitized',
	'exif-exposuretime',
	'exif-exposuretime-format',
	'exif-fnumber',
	'exif-fnumber-format',
	'exif-exposureprogram',
	'exif-spectralsensitivity',
	'exif-isospeedratings',
	'exif-shutterspeedvalue',
	'exif-aperturevalue',
	'exif-brightnessvalue',
	'exif-exposurebiasvalue',
	'exif-maxaperturevalue',
	'exif-subjectdistance',
	'exif-meteringmode',
	'exif-lightsource',
	'exif-flash',
	'exif-focallength',
	'exif-focallength-format',
	'exif-subjectarea',
	'exif-flashenergy',
	'exif-focalplanexresolution',
	'exif-focalplaneyresolution',
	'exif-focalplaneresolutionunit',
	'exif-subjectlocation',
	'exif-exposureindex',
	'exif-sensingmethod',
	'exif-filesource',
	'exif-scenetype',
	'exif-customrendered',
	'exif-exposuremode',
	'exif-whitebalance',
	'exif-digitalzoomratio',
	'exif-focallengthin35mmfilm',
	'exif-scenecapturetype',
	'exif-gaincontrol',
	'exif-contrast',
	'exif-saturation',
	'exif-sharpness',
	'exif-devicesettingdescription',
	'exif-subjectdistancerange',
	'exif-imageuniqueid',
	'exif-gpsversionid',
	'exif-gpslatituderef',
	'exif-gpslatitude',
	'exif-gpslongituderef',
	'exif-gpslongitude',
	'exif-gpsaltituderef',
	'exif-gpsaltitude',
	'exif-gpstimestamp',
	'exif-gpssatellites',
	'exif-gpsstatus',
	'exif-gpsmeasuremode',
	'exif-gpsdop',
	'exif-gpsspeedref',
	'exif-gpsspeed',
	'exif-gpstrackref',
	'exif-gpstrack',
	'exif-gpsimgdirectionref',
	'exif-gpsimgdirection',
	'exif-gpsmapdatum',
	'exif-gpsdestlatituderef',
	'exif-gpsdestlatitude',
	'exif-gpsdestlongituderef',
	'exif-gpsdestlongitude',
	'exif-gpsdestbearingref',
	'exif-gpsdestbearing',
	'exif-gpsdestdistanceref',
	'exif-gpsdestdistance',
	'exif-gpsprocessingmethod',
	'exif-gpsareainformation',
	'exif-gpsdatestamp',
	'exif-gpsdifferential',
	'exif-coordinate-format',
	'exif-jpegfilecomment',
	'exif-keywords',
	'exif-worldregioncreated',
	'exif-countrycreated',
	'exif-countrycodecreated',
	'exif-provinceorstatecreated',
	'exif-citycreated',
	'exif-sublocationcreated',
	'exif-worldregiondest',
	'exif-countrydest',
	'exif-countrycodedest',
	'exif-provinceorstatedest',
	'exif-citydest',
	'exif-sublocationdest',
	'exif-objectname',
	'exif-specialinstructions',
	'exif-headline',
	'exif-credit',
	'exif-source',
	'exif-editstatus',
	'exif-urgency',
	'exif-fixtureidentifier',
	'exif-locationdest',
	'exif-locationdestcode',
	'exif-objectcycle',
	'exif-contact',
	'exif-writer',
	'exif-languagecode',
	'exif-iimversion',
	'exif-iimcategory',
	'exif-iimsupplementalcategory',
	'exif-datetimeexpires',
	'exif-datetimereleased',
	'exif-originaltransmissionref',
	'exif-identifier',
	'exif-lens',
	'exif-serialnumber',
	'exif-cameraownername',
	'exif-label',
	'exif-datetimemetadata',
	'exif-nickname',
	'exif-rating',
	'exif-rightscertificate',
	'exif-copyrighted',
	'exif-copyrightowner',
	'exif-usageterms',
	'exif-webstatement',
	'exif-originaldocumentid',
	'exif-licenseurl',
	'exif-morepermissionsurl',
	'exif-attributionurl',
	'exif-preferredattributionname',
	'exif-pngfilecomment',
	'exif-disclaimer',
	'exif-contentwarning',
	'exif-giffilecomment',
	'exif-intellectualgenre',
	'exif-subjectnewscode',
	'exif-scenecode',
	'exif-event',
	'exif-organisationinimage',
	'exif-personinimage',
	'exif-originalimageheight',
	'exif-originalimagewidth',
	'exif-make-value',
	'exif-model-value',
	'exif-software-value',
	'exif-software-version-value',
	'exif-contact-value',
	'exif-subjectnewscode-value',
	'exif-compression-1',
	'exif-compression-2',
	'exif-compression-3',
	'exif-compression-4',
	'exif-compression-5',
	'exif-compression-6',
	'exif-compression-7',
	'exif-compression-8',
	'exif-compression-32773',
	'exif-compression-32946',
	'exif-compression-34712',
	'exif-copyrighted-true',
	'exif-copyrighted-false',
	'exif-photometricinterpretation-2',
	'exif-photometricinterpretation-6',
	'exif-unknowndate',
	'exif-orientation-1',
	'exif-orientation-2',
	'exif-orientation-3',
	'exif-orientation-4',
	'exif-orientation-5',
	'exif-orientation-6',
	'exif-orientation-7',
	'exif-orientation-8',
	'exif-planarconfiguration-1',
	'exif-planarconfiguration-2',
	'exif-xyresolution-i',
	'exif-xyresolution-c',
	'exif-colorspace-1',
	'exif-colorspace-65535',
	'exif-componentsconfiguration-0',
	'exif-componentsconfiguration-1',
	'exif-componentsconfiguration-2',
	'exif-componentsconfiguration-3',
	'exif-componentsconfiguration-4',
	'exif-componentsconfiguration-5',
	'exif-componentsconfiguration-6',
	'exif-exposureprogram-0',
	'exif-exposureprogram-1',
	'exif-exposureprogram-2',
	'exif-exposureprogram-3',
	'exif-exposureprogram-4',
	'exif-exposureprogram-5',
	'exif-exposureprogram-6',
	'exif-exposureprogram-7',
	'exif-exposureprogram-8',
	'exif-subjectdistance-value',
	'exif-meteringmode-0',
	'exif-meteringmode-1',
	'exif-meteringmode-2',
	'exif-meteringmode-3',
	'exif-meteringmode-4',
	'exif-meteringmode-5',
	'exif-meteringmode-6',
	'exif-meteringmode-255',
	'exif-lightsource-0',
	'exif-lightsource-1',
	'exif-lightsource-2',
	'exif-lightsource-3',
	'exif-lightsource-4',
	'exif-lightsource-9',
	'exif-lightsource-10',
	'exif-lightsource-11',
	'exif-lightsource-12',
	'exif-lightsource-13',
	'exif-lightsource-14',
	'exif-lightsource-15',
	'exif-lightsource-17',
	'exif-lightsource-18',
	'exif-lightsource-19',
	'exif-lightsource-20',
	'exif-lightsource-21',
	'exif-lightsource-22',
	'exif-lightsource-23',
	'exif-lightsource-24',
	'exif-lightsource-255',
	'exif-flash-fired-0',
	'exif-flash-fired-1',
	'exif-flash-return-0',
	'exif-flash-return-2',
	'exif-flash-return-3',
	'exif-flash-mode-1',
	'exif-flash-mode-2',
	'exif-flash-mode-3',
	'exif-flash-function-1',
	'exif-flash-redeye-1',
	'exif-focalplaneresolutionunit-2',
	'exif-sensingmethod-1',
	'exif-sensingmethod-2',
	'exif-sensingmethod-3',
	'exif-sensingmethod-4',
	'exif-sensingmethod-5',
	'exif-sensingmethod-7',
	'exif-sensingmethod-8',
	'exif-filesource-3',
	'exif-scenetype-1',
	'exif-customrendered-0',
	'exif-customrendered-1',
	'exif-exposuremode-0',
	'exif-exposuremode-1',
	'exif-exposuremode-2',
	'exif-whitebalance-0',
	'exif-whitebalance-1',
	'exif-scenecapturetype-0',
	'exif-scenecapturetype-1',
	'exif-scenecapturetype-2',
	'exif-scenecapturetype-3',
	'exif-gaincontrol-0',
	'exif-gaincontrol-1',
	'exif-gaincontrol-2',
	'exif-gaincontrol-3',
	'exif-gaincontrol-4',
	'exif-contrast-0',
	'exif-contrast-1',
	'exif-contrast-2',
	'exif-saturation-0',
	'exif-saturation-1',
	'exif-saturation-2',
	'exif-sharpness-0',
	'exif-sharpness-1',
	'exif-sharpness-2',
	'exif-subjectdistancerange-0',
	'exif-subjectdistancerange-1',
	'exif-subjectdistancerange-2',
	'exif-subjectdistancerange-3',
	'exif-gpslatitude-n',
	'exif-gpslatitude-s',
	'exif-gpslongitude-e',
	'exif-gpslongitude-w',
	'exif-gpsaltitude-above-sealevel',
	'exif-gpsaltitude-below-sealevel',
	'exif-gpsstatus-a',
	'exif-gpsstatus-v',
	'exif-gpsmeasuremode-2',
	'exif-gpsmeasuremode-3',
	'exif-gpsspeed-k',
	'exif-gpsspeed-m',
	'exif-gpsspeed-n',
	'exif-gpsdestdistance-k',
	'exif-gpsdestdistance-m',
	'exif-gpsdestdistance-n',
	'exif-gpsdop-excellent',
	'exif-gpsdop-good',
	'exif-gpsdop-moderate',
	'exif-gpsdop-fair',
	'exif-gpsdop-poor',
	'exif-objectcycle-a',
	'exif-objectcycle-p',
	'exif-objectcycle-b',
	'exif-gpsdirection-t',
	'exif-gpsdirection-m',
	'exif-ycbcrpositioning-1',
	'exif-ycbcrpositioning-2',
	'exif-dc-contributor',
	'exif-dc-coverage',
	'exif-dc-date',
	'exif-dc-publisher',
	'exif-dc-relation',
	'exif-dc-rights',
	'exif-dc-source',
	'exif-dc-type',
	'exif-rating-rejected',
	'exif-isospeedratings-overflow',
	'exif-maxaperturevalue-value',
	'exif-iimcategory-ace',
	'exif-iimcategory-clj',
	'exif-iimcategory-dis',
	'exif-iimcategory-fin',
	'exif-iimcategory-edu',
	'exif-iimcategory-evn',
	'exif-iimcategory-hth',
	'exif-iimcategory-hum',
	'exif-iimcategory-lab',
	'exif-iimcategory-lif',
	'exif-iimcategory-pol',
	'exif-iimcategory-rel',
	'exif-iimcategory-sci',
	'exif-iimcategory-soi',
	'exif-iimcategory-spo',
	'exif-iimcategory-war',
	'exif-iimcategory-wea',
	'exif-urgency-normal',
	'exif-urgency-low',
	'exif-urgency-high',
	'exif-urgency-other',
);
