<?php
/**
 * Define the messages structure in the messages file, for an automated rewriting.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 * @ingroup MaintenanceLanguage
 */

/** The structure of the messages, divided to blocks */
$wgMessageStructure = array(
	'sidebar' => array(
		'sidebar',
	),
	'toggles' => array(
		'tog-underline',
		'tog-justify',
		'tog-hideminor',
		'tog-hidepatrolled',
		'tog-newpageshidepatrolled',
		'tog-extendwatchlist',
		'tog-usenewrc',
		'tog-numberheadings',
		'tog-showtoolbar',
		'tog-editondblclick',
		'tog-editsection',
		'tog-editsectiononrightclick',
		'tog-showtoc',
		'tog-rememberpassword',
		'tog-watchcreations',
		'tog-watchdefault',
		'tog-watchmoves',
		'tog-watchdeletion',
		'tog-minordefault',
		'tog-previewontop',
		'tog-previewonfirst',
		'tog-nocache',
		'tog-enotifwatchlistpages',
		'tog-enotifusertalkpages',
		'tog-enotifminoredits',
		'tog-enotifrevealaddr',
		'tog-shownumberswatching',
		'tog-oldsig',
		'tog-fancysig',
		'tog-externaleditor',
		'tog-externaldiff',
		'tog-showjumplinks',
		'tog-uselivepreview',
		'tog-forceeditsummary',
		'tog-watchlisthideown',
		'tog-watchlisthidebots',
		'tog-watchlisthideminor',
		'tog-watchlisthideliu',
		'tog-watchlisthideanons',
		'tog-watchlisthidepatrolled',
		'tog-ccmeonemails',
		'tog-diffonly',
		'tog-showhiddencats',
		'tog-noconvertlink',
		'tog-norollbackdiff',
	),
	'underline' => array(
		'underline-always',
		'underline-never',
		'underline-default',
	),
	'editfont' => array(
		'editfont-style',
		'editfont-default',
		'editfont-monospace',
		'editfont-sansserif',
		'editfont-serif',
	),
	'dates' => array(
		'sunday',
		'monday',
		'tuesday',
		'wednesday',
		'thursday',
		'friday',
		'saturday',
		'sun',
		'mon',
		'tue',
		'wed',
		'thu',
		'fri',
		'sat',
		'january',
		'february',
		'march',
		'april',
		'may_long',
		'june',
		'july',
		'august',
		'september',
		'october',
		'november',
		'december',
		'january-gen',
		'february-gen',
		'march-gen',
		'april-gen',
		'may-gen',
		'june-gen',
		'july-gen',
		'august-gen',
		'september-gen',
		'october-gen',
		'november-gen',
		'december-gen',
		'jan',
		'feb',
		'mar',
		'apr',
		'may',
		'jun',
		'jul',
		'aug',
		'sep',
		'oct',
		'nov',
		'dec',
	),
	'categorypages' => array(
		'pagecategories',
		'pagecategorieslink',
		'category_header',
		'subcategories',
		'category-media-header',
		'category-empty',
		'hidden-categories',
		'hidden-category-category',
		'category-subcat-count',
		'category-subcat-count-limited',
		'category-article-count',
		'category-article-count-limited',
		'category-file-count',
		'category-file-count-limited',
		'listingcontinuesabbrev',
		'index-category',
		'noindex-category',
		'broken-file-category',
		'categoryviewer-pagedlinks',
	),
	'mainpage' => array(
		'linkprefix',
	),
	'miscellaneous1' => array(
		'about',
		'article',
		'newwindow',
		'cancel',
		'moredotdotdot',
		'morenotlisted',
		'mypage',
		'mytalk',
		'anontalk',
		'navigation',
		'and',
	),
	'cologneblue' => array(
		'qbfind',
		'qbbrowse',
		'qbedit',
		'qbpageoptions',
		'qbmyoptions',
		'qbspecialpages',
		'faq',
		'faqpage',
		'sitetitle',
		'sitesubtitle',
	),
	'vector' => array(
		'vector-action-addsection',
		'vector-action-delete',
		'vector-action-move',
		'vector-action-protect',
		'vector-action-undelete',
		'vector-action-unprotect',
		'vector-simplesearch-preference',
		'vector-view-create',
		'vector-view-edit',
		'vector-view-history',
		'vector-view-view',
		'vector-view-viewsource',
		'actions',
		'namespaces',
		'variants',
	),
	'miscellaneous2' => array(
		'navigation-heading',
		'errorpagetitle',
		'returnto',
		'tagline',
		'help',
		'search',
		'searchbutton',
		'go',
		'searcharticle',
		'history',
		'history_short',
		'updatedmarker',
		'printableversion',
		'permalink',
		'print',
		'view',
		'edit',
		'create',
		'editthispage',
		'create-this-page',
		'delete',
		'deletethispage',
		'undelete_short',
		'viewdeleted_short',
		'protect',
		'protect_change',
		'protectthispage',
		'unprotect',
		'unprotectthispage',
		'newpage',
		'talkpage',
		'talkpagelinktext',
		'specialpage',
		'personaltools',
		'postcomment',
		'addsection',
		'articlepage',
		'talk',
		'views',
		'toolbox',
		'userpage',
		'projectpage',
		'imagepage',
		'mediawikipage',
		'templatepage',
		'viewhelppage',
		'categorypage',
		'viewtalkpage',
		'otherlanguages',
		'redirectedfrom',
		'redirectpagesub',
		'talkpageheader',
		'lastmodifiedat',
		'viewcount',
		'protectedpage',
		'jumpto',
		'jumptonavigation',
		'jumptosearch',
		'view-pool-error',
		'pool-timeout',
		'pool-queuefull',
		'pool-errorunknown',
	),
	'links' => array(
		'aboutsite',
		'aboutpage',
		'copyright',
		'copyrightpage',
		'currentevents',
		'currentevents-url',
		'disclaimers',
		'disclaimerpage',
		'edithelp',
		'edithelppage',
		'help',
		'helppage',
		'mainpage',
		'mainpage-description',
		'policy-url',
		'portal',
		'portal-url',
		'privacy',
		'privacypage',
	),
	'badaccess' => array(
		'badaccess',
		'badaccess-group0',
		'badaccess-groups',
	),
	'versionrequired' => array(
		'versionrequired',
		'versionrequiredtext',
	),
	'miscellaneous3' => array(
		'ok',
		'pagetitle',
		'pagetitle-view-mainpage',
		'backlinksubtitle',
		'retrievedfrom',
		'youhavenewmessages',
		'newmessageslink',
		'newmessagesdifflink',
		'youhavenewmessagesfromusers',
		'youhavenewmessagesmanyusers',
		'newmessageslinkplural',
		'newmessagesdifflinkplural',
		'youhavenewmessagesmulti',
		'newtalkseparator',
		'editsection',
		'editsection-brackets',
		'editold',
		'viewsourceold',
		'editlink',
		'viewsourcelink',
		'editsectionhint',
		'toc',
		'showtoc',
		'hidetoc',
		'collapsible-collapse',
		'collapsible-expand',
		'thisisdeleted',
		'viewdeleted',
		'restorelink',
		'feedlinks',
		'feed-invalid',
		'feed-unavailable',
		'site-rss-feed',
		'site-atom-feed',
		'page-rss-feed',
		'page-atom-feed',
		'feed-atom',
		'feed-rss',
		'sitenotice',
		'anonnotice',
		'newsectionheaderdefaultlevel',
		'red-link-title',
		'sort-descending',
		'sort-ascending',

	),
	'nstab' => array(
		'nstab-main',
		'nstab-user',
		'nstab-media',
		'nstab-special',
		'nstab-project',
		'nstab-image',
		'nstab-mediawiki',
		'nstab-template',
		'nstab-help',
		'nstab-category',
		'mainpage-nstab',
	),
	'main' => array(
		'nosuchaction',
		'nosuchactiontext',
		'nosuchspecialpage',
		'nospecialpagetext',
	),
	'errors' => array(
		'error',
		'databaseerror',
		'dberrortext',
		'dberrortextcl',
		'laggedslavemode',
		'readonly',
		'enterlockreason',
		'readonlytext',
		'missing-article', // not used anymore in core, but kept for extensions
		'missingarticle-rev', // not used anymore in core, but kept for extensions
		'missingarticle-diff', // not used anymore in core, but kept for extensions
		'readonly_lag',
		'internalerror',
		'internalerror_info',
		'fileappenderrorread',
		'fileappenderror',
		'filecopyerror',
		'filerenameerror',
		'filedeleteerror',
		'directorycreateerror',
		'filenotfound',
		'fileexistserror',
		'unexpected',
		'formerror',
		'badarticleerror',
		'cannotdelete',
		'cannotdelete-title',
		'delete-hook-aborted',
		'badtitle',
		'badtitletext',
		'perfcached',
		'perfcachedts',
		'querypage-no-updates',
		'wrong_wfQuery_params',
		'viewsource',
		'viewsource-title',
		'actionthrottled',
		'actionthrottledtext',
		'protectedpagetext',
		'viewsourcetext',
		'viewyourtext',
		'protectedinterface',
		'editinginterface',
		'sqlhidden',
		'cascadeprotected',
		'namespaceprotected',
		'customcssprotected',
		'customjsprotected',
		'ns-specialprotected',
		'titleprotected',
		'filereadonlyerror',
		'invalidtitle-knownnamespace',
		'invalidtitle-unknownnamespace',
		'exception-nologin',
		'exception-nologin-text',
	),
	'virus' => array(
		'virus-badscanner',
		'virus-scanfailed',
		'virus-unknownscanner',
	),
	'login' => array(
		'logouttext',
		'welcomeuser',
		'welcomecreation-msg',
		'yourname',
		'yourpassword',
		'yourpasswordagain',
		'remembermypassword',
		'securelogin-stick-https',
		'yourdomainname',
		'password-change-forbidden',
		'externaldberror',
		'login',
		'nav-login-createaccount',
		'loginprompt',
		'userlogin',
		'userloginnocreate',
		'logout',
		'userlogout',
		'userlogout-summary',
		'notloggedin',
		'nologin',
		'nologinlink',
		'createaccount',
		'gotaccount',
		'gotaccountlink',
		'userlogin-resetlink',
		'createaccountmail',
		'createaccountreason',
		'badretype',
		'userexists',
		'loginerror',
		'createaccounterror',
		'nocookiesnew',
		'nocookieslogin',
		'nocookiesfornew',
		'nocookiesforlogin',
		'noname',
		'loginsuccesstitle',
		'loginsuccess',
		'nosuchuser',
		'nosuchusershort',
		'nouserspecified',
		'login-userblocked',
		'wrongpassword',
		'wrongpasswordempty',
		'passwordtooshort',
		'password-name-match',
		'password-login-forbidden',
		'mailmypassword',
		'passwordremindertitle',
		'passwordremindertext',
		'noemail',
		'noemailcreate',
		'passwordsent',
		'blocked-mailpassword',
		'eauthentsent',
		'throttled-mailpassword',
		'loginstart',
		'loginend',
		'loginend-https',
		'signupstart',
		'signupend',
		'signupend-https',
		'mailerror',
		'acct_creation_throttle_hit',
		'emailauthenticated',
		'emailnotauthenticated',
		'noemailprefs',
		'emailconfirmlink',
		'invalidemailaddress',
		'cannotchangeemail',
		'emaildisabled',
		'accountcreated',
		'accountcreatedtext',
		'createaccount-title',
		'createaccount-text',
		'usernamehasherror',
		'login-throttled',
		'login-abort-generic',
		'loginlanguagelabel',
		'loginlanguagelinks',
		'suspicious-userlogout',
	),
	'mail' => array(
		'pear-mail-error',
		'php-mail-error',
		'php-mail-error-unknown',
		'user-mail-no-addy',
		'user-mail-no-body',
	),
	'resetpass' => array(
		'resetpass',
		'resetpass_announce',
		'resetpass_text',
		'resetpass_header',
		'oldpassword',
		'newpassword',
		'retypenew',
		'resetpass_submit',
		'resetpass_success',
		'resetpass_forbidden',
		'resetpass-no-info',
		'resetpass-submit-loggedin',
		'resetpass-submit-cancel',
		'resetpass-wrong-oldpass',
		'resetpass-temp-password',
		'resetpass-abort-generic',
	),
	'passwordreset' => array(
		'passwordreset',
		'passwordreset-text',
		'passwordreset-legend',
		'passwordreset-disabled',
		'passwordreset-pretext',
		'passwordreset-username',
		'passwordreset-domain',
		'passwordreset-capture',
		'passwordreset-capture-help',
		'passwordreset-email',
		'passwordreset-emailtitle',
		'passwordreset-emailtext-ip',
		'passwordreset-emailtext-user',
		'passwordreset-emailelement',
		'passwordreset-emailsent',
		'passwordreset-emailsent-capture',
		'passwordreset-emailerror-capture',
	),
	'changeemail' => array(
		'changeemail',
		'changeemail-summary',
		'changeemail-header',
		'changeemail-text',
		'changeemail-no-info',
		'changeemail-oldemail',
		'changeemail-newemail',
		'changeemail-none',
		'changeemail-password',
		'changeemail-submit',
		'changeemail-cancel',
	),
	'toolbar' => array(
		'bold_sample',
		'bold_tip',
		'italic_sample',
		'italic_tip',
		'link_sample',
		'link_tip',
		'extlink_sample',
		'extlink_tip',
		'headline_sample',
		'headline_tip',
		'nowiki_sample',
		'nowiki_tip',
		'image_sample',
		'image_tip',
		'media_sample',
		'media_tip',
		'sig_tip',
		'hr_tip',
	),
	'edit' => array(
		'summary',
		'subject',
		'minoredit',
		'watchthis',
		'savearticle',
		'preview',
		'showpreview',
		'showlivepreview',
		'showdiff',
		'anoneditwarning',
		'anonpreviewwarning',
		'missingsummary',
		'missingcommenttext',
		'missingcommentheader',
		'summary-preview',
		'subject-preview',
		'blockedtitle',
		'blockedtext',
		'autoblockedtext',
		'blockednoreason',
		'whitelistedittext',
		'confirmedittext',
		'nosuchsectiontitle',
		'nosuchsectiontext',
		'loginreqtitle',
		'loginreqlink',
		'loginreqpagetext',
		'accmailtitle',
		'accmailtext',
		'newarticle',
		'newarticletext',
		'newarticletextanon',
		'talkpagetext',
		'anontalkpagetext',
		'noarticletext',
		'noarticletext-nopermission',
		'noarticletextanon',
		'missing-revision',
		'userpage-userdoesnotexist',
		'userpage-userdoesnotexist-view',
		'blocked-notice-logextract',
		'clearyourcache',
		'usercssyoucanpreview',
		'userjsyoucanpreview',
		'usercsspreview',
		'userjspreview',
		'sitecsspreview',
		'sitejspreview',
		'userinvalidcssjstitle',
		'updated',
		'note',
		'previewnote',
		'continue-editing',
		'previewconflict',
		'session_fail_preview',
		'session_fail_preview_html',
		'token_suffix_mismatch',
		'edit_form_incomplete',
		'editing',
		'creating',
		'editingsection',
		'editingcomment',
		'editconflict',
		'explainconflict',
		'yourtext',
		'storedversion',
		'nonunicodebrowser',
		'editingold',
		'yourdiff',
		'copyrightwarning',
		'copyrightwarning2',
		'editpage-head-copy-warn',
		'editpage-tos-summary',
		'longpage-hint',
		'longpageerror',
		'readonlywarning',
		'protectedpagewarning',
		'semiprotectedpagewarning',
		'cascadeprotectedwarning',
		'titleprotectedwarning',
		'templatesused',
		'templatesusedpreview',
		'templatesusedsection',
		'template-protected',
		'template-semiprotected',
		'hiddencategories',
		'edittools',
		'edittools-upload',
		'nocreatetext',
		'nocreate-loggedin',
		'sectioneditnotsupported-title',
		'sectioneditnotsupported-text',
		'permissionserrors',
		'permissionserrorstext',
		'permissionserrorstext-withaction',
		'recreate-moveddeleted-warn',
		'moveddeleted-notice',
		'log-fulllog',
		'edit-hook-aborted',
		'edit-gone-missing',
		'edit-conflict',
		'edit-no-change',
		'edit-already-exists',
		'addsection-preload',
		'addsection-editintro',
		'defaultmessagetext',
		'content-failed-to-parse',
		'invalid-content-data',
		'content-not-allowed-here',
	),
	'contentmodels' => array(
		'content-model-wikitext',
		'content-model-text',
		'content-model-javascript',
		'content-model-css',
	),
	'parserwarnings' => array(
		'expensive-parserfunction-warning',
		'expensive-parserfunction-category',
		'post-expand-template-inclusion-warning',
		'post-expand-template-inclusion-category',
		'post-expand-template-argument-warning',
		'post-expand-template-argument-category',
		'parser-template-loop-warning',
		'parser-template-recursion-depth-warning',
		'language-converter-depth-warning',
		'node-count-exceeded-category',
		'node-count-exceeded-warning',
		'expansion-depth-exceeded-category',
		'expansion-depth-exceeded-warning',
		'parser-unstrip-loop-warning',
		'parser-unstrip-recursion-limit',
		'converter-manual-rule-error',
	),
	'undo' => array(
		'undo-success',
		'undo-failure',
		'undo-norev',
		'undo-summary',
	),
	'cantcreateaccount' => array(
		'cantcreateaccounttitle',
		'cantcreateaccount-text',
	),
	'history' => array(
		'viewpagelogs',
		'nohistory',
		'currentrev',
		'currentrev-asof',
		'revisionasof',
		'revision-info',
		'revision-info-current',
		'revision-nav',
		'previousrevision',
		'nextrevision',
		'currentrevisionlink',
		'cur',
		'next',
		'last',
		'page_first',
		'page_last',
		'histlegend',
		'history-fieldset-title',
		'history-show-deleted',
		'history_copyright',
		'histfirst',
		'histlast',
		'historysize',
		'historyempty',
	),
	'history-feed' => array(
		'history-feed-title',
		'history-feed-description',
		'history-feed-item-nocomment',
		'history-feed-empty',
	),
	'revdelete' => array(
		'rev-deleted-comment',
		'rev-deleted-user',
		'rev-deleted-event',
		'rev-deleted-user-contribs',
		'rev-deleted-text-permission',
		'rev-deleted-text-unhide',
		'rev-suppressed-text-unhide',
		'rev-deleted-text-view',
		'rev-suppressed-text-view',
		'rev-deleted-no-diff',
		'rev-suppressed-no-diff',
		'rev-deleted-unhide-diff',
		'rev-suppressed-unhide-diff',
		'rev-deleted-diff-view',
		'rev-suppressed-diff-view',
		'rev-delundel',
		'rev-showdeleted',
		'revisiondelete',
		'revdelete-nooldid-title',
		'revdelete-nooldid-text',
		'revdelete-nologtype-title',
		'revdelete-nologtype-text',
		'revdelete-nologid-title',
		'revdelete-nologid-text',
		'revdelete-no-file',
		'revdelete-show-file-confirm',
		'revdelete-show-file-submit',
		'revdelete-selected',
		'logdelete-selected',
		'revdelete-text',
		'revdelete-confirm',
		'revdelete-suppress-text',
		'revdelete-legend',
		'revdelete-hide-text',
		'revdelete-hide-image',
		'revdelete-hide-name',
		'revdelete-hide-comment',
		'revdelete-hide-user',
		'revdelete-hide-restricted',
		'revdelete-radio-same',
		'revdelete-radio-set',
		'revdelete-radio-unset',
		'revdelete-suppress',
		'revdelete-unsuppress',
		'revdelete-log',
		'revdelete-submit',
		'revdelete-success',
		'revdelete-failure',
		'logdelete-success',
		'logdelete-failure',
		'revdel-restore',
		'revdel-restore-deleted',
		'revdel-restore-visible',
		'pagehist',
		'deletedhist',
		'revdelete-hide-current',
		'revdelete-show-no-access',
		'revdelete-modify-no-access',
		'revdelete-modify-missing',
		'revdelete-no-change',
		'revdelete-concurrent-change',
		'revdelete-only-restricted',
		'revdelete-reason-dropdown',
		'revdelete-otherreason',
		'revdelete-reasonotherlist',
		'revdelete-edit-reasonlist',
		'revdelete-offender',
	),
	'suppression' => array(
		'suppressionlog',
		'suppressionlogtext',
	),
	'mergehistory' => array(
		'mergehistory',
		'mergehistory-header',
		'mergehistory-box',
		'mergehistory-from',
		'mergehistory-into',
		'mergehistory-list',
		'mergehistory-merge',
		'mergehistory-go',
		'mergehistory-submit',
		'mergehistory-empty',
		'mergehistory-success',
		'mergehistory-fail',
		'mergehistory-no-source',
		'mergehistory-no-destination',
		'mergehistory-invalid-source',
		'mergehistory-invalid-destination',
		'mergehistory-autocomment',
		'mergehistory-comment',
		'mergehistory-same-destination',
		'mergehistory-reason',
		'mergehistory-revisionrow'
	),
	'mergelog' => array(
		'mergelog',
		'pagemerge-logentry',
		'revertmerge',
		'mergelogpagetext',
	),
	'diffs' => array(
		'history-title',
		'difference-title',
		'difference-title-multipage',
		'difference-multipage',
		'lineno',
		'compareselectedversions',
		'showhideselectedversions',
		'editundo',
		'diff-multi',
		'diff-multi-manyusers',
		'difference-missing-revision',
	),
	'search' => array(
		'search-summary',
		'searchresults',
		'searchresults-title',
		'searchresulttext',
		'searchsubtitle',
		'searchsubtitleinvalid',
		'toomanymatches',
		'titlematches',
		'notitlematches',
		'textmatches',
		'notextmatches',
		'prevn',
		'nextn',
		'prevn-title',
		'nextn-title',
		'shown-title',
		'viewprevnext',
		'searchmenu-legend',
		'searchmenu-exists',
		'searchmenu-new',
		'searchmenu-new-nocreate',
		'searchhelp-url',
		'searchmenu-prefix',
		'searchmenu-help',
		'searchprofile-articles',
		'searchprofile-project',
		'searchprofile-images',
		'searchprofile-everything',
		'searchprofile-advanced',
		'searchprofile-articles-tooltip',
		'searchprofile-project-tooltip',
		'searchprofile-images-tooltip',
		'searchprofile-everything-tooltip',
		'searchprofile-advanced-tooltip',
		'search-result-size',
		'search-result-category-size',
		'search-result-score',
		'search-redirect',
		'search-section',
		'search-suggest',
		'search-interwiki-caption',
		'search-interwiki-default',
		'search-interwiki-custom',
		'search-interwiki-more',
		'search-relatedarticle',
		'mwsuggest-disable',
		'searcheverything-enable',
		'searchrelated',
		'searchall',
		'showingresults',
		'showingresultsnum',
		'showingresultsheader',
		'nonefound',
		'search-nonefound',
		'powersearch',
		'powersearch-legend',
		'powersearch-ns',
		'powersearch-redir',
		'powersearch-field',
		'powersearch-togglelabel',
		'powersearch-toggleall',
		'powersearch-togglenone',
		'search-external',
		'searchdisabled',
		'googlesearch',
	),
	'opensearch' => array(
		'opensearch-desc',
	),
	'quickbar' => array(
		'qbsettings',
		'qbsettings-none',
		'qbsettings-fixedleft',
		'qbsettings-fixedright',
		'qbsettings-floatingleft',
		'qbsettings-floatingright',
		'qbsettings-directionality',
	),
	'preferences' => array(
		'preferences',
		'preferences-summary',
		'mypreferences',
		'prefs-edits',
		'prefsnologin',
		'prefsnologintext',
		'changepassword',
		'changepassword-summary',
		'prefs-skin',
		'skin-preview',
		'datedefault',
		'prefs-beta',
		'prefs-datetime',
		'prefs-labs',
		'prefs-user-pages',
		'prefs-personal',
		'prefs-rc',
		'prefs-watchlist',
		'prefs-watchlist-days',
		'prefs-watchlist-days-max',
		'prefs-watchlist-edits',
		'prefs-watchlist-edits-max',
		'prefs-watchlist-token',
		'prefs-misc', // continue checking if used from here on (r49916)
		'prefs-resetpass',
		'prefs-changeemail',
		'prefs-setemail',
		'prefs-email',
		'prefs-rendering',
		'saveprefs',
		'resetprefs',
		'restoreprefs',
		'prefs-editing',
		'prefs-edit-boxsize',
		'rows',
		'columns',
		'searchresultshead',
		'resultsperpage',
		'stub-threshold',
		'stub-threshold-disabled',
		'recentchangesdays',
		'recentchangesdays-max',
		'recentchangescount',
		'prefs-help-recentchangescount',
		'prefs-help-watchlist-token',
		'savedprefs',
		'timezonelegend',
		'localtime',
		'timezoneuseserverdefault',
		'timezoneuseoffset',
		'timezoneoffset',
		'servertime',
		'guesstimezone',
		'timezoneregion-africa',
		'timezoneregion-america',
		'timezoneregion-antarctica',
		'timezoneregion-arctic',
		'timezoneregion-asia',
		'timezoneregion-atlantic',
		'timezoneregion-australia',
		'timezoneregion-europe',
		'timezoneregion-indian',
		'timezoneregion-pacific',
		'allowemail',
		'prefs-searchoptions',
		'prefs-namespaces',
		'defaultns',
		'default',
		'defaultns',
		'prefs-files',
		'prefs-custom-css',
		'prefs-custom-js',
		'prefs-common-css-js',
		'prefs-reset-intro',
		'prefs-emailconfirm-label',
		'prefs-textboxsize',
		'youremail',
		'username',
		'uid',
		'prefs-memberingroups',
		'prefs-memberingroups-type',
		'prefs-registration',
		'prefs-registration-date-time',
		'yourrealname',
		'yourlanguage',
		'yourvariant',
		'prefs-help-variant',
		'yournick',
		'prefs-help-signature',
		'badsig',
		'badsiglength',
		'yourgender',
		'gender-unknown',
		'gender-male',
		'gender-female',
		'prefs-help-gender',
		'email',
		'prefs-help-realname',

		# 3 messages depending upon $wgEmailConfirmToEdit and $wgEnableUserEmail
		'prefs-help-email',
		'prefs-help-email-others',
		'prefs-help-email-required',

		'prefs-info',
		'prefs-i18n',
		'prefs-signature',
		'prefs-dateformat',
		'prefs-timeoffset',
		'prefs-advancedediting',
		'prefs-advancedrc',
		'prefs-advancedrendering',
		'prefs-advancedsearchoptions',
		'prefs-advancedwatchlist',
		'prefs-displayrc',
		'prefs-displaysearchoptions',
		'prefs-displaywatchlist',
		'prefs-diffs',
	),
	'preferences-email' => array(
		'email-address-validity-valid',
		'email-address-validity-invalid',
	),
	'userrights' => array(
		'userrights',
		'userrights-summary',
		'userrights-lookup-user',
		'userrights-user-editname',
		'editusergroup',
		'editinguser',
		'userrights-editusergroup',
		'saveusergroups',
		'userrights-groupsmember',
		'userrights-groupsmember-auto',
		'userrights-groupsmember-type',
		'userrights-groups-help',
		'userrights-reason',
		'userrights-no-interwiki',
		'userrights-nodatabase',
		'userrights-nologin',
		'userrights-notallowed',
		'userrights-changeable-col',
		'userrights-unchangeable-col',
		'userrights-irreversible-marker',
	),
	'group' => array(
		'group',
		'group-user',
		'group-autoconfirmed',
		'group-bot',
		'group-sysop',
		'group-bureaucrat',
		'group-suppress',
		'group-all',
	),
	'group-member' => array(
		'group-user-member',
		'group-autoconfirmed-member',
		'group-bot-member',
		'group-sysop-member',
		'group-bureaucrat-member',
		'group-suppress-member',
	),
	'grouppage' => array(
		'grouppage-user',
		'grouppage-autoconfirmed',
		'grouppage-bot',
		'grouppage-sysop',
		'grouppage-bureaucrat',
		'grouppage-suppress',
	),
	'right' => array(
		'right-read',
		'right-edit',
		'right-createpage',
		'right-createtalk',
		'right-createaccount',
		'right-minoredit',
		'right-move',
		'right-move-subpages',
		'right-move-rootuserpages',
		'right-movefile',
		'right-suppressredirect',
		'right-upload',
		'right-reupload',
		'right-reupload-own',
		'right-reupload-shared',
		'right-upload_by_url',
		'right-purge',
		'right-autoconfirmed',
		'right-bot',
		'right-nominornewtalk',
		'right-apihighlimits',
		'right-writeapi',
		'right-delete',
		'right-bigdelete',
		'right-deletelogentry',
		'right-deleterevision',
		'right-deletedhistory',
		'right-deletedtext',
		'right-browsearchive',
		'right-undelete',
		'right-suppressrevision',
		'right-suppressionlog',
		'right-block',
		'right-blockemail',
		'right-hideuser',
		'right-ipblock-exempt',
		'right-proxyunbannable',
		'right-unblockself',
		'right-protect',
		'right-editprotected',
		'right-editinterface',
		'right-editusercssjs',
		'right-editusercss',
		'right-edituserjs',
		'right-rollback',
		'right-markbotedits',
		'right-noratelimit',
		'right-import',
		'right-importupload',
		'right-patrol',
		'right-autopatrol',
		'right-patrolmarks',
		'right-unwatchedpages',
		'right-mergehistory',
		'right-userrights',
		'right-userrights-interwiki',
		'right-siteadmin',
		'right-override-export-depth',
		'right-sendemail',
		'right-passwordreset',
	),
	'newuserlog' => array(
		'newuserlogpage',
		'newuserlogpagetext',
	),
	'rightslog' => array(
		'rightslog',
		'rightslogtext',
	),
	'action' => array(
		'action-read',
		'action-edit',
		'action-createpage',
		'action-createtalk',
		'action-createaccount',
		'action-minoredit',
		'action-move',
		'action-move-subpages',
		'action-move-rootuserpages',
		'action-movefile',
		'action-upload',
		'action-reupload',
		'action-reupload-shared',
		'action-upload_by_url',
		'action-writeapi',
		'action-delete',
		'action-deleterevision',
		'action-deletedhistory',
		'action-browsearchive',
		'action-undelete',
		'action-suppressrevision',
		'action-suppressionlog',
		'action-block',
		'action-protect',
		'action-rollback',
		'action-import',
		'action-importupload',
		'action-patrol',
		'action-autopatrol',
		'action-unwatchedpages',
		'action-mergehistory',
		'action-userrights',
		'action-userrights-interwiki',
		'action-siteadmin',
		'action-sendemail',
	),
	'recentchanges' => array(
		'nchanges',
		'recentchanges',
		'recentchanges-url',
		'recentchanges-legend',
		'recentchanges-summary',
		'recentchangestext',
		'recentchanges-feed-description',
		'recentchanges-label-newpage',
		'recentchanges-label-minor',
		'recentchanges-label-bot',
		'recentchanges-label-unpatrolled',
		'rcnote',
		'rcnotefrom',
		'rclistfrom',
		'rcshowhideminor',
		'rcshowhidebots',
		'rcshowhideliu',
		'rcshowhideanons',
		'rcshowhidepatr',
		'rcshowhidemine',
		'rclinks',
		'diff',
		'hist',
		'hide',
		'show',
		'minoreditletter',
		'newpageletter',
		'boteditletter',
		'unpatrolledletter',
		'number_of_watching_users_RCview',
		'number_of_watching_users_pageview',
		'rc_categories',
		'rc_categories_any',
		'rc-change-size',
		'rc-change-size-new',
		'newsectionsummary',
		'rc-enhanced-expand',
		'rc-enhanced-hide',
		'rc-old-title',
	),
	'recentchangeslinked' => array(
		'recentchangeslinked',
		'recentchangeslinked-feed',
		'recentchangeslinked-toolbox',
		'recentchangeslinked-title',
		'recentchangeslinked-noresult',
		'recentchangeslinked-summary',
		'recentchangeslinked-page',
		'recentchangeslinked-to',
	),
	'upload' => array(
		'upload',
		'uploadbtn',
		'reuploaddesc',
		'upload-tryagain',
		'uploadnologin',
		'uploadnologintext',
		'upload_directory_missing',
		'upload_directory_read_only',
		'uploaderror',
		'upload-summary',
		'upload-recreate-warning',
		'uploadtext',
		'upload-permitted',
		'upload-preferred',
		'upload-prohibited',
		'uploadfooter',
		'uploadlog',
		'uploadlogpage',
		'uploadlogpagetext',
		'filename',
		'filedesc',
		'fileuploadsummary',
		'filereuploadsummary',
		'filestatus',
		'filesource',
		'uploadedfiles',
		'ignorewarning',
		'ignorewarnings',
		'minlength1',
		'illegalfilename',
		'filename-toolong',
		'badfilename',
		'filetype-mime-mismatch',
		'filetype-badmime',
		'filetype-bad-ie-mime',
		'filetype-unwanted-type',
		'filetype-banned-type',
		'filetype-missing',
		'empty-file',
		'file-too-large',
		'filename-tooshort',
		'filetype-banned',
		'verification-error',
		'hookaborted',
		'illegal-filename',
		'overwrite',
		'unknown-error',
		'tmp-create-error',
		'tmp-write-error',
		'large-file',
		'largefileserver',
		'emptyfile',
		'windows-nonascii-filename',
		'fileexists',
		'filepageexists',
		'fileexists-extension',
		'fileexists-thumbnail-yes',
		'file-thumbnail-no',
		'fileexists-forbidden',
		'fileexists-shared-forbidden',
		'file-exists-duplicate',
		'file-deleted-duplicate',
		'uploadwarning',
		'uploadwarning-text',
		'savefile',
		'uploadedimage',
		'overwroteimage',
		'uploaddisabled',
		'copyuploaddisabled',
		'uploadfromurl-queued',
		'uploaddisabledtext',
		'php-uploaddisabledtext',
		'uploadscripted',
		'uploadvirus',
		'uploadjava',
		'upload-source',
		'sourcefilename',
		'sourceurl',
		'destfilename',
		'upload-maxfilesize',
		'upload-description',
		'upload-options',
		'watchthisupload',
		'filewasdeleted',
		'filename-bad-prefix',
		'filename-prefix-blacklist',
		'upload-success-subj',
		'upload-success-msg',
		'upload-failure-subj',
		'upload-failure-msg',
		'upload-warning-subj',
		'upload-warning-msg',
	),
	'upload-errors' => array(
		'upload-proto-error',
		'upload-proto-error-text',
		'upload-file-error',
		'upload-file-error-text',
		'upload-misc-error',
		'upload-misc-error-text',
		'upload-too-many-redirects',
		'upload-unknown-size',
		'upload-http-error',
		'upload-copy-upload-invalid-domain',
	),

	'filebackend-errors' => array(
		'backend-fail-stream',
		'backend-fail-backup',
		'backend-fail-notexists',
		'backend-fail-hashes',
		'backend-fail-notsame',
		'backend-fail-invalidpath',
		'backend-fail-delete',
		'backend-fail-describe',
		'backend-fail-alreadyexists',
		'backend-fail-store',
		'backend-fail-copy',
		'backend-fail-move',
		'backend-fail-opentemp',
		'backend-fail-writetemp',
		'backend-fail-closetemp',
		'backend-fail-read',
		'backend-fail-create',
		'backend-fail-maxsize',
		'backend-fail-readonly',
		'backend-fail-synced',
		'backend-fail-connect',
		'backend-fail-internal',
		'backend-fail-contenttype',
		'backend-fail-batchsize',
		'backend-fail-usable'
	),

	'filejournal-errors' => array(
		'filejournal-fail-dbconnect',
		'filejournal-fail-dbquery'
	),

	'lockmanager-errors' => array(
		'lockmanager-notlocked',
		'lockmanager-fail-closelock',
		'lockmanager-fail-deletelock',
		'lockmanager-fail-acquirelock',
		'lockmanager-fail-openlock',
		'lockmanager-fail-acquirelock',
		'lockmanager-fail-releaselock',
		'lockmanager-fail-db-bucket',
		'lockmanager-fail-db-release',
		'lockmanager-fail-svr-acquire',
		'lockmanager-fail-svr-release'
	),

	'zip' => array(
		'zip-file-open-error',
		'zip-wrong-format',
		'zip-bad',
		'zip-unsupported'
	),

	'uploadstash' => array(
		'uploadstash',
		'uploadstash-summary',
		'uploadstash-clear',
		'uploadstash-nofiles',
		'uploadstash-badtoken',
		'uploadstash-errclear',
		'uploadstash-refresh',
		'invalid-chunk-offset',
	),

	'img-auth' => array(
		'img-auth-accessdenied',
		'img-auth-desc',
		'img-auth-nopathinfo',
		'img-auth-notindir',
		'img-auth-badtitle',
		'img-auth-nologinnWL',
		'img-auth-nofile',
		'img-auth-isdir',
		'img-auth-streaming',
		'img-auth-public',
		'img-auth-noread',
		'img-auth-bad-query-string',
	),

	'http-errors' => array(
		'http-invalid-url',
		'http-invalid-scheme',
		'http-request-error',
		'http-read-error',
		'http-timed-out',
		'http-curl-error',
		'http-host-unreachable',
		'http-bad-status',
	),

	'upload-curl-errors' => array(
		'upload-curl-error6',
		'upload-curl-error6-text',
		'upload-curl-error28',
		'upload-curl-error28-text',
	),
	'licenses' => array(
		'license',
		'license-header',
		'nolicense',
		'licenses',
		'license-nopreview',
		'upload_source_url',
		'upload_source_file',
	),
	'filelist' => array(
		'listfiles-summary',
		'listfiles_search_for',
		'imgfile',
		'listfiles',
		'listfiles_thumb',
		'listfiles_date',
		'listfiles_name',
		'listfiles_user',
		'listfiles_size',
		'listfiles_description',
		'listfiles_count',
	),
	'filedescription' => array(
		'file-anchor-link',
		'filehist',
		'filehist-help',
		'filehist-deleteall',
		'filehist-deleteone',
		'filehist-revert',
		'filehist-current',
		'filehist-datetime',
		'filehist-thumb',
		'filehist-thumbtext',
		'filehist-nothumb',
		'filehist-user',
		'filehist-dimensions',
		'filehist-filesize',
		'filehist-comment',
		'filehist-missing',
		'imagelinks',
		'linkstoimage',
		'linkstoimage-more',
		'nolinkstoimage',
		'morelinkstoimage',
		'linkstoimage-redirect',
		'duplicatesoffile',
		'sharedupload',
		'sharedupload-desc-there',
		'sharedupload-desc-here',
		'sharedupload-desc-edit',
		'sharedupload-desc-create',
		'shareddescriptionfollows',
		'filepage-nofile',
		'filepage-nofile-link',
		'uploadnewversion-linktext',
		'shared-repo-from',
		'shared-repo',
		'shared-repo-name-wikimediacommons',
		'filepage.css',
		'upload-disallowed-here',
	),
	'filerevert' => array(
		'filerevert',
		'filerevert-legend',
		'filerevert-intro',
		'filerevert-comment',
		'filerevert-defaultcomment',
		'filerevert-submit',
		'filerevert-success',
		'filerevert-badversion',
	),
	'filedelete' => array(
		'filedelete',
		'filedelete-legend',
		'filedelete-intro',
		'filedelete-intro-old',
		'filedelete-comment',
		'filedelete-submit',
		'filedelete-success',
		'filedelete-success-old',
		'filedelete-nofile',
		'filedelete-nofile-old',
		'filedelete-otherreason',
		'filedelete-reason-otherlist',
		'filedelete-reason-dropdown',
		'filedelete-edit-reasonlist',
		'filedelete-maintenance',
		'filedelete-maintenance-title',
	),
	'mimesearch' => array(
		'mimesearch',
		'mimesearch-summary',
		'mimetype',
		'download',
	),
	'unwatchedpages' => array(
		'unwatchedpages',
		'unwatchedpages-summary',
	),
	'listredirects' => array(
		'listredirects',
		'listredirects-summary',
	),
	'unusedtemplates' => array(
		'unusedtemplates',
		'unusedtemplates-summary',
		'unusedtemplatestext',
		'unusedtemplateswlh',
	),
	'randompage' => array(
		'randompage',
		'randompage-nopages',
		'randompage-url',
	),
	'randomredirect' => array(
		'randomredirect',
		'randomredirect-nopages',
	),
	'statistics' => array(
		'statistics',
		'statistics-summary',
		'statistics-header-pages',
		'statistics-header-edits',
		'statistics-header-views',
		'statistics-header-users',
		'statistics-header-hooks',
		'statistics-articles',
		'statistics-pages',
		'statistics-pages-desc',
		'statistics-files',
		'statistics-edits',
		'statistics-edits-average',
		'statistics-views-total',
		'statistics-views-total-desc',
		'statistics-views-peredit',
		'statistics-users',
		'statistics-users-active',
		'statistics-users-active-desc',
		'statistics-mostpopular',
		'statistics-footer',
	),
	'disambiguations' => array(
		'disambiguations',
		'disambiguations-summary',
		'disambiguationspage',
		'disambiguations-text',
	),
	'pageswithprop' => array(
		'pageswithprop',
		'pageswithprop-summary',
		'pageswithprop-legend',
		'pageswithprop-text',
		'pageswithprop-prop',
		'pageswithprop-submit',
	),
	'doubleredirects' => array(
		'doubleredirects',
		'doubleredirects-summary',
		'doubleredirectstext',
		'double-redirect-fixed-move',
		'double-redirect-fixed-maintenance',
		'double-redirect-fixer',
	),
	'brokenredirects' => array(
		'brokenredirects',
		'brokenredirects-summary',
		'brokenredirectstext',
		'brokenredirects-edit',
		'brokenredirects-delete',
	),
	'withoutinterwiki' => array(
		'withoutinterwiki',
		'withoutinterwiki-summary',
		'withoutinterwiki-legend',
		'withoutinterwiki-submit',
	),
	'fewestrevisions' => array(
		'fewestrevisions',
		'fewestrevisions-summary',
	),
	'specialpages' => array(
		'nbytes',
		'ncategories',
		'ninterwikis',
		'nlinks',
		'nmembers',
		'nrevisions',
		'nviews',
		'nchanges',
		'nimagelinks',
		'ntransclusions',
		'specialpage-empty',
		'lonelypages',
		'lonelypages-summary',
		'lonelypagestext',
		'uncategorizedpages',
		'uncategorizedpages-summary',
		'uncategorizedcategories',
		'uncategorizedcategories-summary',
		'uncategorizedimages',
		'uncategorizedimages-summary',
		'uncategorizedtemplates',
		'uncategorizedtemplates-summary',
		'unusedcategories',
		'unusedcategories-summary',
		'unusedimages',
		'unusedimages-summary',
		'popularpages',
		'popularpages-summary',
		'wantedcategories',
		'wantedcategories-summary',
		'wantedpages',
		'wantedpages-summary',
		'wantedpages-badtitle',
		'wantedfiles',
		'wantedfiles-summary',
		'wantedfiletext-cat',
		'wantedfiletext-nocat',
		'wantedtemplates',
		'wantedtemplates-summary',
		'mostlinked',
		'mostlinked-summary',
		'mostlinkedcategories',
		'mostlinkedcategories-summary',
		'mostlinkedtemplates',
		'mostlinkedtemplates-summary',
		'mostcategories',
		'mostcategories-summary',
		'mostimages',
		'mostimages-summary',
		'mostinterwikis',
		'mostinterwikis-summary',
		'mostrevisions',
		'mostrevisions-summary',
		'prefixindex',
		'prefixindex-namespace',
		'prefixindex-summary',
		'shortpages',
		'shortpages-summary',
		'longpages',
		'longpages-summary',
		'deadendpages',
		'deadendpages-summary',
		'deadendpagestext',
		'protectedpages',
		'protectedpages-indef',
		'protectedpages-summary',
		'protectedpages-cascade',
		'protectedpagestext',
		'protectedpagesempty',
		'protectedtitles',
		'protectedtitles-summary',
		'protectedtitlestext',
		'protectedtitlesempty',
		'listusers',
		'listusers-summary',
		'listusers-editsonly',
		'listusers-creationsort',
		'usereditcount',
		'usercreated',
		'newpages',
		'newpages-summary',
		'newpages-username',
		'ancientpages',
		'ancientpages-summary',
		'move',
		'movethispage',
		'unusedimagestext',
		'unusedcategoriestext',
		'notargettitle',
		'notargettext',
		'nopagetitle',
		'nopagetext',
		'pager-newer-n',
		'pager-older-n',
		'suppress',
		'querypage-disabled',
	),
	'booksources' => array(
		'booksources',
		'booksources-summary',
		'booksources-search-legend',
		'booksources-isbn',
		'booksources-go',
		'booksources-text',
		'booksources-invalid-isbn',
	),
	'magicwords' => array(
		'rfcurl',
		'pubmedurl',
	),
	'logpages' => array(
		'specialloguserlabel',
		'speciallogtitlelabel',
		'log',
		'all-logs-page',
		'alllogstext',
		'logempty',
		'log-title-wildcard',
		'showhideselectedlogentries',
	),
	'allpages' => array(
		'allpages',
		'allpages-summary',
		'alphaindexline',
		'nextpage',
		'prevpage',
		'allpagesfrom',
		'allpagesto',
		'allarticles',
		'allinnamespace',
		'allnotinnamespace',
		'allpagesprev',
		'allpagesnext',
		'allpagessubmit',
		'allpagesprefix',
		'allpagesbadtitle',
		'allpages-bad-ns',
		'allpages-hide-redirects',
	),
	'cachedspecial' => array(
		'cachedspecial-viewing-cached-ttl',
		'cachedspecial-viewing-cached-ts',
		'cachedspecial-refresh-now',
	),
	'categories' => array(
		'categories',
		'categories-summary',
		'categoriespagetext',
		'categoriesfrom',
		'special-categories-sort-count',
		'special-categories-sort-abc',
	),
	'deletedcontribs' => array(
		'deletedcontributions',
		'deletedcontributions-summary',
		'deletedcontributions-title',
		'sp-deletedcontributions-contribs',
	),
	'linksearch' => array(
		'linksearch',
		'linksearch-summary',
		'linksearch-pat',
		'linksearch-ns',
		'linksearch-ok',
		'linksearch-text',
		'linksearch-line',
		'linksearch-error',
	),
	'listusers' => array(
		'listusersfrom',
		'listusers-submit',
		'listusers-noresult',
		'listusers-blocked',
	),
	'activeusers' => array(
		'activeusers',
		'activeusers-summary',
		'activeusers-intro',
		'activeusers-count',
		'activeusers-from',
		'activeusers-hidebots',
		'activeusers-hidesysops',
		'activeusers-submit',
		'activeusers-noresult',
	),
	'listgrouprights' => array(
		'listgrouprights',
		'listgrouprights-summary',
		'listgrouprights-key',
		'listgrouprights-group',
		'listgrouprights-rights',
		'listgrouprights-helppage',
		'listgrouprights-members',
		'listgrouprights-right-display',
		'listgrouprights-right-revoked',
		'listgrouprights-addgroup',
		'listgrouprights-removegroup',
		'listgrouprights-addgroup-all',
		'listgrouprights-removegroup-all',
		'listgrouprights-addgroup-self',
		'listgrouprights-removegroup-self',
		'listgrouprights-addgroup-self-all',
		'listgrouprights-removegroup-self-all',

	),
	'emailuser' => array(
		'mailnologin',
		'mailnologintext',
		'emailuser',
		'emailuser-title-target',
		'emailuser-title-notarget',
		'emailuser-summary',
		'emailpage',
		'emailpagetext',
		'usermailererror',
		'defemailsubject',
		'usermaildisabled',
		'usermaildisabledtext',
		'noemailtitle',
		'noemailtext',
		'nowikiemailtitle',
		'nowikiemailtext',
		'emailnotarget',
		'emailtarget',
		'emailusername',
		'emailusernamesubmit',
		'email-legend',
		'emailfrom',
		'emailto',
		'emailsubject',
		'emailmessage',
		'emailsend',
		'emailccme',
		'emailccsubject',
		'emailsent',
		'emailsenttext',
		'emailuserfooter',
	),
	'usermessage' => array(
		'usermessage-summary',
		'usermessage-editor',
		'usermessage-template',
	),
	'watchlist' => array(
		'watchlist',
		'watchlist-summary',
		'mywatchlist',
		'watchlistfor2',
		'nowatchlist',
		'watchlistanontext',
		'watchnologin',
		'watchnologintext',
		'addwatch',
		'addedwatchtext',
		'removewatch',
		'removedwatchtext',
		'watch',
		'watchthispage',
		'unwatch',
		'unwatchthispage',
		'notanarticle',
		'notvisiblerev',
		'watchnochange',
		'watchlist-details',
		'wlheader-enotif',
		'wlheader-showupdated',
		'watchmethod-recent',
		'watchmethod-list',
		'watchlistcontains',
		'iteminvalidname',
		'wlnote',
		'wlshowlast',
		'watchlist-options',
	),
	'watching' => array(
		'watching',
		'unwatching',
		'watcherrortext',
	),
	'enotif' => array(
		'enotif_mailer',
		'enotif_reset',
		'enotif_impersonal_salutation',
		'enotif_subject_deleted',
		'enotif_subject_created',
		'enotif_subject_moved',
		'enotif_subject_restored',
		'enotif_subject_changed',
		'enotif_body_intro_deleted',
		'enotif_body_intro_created',
		'enotif_body_intro_moved',
		'enotif_body_intro_restored',
		'enotif_body_intro_changed',
		'enotif_lastvisited',
		'enotif_lastdiff',
		'enotif_anon_editor',
		'enotif_body',
		'created',
		'changed',
	),
	'delete' => array(
		'deletepage',
		'confirm',
		'excontent',
		'excontentauthor',
		'exbeforeblank',
		'exblank',
		'delete-confirm',
		'delete-legend',
		'historywarning',
		'confirmdeletetext',
		'actioncomplete',
		'actionfailed',
		'deletedtext',
		'dellogpage',
		'dellogpagetext',
		'deletionlog',
		'reverted',
		'deletecomment',
		'deleteotherreason',
		'deletereasonotherlist',
		'deletereason-dropdown',
		'delete-edit-reasonlist',
		'delete-toobig',
		'delete-warning-toobig',
	),
	'rollback' => array(
		'rollback',
		'rollback_short',
		'rollbacklink',
		'rollbacklinkcount',
		'rollbacklinkcount-morethan',
		'rollbackfailed',
		'cantrollback',
		'alreadyrolled',
		'editcomment',
		'revertpage',
		'revertpage-nouser',
		'rollback-success',
	),
	'edittokens' => array(
		'sessionfailure-title',
		'sessionfailure',
	),
	'protect' => array(
		'protectlogpage',
		'protectlogtext',
		'protectedarticle',
		'modifiedarticleprotection',
		'unprotectedarticle',
		'movedarticleprotection',
		'protect-title',
		'protect-title-notallowed',
		'prot_1movedto2',
		'protect-badnamespace-title',
		'protect-badnamespace-text',
		'protect-norestrictiontypes-text',
		'protect-norestrictiontypes-title',
		'protect-legend',
		'protectcomment',
		'protectexpiry',
		'protect_expiry_invalid',
		'protect_expiry_old',
		'protect-unchain-permissions',
		'protect-text',
		'protect-locked-blocked',
		'protect-locked-dblock',
		'protect-locked-access',
		'protect-cascadeon',
		'protect-default',
		'protect-fallback',
		'protect-level-autoconfirmed',
		'protect-level-sysop',
		'protect-summary-desc',
		'protect-summary-cascade',
		'protect-expiring',
		'protect-expiring-local',
		'protect-expiry-indefinite',
		'protect-cascade',
		'protect-cantedit',
		'protect-othertime',
		'protect-othertime-op',
		'protect-existing-expiry',
		'protect-otherreason',
		'protect-otherreason-op',
		'protect-dropdown',
		'protect-edit-reasonlist',
		'protect-expiry-options',
		'restriction-type',
		'restriction-level',
		'minimum-size',
		'maximum-size',
		'pagesize',
	),
	'restrictions' => array(
		'restriction-edit',
		'restriction-move',
		'restriction-create',
		'restriction-upload',
	),
	'restriction-levels' => array(
		'restriction-level-sysop',
		'restriction-level-autoconfirmed',
		'restriction-level-all',
	),
	'undelete' => array(
		'undelete',
		'undelete-summary',
		'undeletepage',
		'undeletepagetitle',
		'viewdeletedpage',
		'undeletepagetext',
		'undelete-fieldset-title',
		'undeleteextrahelp',
		'undeleterevisions',
		'undeletehistory',
		'undeleterevdel',
		'undeletehistorynoadmin',
		'undelete-revision',
		'undeleterevision-missing',
		'undelete-nodiff',
		'undeletebtn',
		'undeletelink',
		'undeleteviewlink',
		'undeletereset',
		'undeleteinvert',
		'undeletecomment',
		'undeletedrevisions',
		'undeletedrevisions-files',
		'undeletedfiles',
		'cannotundelete',
		'undeletedpage',
		'undelete-header',
		'undelete-search-title',
		'undelete-search-box',
		'undelete-search-prefix',
		'undelete-search-submit',
		'undelete-no-results',
		'undelete-filename-mismatch',
		'undelete-bad-store-key',
		'undelete-cleanup-error',
		'undelete-missing-filearchive',
		'undelete-error',
		'undelete-error-short',
		'undelete-error-long',
		'undelete-show-file-confirm',
		'undelete-show-file-submit',
		'undelete-revisionrow',
	),
	'nsform' => array(
		'namespace',
		'invert',
		'tooltip-invert',
		'namespace_association',
		'tooltip-namespace_association',
		'blanknamespace',
	),
	'contributions' => array(
		'contributions',
		'contributions-summary',
		'contributions-title',
		'mycontris',
		'contribsub2',
		'nocontribs',
		'uctop',
		'month',
		'year',
	),
	'sp-contributions' => array(
		'sp-contributions-newbies',
		'sp-contributions-newbies-sub',
		'sp-contributions-newbies-title',
		'sp-contributions-blocklog',
		'sp-contributions-deleted',
		'sp-contributions-uploads',
		'sp-contributions-logs',
		'sp-contributions-talk',
		'sp-contributions-userrights',
		'sp-contributions-blocked-notice',
		'sp-contributions-blocked-notice-anon',
		'sp-contributions-search',
		'sp-contributions-username',
		'sp-contributions-toponly',
		'sp-contributions-submit',
		'sp-contributions-explain',
		'sp-contributions-footer',
		'sp-contributions-footer-anon',
		'sp-contributions-footer-newbies',
	),
	'whatlinkshere' => array(
		'whatlinkshere',
		'whatlinkshere-title',
		'whatlinkshere-summary',
		'whatlinkshere-page',
		'linkshere',
		'nolinkshere',
		'nolinkshere-ns',
		'isredirect',
		'istemplate',
		'isimage',
		'whatlinkshere-prev',
		'whatlinkshere-next',
		'whatlinkshere-links',
		'whatlinkshere-hideredirs',
		'whatlinkshere-hidetrans',
		'whatlinkshere-hidelinks',
		'whatlinkshere-hideimages',
		'whatlinkshere-filters',
	),
	'block' => array(
		'autoblockid',
		'block',
		'unblock',
		'unblock-summary',
		'blockip',
		'blockip-title',
		'blockip-legend',
		'blockiptext',
		'ipadressorusername',
		'ipbexpiry',
		'ipbreason',
		'ipbreasonotherlist',
		'ipbreason-dropdown',
		'ipb-hardblock',
		'ipbcreateaccount',
		'ipbemailban',
		'ipbenableautoblock',
		'ipbsubmit',
		'ipbother',
		'ipboptions',
		'ipbotheroption',
		'ipbotherreason',
		'ipbhidename',
		'ipbwatchuser',
		'ipb-disableusertalk',
		'ipb-change-block',
		'ipb-confirm',
		'badipaddress',
		'blockipsuccesssub',
		'blockipsuccesstext',
		'ipb-blockingself',
		'ipb-confirmhideuser',
		'ipb-edit-dropdown',
		'ipb-unblock-addr',
		'ipb-unblock',
		'ipb-blocklist',
		'ipb-blocklist-contribs',
		'unblockip',
		'unblockiptext',
		'ipusubmit',
		'unblocked',
		'unblocked-range',
		'unblocked-id',
		'blocklist',
		'ipblocklist',
		'ipblocklist-legend',
		'blocklist-userblocks',
		'blocklist-tempblocks',
		'blocklist-addressblocks',
		'blocklist-rangeblocks',
		'blocklist-timestamp',
		'blocklist-target',
		'blocklist-expiry',
		'blocklist-by',
		'blocklist-params',
		'blocklist-reason',
		'blocklist-summary',
		'ipblocklist-submit',
		'ipblocklist-localblock',
		'ipblocklist-otherblocks',

		'infiniteblock',
		'expiringblock',
		'anononlyblock',
		'noautoblockblock',
		'createaccountblock',
		'emailblock',
		'blocklist-nousertalk',
		'ipblocklist-empty',
		'ipblocklist-no-results',
		'blocklink',
		'unblocklink',
		'change-blocklink',
		'contribslink',
		'emaillink',
		'autoblocker',
		'blocklogpage',
		'blocklog-showlog',
		'blocklog-showsuppresslog',
		'blocklogentry',
		'reblock-logentry',
		'blocklogtext',
		'unblocklogentry',
		'block-log-flags-anononly',
		'block-log-flags-nocreate',
		'block-log-flags-noautoblock',
		'block-log-flags-noemail',
		'block-log-flags-nousertalk',
		'block-log-flags-angry-autoblock',
		'block-log-flags-hiddenname',
		'range_block_disabled',
		'ipb_expiry_invalid',
		'ipb_expiry_temp',
		'ipb_hide_invalid',
		'ipb_already_blocked',
		'ipb-needreblock',
		'ipb-otherblocks-header',
		'unblock-hideuser',
		'ipb_cant_unblock',
		'ipb_blocked_as_range',
		'ip_range_invalid',
		'ip_range_toolarge',
		'blockme',
		'proxyblocker',
		'proxyblocker-disabled',
		'proxyblockreason',
		'proxyblocksuccess',
		'sorbs',
		'sorbsreason',
		'sorbs_create_account_reason',
		'cant-block-while-blocked',
		'cant-see-hidden-user',
		'ipbblocked',
		'ipbnounblockself',
		'ipb-default-expiry',
	),
	'developertools' => array(
		'lockdb',
		'unlockdb',
		'lockdbtext',
		'unlockdbtext',
		'lockconfirm',
		'unlockconfirm',
		'lockbtn',
		'unlockbtn',
		'locknoconfirm',
		'lockdbsuccesssub',
		'unlockdbsuccesssub',
		'lockdbsuccesstext',
		'unlockdbsuccesstext',
		'lockfilenotwritable',
		'databasenotlocked',
		'lockedbyandtime',
	),
	'movepage' => array(
		'move-page',
		'movepage-summary',
		'move-page-legend',
		'movepagetext',
		'movepagetext-noredirectfixer',
		'movepagetalktext',
		'movearticle',
		'moveuserpage-warning',
		'movenologin',
		'movenologintext',
		'movenotallowed',
		'movenotallowedfile',
		'cant-move-user-page',
		'cant-move-to-user-page',
		'newtitle',
		'move-watch',
		'movepagebtn',
		'pagemovedsub',
		'movepage-moved',
		'movepage-moved-redirect',
		'movepage-moved-noredirect',
		'articleexists',
		'cantmove-titleprotected',
		'talkexists',
		'movedto',
		'movetalk',
		'move-subpages',
		'move-talk-subpages',
		'movepage-page-exists',
		'movepage-page-moved',
		'movepage-page-unmoved',
		'movepage-max-pages',
		'movelogpage',
		'movelogpagetext',
		'movesubpage',
		'movesubpagetext',
		'movenosubpage',
		'movereason',
		'revertmove',
		'delete_and_move',
		'delete_and_move_text',
		'delete_and_move_confirm',
		'delete_and_move_reason',
		'selfmove',
		'immobile-source-namespace',
		'immobile-target-namespace',
		'immobile-target-namespace-iw',
		'immobile-source-page',
		'immobile-target-page',
		'bad-target-model',
		'immobile_namespace',
		'imagenocrossnamespace',
		'nonfile-cannot-move-to-file',
		'imagetypemismatch',
		'imageinvalidfilename',
		'fix-double-redirects',
		'move-leave-redirect',
		'protectedpagemovewarning',
		'semiprotectedpagemovewarning',
		'move-over-sharedrepo',
		'file-exists-sharedrepo',
	),
	'export' => array(
		'export',
		'export-summary',
		'exporttext',
		'exportall',
		'exportcuronly',
		'exportnohistory',
		'exportlistauthors',
		'export-submit',
		'export-addcattext',
		'export-addcat',
		'export-addnstext',
		'export-addns',
		'export-download',
		'export-templates',
		'export-pagelinks',
	),
	'allmessages' => array(
		'allmessages',
		'allmessagesname',
		'allmessagesdefault',
		'allmessagescurrent',
		'allmessagestext',
		'allmessagesnotsupportedDB',
		'allmessages-filter-legend',
		'allmessages-filter',
		'allmessages-filter-unmodified',
		'allmessages-filter-all',
		'allmessages-filter-modified',
		'allmessages-prefix',
		'allmessages-language',
		'allmessages-filter-submit',
	),
	'thumbnails' => array(
		'thumbnail-more',
		'filemissing',
		'thumbnail_error',
		'djvu_page_error',
		'djvu_no_xml',
		'thumbnail-temp-create',
		'thumbnail-dest-create',
		'thumbnail_invalid_params',
		'thumbnail_dest_directory',
		'thumbnail_image-type',
		'thumbnail_gd-library',
		'thumbnail_image-missing',
	),
	'import' => array(
		'import',
		'import-summary',
		'importinterwiki',
		'import-interwiki-text',
		'import-interwiki-source',
		'import-interwiki-history',
		'import-interwiki-templates',
		'import-interwiki-submit',
		'import-interwiki-namespace',
		'import-interwiki-rootpage',
		'import-upload-filename',
		'import-comment',
		'importtext',
		'importstart',
		'import-revision-count',
		'importnopages',
		'imported-log-entries',
		'importfailed',
		'importunknownsource',
		'importcantopen',
		'importbadinterwiki',
		'importnotext',
		'importsuccess',
		'importhistoryconflict',
		'importnosources',
		'importnofile',
		'importuploaderrorsize',
		'importuploaderrorpartial',
		'importuploaderrortemp',
		'import-parse-failure',
		'import-noarticle',
		'import-nonewrevisions',
		'xml-error-string',
		'import-upload',
		'import-token-mismatch',
		'import-invalid-interwiki',
		'import-error-edit',
		'import-error-create',
		'import-error-interwiki',
		'import-error-special',
		'import-error-invalid',
		'import-error-unserialize',
		'import-options-wrong',
		'import-rootpage-invalid',
		'import-rootpage-nosubpage',
	),
	'importlog' => array(
		'importlogpage',
		'importlogpagetext',
		'import-logentry-upload',
		'import-logentry-upload-detail',
		'import-logentry-interwiki',
		'import-logentry-interwiki-detail',
	),
	'javaccripttest' => array(
		'javascripttest',
		'javascripttest-backlink',
		'javascripttest-title',
		'javascripttest-pagetext-noframework',
		'javascripttest-pagetext-unknownframework',
		'javascripttest-pagetext-frameworks',
		'javascripttest-pagetext-skins' ,
		'javascripttest-qunit-name',
		'javascripttest-qunit-intro',
		'javascripttest-qunit-heading',
	),
	'accesskeys' => array(
		'accesskey-pt-userpage',
		'accesskey-pt-anonuserpage',
		'accesskey-pt-mytalk',
		'accesskey-pt-anontalk',
		'accesskey-pt-preferences',
		'accesskey-pt-watchlist',
		'accesskey-pt-mycontris',
		'accesskey-pt-login',
		'accesskey-pt-anonlogin',
		'accesskey-pt-logout',
		'accesskey-ca-talk',
		'accesskey-ca-edit',
		'accesskey-ca-addsection',
		'accesskey-ca-viewsource',
		'accesskey-ca-history',
		'accesskey-ca-protect',
		'accesskey-ca-unprotect',
		'accesskey-ca-delete',
		'accesskey-ca-undelete',
		'accesskey-ca-move',
		'accesskey-ca-watch',
		'accesskey-ca-unwatch',
		'accesskey-search',
		'accesskey-search-go',
		'accesskey-search-fulltext',
		'accesskey-p-logo',
		'accesskey-n-mainpage',
		'accesskey-n-mainpage-description',
		'accesskey-n-portal',
		'accesskey-n-currentevents',
		'accesskey-n-recentchanges',
		'accesskey-n-randompage',
		'accesskey-n-help',
		'accesskey-t-whatlinkshere',
		'accesskey-t-recentchangeslinked',
		'accesskey-t-random',
		'accesskey-feed-rss',
		'accesskey-feed-atom',
		'accesskey-t-contributions',
		'accesskey-t-emailuser',
		'accesskey-t-permalink',
		'accesskey-t-print',
		'accesskey-t-upload',
		'accesskey-t-specialpages',
		'accesskey-ca-nstab-main',
		'accesskey-ca-nstab-user',
		'accesskey-ca-nstab-media',
		'accesskey-ca-nstab-special',
		'accesskey-ca-nstab-project',
		'accesskey-ca-nstab-image',
		'accesskey-ca-nstab-mediawiki',
		'accesskey-ca-nstab-template',
		'accesskey-ca-nstab-help',
		'accesskey-ca-nstab-category',
		'accesskey-minoredit',
		'accesskey-save',
		'accesskey-preview',
		'accesskey-diff',
		'accesskey-compareselectedversions',
		'accesskey-watch',
		'accesskey-upload',
		'accesskey-preferences-save',
		'accesskey-summary',
		'accesskey-userrights-set',
		'accesskey-blockip-block',
		'accesskey-export',
		'accesskey-import',
		'accesskey-watchlistedit-normal-submit',
		'accesskey-watchlistedit-raw-submit',
	),
	'tooltips' => array(
		'tooltip-pt-userpage',
		'tooltip-pt-anonuserpage',
		'tooltip-pt-mytalk',
		'tooltip-pt-anontalk',
		'tooltip-pt-preferences',
		'tooltip-pt-watchlist',
		'tooltip-pt-mycontris',
		'tooltip-pt-login',
		'tooltip-pt-anonlogin',
		'tooltip-pt-logout',
		'tooltip-ca-talk',
		'tooltip-ca-edit',
		'tooltip-ca-addsection',
		'tooltip-ca-viewsource',
		'tooltip-ca-history',
		'tooltip-ca-protect',
		'tooltip-ca-unprotect',
		'tooltip-ca-delete',
		'tooltip-ca-undelete',
		'tooltip-ca-move',
		'tooltip-ca-watch',
		'tooltip-ca-unwatch',
		'tooltip-search',
		'tooltip-search-go',
		'tooltip-search-fulltext',
		'tooltip-p-logo',
		'tooltip-n-mainpage',
		'tooltip-n-mainpage-description',
		'tooltip-n-portal',
		'tooltip-n-currentevents',
		'tooltip-n-recentchanges',
		'tooltip-n-randompage',
		'tooltip-n-help',
		'tooltip-t-whatlinkshere',
		'tooltip-t-recentchangeslinked',
		'tooltip-t-random',
		'tooltip-feed-rss',
		'tooltip-feed-atom',
		'tooltip-t-contributions',
		'tooltip-t-emailuser',
		'tooltip-t-upload',
		'tooltip-t-specialpages',
		'tooltip-t-print',
		'tooltip-t-permalink',
		'tooltip-ca-nstab-main',
		'tooltip-ca-nstab-user',
		'tooltip-ca-nstab-media',
		'tooltip-ca-nstab-special',
		'tooltip-ca-nstab-project',
		'tooltip-ca-nstab-image',
		'tooltip-ca-nstab-mediawiki',
		'tooltip-ca-nstab-template',
		'tooltip-ca-nstab-help',
		'tooltip-ca-nstab-category',
		'tooltip-minoredit',
		'tooltip-save',
		'tooltip-preview',
		'tooltip-diff',
		'tooltip-compareselectedversions',
		'tooltip-watch',
		'tooltip-watchlistedit-normal-submit',
		'tooltip-watchlistedit-raw-submit',
		'tooltip-recreate',
		'tooltip-upload',
		'tooltip-rollback',
		'tooltip-undo',
		'tooltip-preferences-save',
		'tooltip-summary',
	),
	'stylesheets' => array(
		'common.css',
		'standard.css',
		'nostalgia.css',
		'cologneblue.css',
		'monobook.css',
		'myskin.css',
		'chick.css',
		'simple.css',
		'modern.css',
		'vector.css',
		'print.css',
		'handheld.css',
		'noscript.css',
		'group-autoconfirmed.css',
		'group-bot.css',
		'group-sysop.css',
		'group-bureaucrat.css',
	),
	'scripts' => array(
		'common.js',
		'standard.js',
		'nostalgia.js',
		'cologneblue.js',
		'monobook.js',
		'myskin.js',
		'chick.js',
		'simple.js',
		'modern.js',
		'vector.js',
		'group-autoconfirmed.js',
		'group-bot.js',
		'group-sysop.js',
		'group-bureaucrat.js',
	),
	'metadata_cc' => array(
		'notacceptable',
	),
	'attribution' => array(
		'anonymous',
		'siteuser',
		'anonuser',
		'lastmodifiedatby',
		'othercontribs',
		'others',
		'siteusers',
		'anonusers',
		'creditspage',
		'nocredits',
	),
	'spamprotection' => array(
		'spamprotectiontitle',
		'spamprotectiontext',
		'spamprotectionmatch',
		'spambot_username',
		'spam_reverting',
		'spam_blanking',
		'spam_deleting',
	),
	'info' => array(
		'pageinfo-header',
		'pageinfo-title',
		'pageinfo-not-current',
		'pageinfo-header-basic',
		'pageinfo-header-edits',
		'pageinfo-header-restrictions',
		'pageinfo-header-properties',
		'pageinfo-display-title',
		'pageinfo-default-sort',
		'pageinfo-length',
		'pageinfo-article-id',
		'pageinfo-language',
		'pageinfo-robot-policy',
		'pageinfo-robot-index',
		'pageinfo-robot-noindex',
		'pageinfo-views',
		'pageinfo-watchers',
		'pageinfo-few-watchers',
		'pageinfo-redirects-name',
		'pageinfo-redirects-value',
		'pageinfo-subpages-name',
		'pageinfo-subpages-value',
		'pageinfo-firstuser',
		'pageinfo-firsttime',
		'pageinfo-lastuser',
		'pageinfo-lasttime',
		'pageinfo-edits',
		'pageinfo-authors',
		'pageinfo-recent-edits',
		'pageinfo-recent-authors',
		'pageinfo-magic-words',
		'pageinfo-hidden-categories',
		'pageinfo-templates',
		'pageinfo-transclusions',
		'pageinfo-footer',
		'pageinfo-toolboxlink',
		'pageinfo-redirectsto',
		'pageinfo-redirectsto-info',
		'pageinfo-contentpage',
		'pageinfo-contentpage-yes',
		'pageinfo-protect-cascading',
		'pageinfo-protect-cascading-yes',
		'pageinfo-protect-cascading-from',
		'pageinfo-category-info',
		'pageinfo-category-pages',
		'pageinfo-category-subcats',
		'pageinfo-category-files'
	),
	'skin' => array(
		'skinname-standard',
		'skinname-nostalgia',
		'skinname-cologneblue',
		'skinname-monobook',
		'skinname-myskin',
		'skinname-chick',
		'skinname-simple',
		'skinname-modern',
		'skinname-vector',
	),
	'patrolling' => array(
		'markaspatrolleddiff',
		'markaspatrolledlink',
		'markaspatrolledtext',
		'markedaspatrolled',
		'markedaspatrolledtext',
		'rcpatroldisabled',
		'rcpatroldisabledtext',
		'markedaspatrollederror',
		'markedaspatrollederrortext',
		'markedaspatrollederror-noautopatrol',
		'markedaspatrollednotify',
		'markedaspatrollederrornotify',
	),
	'patrol-log' => array(
		'patrol-log-page',
		'patrol-log-header',
		'log-show-hide-patrol',
	),
	'imagedeletion' => array(
		'deletedrevision',
		'filedeleteerror-short',
		'filedeleteerror-long',
		'filedelete-missing',
		'filedelete-old-unregistered',
		'filedelete-current-unregistered',
		'filedelete-archive-read-only',
	),
	'browsediffs' => array(
		'previousdiff',
		'nextdiff',
	),
	'media-info' => array(
		'mediawarning',
		'imagemaxsize',
		'thumbsize',
		'widthheight',
		'widthheightpage',
		'file-info',
		'file-info-size',
		'file-info-size-pages',
		'file-nohires',
		'svg-long-desc',
		'svg-long-desc-animated',
		'svg-long-error',
		'show-big-image',
		'show-big-image-preview',
		'show-big-image-other',
		'show-big-image-size',
		'file-info-gif-looped',
		'file-info-gif-frames',
		'file-info-png-looped',
		'file-info-png-repeat',
		'file-info-png-frames',
		'file-no-thumb-animation',
		'file-no-thumb-animation-gif',
	),
	'newfiles' => array(
		'newimages',
		'imagelisttext',
		'newimages-summary',
		'newimages-legend',
		'newimages-label',
		'showhidebots',
		'noimages',
		'ilsubmit',
		'bydate',
		'sp-newimages-showfrom',
	),
	'video-info' => array(
		'video-dims',
		'seconds-abbrev',
		'minutes-abbrev',
		'hours-abbrev',
		'days-abbrev',
		'seconds',
		'minutes',
		'hours',
		'days',
		'months',
		'years',
		'ago',
		'just-now',
	),
	'badimagelist' => array(
		'bad_image_list',
	),
	'variantname-zh' => array(
		'variantname-zh-hans',
		'variantname-zh-hant',
		'variantname-zh-cn',
		'variantname-zh-tw',
		'variantname-zh-hk',
		'variantname-zh-mo',
		'variantname-zh-sg',
		'variantname-zh-my',
		'variantname-zh',
	),
	'variantname-gan' => array(
		'variantname-gan-hans',
		'variantname-gan-hant',
		'variantname-gan',
	),
	'variantname-sr' => array(
		'variantname-sr-ec',
		'variantname-sr-el',
		'variantname-sr',
	),
	'variantname-kk' => array(
		'variantname-kk-kz',
		'variantname-kk-tr',
		'variantname-kk-cn',
		'variantname-kk-cyrl',
		'variantname-kk-latn',
		'variantname-kk-arab',
		'variantname-kk',
	),
	'variantname-ku' => array(
		'variantname-ku-arab',
		'variantname-ku-latn',
		'variantname-ku',
	),
	'variantname-tg' => array(
		'variantname-tg-cyrl',
		'variantname-tg-latn',
		'variantname-tg',
	),
	'variantname-iu' => array(
		'variantname-ike-cans',
		'variantname-ike-latn',
		'variantname-iu',
	),
	'variantname-shi' => array(
		'variantname-shi-tfng',
		'variantname-shi-latn',
		'variantname-shi',
	),
	'metadata' => array(
		'metadata',
		'metadata-help',
		'metadata-expand',
		'metadata-collapse',
		'metadata-fields',
		'metadata-langitem',
		'metadata-langitem-default',
	),
	'exif' => array(
		'exif-imagewidth',
		'exif-imagelength',
		'exif-bitspersample',
		'exif-compression',
		'exif-photometricinterpretation',
		'exif-orientation',
		'exif-samplesperpixel',
		'exif-planarconfiguration',
		'exif-ycbcrsubsampling',
		'exif-ycbcrpositioning',
		'exif-xresolution',
		'exif-yresolution',
		'exif-resolutionunit',
		'exif-stripoffsets',
		'exif-rowsperstrip',
		'exif-stripbytecounts',
		'exif-jpeginterchangeformat',
		'exif-jpeginterchangeformatlength',
		'exif-whitepoint',
		'exif-primarychromaticities',
		'exif-ycbcrcoefficients',
		'exif-referenceblackwhite',
		'exif-datetime',
		'exif-imagedescription',
		'exif-make',
		'exif-model',
		'exif-software',
		'exif-artist',
		'exif-copyright',
		'exif-exifversion',
		'exif-flashpixversion',
		'exif-colorspace',
		'exif-componentsconfiguration',
		'exif-compressedbitsperpixel',
		'exif-pixelydimension',
		'exif-pixelxdimension',
		'exif-usercomment',
		'exif-relatedsoundfile',
		'exif-datetimeoriginal',
		'exif-datetimedigitized',
		'exif-subsectime',
		'exif-subsectimeoriginal',
		'exif-subsectimedigitized',
		'exif-exposuretime',
		'exif-exposuretime-format',
		'exif-fnumber',
		'exif-fnumber-format',
		'exif-exposureprogram',
		'exif-spectralsensitivity',
		'exif-isospeedratings',
		'exif-shutterspeedvalue',
		'exif-aperturevalue',
		'exif-brightnessvalue',
		'exif-exposurebiasvalue',
		'exif-maxaperturevalue',
		'exif-subjectdistance',
		'exif-meteringmode',
		'exif-lightsource',
		'exif-flash',
		'exif-focallength',
		'exif-focallength-format',
		'exif-subjectarea',
		'exif-flashenergy',
		'exif-focalplanexresolution',
		'exif-focalplaneyresolution',
		'exif-focalplaneresolutionunit',
		'exif-subjectlocation',
		'exif-exposureindex',
		'exif-sensingmethod',
		'exif-filesource',
		'exif-scenetype',
		'exif-customrendered',
		'exif-exposuremode',
		'exif-whitebalance',
		'exif-digitalzoomratio',
		'exif-focallengthin35mmfilm',
		'exif-scenecapturetype',
		'exif-gaincontrol',
		'exif-contrast',
		'exif-saturation',
		'exif-sharpness',
		'exif-devicesettingdescription',
		'exif-subjectdistancerange',
		'exif-imageuniqueid',
		'exif-gpsversionid',
		'exif-gpslatituderef',
		'exif-gpslatitude',
		'exif-gpslongituderef',
		'exif-gpslongitude',
		'exif-gpsaltituderef',
		'exif-gpsaltitude',
		'exif-gpstimestamp',
		'exif-gpssatellites',
		'exif-gpsstatus',
		'exif-gpsmeasuremode',
		'exif-gpsdop',
		'exif-gpsspeedref',
		'exif-gpsspeed',
		'exif-gpstrackref',
		'exif-gpstrack',
		'exif-gpsimgdirectionref',
		'exif-gpsimgdirection',
		'exif-gpsmapdatum',
		'exif-gpsdestlatituderef',
		'exif-gpsdestlatitude',
		'exif-gpsdestlongituderef',
		'exif-gpsdestlongitude',
		'exif-gpsdestbearingref',
		'exif-gpsdestbearing',
		'exif-gpsdestdistanceref',
		'exif-gpsdestdistance',
		'exif-gpsprocessingmethod',
		'exif-gpsareainformation',
		'exif-gpsdatestamp',
		'exif-gpsdifferential',
		'exif-coordinate-format',
		'exif-jpegfilecomment',
		'exif-keywords',
		'exif-worldregioncreated',
		'exif-countrycreated',
		'exif-countrycodecreated',
		'exif-provinceorstatecreated',
		'exif-citycreated',
		'exif-sublocationcreated',
		'exif-worldregiondest',
		'exif-countrydest',
		'exif-countrycodedest',
		'exif-provinceorstatedest',
		'exif-citydest',
		'exif-sublocationdest',
		'exif-objectname',
		'exif-specialinstructions',
		'exif-headline',
		'exif-credit',
		'exif-source',
		'exif-editstatus',
		'exif-urgency',
		'exif-fixtureidentifier',
		'exif-locationdest',
		'exif-locationdestcode',
		'exif-objectcycle',
		'exif-contact',
		'exif-writer',
		'exif-languagecode',
		'exif-iimversion',
		'exif-iimcategory',
		'exif-iimsupplementalcategory',
		'exif-datetimeexpires',
		'exif-datetimereleased',
		'exif-originaltransmissionref',
		'exif-identifier',
		'exif-lens',
		'exif-serialnumber',
		'exif-cameraownername',
		'exif-label',
		'exif-datetimemetadata',
		'exif-nickname',
		'exif-rating',
		'exif-rightscertificate',
		'exif-copyrighted',
		'exif-copyrightowner',
		'exif-usageterms',
		'exif-webstatement',
		'exif-originaldocumentid',
		'exif-licenseurl',
		'exif-morepermissionsurl',
		'exif-attributionurl',
		'exif-preferredattributionname',
		'exif-pngfilecomment',
		'exif-disclaimer',
		'exif-contentwarning',
		'exif-giffilecomment',
		'exif-intellectualgenre',
		'exif-subjectnewscode',
		'exif-scenecode',
		'exif-event',
		'exif-organisationinimage',
		'exif-personinimage',
		'exif-originalimageheight',
		'exif-originalimagewidth',
	),
	'exif-values' => array(
		'exif-make-value',
		'exif-model-value',
		'exif-software-value',
		'exif-software-version-value',
		'exif-contact-value',
		'exif-subjectnewscode-value',
	),
	'exif-compression' => array(
		'exif-compression-1',
		'exif-compression-2',
		'exif-compression-3',
		'exif-compression-4',
		'exif-compression-5',
		'exif-compression-6',
		'exif-compression-7',
		'exif-compression-8',
		'exif-compression-32773',
		'exif-compression-32946',
		'exif-compression-34712',
	),
	'exif-copyrighted' => array(
		'exif-copyrighted-true',
		'exif-copyrighted-false',
	),
	'exif-photometricinterpretation' => array(
		'exif-photometricinterpretation-2',
		'exif-photometricinterpretation-6',
	),
	'exif-unknowndate' => array(
		'exif-unknowndate',
	),
	'exif-orientation' => array(
		'exif-orientation-1',
		'exif-orientation-2',
		'exif-orientation-3',
		'exif-orientation-4',
		'exif-orientation-5',
		'exif-orientation-6',
		'exif-orientation-7',
		'exif-orientation-8',
	),
	'exif-planarconfiguration' => array(
		'exif-planarconfiguration-1',
		'exif-planarconfiguration-2',
	),
	'exif-xyresolution' => array(
		'exif-xyresolution-i',
		'exif-xyresolution-c',
	),
	'exif-colorspace' => array(
		'exif-colorspace-1',
		'exif-colorspace-65535',
	),
	'exif-componentsconfiguration' => array(
		'exif-componentsconfiguration-0',
		'exif-componentsconfiguration-1',
		'exif-componentsconfiguration-2',
		'exif-componentsconfiguration-3',
		'exif-componentsconfiguration-4',
		'exif-componentsconfiguration-5',
		'exif-componentsconfiguration-6',
	),
	'exif-exposureprogram' => array(
		'exif-exposureprogram-0',
		'exif-exposureprogram-1',
		'exif-exposureprogram-2',
		'exif-exposureprogram-3',
		'exif-exposureprogram-4',
		'exif-exposureprogram-5',
		'exif-exposureprogram-6',
		'exif-exposureprogram-7',
		'exif-exposureprogram-8',
	),
	'exif-subjectdistance-value' => array(
		'exif-subjectdistance-value',
	),
	'exif-meteringmode' => array(
		'exif-meteringmode-0',
		'exif-meteringmode-1',
		'exif-meteringmode-2',
		'exif-meteringmode-3',
		'exif-meteringmode-4',
		'exif-meteringmode-5',
		'exif-meteringmode-6',
		'exif-meteringmode-255',
	),
	'exif-lightsource' => array(
		'exif-lightsource-0',
		'exif-lightsource-1',
		'exif-lightsource-2',
		'exif-lightsource-3',
		'exif-lightsource-4',
		'exif-lightsource-9',
		'exif-lightsource-10',
		'exif-lightsource-11',
		'exif-lightsource-12',
		'exif-lightsource-13',
		'exif-lightsource-14',
		'exif-lightsource-15',
		'exif-lightsource-17',
		'exif-lightsource-18',
		'exif-lightsource-19',
		'exif-lightsource-20',
		'exif-lightsource-21',
		'exif-lightsource-22',
		'exif-lightsource-23',
		'exif-lightsource-24',
		'exif-lightsource-255',
	),
	'exif-flash' => array(
		'exif-flash-fired-0' ,
		'exif-flash-fired-1' ,
		'exif-flash-return-0' ,
		'exif-flash-return-2' ,
		'exif-flash-return-3' ,
		'exif-flash-mode-1' ,
		'exif-flash-mode-2' ,
		'exif-flash-mode-3' ,
		'exif-flash-function-1' ,
		'exif-flash-redeye-1' ,
	),
	'exif-focalplaneresolutionunit' => array(
		'exif-focalplaneresolutionunit-2',
	),
	'exif-sensingmethod' => array(
		'exif-sensingmethod-1',
		'exif-sensingmethod-2',
		'exif-sensingmethod-3',
		'exif-sensingmethod-4',
		'exif-sensingmethod-5',
		'exif-sensingmethod-7',
		'exif-sensingmethod-8',
	),
	'exif-filesource' => array(
		'exif-filesource-3',
	),
	'exif-scenetype' => array(
		'exif-scenetype-1',
	),
	'exif-customrendered' => array(
		'exif-customrendered-0',
		'exif-customrendered-1',
	),
	'exif-exposuremode' => array(
		'exif-exposuremode-0',
		'exif-exposuremode-1',
		'exif-exposuremode-2',
	),
	'exif-whitebalance' => array(
		'exif-whitebalance-0',
		'exif-whitebalance-1',
	),
	'exif-scenecapturetype' => array(
		'exif-scenecapturetype-0',
		'exif-scenecapturetype-1',
		'exif-scenecapturetype-2',
		'exif-scenecapturetype-3',
	),
	'exif-gaincontrol' => array(
		'exif-gaincontrol-0',
		'exif-gaincontrol-1',
		'exif-gaincontrol-2',
		'exif-gaincontrol-3',
		'exif-gaincontrol-4',
	),
	'exif-contrast' => array(
		'exif-contrast-0',
		'exif-contrast-1',
		'exif-contrast-2',
	),
	'exif-saturation' => array(
		'exif-saturation-0',
		'exif-saturation-1',
		'exif-saturation-2',
	),
	'exif-sharpness' => array(
		'exif-sharpness-0',
		'exif-sharpness-1',
		'exif-sharpness-2',
	),
	'exif-subjectdistancerange' => array(
		'exif-subjectdistancerange-0',
		'exif-subjectdistancerange-1',
		'exif-subjectdistancerange-2',
		'exif-subjectdistancerange-3',
	),
	'exif-gpslatitude' => array(
		'exif-gpslatitude-n',
		'exif-gpslatitude-s',
	),
	'exif-gpslongitude' => array(
		'exif-gpslongitude-e',
		'exif-gpslongitude-w',
	),
	'exif-altituderef' => array(
		'exif-gpsaltitude-above-sealevel',
		'exif-gpsaltitude-below-sealevel',
	),
	'exif-gpsstatus' => array(
		'exif-gpsstatus-a',
		'exif-gpsstatus-v',
	),
	'exif-gpsmeasuremode' => array(
		'exif-gpsmeasuremode-2',
		'exif-gpsmeasuremode-3',
	),
	'exif-gpsspeed' => array(
		'exif-gpsspeed-k',
		'exif-gpsspeed-m',
		'exif-gpsspeed-n',
	),
	'exif-gpsdestdistanceref' => array(
		'exif-gpsdestdistance-k',
		'exif-gpsdestdistance-m',
		'exif-gpsdestdistance-n',
	),
	'exif-gdop' => array(
		'exif-gpsdop-excellent',
		'exif-gpsdop-good',
		'exif-gpsdop-moderate',
		'exif-gpsdop-fair',
		'exif-gpsdop-poor',
	),
	'exif-objectcycle' => array(
		'exif-objectcycle-a',
		'exif-objectcycle-p',
		'exif-objectcycle-b',
	),
	'exif-gpsdirection' => array(
		'exif-gpsdirection-t',
		'exif-gpsdirection-m',
	),
	'exif-ycbcrpositioning' => array(
		'exif-ycbcrpositioning-1',
		'exif-ycbcrpositioning-2',
	),
	'exif-dc' => array(
		'exif-dc-contributor',
		'exif-dc-coverage',
		'exif-dc-date',
		'exif-dc-publisher',
		'exif-dc-relation',
		'exif-dc-rights',
		'exif-dc-source',
		'exif-dc-type',
	),
	'exif-rating' => array(
		'exif-rating-rejected',
	),
	'exif-isospeedratings' => array(
		'exif-isospeedratings-overflow',
	),
	'exif-maxaperturevalue' => array(
		'exif-maxaperturevalue-value',
	),
	'exif-iimcategory' => array(
		'exif-iimcategory-ace',
		'exif-iimcategory-clj',
		'exif-iimcategory-dis',
		'exif-iimcategory-fin',
		'exif-iimcategory-edu',
		'exif-iimcategory-evn',
		'exif-iimcategory-hth',
		'exif-iimcategory-hum',
		'exif-iimcategory-lab',
		'exif-iimcategory-lif',
		'exif-iimcategory-pol',
		'exif-iimcategory-rel',
		'exif-iimcategory-sci',
		'exif-iimcategory-soi',
		'exif-iimcategory-spo',
		'exif-iimcategory-war',
		'exif-iimcategory-wea',
	),
	'exif-urgency' => array(
		'exif-urgency-normal',
		'exif-urgency-low',
		'exif-urgency-high',
		'exif-urgency-other',
	),
	'edit-externally' => array(
		'edit-externally',
		'edit-externally-help',
	),
	'all' => array(
		'watchlistall2',
		'namespacesall',
		'monthsall',
		'limitall',
	),
	'confirmemail' => array(
		'confirmemail',
		'confirmemail_noemail',
		'confirmemail_text',
		'confirmemail_pending',
		'confirmemail_send',
		'confirmemail_sent',
		'confirmemail_oncreate',
		'confirmemail_sendfailed',
		'confirmemail_invalid',
		'confirmemail_needlogin',
		'confirmemail_success',
		'confirmemail_loggedin',
		'confirmemail_error',
		'confirmemail_subject',
		'confirmemail_body',
		'confirmemail_body_changed',
		'confirmemail_body_set',
		'confirmemail_invalidated',
		'invalidateemail',
	),
	'scarytransclusion' => array(
		'scarytranscludedisabled',
		'scarytranscludefailed',
		'scarytranscludefailed-httpstatus',
		'scarytranscludetoolong',
	),
	'deleteconflict' => array(
		'deletedwhileediting',
		'confirmrecreate',
		'confirmrecreate-noreason',
		'recreate',
	),
	'unit-pixel' => array(
		'unit-pixel',
	),
	'purge' => array(
		'confirm_purge_button',
		'confirm-purge-top',
		'confirm-purge-bottom',
	),
	'watch-unwatch' => array(
		'confirm-watch-button',
		'confirm-watch-top',
		'confirm-unwatch-button',
		'confirm-unwatch-top',
	),
	'separators' => array(
		'semicolon-separator',
		'comma-separator',
		'colon-separator',
		'autocomment-prefix',
		'pipe-separator',
		'word-separator',
		'ellipsis',
		'percent',
		'parentheses',
		'brackets',
	),
	'imgmulti' => array(
		'imgmultipageprev',
		'imgmultipagenext',
		'imgmultigo',
		'imgmultigoto',
	),
	'tablepager' => array(
		'ascending_abbrev',
		'descending_abbrev',
		'table_pager_next',
		'table_pager_prev',
		'table_pager_first',
		'table_pager_last',
		'table_pager_limit',
		'table_pager_limit_label',
		'table_pager_limit_submit',
		'table_pager_empty',
	),
	'autosumm' => array(
		'autosumm-blank',
		'autosumm-replace',
		'autoredircomment',
		'autosumm-new',
	),
	'autoblock_whitelist' => array(
		'autoblock_whitelist',
	),
	'sizeunits' => array(
		'size-bytes',
		'size-kilobytes',
		'size-megabytes',
		'size-gigabytes',
		'size-terabytes',
		'size-petabytes',
		'size-exabytes',
		'size-zetabytes',
		'size-yottabytes',
	),
	'bitrateunits' => array(
		'bitrate-bits',
		'bitrate-kilobits',
		'bitrate-megabits',
		'bitrate-gigabits',
		'bitrate-terabits',
		'bitrate-petabits',
		'bitrate-exabits',
		'bitrate-zetabits',
		'bitrate-yottabits',
	),
	'livepreview' => array(
		'livepreview-loading',
		'livepreview-ready',
		'livepreview-failed',
		'livepreview-error',
	),
	'lagwarning' => array(
		'lag-warn-normal',
		'lag-warn-high',
	),
	'watch' => array(
		'confirm-watch-button',
	),
	'watchlisteditor' => array(
		'editwatchlist-summary',
		'watchlistedit-numitems',
		'watchlistedit-noitems',
		'watchlistedit-normal-title',
		'watchlistedit-normal-legend',
		'watchlistedit-normal-explain',
		'watchlistedit-normal-submit',
		'watchlistedit-normal-done',
		'watchlistedit-raw-title',
		'watchlistedit-raw-legend',
		'watchlistedit-raw-explain',
		'watchlistedit-raw-titles',
		'watchlistedit-raw-submit',
		'watchlistedit-raw-done',
		'watchlistedit-raw-added',
		'watchlistedit-raw-removed',
	),
	'watchlisttools' => array(
		'watchlisttools-view',
		'watchlisttools-edit',
		'watchlisttools-raw',
	),
	'iranian-dates' => array(
		'iranian-calendar-m1',
		'iranian-calendar-m2',
		'iranian-calendar-m3',
		'iranian-calendar-m4',
		'iranian-calendar-m5',
		'iranian-calendar-m6',
		'iranian-calendar-m7',
		'iranian-calendar-m8',
		'iranian-calendar-m9',
		'iranian-calendar-m10',
		'iranian-calendar-m11',
		'iranian-calendar-m12',
	),
	'hijri-dates' => array(
		'hijri-calendar-m1',
		'hijri-calendar-m2',
		'hijri-calendar-m3',
		'hijri-calendar-m4',
		'hijri-calendar-m5',
		'hijri-calendar-m6',
		'hijri-calendar-m7',
		'hijri-calendar-m8',
		'hijri-calendar-m9',
		'hijri-calendar-m10',
		'hijri-calendar-m11',
		'hijri-calendar-m12',
	),
	'hebrew-dates' => array(
		'hebrew-calendar-m1',
		'hebrew-calendar-m2',
		'hebrew-calendar-m3',
		'hebrew-calendar-m4',
		'hebrew-calendar-m5',
		'hebrew-calendar-m6',
		'hebrew-calendar-m6a',
		'hebrew-calendar-m6b',
		'hebrew-calendar-m7',
		'hebrew-calendar-m8',
		'hebrew-calendar-m9',
		'hebrew-calendar-m10',
		'hebrew-calendar-m11',
		'hebrew-calendar-m12',
		'hebrew-calendar-m1-gen',
		'hebrew-calendar-m2-gen',
		'hebrew-calendar-m3-gen',
		'hebrew-calendar-m4-gen',
		'hebrew-calendar-m5-gen',
		'hebrew-calendar-m6-gen',
		'hebrew-calendar-m6a-gen',
		'hebrew-calendar-m6b-gen',
		'hebrew-calendar-m7-gen',
		'hebrew-calendar-m8-gen',
		'hebrew-calendar-m9-gen',
		'hebrew-calendar-m10-gen',
		'hebrew-calendar-m11-gen',
		'hebrew-calendar-m12-gen',
	),
	'signatures' => array(
		'signature',
		'signature-anon',
		'timezone-utc',
	),
	'CoreParserFunctions' => array(
		'unknown_extension_tag',
		'duplicate-defaultsort',
	),
	'version' => array(
		'version',
		'version-summary',
		'version-extensions',
		'version-specialpages',
		'version-parserhooks',
		'version-variables',
		'version-antispam',
		'version-skins',
		'version-api',
		'version-other',
		'version-mediahandlers',
		'version-hooks',
		'version-extension-functions',
		'version-parser-extensiontags',
		'version-parser-function-hooks',
		'version-hook-name',
		'version-hook-subscribedby',
		'version-version',
		'version-svn-revision',
		'version-license',
		'version-poweredby-credits',
		'version-poweredby-others',
		'version-credits-summary',
		'version-license-info',
		'version-software',
		'version-software-product',
		'version-software-version',
		'version-entrypoints',
		'version-entrypoints-header-entrypoint',
		'version-entrypoints-header-url',
		'version-entrypoints-articlepath',
		'version-entrypoints-scriptpath',
		'version-entrypoints-index-php',
		'version-entrypoints-api-php',
		'version-entrypoints-load-php',
	),
	'filepath' => array(
		'filepath',
		'filepath-page',
		'filepath-submit',
		'filepath-summary',
	),
	'fileduplicatesearch' => array(
		'fileduplicatesearch',
		'fileduplicatesearch-summary',
		'fileduplicatesearch-legend',
		'fileduplicatesearch-filename',
		'fileduplicatesearch-submit',
		'fileduplicatesearch-info',
		'fileduplicatesearch-result-1',
		'fileduplicatesearch-result-n',
		'fileduplicatesearch-noresults',
	),
	'special-specialpages' => array(
		'specialpages',
		'specialpages-summary',
		'specialpages-note',
		'specialpages-group-maintenance',
		'specialpages-group-other',
		'specialpages-group-login',
		'specialpages-group-changes',
		'specialpages-group-media',
		'specialpages-group-users',
		'specialpages-group-highuse',
		'specialpages-group-pages',
		'specialpages-group-pagetools',
		'specialpages-group-wiki',
		'specialpages-group-redirects',
		'specialpages-group-spam',
	),
	'special-blank' => array(
		'blankpage',
		'intentionallyblankpage',
	),
	'external_images' => array(
		'external_image_whitelist',
	),
	'special-tags' => array(
		'tags',
		'tags-summary',
		'tag-filter',
		'tag-filter-submit',
		'tags-title',
		'tags-intro',
		'tags-tag',
		'tags-display-header',
		'tags-description-header',
		'tags-hitcount-header',
		'tags-edit',
		'tags-hitcount',
	),
	'comparepages' => array(
		'comparepages',
		'comparepages-summary',
		'compare-selector',
		'compare-page1',
		'compare-page2',
		'compare-rev1',
		'compare-rev2',
		'compare-submit',
		'compare-invalid-title',
		'compare-title-not-exists',
		'compare-revision-not-exists',
	),
	'db-error-messages' => array(
		'dberr-header',
		'dberr-problems',
		'dberr-again',
		'dberr-info',
		'dberr-usegoogle',
		'dberr-outofdate',
		'dberr-cachederror',
	),
	'html-forms' => array(
		'htmlform-invalid-input',
		'htmlform-select-badoption',
		'htmlform-int-invalid',
		'htmlform-float-invalid',
		'htmlform-int-toolow',
		'htmlform-int-toohigh',
		'htmlform-required',
		'htmlform-submit',
		'htmlform-reset',
		'htmlform-selectorother-other',
	),
	'sqlite' => array(
		'sqlite-has-fts',
		'sqlite-no-fts',
	),
	'unwatch' => array(
		'confirm-unwatch-button',
	),
	'logging' => array(
		'logentry-delete-delete',
		'logentry-delete-restore',
		'logentry-delete-event',
		'logentry-delete-revision',
		'logentry-delete-event-legacy',
		'logentry-delete-revision-legacy',
		'logentry-suppress-delete',
		'logentry-suppress-event',
		'logentry-suppress-revision',
		'logentry-suppress-event-legacy',
		'logentry-suppress-revision-legacy',
		'revdelete-content-hid',
		'revdelete-summary-hid',
		'revdelete-uname-hid',
		'revdelete-content-unhid',
		'revdelete-summary-unhid',
		'revdelete-uname-unhid',
		'revdelete-restricted',
		'revdelete-unrestricted',
		'logentry-move-move',
		'logentry-move-move-noredirect',
		'logentry-move-move_redir',
		'logentry-move-move_redir-noredirect',
		'logentry-patrol-patrol',
		'logentry-patrol-patrol-auto',
		'logentry-newusers-newusers',
		'logentry-newusers-create',
		'logentry-newusers-create2',
		'logentry-newusers-byemail',
		'logentry-newusers-autocreate',
		'logentry-rights-rights',
		'logentry-rights-rights-legacy',
		'logentry-rights-autopromote',
		'rightsnone',
	),
	'logging-irc' => array(
		'revdelete-logentry',
		'logdelete-logentry',
		'revdelete-content',
		'revdelete-summary',
		'revdelete-uname',
		'revdelete-hid',
		'revdelete-unhid',
		'revdelete-log-message',
		'logdelete-log-message',
		'deletedarticle',
		'suppressedarticle',
		'undeletedarticle',
		'patrol-log-line',
		'patrol-log-auto',
		'patrol-log-diff',
		'1movedto2',
		'1movedto2_redir',
		'move-redirect-suppressed',
		'newuserlog-create-entry',
		'newuserlog-create2-entry',
		'newuserlog-autocreate-entry',
		'suppressedarticle',
		'deletedarticle',
		// 'uploadedimage',
		// 'overwroteimage',
		'rightslogentry',
		'rightslogentry-autopromote',
	),
	'feedback' => array(
		'feedback-bugornote',
		'feedback-subject',
		'feedback-message',
		'feedback-cancel',
		'feedback-submit',
		'feedback-adding',
		'feedback-error1',
		'feedback-error2',
		'feedback-error3',
		'feedback-thanks',
		'feedback-close',
		'feedback-bugcheck',
		'feedback-bugnew',
	),
	'searchsuggestions' => array(
		'searchsuggest-search',
		'searchsuggest-containing',
	),
	'apierrors' => array(
		'api-error-badaccess-groups',
		'api-error-badtoken',
		'api-error-copyuploaddisabled',
		'api-error-duplicate',
		'api-error-duplicate-archive',
		'api-error-duplicate-archive-popup-title',
		'api-error-duplicate-popup-title',
		'api-error-empty-file',
		'api-error-emptypage',
		'api-error-fetchfileerror',
		'api-error-fileexists-forbidden',
		'api-error-fileexists-shared-forbidden',
		'api-error-file-too-large',
		'api-error-filename-tooshort',
		'api-error-filetype-banned',
		'api-error-filetype-banned-type',
		'api-error-filetype-missing',
		'api-error-hookaborted',
		'api-error-http',
		'api-error-illegal-filename',
		'api-error-internal-error',
		'api-error-invalid-file-key',
		'api-error-missingparam',
		'api-error-missingresult',
		'api-error-mustbeloggedin',
		'api-error-mustbeposted',
		'api-error-noimageinfo',
		'api-error-nomodule',
		'api-error-ok-but-empty',
		'api-error-overwrite',
		'api-error-stashfailed',
		'api-error-publishfailed',
		'api-error-timeout',
		'api-error-unclassified',
		'api-error-unknown-code',
		'api-error-unknown-error',
		'api-error-unknown-warning',
		'api-error-unknownerror',
		'api-error-uploaddisabled',
		'api-error-verification-error',
	),
	'duration' => array(
		'duration-seconds',
		'duration-minutes',
		'duration-hours',
		'duration-days',
		'duration-weeks',
		'duration-years',
		'duration-decades',
		'duration-centuries',
		'duration-millennia'
	),
	'rotation' => array(
		'rotate-comment',
	),
);

/** Comments for each block */
$wgBlockComments = array(
	'sidebar'             => "The sidebar for MonoBook is generated from this message, lines that do not
begin with * or ** are discarded, furthermore lines that do begin with ** and
do not contain | are also discarded, but do not depend on this behavior for
future releases. Also note that since each list value is wrapped in a unique
XHTML id it should only appear once and include characters that are legal
XHTML id names.",
	'toggles'             => 'User preference toggles',
	'underline'           => '',
	'editfont'            => 'Font style option in Special:Preferences',
	'dates'               => 'Dates',
	'categorypages'       => 'Categories related messages',
	'mainpage'            => '',
	'miscellaneous1'      => '',
	'cologneblue'         => 'Cologne Blue skin',
	'vector'              => 'Vector skin',
	'miscellaneous2'      => '',
	'links'               => 'All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).',
	'badaccess'           => '',
	'versionrequired'     => '',
	'miscellaneous3'      => '',
	'nstab'               => "Short words for each namespace, by default used in the namespace tab in monobook",
	'main'                => 'Main script and global functions',
	'errors'              => 'General errors',
	'virus'               => 'Virus scanner',
	'login'               => 'Login and logout pages',
	'mail'                => 'Email sending',
	'passwordstrength'    => 'JavaScript password checks',
	'resetpass'           => 'Change password dialog',
	'passwordreset'       => 'Special:PasswordReset',
	'changeemail'         => 'Special:ChangeEmail',
	'toolbar'             => 'Edit page toolbar',
	'edit'                => 'Edit pages',
	'parserwarnings'      => 'Parser/template warnings',
	'contentmodels'       => 'Content models',
	'undo'                => '"Undo" feature',
	'cantcreateaccount'   => 'Account creation failure',
	'history'             => 'History pages',
	'history-feed'        => 'Revision feed',
	'revdelete'           => 'Revision deletion',
	'suppression'         => 'Suppression log',
	'mergehistory'        => 'History merging',
	'mergelog'            => 'Merge log',
	'diffs'               => 'Diffs',
	'search'              => 'Search results',
	'opensearch'          => 'OpenSearch description',
	'quickbar'            => 'Quickbar',
	'preferences'         => 'Preferences page',
	'preferences-email'   => 'User preference: email validation using jQuery',
	'userrights'          => 'User rights',
	'group'               => 'Groups',
	'group-member'        => '',
	'grouppage'           => '',
	'right'               => 'Rights',
	'action'              => 'Associated actions - in the sentence "You do not have permission to X"',
	'rightslog'           => 'User rights log',
	'recentchanges'       => 'Recent changes',
	'recentchangeslinked' => 'Recent changes linked',
	'upload'              => 'Upload',
	'zip'                 => 'ZipDirectoryReader',
	'upload-errors'       => '',
	'filebackend-errors'  => 'File backend',
	'filejournal-errors'  => 'File journal errors',
	'lockmanager-errors'  => 'Lock manager',
	'uploadstash'         => 'Special:UploadStash',
	'img-auth'            => 'img_auth script messages',
	'http-errors'         => 'HTTP errors',
	'upload-curl-errors'  => 'Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>',
	'licenses'            => '',
	'filelist'            => 'Special:ListFiles',
	'filedescription'     => 'File description page',
	'filerevert'          => 'File reversion',
	'filedelete'          => 'File deletion',
	'mimesearch'          => 'MIME search',
	'unwatchedpages'      => 'Unwatched pages',
	'listredirects'       => 'List redirects',
	'unusedtemplates'     => 'Unused templates',
	'randompage'          => 'Random page',
	'randomredirect'      => 'Random redirect',
	'statistics'          => 'Statistics',
	'disambiguations'     => '',
	'pageswithprop'       => '',
	'doubleredirects'     => '',
	'brokenredirects'     => '',
	'withoutinterwiki'    => '',
	'fewestrevisions'     => '',
	'specialpages'        => 'Miscellaneous special pages',
	'booksources'         => 'Book sources',
	'magicwords'          => 'Magic words',
	'logpages'            => 'Special:Log',
	'allpages'            => 'Special:AllPages',
	'categories'          => 'Special:Categories',
	'deletedcontribs'     => 'Special:DeletedContributions',
	'linksearch'          => 'Special:LinkSearch',
	'listusers'           => 'Special:ListUsers',
	'activeusers'         => 'Special:ActiveUsers',
	'newuserlog'          => 'Special:Log/newusers',
	'listgrouprights'     => 'Special:ListGroupRights',
	'emailuser'           => 'Email user',
	'usermessage'         => 'User Messenger',
	'watchlist'           => 'Watchlist',
	'watching'            => 'Displayed when you click the "watch" button and it is in the process of watching',
	'enotif'              => '',
	'delete'              => 'Delete',
	'rollback'            => 'Rollback',
	'edittokens'          => 'Edit tokens',
	'protect'             => 'Protect',
	'restrictions'        => 'Restrictions (nouns)',
	'restriction-levels'  => 'Restriction levels',
	'undelete'            => 'Undelete',
	'nsform'              => 'Namespace form on various pages',
	'contributions'       => 'Contributions',
	'sp-contributions'    => '',
	'whatlinkshere'       => 'What links here',
	'block'               => 'Block/unblock',
	'developertools'      => 'Developer tools',
	'movepage'            => 'Move page',
	'export'              => 'Export',
	'allmessages'         => 'Namespace 8 related',
	'thumbnails'          => 'Thumbnails',
	'import'              => 'Special:Import',
	'importlog'           => 'Import log',
	'javaccripttest'      => 'JavaScriptTest',
	'accesskeys'          => 'Keyboard access keys for power users',
	'tooltips'            => 'Tooltip help for the actions',
	'stylesheets'         => 'Stylesheets',
	'scripts'             => 'Scripts',
	'metadata_cc'         => 'Metadata',
	'attribution'         => 'Attribution',
	'spamprotection'      => 'Spam protection',
	'info'                => 'Info page',
	'skin'                => 'Skin names',
	'patrolling'          => 'Patrolling',
	'patrol-log'          => 'Patrol log',
	'imagedeletion'       => 'Image deletion',
	'browsediffs'         => 'Browsing diffs',
	'newfiles'           => 'Special:NewFiles',
	'video-info'          => 'Video information, used by Language::formatTimePeriod() to format lengths in the above messages',
	'badimagelist'        => 'Bad image list',
	'variantname-zh'      => "Short names for language variants used for language conversion links.
Variants for Chinese language",
	'variantname-gan'      => 'Variants for Gan language',
	'variantname-sr'      => 'Variants for Serbian language',
	'variantname-kk'      => 'Variants for Kazakh language',
	'variantname-ku'      => 'Variants for Kurdish language',
	'variantname-tg'      => 'Variants for Tajiki language',
	'variantname-iu'      => 'Variants for Inuktitut language',
	'variantname-shi'     => 'Variants for Tachelhit language',
	'media-info'          => 'Media information',
	'metadata'            => 'Metadata',
	'exif'                           => 'EXIF tags',
	'exif-values'                    => 'Make & model, can be wikified in order to link to the camera and model name',
	'exif-compression'               => 'EXIF attributes',
	'exif-copyrighted'               => '',
	'exif-unknowndate'               => '',
	'exif-photometricinterpretation' => '',
	'exif-orientation'               => '',
	'exif-planarconfiguration'       => '',
	'exif-xyresolution'              => '',
	'exif-colorspace'                => '',
	'exif-componentsconfiguration'   => '',
	'exif-exposureprogram'           => '',
	'exif-subjectdistance-value'     => '',
	'exif-meteringmode'              => '',
	'exif-lightsource'               => '',
	'exif-flash'                     => 'Flash modes',
	'exif-focalplaneresolutionunit'  => '',
	'exif-sensingmethod'             => '',
	'exif-filesource'                => '',
	'exif-scenetype'                 => '',
	'exif-customrendered'            => '',
	'exif-exposuremode'              => '',
	'exif-whitebalance'              => '',
	'exif-scenecapturetype'          => '',
	'exif-gaincontrol'               => '',
	'exif-contrast'                  => '',
	'exif-saturation'                => '',
	'exif-sharpness'                 => '',
	'exif-subjectdistancerange'      => '',
	'exif-gpslatitude'               => 'Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef',
	'exif-gpslongitude'              => 'Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef',
	'exif-altituderef'               => 'Pseudotags used for GPSAltitudeRef',
	'exif-gpsstatus'                 => '',
	'exif-gpsmeasuremode'            => '',
	'exif-gpsspeed'                  => 'Pseudotags used for GPSSpeedRef',
	'exif-gpsdestdistanceref'        => 'Pseudotags used for GPSDestDistanceRef',
	'exif-gdop'                      => '',
	'exif-objectcycle'               => '',
	'exif-gpsdirection'              => 'Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef',
	'exif-ycbcrpositioning'          => '',
	'exif-dc'                        => '',
	'exif-rating'                    => '',
	'exif-isospeedratings'           => '',
	'exif-maxaperturevalue'          => '',
	'exif-iimcategory'               => '',
	'exif-urgency'                   => '',
	'edit-externally'       => 'External editor support',
	'all'                   => "'all' in various places, this might be different for inflected languages",
	'confirmemail'          => 'Email address confirmation',
	'scarytransclusion'     => 'Scary transclusion',
	'deleteconflict'        => 'Delete conflict',
	'unit-pixel'            => '',
	'purge'                 => 'action=purge',
	'watch-unwatch'         => 'action=watch/unwatch',
	'separators'            => 'Separators for various lists, etc.',
	'imgmulti'              => 'Multipage image navigation',
	'tablepager'            => 'Table pager',
	'autosumm'              => 'Auto-summaries',
	'autoblock_whitelist'   => 'Autoblock whitelist',
	'sizeunits'             => 'Size units',
	'bitrateunits'          => 'Bitrate units',
	'livepreview'           => 'Live preview',
	'lagwarning'            => 'Friendlier slave lag warnings',
	'watchlisteditor'       => 'Watchlist editor',
	'watchlisttools'        => 'Watchlist editing tools',
	'iranian-dates'         => 'Iranian month names',
	'hijri-dates'           => 'Hijri month names',
	'hebrew-dates'          => 'Hebrew month names',
	'signatures'            => 'Signatures',
	'CoreParserFunctions'   => 'Core parser functions',
	'version'               => 'Special:Version',
	'filepath'              => 'Special:FilePath',
	'fileduplicatesearch'   => 'Special:FileDuplicateSearch',
	'special-specialpages'  => 'Special:SpecialPages',
	'special-blank'         => 'Special:BlankPage',
	'external_images'       => 'External image whitelist',
	'special-tags'          => 'Special:Tags',
	'comparepages'          => 'Special:ComparePages',
	'db-error-messages'     => 'Database error messages',
	'html-forms'            => 'HTML forms',
	'sqlite'                => 'SQLite database support',
	'logging'               => 'New logging system',
	'logging-irc'           => 'For IRC, see bug 34508. Do not change',
	'feedback'              => 'Feedback',
	'searchsuggestions'     => 'Search suggestions',
	'apierrors'             => 'API errors',
	'duration'              => 'Durations',
	'cachedspecial'         => 'SpecialCachedPage',
	'rotation'              => 'Image rotation',
);
