/*
 * Decompiled with CFR 0.152.
 */
package pi.demo;

import pi.Block;
import pi.Minecraft;
import pi.Vec;

public class ChristmasTreeDemo {
    static double[] tree = new double[]{0.5, 1.0, 1.5, 2.0, 2.6, 3.0, 4.0, 5.0, 6.0, 4.0, 5.0, 6.0, 7.0, 8.0, 8.6, 7.0, 8.0, 9.0, 10.0, 10.6, 9.0, 10.0, 11.0, 12.0, 13.0};

    public static void main(String[] args) {
        Minecraft mc = Minecraft.connect((String[])args);
        ChristmasTreeDemo.drawChristmasTree(mc, Vec.ZERO);
    }

    static void drawChristmasTree(Minecraft mc, Vec p) {
        Vec v = Vec.xyz((int)20, (int)0, (int)20);
        mc.setBlocks(v.neg(), v.add(0, 50, 0), Block.AIR);
        mc.setBlocks(v.neg(), v, Block.SNOW_BLOCK);
        int h = 6;
        for (int i = 0; i < tree.length; ++i) {
            ChristmasTreeDemo.drawDisc(mc, p.add(0, h, 0), tree[tree.length - i - 1], Block.LEAVES.withData(1));
            ++h;
        }
        mc.setBlocks(p.add(-1, 0, 0), p.add(1, h - 6, 0), Block.WOOD);
        mc.setBlocks(p.add(0, 0, -1), p.add(0, h - 6, 1), Block.WOOD);
        ChristmasTreeDemo.drawStar(mc, p.add(0, h, 0));
    }

    static void drawDisc(Minecraft mc, Vec p, double r, Block b) {
        int rr = (int)Math.ceil(r);
        for (int j = -rr; j <= rr; ++j) {
            for (int i = -rr; i <= rr; ++i) {
                double diff = (double)(i * i + j * j) - r * r;
                if (!(diff <= 0.0)) continue;
                mc.setBlock(p.add(i, 0, j), b);
            }
        }
    }

    private static void drawStar(Minecraft mc, Vec p) {
        double[] radii = new double[]{0.0, 0.0, 1.0, 2.0, 1.0, 0.0};
        for (int i = 0; i < radii.length; ++i) {
            ChristmasTreeDemo.drawDisc(mc, p.add(0, i, 0), radii[i], Block.GOLD_BLOCK);
        }
    }
}

