/*
 * Decompiled with CFR 0.152.
 */
package pi.demo.sokoban;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import pi.demo.sokoban.LevelTile;
import pi.demo.sokoban.Position;

class Level {
    int number;
    String name;
    LevelTile[][] tiles;
    int width;
    int height;

    Level(String data, int number) {
        this.number = number;
        Scanner s = new Scanner(data);
        this.name = s.nextLine();
        ArrayList<LevelTile[]> rows = new ArrayList<LevelTile[]>();
        while (s.hasNextLine()) {
            LevelTile[] row = Level.parseRow(s.nextLine());
            this.width = Math.max(this.width, row.length);
            rows.add(row);
        }
        this.height = rows.size();
        this.tiles = (LevelTile[][])rows.toArray((T[])new LevelTile[this.height][]);
    }

    LevelTile get(Position p) {
        LevelTile[] row = this.tiles[p.j];
        return p.i < row.length ? row[p.i] : LevelTile.EMPTY;
    }

    private static LevelTile[] parseRow(String line) {
        ArrayList<LevelTile> row = new ArrayList<LevelTile>();
        for (char c : line.toCharArray()) {
            row.add(LevelTile.from(c));
        }
        return row.toArray(new LevelTile[row.size()]);
    }

    static List<Level> loadLevels() {
        ArrayList<Level> levels = new ArrayList<Level>();
        Scanner s = new Scanner(Level.class.getResourceAsStream("Level_Data"));
        s.useDelimiter("#").next();
        while (s.hasNext()) {
            levels.add(new Level(s.next(), levels.size() + 1));
        }
        return levels;
    }
}

