/*
 * Decompiled with CFR 0.152.
 */
package pi.demo.sokoban;

import java.util.HashSet;
import java.util.List;
import pi.Block;
import pi.Color;
import pi.Minecraft;
import pi.Vec;
import pi.demo.sokoban.Level;
import pi.demo.sokoban.LevelTile;
import pi.demo.sokoban.Position;
import pi.event.BlockHitEvent;

public class Sokoban {
    Minecraft mc;
    List<Level> levels = Level.loadLevels();
    Level level;
    PositionSet walls = new PositionSet();
    PositionSet targets = new PositionSet();
    PositionSet stones = new PositionSet();

    public Sokoban(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public static void main(String[] args) {
        new Sokoban(Minecraft.connect((String[])args)).run();
    }

    public void run() {
        this.mc.postToChat("Sokoban!");
        this.mc.camera.setNormal();
        this.mc.setting("immutable", true);
        while (true) {
            List hits;
            if (this.stones.equals(this.targets)) {
                if (this.level != null) {
                    this.mc.postToChat("Level finished!");
                    this.sleep(2000L);
                }
                int ni = this.level == null ? 0 : (this.level.number >= this.levels.size() ? 0 : this.level.number);
                this.startLevel(this.levels.get(ni));
            }
            if (!(hits = this.mc.events.pollBlockHits()).isEmpty()) {
                BlockHitEvent ev = (BlockHitEvent)hits.iterator().next();
                this.onBlockHit(ev.position, ev.surfaceDirection.neg());
            }
            this.sleep(80L);
        }
    }

    void startLevel(Level level) {
        this.level = level;
        this.walls.clear();
        this.targets.clear();
        this.stones.clear();
        this.mc.setBlocks(Position.uv(0, 0).toWorld(0), Position.uv(level.width - 1, level.height - 1).toWorld(10), Block.AIR);
        this.mc.setBlocks(Position.uv(0, 0).toWorld(-1), Position.uv(level.width - 1, level.height - 1).toWorld(-1), Block.SANDSTONE);
        for (int v = 0; v < level.height; ++v) {
            for (int u = 0; u < level.width; ++u) {
                Position pos = Position.uv(u, v);
                LevelTile t = level.get(pos);
                if (LevelTile.EMPTY == t) continue;
                if (LevelTile.WALL == t) {
                    this.walls.add(pos);
                    this.mc.setBlocks(pos.toWorld(0), pos.toWorld(2), Block.STONE);
                }
                if (LevelTile.PLAYER == t) {
                    this.mc.player.setPosition(pos.toWorld(2));
                }
                if (LevelTile.TARGET == t || LevelTile.TARGET_AND_STONE == t) {
                    this.targets.add(pos);
                    this.mc.setBlock(pos.toWorld(-1), Block.wool((Color)Color.LIGHT_BLUE));
                }
                if (LevelTile.STONE != t && LevelTile.TARGET_AND_STONE != t) continue;
                this.stones.add(pos);
                this.mc.setBlock(pos.toWorld(0), Block.IRON_BLOCK);
            }
        }
        this.mc.events.clearAll();
        this.mc.postToChat("Level " + level.number + " - " + level.name);
    }

    void onBlockHit(Vec position, Vec.Unit direction) {
        Position to;
        Position from = Position.fromWorld(position);
        if (!from.equals(to = Position.fromWorld(position.add((Vec)direction))) && !this.walls.contains(to) && !this.stones.contains(to) && this.stones.remove(from)) {
            this.stones.add(to);
            this.mc.setBlock(to.toWorld(0), this.targets.contains(to) ? Block.GOLD_BLOCK : Block.IRON_BLOCK);
            this.mc.setBlock(position, Block.AIR);
        }
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class PositionSet
    extends HashSet<Position> {
        private PositionSet() {
        }
    }
}

