/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import processing.app.Base;
import processing.app.Platform;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.ui.Toolkit;

public class ListPanel
extends JPanel
implements Scrollable,
ContributionListing.ChangeListener {
    ContributionTab contributionTab;
    TreeMap<Contribution, DetailPanel> panelByContribution = new TreeMap(ContributionListing.COMPARATOR);
    Set<Contribution> visibleContributions = new TreeSet<Contribution>(ContributionListing.COMPARATOR);
    private DetailPanel selectedPanel;
    protected Contribution.Filter filter;
    protected ContributionListing contribListing = ContributionListing.getInstance();
    protected JTable table;
    DefaultTableModel model;
    JScrollPane scrollPane;
    static Icon upToDateIcon;
    static Icon updateAvailableIcon;
    static Icon incompatibleIcon;
    static Icon foundationIcon;
    static Icon downloadingIcon;
    static final Color HEADER_BGCOLOR;

    static {
        HEADER_BGCOLOR = new Color(-1315861);
    }

    public ListPanel() {
        if (upToDateIcon == null) {
            upToDateIcon = Toolkit.getLibIconX("manager/up-to-date");
            updateAvailableIcon = Toolkit.getLibIconX("manager/update-available");
            incompatibleIcon = Toolkit.getLibIconX("manager/incompatible");
            foundationIcon = Toolkit.getLibIconX("icons/foundation", 16);
            downloadingIcon = Toolkit.getLibIconX("manager/downloading");
        }
    }

    public ListPanel(final ContributionTab contributionTab, Contribution.Filter filter) {
        this.contributionTab = contributionTab;
        this.filter = filter;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.model = new ContribTableModel();
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (this.isRowSelected(row)) {
                    c.setBackground(new Color(14745597));
                } else {
                    c.setBackground(Color.white);
                }
                return c;
            }
        };
        Object[] colName = new String[]{" Status", "Name", "Author"};
        this.model.setColumnIdentifiers(colName);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Contribution.class, new ContribStatusRenderer());
        this.table.setFont(ManagerFrame.NORMAL_PLAIN);
        this.table.setRowHeight(Toolkit.zoom(28));
        this.table.setRowMargin(Toolkit.zoom(6));
        this.table.getColumnModel().setColumnMargin(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(ManagerFrame.STATUS_WIDTH);
        this.table.getColumnModel().getColumn(2).setMinWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.getColumnModel().getColumn(2).setMaxWidth(ManagerFrame.AUTHOR_WIDTH);
        this.table.setShowGrid(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoCreateRowSorter(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (ListPanel.this.table.getSelectedRow() != -1) {
                    ListPanel.this.setSelectedPanel(ListPanel.this.panelByContribution.get(ListPanel.this.table.getValueAt(ListPanel.this.table.getSelectedRow(), 0)));
                    if (!contributionTab.filterField.hasFocus()) {
                        ListPanel.this.table.requestFocusInWindow();
                    }
                }
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        sorter.setComparator(1, ContributionListing.COMPARATOR);
        sorter.setComparator(2, new Comparator<Contribution>(){

            @Override
            public int compare(Contribution o1, Contribution o2) {
                return ListPanel.this.getAuthorNameWithoutMarkup(o1.getAuthorList()).compareTo(ListPanel.this.getAuthorNameWithoutMarkup(o2.getAuthorList()));
            }
        });
        sorter.setComparator(0, new Comparator<Contribution>(){

            @Override
            public int compare(Contribution o1, Contribution o2) {
                int pos1 = 0;
                if (o1.isInstalled()) {
                    pos1 = 1;
                    if (ListPanel.this.contribListing.hasUpdates(o1)) {
                        pos1 = 2;
                    }
                    if (!o1.isCompatible(Base.getRevision())) {
                        pos1 = 3;
                    }
                } else {
                    pos1 = 4;
                }
                int pos2 = 0;
                if (o2.isInstalled()) {
                    pos2 = 1;
                    if (ListPanel.this.contribListing.hasUpdates(o2)) {
                        pos2 = 2;
                    }
                    if (!o2.isCompatible(Base.getRevision())) {
                        pos2 = 3;
                    }
                } else {
                    pos2 = 4;
                }
                return pos1 - pos2;
            }
        });
        this.table.getTableHeader().setDefaultRenderer(new ContribHeaderRenderer());
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.scrollPane));
        this.setLayout(layout);
        this.table.setVisible(true);
    }

    String getAuthorNameWithoutMarkup(String authorList) {
        StringBuilder name = new StringBuilder("");
        if (authorList != null) {
            int i = 0;
            while (i < authorList.length()) {
                if (authorList.charAt(i) != '[' && authorList.charAt(i) != ']') {
                    if (authorList.charAt(i) == '(') {
                        ++i;
                        while (authorList.charAt(i) != ')') {
                            ++i;
                        }
                    } else {
                        name.append(authorList.charAt(i));
                    }
                }
                ++i;
            }
        }
        return name.toString();
    }

    void updatePanelOrdering(Set<Contribution> contributionsSet) {
        this.model.getDataVector().removeAllElements();
        int rowCount = 0;
        for (Contribution entry : contributionsSet) {
            this.model.addRow(new Object[]{entry, entry, entry});
            if (this.selectedPanel != null && entry.getName().equals(this.selectedPanel.getContrib().getName())) {
                this.table.setRowSelectionInterval(rowCount, rowCount);
            }
            ++rowCount;
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public void contributionAdded(Contribution contribution) {
        if (this.filter.matches(contribution) && !this.panelByContribution.containsKey(contribution)) {
            DetailPanel newPanel = new DetailPanel(this);
            this.panelByContribution.put(contribution, newPanel);
            this.visibleContributions.add(contribution);
            newPanel.setContribution(contribution);
            this.add(newPanel);
            this.updatePanelOrdering(this.visibleContributions);
            this.updateColors();
        }
    }

    @Override
    public void contributionRemoved(Contribution contribution) {
        if (this.filter.matches(contribution)) {
            DetailPanel panel = this.panelByContribution.get(contribution);
            if (panel != null) {
                this.remove(panel);
                this.panelByContribution.remove(contribution);
            }
            this.visibleContributions.remove(contribution);
            this.updatePanelOrdering(this.visibleContributions);
            this.updateColors();
            this.updateUI();
        }
    }

    @Override
    public void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        if (this.filter.matches(oldContrib) || this.filter.matches(newContrib)) {
            DetailPanel panel = this.panelByContribution.get(oldContrib);
            if (panel == null) {
                this.contributionAdded(newContrib);
            } else {
                this.panelByContribution.remove(oldContrib);
                panel.setContribution(newContrib);
                this.panelByContribution.put(newContrib, panel);
            }
            if (this.visibleContributions.contains(oldContrib)) {
                this.visibleContributions.remove(oldContrib);
                this.visibleContributions.add(newContrib);
            }
            this.updatePanelOrdering(this.visibleContributions);
        }
    }

    public void filterLibraries(List<Contribution> filteredContributions) {
        this.visibleContributions.clear();
        for (Contribution contribution : this.panelByContribution.keySet()) {
            if (contribution.getType() != this.contributionTab.contribType || !filteredContributions.contains(contribution) || !this.panelByContribution.keySet().contains(contribution)) continue;
            this.visibleContributions.add(contribution);
        }
        this.updatePanelOrdering(this.visibleContributions);
    }

    protected void setSelectedPanel(DetailPanel contributionPanel) {
        this.contributionTab.updateStatusPanel(contributionPanel);
        if (this.selectedPanel == contributionPanel) {
            this.selectedPanel.setSelected(true);
        } else {
            DetailPanel lastSelected = this.selectedPanel;
            this.selectedPanel = contributionPanel;
            if (lastSelected != null) {
                lastSelected.setSelected(false);
            }
            contributionPanel.setSelected(true);
            this.updateColors();
            this.requestFocusInWindow();
        }
    }

    protected DetailPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    protected void updateColors() {
        int count = 0;
        for (Map.Entry<Contribution, DetailPanel> entry : this.panelByContribution.entrySet()) {
            DetailPanel panel = entry.getValue();
            if (panel.isVisible() && panel.isSelected()) {
                panel.setBackground(UIManager.getColor("List.selectionBackground"));
                panel.setForeground(UIManager.getColor("List.selectionForeground"));
                panel.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
                ++count;
                continue;
            }
            Border border = null;
            if (panel.isVisible()) {
                if (Platform.isMacOS()) {
                    border = count % 2 == 1 ? UIManager.getBorder("List.oddRowBackgroundPainter") : UIManager.getBorder("List.evenRowBackgroundPainter");
                } else if (count % 2 == 1) {
                    panel.setBackground(new Color(219, 224, 229));
                } else {
                    panel.setBackground(new Color(241, 241, 241));
                }
                ++count;
            }
            if (border == null) {
                border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            }
            panel.setBorder(border);
            panel.setForeground(UIManager.getColor("List.foreground"));
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int blockAmount = visibleRect.height;
            visibleRect.y = direction > 0 ? (visibleRect.y += blockAmount) : (visibleRect.y -= blockAmount);
            return blockAmount += this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lastHeight = 0;
            int height = 0;
            int bottomOfScrollArea = visibleRect.y + visibleRect.height;
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c.isVisible() && c instanceof DetailPanel) {
                    Dimension d = c.getPreferredSize();
                    int nextHeight = height + d.height;
                    if (direction > 0) {
                        if (nextHeight > bottomOfScrollArea) {
                            return nextHeight - bottomOfScrollArea;
                        }
                    } else if (nextHeight > visibleRect.y) {
                        if (visibleRect.y != height) {
                            return visibleRect.y - height;
                        }
                        return visibleRect.y - lastHeight;
                    }
                    lastHeight = height;
                    height = nextHeight;
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getRowCount() {
        return this.panelByContribution.size();
    }

    class ContribHeaderRenderer
    extends DefaultTableCellRenderer {
        public ContribHeaderRenderer() {
            this.setHorizontalTextPosition(2);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JTableHeader tableHeader = table.getTableHeader();
            if (tableHeader != null) {
                this.setForeground(tableHeader.getForeground());
            }
            this.setFont(ManagerFrame.SMALL_PLAIN);
            this.setIcon(this.getSortIcon(table, column));
            this.setBackground(HEADER_BGCOLOR);
            this.setBorder(null);
            return this;
        }

        protected Icon getSortIcon(JTable table, int column) {
            RowSorter.SortKey sortKey = this.getSortKey(table, column);
            if (sortKey != null && table.convertColumnIndexToView(sortKey.getColumn()) == column) {
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        return UIManager.getIcon("Table.ascendingSortIcon");
                    }
                    case DESCENDING: {
                        return UIManager.getIcon("Table.descendingSortIcon");
                    }
                }
            }
            return null;
        }

        protected RowSorter.SortKey getSortKey(JTable table, int column) {
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            if (rowSorter == null) {
                return null;
            }
            List<RowSorter.SortKey> sortedColumns = rowSorter.getSortKeys();
            if (sortedColumns.size() > 0) {
                return sortedColumns.get(0);
            }
            return null;
        }
    }

    private class ContribStatusRenderer
    extends DefaultTableCellRenderer {
        private ContribStatusRenderer() {
        }

        @Override
        public void setVerticalAlignment(int alignment) {
            super.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Contribution contribution = (Contribution)value;
            JLabel label = new JLabel();
            if (value == null) {
                return label;
            }
            if (column == 0) {
                Icon icon = null;
                label.setFont(ManagerFrame.NORMAL_PLAIN);
                if (contribution.isInstalled()) {
                    icon = upToDateIcon;
                    if (ListPanel.this.contribListing.hasUpdates(contribution)) {
                        icon = updateAvailableIcon;
                    }
                    if (!contribution.isCompatible(Base.getRevision())) {
                        icon = incompatibleIcon;
                    }
                }
                if (ListPanel.this.panelByContribution.get((Object)contribution).updateInProgress || ListPanel.this.panelByContribution.get((Object)contribution).installInProgress) {
                    label.setIcon(downloadingIcon);
                } else {
                    label.setIcon(icon);
                }
                label.setHorizontalAlignment(0);
                if (isSelected) {
                    label.setBackground(new Color(14745597));
                }
                label.setOpaque(true);
            } else if (column == 1) {
                Font boldFont = ManagerFrame.NORMAL_BOLD;
                String fontFace = "<font face=\"" + boldFont.getName() + "\">";
                FontMetrics fontMetrics = table.getFontMetrics(boldFont);
                int colSize = table.getColumnModel().getColumn(1).getWidth();
                String sentence = contribution.getSentence();
                int currentWidth = table.getFontMetrics(boldFont).stringWidth(String.valueOf(contribution.getName()) + " | ");
                int ellipsesWidth = fontMetrics.stringWidth("...");
                String name = "<html><body>" + fontFace + contribution.getName();
                if (sentence == null) {
                    label.setText(String.valueOf(name) + "</font></body></html>");
                } else {
                    sentence = " | </font>" + sentence;
                    currentWidth += ellipsesWidth;
                    int i = 0;
                    i = 0;
                    while (i < sentence.length()) {
                        if ((currentWidth += fontMetrics.charWidth(sentence.charAt(i))) >= colSize) break;
                        ++i;
                    }
                    if (i != sentence.length()) {
                        label.setText(String.valueOf(name) + sentence.substring(0, i) + "...</body></html>");
                    } else {
                        label.setText(String.valueOf(name) + sentence + "</body></html>");
                    }
                }
                if (!contribution.isCompatible(Base.getRevision())) {
                    label.setForeground(Color.LIGHT_GRAY);
                }
                if (table.isRowSelected(row)) {
                    label.setBackground(new Color(14745597));
                }
                label.setFont(ManagerFrame.NORMAL_PLAIN);
                label.setOpaque(true);
            } else {
                label = contribution.isSpecial() ? new JLabel(foundationIcon) : new JLabel();
                String authorList = contribution.getAuthorList();
                String name = ListPanel.this.getAuthorNameWithoutMarkup(authorList);
                label.setText(name);
                label.setHorizontalAlignment(2);
                if (!contribution.isCompatible(Base.getRevision())) {
                    label.setForeground(Color.LIGHT_GRAY);
                } else {
                    label.setForeground(Color.BLACK);
                }
                if (table.isRowSelected(row)) {
                    label.setBackground(new Color(14745597));
                }
                label.setFont(ManagerFrame.NORMAL_BOLD);
                label.setOpaque(true);
            }
            return label;
        }
    }

    private static class ContribTableModel
    extends DefaultTableModel {
        private ContribTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Contribution.class;
        }
    }
}

