/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import processing.app.Base;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionTab;
import processing.app.contrib.ContributionType;
import processing.app.contrib.DetailPanel;
import processing.app.contrib.ListPanel;
import processing.app.contrib.ManagerFrame;
import processing.app.contrib.UpdateContributionTab;
import processing.app.contrib.UpdateStatusPanel;

public class UpdateListPanel
extends ListPanel {
    static final Color SECTION_COLOR = new Color(-460552);
    static final String[] PLURAL_TYPES = new String[]{ContributionType.LIBRARY.getPluralTitle(), ContributionType.MODE.getPluralTitle(), ContributionType.TOOL.getPluralTitle(), ContributionType.EXAMPLES.getPluralTitle()};
    Set<String> sectionNames = new HashSet<String>(Arrays.asList(PLURAL_TYPES));

    public UpdateListPanel(ContributionTab contributionTab, Contribution.Filter filter) {
        this.contributionTab = contributionTab;
        this.filter = filter;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex == 0 ? Icon.class : String.class;
            }
        };
        this.model.setColumnIdentifiers(new String[]{"", "Name", "Author", "Installed", "Available"});
        this.table = new JTable(this.model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                String title = (String)this.getValueAt(row, 1);
                if (UpdateListPanel.this.sectionNames.contains(title)) {
                    c.setBackground(SECTION_COLOR);
                } else {
                    c.setBackground(Color.WHITE);
                }
                return c;
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                String title = (String)this.getValueAt(rowIndex, 1);
                if (!UpdateListPanel.this.sectionNames.contains(title)) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionBackground(new Color(14745597));
        this.table.setSelectionForeground(this.table.getForeground());
        this.table.setFont(ManagerFrame.NORMAL_PLAIN);
        this.table.setRowHeight(30);
        this.table.setRowMargin(6);
        this.table.getColumnModel().setColumnMargin(-1);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.setShowGrid(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
        });
        this.table.getTableHeader().setDefaultRenderer(new ListPanel.ContribHeaderRenderer());
        GroupLayout layout = new GroupLayout(this);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.scrollPane));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.scrollPane));
        this.setLayout(layout);
        this.table.setVisible(true);
        this.panelByContribution = new TreeMap(new Comparator<Contribution>(){

            @Override
            public int compare(Contribution o1, Contribution o2) {
                int diff = ContributionManager.getTypeIndex(o1.getType()) - ContributionManager.getTypeIndex(o2.getType());
                if (diff == 0) {
                    diff = o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
                return diff;
            }
        });
    }

    @Override
    void updatePanelOrdering(Set<Contribution> contributionsSet) {
        this.model.getDataVector().removeAllElements();
        ContributionType currentType = null;
        String fontFace = "<font face=\"" + ManagerFrame.NORMAL_BOLD.getName() + "\">";
        for (Contribution entry : contributionsSet) {
            if (entry.getType() != currentType) {
                currentType = entry.getType();
                Object[] objectArray = new Object[5];
                objectArray[1] = currentType.getPluralTitle();
                this.model.addRow(objectArray);
            }
            StringBuilder name = new StringBuilder("");
            String authorList = entry.getAuthorList();
            if (authorList != null) {
                int i = 0;
                while (i < authorList.length()) {
                    if (authorList.charAt(i) != '[' && authorList.charAt(i) != ']') {
                        if (authorList.charAt(i) == '(') {
                            ++i;
                            while (authorList.charAt(i) != ')') {
                                ++i;
                            }
                        } else {
                            name.append(authorList.charAt(i));
                        }
                    }
                    ++i;
                }
            }
            Icon icon = null;
            if (entry.isInstalled()) {
                icon = upToDateIcon;
                if (this.contribListing.hasUpdates(entry)) {
                    icon = updateAvailableIcon;
                }
                if (!entry.isCompatible(Base.getRevision())) {
                    icon = incompatibleIcon;
                }
            }
            if (((DetailPanel)this.panelByContribution.get((Object)entry)).updateInProgress || ((DetailPanel)this.panelByContribution.get((Object)entry)).installInProgress) {
                icon = downloadingIcon;
            }
            this.model.addRow(new Object[]{icon, "<html>" + fontFace + entry.getName() + "</font></html>", name, entry.getBenignVersion(), this.contributionTab.contribListing.getLatestPrettyVersion(entry)});
        }
        this.model.fireTableDataChanged();
        UpdateContributionTab tab = (UpdateContributionTab)this.contributionTab;
        ((UpdateStatusPanel)tab.statusPanel).update();
    }

    @Override
    public void contributionAdded(Contribution contribution) {
        if (this.filter.matches(contribution)) {
            DetailPanel newPanel = this.contributionTab.contribDialog.getTab((ContributionType)contribution.getType()).contributionListPanel.panelByContribution.get(contribution);
            if (newPanel == null) {
                newPanel = new DetailPanel(this);
            }
            if (!this.panelByContribution.containsKey(contribution)) {
                this.panelByContribution.put(contribution, newPanel);
            }
            this.visibleContributions.add(contribution);
            newPanel.setContribution(contribution);
            this.add(newPanel);
            this.updatePanelOrdering(this.panelByContribution.keySet());
            this.updateColors();
        }
    }

    @Override
    public void contributionChanged(Contribution oldContrib, Contribution newContrib) {
        DetailPanel panel = (DetailPanel)this.panelByContribution.get(oldContrib);
        if (panel == null) {
            this.contributionAdded(newContrib);
        } else if (newContrib.isInstalled()) {
            this.panelByContribution.remove(oldContrib);
            this.visibleContributions.remove(oldContrib);
        }
        this.updatePanelOrdering(this.visibleContributions);
    }
}

