/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import processing.app.Preferences;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarkerState;
import processing.app.syntax.im.CompositionTextPainter;
import processing.app.ui.Toolkit;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    protected CompositionTextPainter compositionTextPainter;
    protected JEditTextArea textArea;
    protected TextAreaDefaults defaults;
    private Font plainFont;
    private Font boldFont;
    private boolean antialias;
    protected int tabSize;
    protected FontMetrics fm;
    protected Highlight highlights;
    int currentLineIndex;
    Token currentLineTokens;
    Segment currentLine;

    public TextAreaPainter(JEditTextArea textArea, TextAreaDefaults defaults) {
        this.textArea = textArea;
        this.defaults = defaults;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.updateAppearance();
    }

    public void updateAppearance() {
        this.setForeground(this.defaults.fgcolor);
        this.setBackground(this.defaults.bgcolor);
        Toolkit.getMonoFontName();
        String fontFamily = Preferences.get("editor.font.family");
        int fontSize = Toolkit.zoom(Preferences.getInteger("editor.font.size"));
        this.plainFont = new Font(fontFamily, 0, fontSize);
        if (!fontFamily.equals(this.plainFont.getFamily())) {
            System.err.println(String.valueOf(fontFamily) + " not available, resetting to monospaced");
            fontFamily = "Monospaced";
            Preferences.set("editor.font.family", fontFamily);
            this.plainFont = new Font(fontFamily, 0, fontSize);
        }
        this.boldFont = new Font(fontFamily, 1, fontSize);
        this.antialias = Preferences.getBoolean("editor.smooth");
        this.fm = super.getFontMetrics(this.plainFont);
        this.tabSize = this.fm.charWidth(' ') * Preferences.getInteger("editor.tabs.size");
        this.textArea.recalculateVisibleLines();
    }

    public CompositionTextPainter getCompositionTextpainter() {
        if (this.compositionTextPainter == null) {
            this.compositionTextPainter = new CompositionTextPainter(this.textArea);
        }
        return this.compositionTextPainter;
    }

    public final SyntaxStyle[] getStyles() {
        return this.defaults.styles;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.defaults.lineHighlight = lineHighlight;
        this.invalidateSelectedLines();
    }

    public final boolean isBracketHighlightEnabled() {
        return this.defaults.bracketHighlight;
    }

    public final boolean isBlockCaretEnabled() {
        return this.defaults.blockCaret;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public FontMetrics getFontMetrics(SyntaxStyle style) {
        return this.getFontMetrics(style.isBold() ? this.boldFont : this.plainFont);
    }

    public int getLineHeight() {
        return this.fm.getHeight() + this.fm.getDescent();
    }

    @Override
    public void paint(Graphics gfx) {
        Graphics2D g2 = (Graphics2D)gfx;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        int height = this.fm.getHeight();
        int firstLine = this.textArea.getFirstLine();
        int firstInvalid = firstLine + clipRect.y / height;
        int lastInvalid = firstLine + (clipRect.y + clipRect.height - 1) / height;
        try {
            TokenMarkerState tokenMarker = this.textArea.getDocument().getTokenMarker();
            int x = this.textArea.getHorizontalOffset();
            int line = firstInvalid;
            while (line <= lastInvalid) {
                this.paintLine(gfx, line, x, tokenMarker);
                ++line;
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                int h = clipRect.y + clipRect.height;
                this.repaint(0, h, this.getWidth(), this.getHeight() - h);
            }
        }
        catch (Exception e) {
            System.err.println("Error repainting line range {" + firstInvalid + "," + lastInvalid + "}:");
            e.printStackTrace();
        }
    }

    public final void invalidateLine(int line) {
        this.repaint(0, this.textArea.lineToY(line) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), this.fm.getHeight());
    }

    final void invalidateLineRange(int firstLine, int lastLine) {
        this.repaint(0, this.textArea.lineToY(firstLine) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), (lastLine - firstLine + 1) * this.fm.getHeight());
    }

    final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionStopLine());
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int offset = this.textArea.getHorizontalOffset();
        int ntabs = ((int)x - offset) / this.tabSize;
        return (ntabs + 1) * this.tabSize + offset;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fm.charWidth('w') * this.defaults.cols, this.fm.getHeight() * this.defaults.rows);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getCurrentLineIndex() {
        return this.currentLineIndex;
    }

    public void setCurrentLineIndex(int what) {
        this.currentLineIndex = what;
    }

    public Token getCurrentLineTokens() {
        return this.currentLineTokens;
    }

    public void setCurrentLineTokens(Token tokens) {
        this.currentLineTokens = tokens;
    }

    public Segment getCurrentLine() {
        return this.currentLine;
    }

    protected void paintLine(Graphics gfx, int line, int x, TokenMarkerState tokenMarker) {
        this.currentLineIndex = line;
        int y = this.textArea.lineToY(line);
        if (tokenMarker == null) {
            this.paintPlainLine(gfx, line, x, y);
        } else if (line >= 0 && line < this.textArea.getLineCount()) {
            this.paintSyntaxLine(gfx, line, x, y, tokenMarker);
        }
    }

    protected void paintPlainLine(Graphics gfx, int line, int x, int y) {
        this.paintHighlight(gfx, line, y);
        this.textArea.getLineText(line, this.currentLine);
        int x0 = x - this.textArea.getHorizontalOffset();
        y += this.fm.getHeight();
        int i = 0;
        while (i < this.currentLine.count) {
            gfx.drawChars(this.currentLine.array, this.currentLine.offset + i, 1, x, y);
            x = this.currentLine.array[this.currentLine.offset + i] == '\t' ? x0 + (int)this.nextTabStop(x - x0, i) : x + this.fm.charWidth(this.currentLine.array[this.currentLine.offset + i]);
            this.textArea.offsetToX(line, this.currentLine.offset + i);
            ++i;
        }
        if (this.compositionTextPainter != null && this.compositionTextPainter.hasComposedTextLayout()) {
            this.compositionTextPainter.draw(gfx, this.defaults.lineHighlightColor);
        }
        if (this.defaults.eolMarkers) {
            gfx.setColor(this.defaults.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected void paintSyntaxLine(Graphics gfx, int line, int x, int y, TokenMarkerState tokenMarker) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(gfx, line, y);
        x = this.paintSyntaxLine(gfx, this.currentLine, x, y += this.fm.getHeight(), this.currentLineTokens, this.defaults.styles);
        if (this.compositionTextPainter != null && this.compositionTextPainter.hasComposedTextLayout()) {
            this.compositionTextPainter.draw(gfx, this.defaults.lineHighlightColor);
        }
        if (this.defaults.eolMarkers) {
            gfx.setColor(this.defaults.eolMarkerColor);
            gfx.drawString(".", x, y);
        }
    }

    protected int paintSyntaxLine(Graphics gfx, Segment line, int x, int y, Token tokens, SyntaxStyle[] styles) {
        byte id;
        int x0 = x - this.textArea.getHorizontalOffset();
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                gfx.setColor(this.defaults.fgcolor);
                gfx.setFont(this.plainFont);
            } else {
                SyntaxStyle ss = styles[id];
                gfx.setColor(ss.getColor());
                gfx.setFont(ss.isBold() ? this.boldFont : this.plainFont);
            }
            line.count = length;
            int i = 0;
            while (i < line.count) {
                gfx.drawChars(line.array, line.offset + i, 1, x, y);
                x = line.array[line.offset + i] == '\t' ? x0 + (int)this.nextTabStop(x - x0, i) : x + this.fm.charWidth(line.array[line.offset + i]);
                ++i;
            }
            line.offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    protected void paintHighlight(Graphics gfx, int line, int y) {
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionStopLine()) {
            this.paintLineHighlight(gfx, line, y);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(gfx, line, y);
        }
        if (this.defaults.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(gfx, line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(gfx, line, y);
        }
    }

    protected void paintLineHighlight(Graphics gfx, int line, int y) {
        int selectionEnd;
        int height = this.fm.getHeight();
        y += this.fm.getLeading() + this.fm.getMaxDescent();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart == (selectionEnd = this.textArea.getSelectionStop())) {
            if (this.defaults.lineHighlight) {
                gfx.setColor(this.defaults.lineHighlightColor);
                gfx.fillRect(0, y, this.getWidth(), height);
            }
        } else {
            int x2;
            int x1;
            gfx.setColor(this.defaults.selectionColor);
            int selectionStartLine = this.textArea.getSelectionStartLine();
            int selectionEndLine = this.textArea.getSelectionStopLine();
            int lineStart = this.textArea.getLineStartOffset(line);
            if (selectionStartLine == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else if (line == selectionStartLine) {
                x1 = this.textArea._offsetToX(line, selectionStart - lineStart);
                x2 = this.getWidth();
            } else if (line == selectionEndLine) {
                x1 = this.textArea._offsetToX(line, 0);
                x2 = this.textArea._offsetToX(line, selectionEnd - lineStart);
            } else {
                x1 = this.textArea._offsetToX(line, 0);
                x2 = this.getWidth();
            }
            gfx.fillRect(x1 > x2 ? x2 : x1, y, x1 > x2 ? x1 - x2 : x2 - x1, height);
        }
    }

    protected void paintBracketHighlight(Graphics gfx, int line, int y) {
        int position = this.textArea.getBracketPosition();
        if (position != -1) {
            int x = this.textArea._offsetToX(line, position);
            gfx.setColor(this.defaults.bracketHighlightColor);
            gfx.drawRect(x, y += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
        }
    }

    protected void paintCaret(Graphics gfx, int line, int y) {
        if (this.textArea.isCaretVisible()) {
            int offset = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
            int caretX = this.textArea._offsetToX(line, offset);
            int caretWidth = this.defaults.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
            y += this.fm.getLeading() + this.fm.getMaxDescent();
            int height = this.fm.getHeight();
            gfx.setColor(this.defaults.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                gfx.fillRect(caretX, y + height - 1, caretWidth, 1);
            } else if (caretWidth == 1) {
                gfx.drawLine(caretX, y, caretX, y + height - 1);
            } else {
                gfx.drawRect(caretX, y, caretWidth - 1, height - 1);
            }
        }
    }

    public int getScrollWidth() {
        return super.getWidth();
    }

    public static interface Highlight {
        public void init(JEditTextArea var1, Highlight var2);

        public void paintHighlight(Graphics var1, int var2, int var3);

        public String getToolTipText(MouseEvent var1);
    }
}

