/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;

public class EditorHeader
extends JComponent {
    static final int HIGH = Toolkit.zoom(29);
    static final int ARROW_TAB_WIDTH = Toolkit.zoom(18);
    static final int ARROW_TOP = Toolkit.zoom(11);
    static final int ARROW_BOTTOM = Toolkit.zoom(18);
    static final int ARROW_WIDTH = Toolkit.zoom(6);
    static final int CURVE_RADIUS = Toolkit.zoom(6);
    static final int TAB_TOP = 0;
    static final int TAB_BOTTOM = Toolkit.zoom(27);
    static final int TAB_BETWEEN = Toolkit.zoom(3);
    static final int TEXT_MARGIN = Toolkit.zoom(16);
    static final int NO_TEXT_WIDTH = Toolkit.zoom(16);
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    Color modifiedColor;
    Color arrowColor;
    Editor editor;
    Tab[] tabs = new Tab[0];
    Tab[] visitOrder;
    Font font;
    int fontAscent;
    JMenu menu;
    JPopupMenu popup;
    int menuLeft;
    int menuRight;
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    String lastNoticeName;
    Image gradient;

    public EditorHeader(Editor eddie) {
        this.editor = eddie;
        this.updateMode();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > EditorHeader.this.menuLeft && x < EditorHeader.this.menuRight) {
                    EditorHeader.this.popup.show(EditorHeader.this, x, y);
                } else {
                    Sketch sketch = EditorHeader.this.editor.getSketch();
                    Tab[] tabArray = EditorHeader.this.tabs;
                    int n = EditorHeader.this.tabs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Tab tab = tabArray[n2];
                        if (tab.contains(x)) {
                            sketch.setCurrentCode(tab.index);
                            EditorHeader.this.repaint();
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (EditorHeader.this.lastNoticeName != null) {
                    EditorHeader.this.editor.clearNotice(EditorHeader.this.lastNoticeName);
                    EditorHeader.this.lastNoticeName = null;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                Tab[] tabArray = EditorHeader.this.tabs;
                int n = EditorHeader.this.tabs.length;
                int n2 = 0;
                while (n2 < n) {
                    Tab tab = tabArray[n2];
                    if (tab.contains(x) && !tab.textVisible) {
                        EditorHeader.this.lastNoticeName = EditorHeader.this.editor.getSketch().getCode(tab.index).getPrettyName();
                        EditorHeader.this.editor.statusNotice(EditorHeader.this.lastNoticeName);
                    }
                    ++n2;
                }
            }
        });
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.textColor[1] = mode.getColor("header.text.selected.color");
        this.textColor[0] = mode.getColor("header.text.unselected.color");
        this.font = mode.getFont("header.text.font");
        this.tabColor[1] = mode.getColor("header.tab.selected.color");
        this.tabColor[0] = mode.getColor("header.tab.unselected.color");
        this.arrowColor = mode.getColor("header.tab.arrow.color");
        this.modifiedColor = mode.getColor("header.tab.modified.color");
        this.gradient = mode.makeGradient("header", 400, HIGH);
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (screen == null) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        if (sketch == null) {
            return;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = Toolkit.offscreenGraphics(this, this.imageW, this.imageH);
        }
        Graphics g = this.offscreen.getGraphics();
        g.setFont(this.font);
        if (this.fontAscent == 0) {
            this.fontAscent = (int)Toolkit.getAscent(g);
        }
        Graphics2D g2 = Toolkit.prepareGraphics(g);
        g.drawImage(this.gradient, 0, 0, this.imageW, this.imageH, this);
        if (this.tabs.length != sketch.getCodeCount()) {
            this.tabs = new Tab[sketch.getCodeCount()];
            int i = 0;
            while (i < this.tabs.length) {
                this.tabs[i] = new Tab(i);
                ++i;
            }
            this.visitOrder = new Tab[sketch.getCodeCount() - 1];
        }
        int leftover = TAB_BETWEEN + ARROW_TAB_WIDTH;
        int tabMax = this.getWidth() - leftover;
        Tab[] tabArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            SketchCode code = sketch.getCode(tab.index);
            tab.textVisible = true;
            tab.lastVisited = code.lastVisited();
            boolean hide = this.editor.getMode().hideExtension(code.getExtension());
            tab.text = hide ? code.getPrettyName() : code.getFileName();
            tab.textWidth = (int)this.font.getStringBounds(tab.text, g2.getFontRenderContext()).getWidth();
            ++n2;
        }
        if (!this.placeTabs(Editor.LEFT_GUTTER, tabMax, null)) {
            int index = 0;
            int i = this.tabs.length - 1;
            while (i > 0) {
                this.visitOrder[index++] = this.tabs[i];
                --i;
            }
            Arrays.sort(this.visitOrder);
            i = 0;
            while (i < this.visitOrder.length) {
                this.tabs[this.visitOrder[i].index].textVisible = false;
                if (this.placeTabs(Editor.LEFT_GUTTER, tabMax, null)) break;
                ++i;
            }
        }
        if (!this.placeTabs(Editor.LEFT_GUTTER, tabMax - ARROW_TAB_WIDTH, g2)) {
            this.menuRight = tabMax;
            this.menuLeft = this.menuRight - ARROW_TAB_WIDTH;
        } else {
            this.menuLeft = this.tabs[this.tabs.length - 1].right + TAB_BETWEEN;
            this.menuRight = this.menuLeft + ARROW_TAB_WIDTH;
        }
        g.setColor(this.tabColor[1]);
        g.fillRect(Editor.LEFT_GUTTER, TAB_BOTTOM, this.editor.getTextArea().getWidth() - Editor.LEFT_GUTTER, Toolkit.zoom(2));
        g.setColor(this.tabColor[0]);
        this.drawTab(g, this.menuLeft, this.menuRight, false, true);
        g.setColor(this.arrowColor);
        GeneralPath trianglePath = new GeneralPath();
        float x1 = (float)this.menuLeft + (float)(ARROW_TAB_WIDTH - ARROW_WIDTH) / 2.0f;
        float x2 = (float)this.menuLeft + (float)(ARROW_TAB_WIDTH + ARROW_WIDTH) / 2.0f;
        trianglePath.moveTo(x1, ARROW_TOP);
        trianglePath.lineTo(x2, ARROW_TOP);
        trianglePath.lineTo((x1 + x2) / 2.0f, ARROW_BOTTOM);
        trianglePath.closePath();
        g2.fill(trianglePath);
        screen.drawImage(this.offscreen, 0, 0, this.imageW, this.imageH, null);
    }

    private boolean placeTabs(int left, int right, Graphics2D g) {
        Sketch sketch = this.editor.getSketch();
        int x = left;
        int i = 0;
        while (i < sketch.getCodeCount()) {
            SketchCode code = sketch.getCode(i);
            Tab tab = this.tabs[i];
            int state = code == sketch.getCurrentCode() ? 1 : 0;
            tab.left = x;
            x += TEXT_MARGIN;
            int drawWidth = tab.textVisible ? tab.textWidth : NO_TEXT_WIDTH;
            tab.right = x += drawWidth + TEXT_MARGIN;
            if (g != null && tab.right < right) {
                g.setColor(this.tabColor[state]);
                this.drawTab(g, tab.left, tab.right, i == 0, false);
                if (tab.textVisible) {
                    int textLeft = tab.left + (tab.right - tab.left - tab.textWidth) / 2;
                    g.setColor(this.textColor[state]);
                    int tabHeight = TAB_BOTTOM - 0;
                    int baseline = 0 + (tabHeight + this.fontAscent) / 2;
                    g.drawString(tab.text, textLeft, baseline);
                }
                if (code.isModified()) {
                    g.setColor(this.modifiedColor);
                    g.drawLine(tab.right, 0, tab.right, TAB_BOTTOM);
                }
            }
            x += TAB_BETWEEN;
            ++i;
        }
        return x <= right;
    }

    private void drawTab(Graphics g, int left, int right, boolean leftNotch, boolean rightNotch) {
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(Toolkit.createRoundRect(left, 0.0f, right, TAB_BOTTOM, leftNotch ? CURVE_RADIUS : 0, rightNotch ? CURVE_RADIUS : 0, 0.0f, 0.0f));
    }

    public void rebuild() {
        this.rebuildMenu();
        this.repaint();
    }

    public void rebuildMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu();
            this.popup = this.menu.getPopupMenu();
            this.add(this.popup);
            this.popup.setLightWeightPopupEnabled(true);
        }
        JRootPane rootPane = this.editor.getRootPane();
        InputMap inputMap = rootPane.getInputMap(1);
        ActionMap actionMap = rootPane.getActionMap();
        JMenuItem item = Toolkit.newJMenuItemShift(Language.text("editor.header.new_tab"), 78);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleNewCode();
            }
        };
        String mapKey = "editor.header.new_tab";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(78, Toolkit.SHORTCUT_SHIFT_KEY_MASK);
        inputMap.put(keyStroke, mapKey);
        actionMap.put(mapKey, action);
        item.addActionListener(action);
        this.menu.add(item);
        item = new JMenuItem(Language.text("editor.header.rename"));
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleRenameCode();
            }
        };
        item.addActionListener(action);
        this.menu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("editor.header.delete"), 68);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sketch sketch = EditorHeader.this.editor.getSketch();
                if (!Platform.isMacOS() && EditorHeader.this.editor.base.getEditors().size() == 1 && sketch.getCurrentCodeIndex() == 0) {
                    Messages.showWarning(Language.text("editor.header.delete.warning.title"), Language.text("editor.header.delete.warning.text"));
                } else {
                    EditorHeader.this.editor.getSketch().handleDeleteCode();
                }
            }
        };
        mapKey = "editor.header.delete";
        keyStroke = KeyStroke.getKeyStroke(68, Toolkit.SHORTCUT_SHIFT_KEY_MASK);
        inputMap.put(keyStroke, mapKey);
        actionMap.put(mapKey, action);
        item.addActionListener(action);
        this.menu.add(item);
        this.menu.addSeparator();
        String prevTab = Language.text("editor.header.previous_tab");
        item = Platform.isLinux() ? Toolkit.newJMenuItem(prevTab, 33) : Toolkit.newJMenuItemAlt(prevTab, 37);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handlePrevCode();
            }
        };
        mapKey = "editor.header.previous_tab";
        keyStroke = Platform.isLinux() ? KeyStroke.getKeyStroke(33, Toolkit.SHORTCUT_KEY_MASK) : KeyStroke.getKeyStroke(37, Toolkit.SHORTCUT_ALT_KEY_MASK);
        inputMap.put(keyStroke, mapKey);
        actionMap.put(mapKey, action);
        item.addActionListener(action);
        this.menu.add(item);
        String nextTab = Language.text("editor.header.next_tab");
        item = Platform.isLinux() ? Toolkit.newJMenuItem(nextTab, 34) : Toolkit.newJMenuItemAlt(nextTab, 39);
        action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorHeader.this.editor.getSketch().handleNextCode();
            }
        };
        mapKey = "editor.header.next_tab";
        keyStroke = Platform.isLinux() ? KeyStroke.getKeyStroke(34, Toolkit.SHORTCUT_KEY_MASK) : KeyStroke.getKeyStroke(39, Toolkit.SHORTCUT_ALT_KEY_MASK);
        inputMap.put(keyStroke, mapKey);
        actionMap.put(mapKey, action);
        item.addActionListener(action);
        this.menu.add(item);
        Sketch sketch = this.editor.getSketch();
        if (sketch != null) {
            this.menu.addSeparator();
            ActionListener jumpListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorHeader.this.editor.getSketch().setCurrentCode(e.getActionCommand());
                }
            };
            SketchCode[] sketchCodeArray = sketch.getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode code = sketchCodeArray[n2];
                item = new JMenuItem(code.getPrettyName());
                item.addActionListener(jumpListener);
                this.menu.add(item);
                ++n2;
            }
        }
        Toolkit.setMenuMnemonics(this.menu);
    }

    public void deselectMenu() {
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, HIGH);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, HIGH);
    }

    static class Tab
    implements Comparable {
        int index;
        int left;
        int right;
        String text;
        int textWidth;
        boolean textVisible;
        long lastVisited;

        Tab(int index) {
            this.index = index;
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        public int compareTo(Object o) {
            Tab other = (Tab)o;
            if (this.lastVisited == other.lastVisited) {
                return 0;
            }
            if (this.lastVisited == 0L) {
                return -1;
            }
            if (other.lastVisited == 0L) {
                return 1;
            }
            return (int)(this.lastVisited - other.lastVisited);
        }
    }
}

