/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.ui.Editor;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class EditorStatus
extends BasicSplitPaneDivider {
    static final int HIGH = Toolkit.zoom(28);
    static final int LEFT_MARGIN = Editor.LEFT_GUTTER;
    static final int RIGHT_MARGIN = Toolkit.zoom(20);
    Color urlColor;
    Color[] fgColor;
    Color[] bgColor;
    Image[] bgImage;
    public static final int ERROR = 1;
    public static final int CURSOR_LINE_ERROR = 2;
    public static final int WARNING = 3;
    public static final int CURSOR_LINE_WARNING = 4;
    public static final int NOTICE = 0;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    Editor editor;
    int mode;
    String message = "";
    String url;
    int rightEdge;
    int mouseX;
    boolean urlRollover;
    Font font;
    FontMetrics metrics;
    int ascent;
    static final int EMOJI_OFFSET = 27;
    Font emojiFont;
    int emojiLeft;
    boolean emojiRollover;
    Image offscreen;
    int sizeW;
    int sizeH;
    int response;
    boolean indeterminate;
    Thread thread;

    public EditorStatus(BasicSplitPaneUI ui, Editor editor) {
        super(ui);
        this.editor = editor;
        this.empty();
        this.updateMode();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                EditorStatus.this.updateMouse();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorStatus.this.urlRollover) {
                    Platform.openURL(EditorStatus.this.url);
                } else if (EditorStatus.this.emojiRollover) {
                    if (e.isShiftDown()) {
                        String fmt = Preferences.get("search.format");
                        Platform.openURL(String.format(fmt, PApplet.urlEncode((String)EditorStatus.this.message)));
                    } else {
                        Clipboard clipboard = EditorStatus.this.getToolkit().getSystemClipboard();
                        clipboard.setContents(new StringSelection(EditorStatus.this.message), null);
                        System.out.println("Copied to the clipboard. Use shift-click to search the web instead.");
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EditorStatus.this.updateMouse();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                EditorStatus.this.mouseX = e.getX();
                EditorStatus.this.updateMouse();
            }
        });
    }

    void updateMouse() {
        if (this.urlRollover) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (this.emojiRollover) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        this.repaint();
    }

    static String findURL(String message) {
        String[] m = PApplet.match((String)message, (String)"http\\S+");
        if (m != null) {
            return m[0];
        }
        return null;
    }

    public void updateMode() {
        Mode mode = this.editor.getMode();
        this.urlColor = mode.getColor("status.url.fgcolor");
        this.fgColor = new Color[]{mode.getColor("status.notice.fgcolor"), mode.getColor("status.error.fgcolor"), mode.getColor("status.error.fgcolor"), mode.getColor("status.warning.fgcolor"), mode.getColor("status.warning.fgcolor")};
        this.bgColor = new Color[]{mode.getColor("status.notice.bgcolor"), mode.getColor("status.error.bgcolor"), mode.getColor("status.error.bgcolor"), mode.getColor("status.warning.bgcolor"), mode.getColor("status.warning.bgcolor")};
        this.bgImage = new Image[]{mode.loadImage("/lib/status/notice.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/error.png"), mode.loadImage("/lib/status/warning.png"), mode.loadImage("/lib/status/warning.png")};
        this.font = mode.getFont("status.font");
        this.emojiFont = mode.getFont("status.emoji.font");
        this.metrics = null;
    }

    public void empty() {
        this.mode = 0;
        this.message = "";
        this.url = null;
        this.repaint();
    }

    public void message(String message, int mode) {
        this.message = message;
        this.mode = mode;
        this.url = EditorStatus.findURL(message);
        this.repaint();
    }

    public void notice(String message) {
        this.message(message, 0);
    }

    public void warning(String message) {
        this.message(message, 3);
    }

    public void error(String message) {
        this.message(message, 1);
    }

    public void startIndeterminate() {
        this.indeterminate = true;
        this.thread = new Thread(){

            @Override
            public void run() {
                while (Thread.currentThread() == EditorStatus.this.thread) {
                    EditorStatus.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.thread.setName("Editor Status");
        this.thread.start();
    }

    public void stopIndeterminate() {
        this.indeterminate = false;
        this.thread = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics screen) {
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            this.offscreen = null;
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.offscreen = Toolkit.offscreenGraphics(this, this.sizeW, this.sizeH);
        }
        Graphics g = this.offscreen.getGraphics();
        Toolkit.prepareGraphics(g);
        g.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.drawImage(this.bgImage[this.mode], 0, 0, this.sizeW, this.sizeH, this);
        g.setColor(this.fgColor[this.mode]);
        if (this.message != null) {
            g.setFont(this.font);
            this.rightEdge = LEFT_MARGIN + g.getFontMetrics().stringWidth(this.message);
            boolean bl = this.urlRollover = this.url != null && this.mouseX > LEFT_MARGIN && this.mouseX < this.rightEdge;
            if (this.urlRollover) {
                g.setColor(this.urlColor);
            }
            g.drawString(this.message, LEFT_MARGIN, (this.sizeH + this.ascent) / 2);
        }
        if (this.indeterminate) {
            int w = Toolkit.getButtonWidth();
            int x = this.getWidth() - RIGHT_MARGIN - w;
            int y = this.getHeight() / 3;
            int h = this.getHeight() / 3;
            g.setColor(new Color(Integer.MIN_VALUE, true));
            g.drawRect(x, y, w, h);
            int i = 0;
            while (i < 10) {
                int r = (int)((double)x + Math.random() * (double)w);
                g.drawLine(r, y, r, y + h);
                ++i;
            }
        } else if (!this.message.isEmpty()) {
            g.setColor(Color.WHITE);
            g.setFont(this.emojiFont);
            this.emojiLeft = this.sizeW - Toolkit.zoom(27);
            g.drawString("\u2398", this.emojiLeft, (this.sizeH + this.ascent) / 2);
            this.emojiRollover = this.mouseX > this.emojiLeft - 4;
        }
        screen.drawImage(this.offscreen, 0, 0, this.sizeW, this.sizeH, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Toolkit.zoom(300), HIGH);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, HIGH);
    }
}

