Const
    cLibrary1 = 'Libraries\STMicroelectronics STM32 F2.IntLib';
    cLibrary2 = 'Libraries\Infineon - AURIX.IntLib';

Function GetFullLibraryPath(ALibrary: String) : String;
Var
    Plugin : IPluginsRegistryItem;
Begin
    Result := ALibrary;
    Plugin := Client.PluginsRegistry.FindItemByHRID('TaskingPinMapper');
    If Plugin = Nil Then Exit;
    Result := ExpandFileName(AddSlash(Plugin.Path) + Result);
End;

Procedure Install;
Begin
    If IntegratedLibraryManager <> Nil Then
    Begin
        IntegratedLibraryManager.InstallLibrary(GetFullLibraryPath(cLibrary1));
        IntegratedLibraryManager.InstallLibrary(GetFullLibraryPath(cLibrary2));
    End;
End;

Procedure Uninstall;
Begin
    If IntegratedLibraryManager <> Nil Then
    Begin
        IntegratedLibraryManager.UninstallLibrary(GetFullLibraryPath(cLibrary1));
        IntegratedLibraryManager.UninstallLibrary(GetFullLibraryPath(cLibrary2));
    End;
End;
