-- ----------------------------------------------------------------------------
-- Xilinx: MMCME2_BASE
-- ----------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
entity ReplaceWith_EntityName is
    port (
           CLKA   : out   std_logic;                    -- IncludeIf_CLKA
           CLKB   : out   std_logic;                    -- IncludeIf_CLKB
           CLKC   : out   std_logic;                    -- IncludeIf_CLKC
           CLKD   : out   std_logic;                    -- IncludeIf_CLKD
           CLKE   : out   std_logic;                    -- IncludeIf_CLKE
           CLKF   : out   std_logic;                    -- IncludeIf_CLKF
           CLKG   : out   std_logic;                    -- IncludeIf_CLKG                                                       
           LOCKED : out   std_logic;                   
           CLK    : in    std_logic;
           RST    : in    std_logic
    );
end;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
architecture RTL of ReplaceWith_EntityName is
    signal CLKFB_IN     : std_logic;
    signal CLKFB_BUF     : std_logic;
    signal GND_BIT      : std_logic;
    
    
    signal CLKA_BUF   : std_logic;                      
    signal CLKB_BUF   : std_logic;                      
    signal CLKC_BUF   : std_logic;                      
    signal CLKD_BUF   : std_logic;                      
    signal CLKE_BUF   : std_logic;                      
    signal CLKF_BUF   : std_logic;                                                              
    signal CLKG_BUF   : std_logic;                      
	
    component BUFG
        port (
            O : out std_ulogic;
            I : in std_ulogic
        );
    end component;

    component MMCME2_BASE
    generic 
    (
       BANDWIDTH : string     := "OPTIMIZED";  
       CLKFBOUT_MULT_F : integer := 5;    
       CLKFBOUT_PHASE  : real := 0.0;    
       CLKIN1_PERIOD   : real := 0.0;    
       CLKOUT1_DIVIDE  : integer := 1;
       CLKOUT2_DIVIDE  : integer := 1;
       CLKOUT3_DIVIDE  : integer := 1;
       CLKOUT4_DIVIDE  : integer := 1;
       CLKOUT5_DIVIDE  : integer := 1;
       CLKOUT6_DIVIDE  : integer := 1;
       CLKOUT0_DIVIDE_F : integer := 1; 
       CLKOUT0_DUTY_CYCLE : real := 0.5;
       CLKOUT1_DUTY_CYCLE : real := 0.5;
       CLKOUT2_DUTY_CYCLE : real := 0.5;
       CLKOUT3_DUTY_CYCLE : real := 0.5;
       CLKOUT4_DUTY_CYCLE : real := 0.5;
       CLKOUT5_DUTY_CYCLE : real := 0.5;
       CLKOUT6_DUTY_CYCLE : real := 0.5;
       CLKOUT0_PHASE : real := 0.0;
       CLKOUT1_PHASE : real := 0.0;
       CLKOUT2_PHASE : real := 0.0;
       CLKOUT3_PHASE : real := 0.0;
       CLKOUT4_PHASE : real := 0.0;
       CLKOUT5_PHASE : real := 0.0;
       CLKOUT6_PHASE : real := 0.0;
       CLKOUT4_CASCADE : boolean := FALSE;
       DIVCLK_DIVIDE : integer := 1;      
       REF_JITTER1 : real := 0.0;        
       STARTUP_WAIT : boolean := FALSE    
    );
    port (
       CLKOUT0  : out std_logic;   
       CLKOUT0B : out std_logic;   
       CLKOUT1  : out std_logic;   
       CLKOUT1B : out std_logic;   
       CLKOUT2  : out std_logic;   
       CLKOUT2B : out std_logic;   
       CLKOUT3  : out std_logic;   
       CLKOUT3B : out std_logic;   
       CLKOUT4  : out std_logic;   
       CLKOUT5  : out std_logic;   
       CLKOUT6  : out std_logic;   
       CLKFBOUT : out std_logic;   
       CLKFBOUTB: out std_logic;   
       LOCKED   : out std_logic;   
       CLKIN1   : in std_logic;    
       PWRDWN   : in std_logic;    
       RST      : in std_logic;    
       CLKFBIN  : in std_logic  	
    );	
   end component;
	
	
begin
    GND_BIT <= '0';

    CLKA_BUFG_INST : BUFG port map (I => CLKA_BUF, O => CLKA);          -- IncludeIf_CLKA
    CLKB_BUFG_INST : BUFG port map (I => CLKB_BUF, O => CLKB);          -- IncludeIf_CLKB
    CLKC_BUFG_INST : BUFG port map (I => CLKC_BUF, O => CLKC);          -- IncludeIf_CLKC
    CLKD_BUFG_INST : BUFG port map (I => CLKD_BUF, O => CLKD);          -- IncludeIf_CLKD
    CLKE_BUFG_INST : BUFG port map (I => CLKE_BUF, O => CLKE);          -- IncludeIf_CLKE
    CLKF_BUFG_INST : BUFG port map (I => CLKF_BUF, O => CLKF);          -- IncludeIf_CLKF
    CLKG_BUFG_INST : BUFG port map (I => CLKG_BUF, O => CLKG);          -- IncludeIf_CLKG
                                                                                    
    CLKFB_BUFG_INST : BUFG port map (I => CLKFB_BUF, O => CLKFB_IN);

   MMCME2_BASE_inst : MMCME2_BASE
   generic map (
      BANDWIDTH => "OPTIMIZED", 
      CLKFBOUT_MULT_F => ReplaceWith_CLKOUT0_MULTIPLY,   
      CLKFBOUT_PHASE => 0.0,    
      CLKIN1_PERIOD => ReplaceWith_CLKIN_PERIOD,     
      CLKOUT1_DIVIDE => 1,											-- IncludeIf_CLKB
      CLKOUT2_DIVIDE => 1,                                          -- IncludeIf_CLKC
      CLKOUT3_DIVIDE => 1,                                          -- IncludeIf_CLKD
      CLKOUT4_DIVIDE => 1,                                          -- IncludeIf_CLKE
      CLKOUT5_DIVIDE => 1,                                          -- IncludeIf_CLKF
      CLKOUT6_DIVIDE => 1,                                          -- IncludeIf_CLKG
      CLKOUT0_DIVIDE_F => ReplaceWith_CLKOUT0_DIVIDE,  				-- IncludeIf_CLKA
      CLKOUT0_DUTY_CYCLE => 0.5,									-- IncludeIf_CLKA
      CLKOUT1_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKB
      CLKOUT2_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKC
      CLKOUT3_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKD
      CLKOUT4_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKE
      CLKOUT5_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKF
      CLKOUT6_DUTY_CYCLE => 0.5,                                    -- IncludeIf_CLKG
      CLKOUT0_PHASE => 0.0,											-- IncludeIf_CLKA
      CLKOUT1_PHASE => 0.0,                                         -- IncludeIf_CLKB
      CLKOUT2_PHASE => 0.0,                                         -- IncludeIf_CLKC
      CLKOUT3_PHASE => 0.0,                                         -- IncludeIf_CLKD
      CLKOUT4_PHASE => 0.0,                                         -- IncludeIf_CLKE
      CLKOUT5_PHASE => 0.0,                                         -- IncludeIf_CLKF
      CLKOUT6_PHASE => 0.0,                                         -- IncludeIf_CLKG
      CLKOUT4_CASCADE => FALSE, 
      DIVCLK_DIVIDE => 1,       
      REF_JITTER1 => 0.0,       
      STARTUP_WAIT => FALSE     
   )
   port map (
      CLKOUT0   => CLKA_BUF,  
      CLKOUT0B  => Open,   
      CLKOUT1   => CLKB_BUF,  
      CLKOUT1B  => Open,   
      CLKOUT2   => CLKC_BUF,  
      CLKOUT2B  => Open,  
      CLKOUT3   => CLKD_BUF,  
      CLKOUT3B  => Open,   
      CLKOUT4   => CLKE_BUF,  
      CLKOUT5   => CLKF_BUF,  
      CLKOUT6   => CLKG_BUF,        
      CLKFBOUT  => CLKFB_BUF, 
      CLKFBOUTB => Open,
      LOCKED 	=> LOCKED,   
      CLKIN1 	=> CLK,   
      PWRDWN 	=> GND_BIT,   
      RST 		=> RST,      
      CLKFBIN 	=> CLKFB_IN   
   );

end RTL;
-- ----------------------------------------------------------------------------

