//***********************************************************
//
// This is the SPI I/O file for the 
//
//  Written by:   ESC Inc.
//                47 Comstock Ave.
//                Ivoryton, CT 06442
//                860-767-2282
//                www.embedded-designer.com
//
//    Copyright (C) 2010-2010 by ESC Inc.
//
// Author: George F. Martin     Created 10 February 2010
//
// File: SpiTasks.c
//
//***********************************************************


// include files for the 
#include "inc/hw_gpio.h"
//#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
//#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
//#include "driverlib/debug.h"
#include "driverlib/gpio.h"
//#include "driverlib/interrupt.h"

//#include "inc/hw_nvic.h"
//#include "driverlib/cpu.h"
#include "driverlib/sysctl.h"
#include "driverlib/ssi.h"
#include "SafeRTOS/SafeRTOS_API.h"


#include "../Consts.h"
#include "../DataBase.h"


//**********************************************[ Public ]********
//
// Init All the SPI interfaces
//
//*****************************************************************
void InitSpi(void) {  
unsigned long ulDataRx[10];   // This is a place to hold the 
                              // flushed data both for SPI 0/1 

// From Ti examples

// For this example SSI0 is used with PortA[5:2].  
// GPIO port A needs to be enabled so these pins can be used.
SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);

// Configure the pin muxing for SSI0 functions on port A2, A3, A4, and A5.
// This step is not necessary if your part does not support pin muxing.
GPIOPinConfigure(GPIO_PA2_SSI0CLK);
GPIOPinConfigure(GPIO_PA3_SSI0FSS);	//We'll be using others as well
GPIOPinConfigure(GPIO_PA4_SSI0RX);
GPIOPinConfigure(GPIO_PA5_SSI0TX);

// Configure the GPIO settings for the SSI pins.  This function also gives
// control of these pins to the SSI hardware.  
// The pins are assigned as follows:
//      PA5 - SSI0Tx
//      PA4 - SSI0Rx
//      PA3 - SSI0Fss  We'll use others as well
//      PA2 - SSI0CLK
//
GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_5 | 
                                GPIO_PIN_4 | 
                                GPIO_PIN_3 |
                                GPIO_PIN_2);

// Configure and enable the SSI port for SPI master mode.  
// Use SSI0, system clock supply, idle clock level low 
// and active low clock in freescale SPI mode, master mode,
// 1MHz SSI frequency, and 8-bit data. For SPI mode, you 
// can set the polarity of the SSI clock when the SSI
// unit is idle.  You can also configure what clock edge 
// you want to capture data on.  
SSIConfigSetExpClk(SSI0_BASE,             // SSI 0
                   SysCtlClockGet(),      // System Clock
                   SSI_FRF_MOTO_MODE_0,   // Freescale SPI mode
                   SSI_MODE_MASTER,       // Master Mode
                   1000000,               // Bit Rate 1 MHz!!!!
                   8);                    // number of Bits


SSIEnable(SSI0_BASE);   // Enable the SSI0 module.

// Read any residual data from the SSI port.  This makes 
// sure the receive FIFOs are empty, so we don't read any 
// unwanted junk.  This is done here because the SPI SSI 
// mode is full-duplex, which allows you to send and receive
// at the same time.  The SSIDataGetNonBlocking function 
// returns "true" when data was returned, and "false" when
// no data was returned. The "non-blocking" function checks
// if there is any data in the receive FIFO and does not 
//"hang" if there isn't.
while (SSIDataGetNonBlocking(SSI0_BASE, &ulDataRx[0])) {	// Flush data
}

// For this example SSI1 is used with PortE[3:0].  
// GPIO port E needs to be enabled so these pins can be used.
SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI1);

// Configure the pin muxing for SSI1 functions on 
// port A0, A1, A2, and A3.
// This step is not necessary if your part does 
// not support pin muxing.
GPIOPinConfigure(GPIO_PE0_SSI1CLK);
GPIOPinConfigure(GPIO_PE1_SSI1FSS); //We'll be using others as well
GPIOPinConfigure(GPIO_PE2_SSI1RX);
GPIOPinConfigure(GPIO_PE3_SSI1TX);

// Configure the GPIO settings for the SSI pins.  
// This function also gives
// control of these pins to the SSI hardware.  
// The pins are assigned as follows:
//      PE3 - SSI1Tx
//      PE2 - SSI1Rx
//      PE1 - SSI1Fss  We'll use others as well
//      PE0 - SSI1CLK
GPIOPinTypeSSI(GPIO_PORTE_BASE, GPIO_PIN_3 | 
                                GPIO_PIN_2 | 
                                GPIO_PIN_1 |
                                GPIO_PIN_0);

// Configure and enable the SSI port for SPI master mode.
// Use SSI1, system clock supply, idle clock level low
// and active low clock in freescale SPI mode, master mode,
// 1MHz SSI frequency, and 8-bit data. For SPI mode, you
// can set the polarity of the SSI clock when the SSI unit
// is idle.  You can also configure what clock edge you 
// want to capture data on.  
SSIConfigSetExpClk(SSI1_BASE,             // SSI 0
                   SysCtlClockGet(),      // System Clock
                   SSI_FRF_MOTO_MODE_0,   // Freescale SPI mode
                   SSI_MODE_MASTER,       // Master Mode
                   1000000,               // Bit Rate
                   8);                    // number of Bits


SSIEnable(SSI1_BASE);   // Enable the SSI1 module.

// Read any residual data from the SSI port.  This makes 
// sure the receive FIFOs are empty, so we don't read any 
// unwanted junk.  This is done here because the SPI SSI 
// mode is full-duplex, which allows you to send and receive
// at the same time.  The SSIDataGetNonBlocking function 
// returns "true" when data was returned, and "false" when
// no data was returned. The "non-blocking" function checks
// if there is any data in the receive FIFO and does not 
//"hang" if there isn't.
while (SSIDataGetNonBlocking(SSI1_BASE, &ulDataRx[0])) {  // Flush data
}

}  // end of void InitAllSpi(void) {


//**********************************************[ Public ]********
//
//
//*****************************************************************
void InitSoftSPI(void) {
	
	
}	// void InitSoftSPI(void) {


  
//**********************************************[ Public ]********
//
// Interogate Slave Systems
//
//*****************************************************************
void InterogateSlaveSystem(void) {

}  // end of void InterogateSlaveSystem(void) 


//**********************************************[ Public ]********
//
// Init SPI Hardware
//
//*****************************************************************
void InitSpiHdw(void) {
   

}  // end of void InitSpiHdw(void) 

INT16 MasterSpiState;   // One of the following

#define  M_SPI_INIT     1
#define  M_SPI_SLAVE1   2
#define  M_SPI_SLAVE2   3

#define  TX_LIMIT 24*3

UINT8 *SpiTxPt;   // Point to the Tx Source
UINT8 *SpiRxPt;   // Point to the Rx Destination
INT16 TxCounter;  // Count the bytes sent

//**********************************************[ Public ]********
//
// Master to Slave SPI
//
//*****************************************************************
void MasterToSlaveSpi(void) {
unsigned long temp;

switch (MasterSpiState) {
   default:
   case M_SPI_INIT: {
      SpiTxPt = &Slave1DisplayData.DispData[0][0];
      SpiRxPt = Slave1SwitchData.LaneLock;
      // send 3 bytes      
      SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
      SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
      SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
      TxCounter = 3;
      MasterSpiState = M_SPI_SLAVE1;
   } break;
   
   case M_SPI_SLAVE1: {
//      if (SSIBusy(SSI0_BASE)) {
//         break;   // Get out of here
//      }
      if (SSIBusy(SSI0_BASE)) {
         taskYIELD();      // Let the schedulre figure it all out
      }
      // Read 3 bytes
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      if (TxCounter >= TX_LIMIT) {
         SpiTxPt = &Slave2DisplayData.DispData[0][0];
         SpiRxPt = Slave2SwitchData.LaneLock;
         // send 3 bytes      
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         MasterSpiState = M_SPI_SLAVE2;
      }
      else {   
         // send 3 bytes      
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         SSIDataPut(SSI0_BASE, (unsigned long) SpiTxPt++);
         TxCounter += 3;
      }
   } break;

   case M_SPI_SLAVE2: {
//      if (SSIBusy(SSI0_BASE)) {
//         break;   // Get out of here
//      }
      if (SSIBusy(SSI0_BASE)) {
         taskYIELD();      // Let the schedulre figure it all out
      }
      // Read 3 bytes
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      SSIDataGet(SSI0_BASE, &temp);
      *SpiRxPt++ = temp & 0xFF;
      if (TxCounter >= TX_LIMIT) {
         MasterSpiState = M_SPI_INIT;
      }
      else {
         // send 3 bytes      
         SSIDataGet(SSI0_BASE, &temp);
         *SpiRxPt++ = temp & 0xFF;
         SSIDataGet(SSI0_BASE, &temp);
         *SpiRxPt++ = temp & 0xFF;
         SSIDataGet(SSI0_BASE, &temp);
         *SpiRxPt++ = temp & 0xFF;
         TxCounter += 3;
      }
   } break;
   
}  // end of switch (MasterSpiState) {

}  // end of void MasterToSlaveSpi(void) {


//********************************************[ Interrupt ]*******
//
// USCI_A0 interrupt
// Talking to Slave units
//
//****************************************************************
__interrupt void USCI_A0_ISR(void) {
   
#ifdef   NEVER
volatile unsigned int i;
INT16 RxData;
INT16 TxData = 0;

switch(__even_in_range(UCA0IV,4)) {

default: {
} break;
   
case 0: {
} break;                          // Vector 0 - no interrupt

case 2: {                         // Vector 2 - RXIFG
   while (!(UCA0IFG&UCTXIFG)) {   // USCI_A0 TX buffer ready?
   }
   RxData = UCA0RXBUF;              // Read the data

   UCA0TXBUF = 0x00;         // Send next value

//   for(i = 20; i>0; i--);        // Add time between transmissions to
//                                 // make sure slave can process information

   while (!(UCA0IFG&UCTXIFG)) {   // USCI_A0 TX buffer ready?
   }
   UCA0TXBUF = TxData;         // Transmit next character
} break;

case 4: {
} break;                          // Vector 4 - TXIFG

}  // end of switch(__even_in_range(UCA0IV,4)) {
#endif
 
}  // end of __interrupt void USCI_A0_ISR(void) {


//********************************************[ Interrupt ]*******
//
// USCI_B0 interrupt
// Talking to Display
//
//****************************************************************
__interrupt void USCI_B0_ISR(void) {

#ifdef   NEVER
volatile unsigned int i;
INT16 RxData;
INT16 TxData = 0;


switch(__even_in_range(UCB0IV,4)) {

default: {
} break;
   
case 0: {
} break;                          // Vector 0 - no interrupt

case 2: {                         // Vector 2 - RXIFG
   while (!(UCB0IFG&UCTXIFG)) {   // USCI_A0 TX buffer ready?
   }
   RxData = UCB0RXBUF;              // Read the data

   UCB0TXBUF = 0x00;         // Send next value

   for(i = 20; i>0; i--);        // Add time between transmissions to
                                 // make sure slave can process information
   while (!(UCB0IFG&UCTXIFG)) {   // USCI_A0 TX buffer ready?
   }
   UCB0TXBUF = TxData;         // Transmit next character
} break;

case 4: {
} break;                          // Vector 4 - TXIFG

}  // end of switch(__even_in_range(UCB0IV,4)) {

#endif

}  // end of __interrupt void USCI_B0_ISR(void) {



//**********************************************[ RTOS ]**********
//

//
//*****************************************************************
static void SpiTask(void *pvParameters) {

for (;;) {
   MasterToSlaveSpi(); // operate the state machine
}

}  // end of static void SpiTask(void *pvParameters) {


//*****************************************************************************
//
// The stack for the SPI(x) SSI(x) task.
//
//*****************************************************************************
static unsigned long g_pulSpiTaskStack[128];


//**********************************************[ Public ]********
//
// Create the Spi Task
//
//*****************************************************************
unsigned long SpiTaskInit(void) {
   
InitSpi();  // Init the hardware

// Create the SPI task.
if (xTaskCreate( SpiTask, 
                (signed portCHAR *)"Spi",
                (signed portCHAR *)g_pulSpiTaskStack,
                 sizeof(g_pulSpiTaskStack), 
                 NULL, 
                 PRIORITY_SPI_TASK,
                 NULL) != pdPASS)
{
   return(1);  // Failure
}

//TaskCreated();
   
return(0);  // Success.

}  // end of unsigned long SpiTaskInit(void) {


// end of file SpiTasks.c

