/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Console {
    private static final Logger logger = Logger.getLogger(Console.class.getName());
    private final BufferedReader in;
    private final PrintWriter out;

    public Console() {
        this(System.in, System.out);
    }

    public Console(InputStream in, OutputStream out) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new PrintWriter(out, true);
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public void print(String message) {
        this.out.print(message);
        this.out.flush();
    }

    public void println() {
        this.out.println();
    }

    public void println(String message) {
        this.out.println(message);
    }

    public int prompt(String prompt, int min, int max, int eof) {
        return this.prompt(prompt, min, max, min - 1, eof);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int prompt(String prompt, int min, int max, int defaultValue, int eof) {
        int result = min - 1;
        try {
            do {
                this.println(prompt);
                String value = this.readLine();
                if (value == null) return eof;
                if ((value = value.trim()).equals("") && defaultValue >= min) {
                    return defaultValue;
                }
                try {
                    result = Integer.valueOf(value);
                }
                catch (NumberFormatException ignore) {}
            } while (result < min || result > max);
            return result;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return eof;
        }
    }

    public String prompt(String prompt, String eof) {
        return this.prompt(prompt, "", eof);
    }

    public String prompt(String prompt, String defaultValue, String eof) {
        String result;
        try {
            this.print(prompt);
            result = this.readLine();
            if (result == null) {
                result = eof;
            } else if (result.equals("")) {
                result = defaultValue;
            }
        }
        catch (IOException e) {
            result = eof;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return result;
    }

    public String prompt(String prompt, String[] values, String eof) {
        String input;
        block0: while ((input = this.prompt(prompt, eof)) != null && !input.equals(eof)) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) continue block0;
                String value = arr$[i$];
                if (value.equalsIgnoreCase(input)) {
                    return value;
                }
                ++i$;
            }
            break;
        }
        return input;
    }
}

