/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base.spi;

import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.spi.AbstractFormatter;
import com.izforge.izpack.util.config.base.spi.IniHandler;
import com.izforge.izpack.util.config.base.spi.ServiceFinder;
import java.io.PrintWriter;
import java.io.Writer;

public class IniFormatter
extends AbstractFormatter
implements IniHandler {
    public static IniFormatter newInstance(Writer out, Config config) {
        IniFormatter instance = IniFormatter.newInstance();
        instance.setOutput(out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out));
        instance.setConfig(config);
        return instance;
    }

    @Override
    public void endIni() {
        this.getOutput().flush();
    }

    @Override
    public void endSection() {
        this.getOutput().print(this.getConfig().getLineSeparator());
    }

    @Override
    public void startIni() {
    }

    @Override
    public void startSection(String sectionName) {
        this.setHeader(false);
        if (!this.getConfig().isGlobalSection() || !sectionName.equals(this.getConfig().getGlobalSectionName())) {
            this.getOutput().print('[');
            this.getOutput().print(this.escapeFilter(sectionName));
            this.getOutput().print(']');
            this.getOutput().print(this.getConfig().getLineSeparator());
        }
    }

    private static IniFormatter newInstance() {
        return ServiceFinder.findService(IniFormatter.class);
    }
}

