/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.CacheUpdateHelper;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JRESelectException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.EmbeddedJNLPValidation;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.MatchJREIf;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.SecureMatchJRE;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.JNLPPreverifyClassLoader;
import com.sun.jnlp.JnlpLookupStub;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Applet2StopListener;
import sun.plugin2.applet.JNLP2ClassLoader;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.server.JVMHealthData;

public class JNLP2Manager
extends Plugin2Manager {
    private URL _initDocumentBaseURL = null;
    private String _initJnlpFile = null;
    private byte[] _initJnlpBytes;
    private boolean _initialized;
    private JREInfo homeJREInfo = null;
    private URL _codebase = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy = null;
    private LocalApplicationProperties _lap = null;
    private static boolean _environmentInitialized = false;
    private String _cachedJNLPFilePath = null;
    private JRESelectException _relaunchException = null;
    private boolean _allSigned = false;

    public void setCachedJNLPFilePath(String string) {
        this._cachedJNLPFilePath = string;
    }

    public JNLP2Manager(String string, URL uRL, String string2, boolean bl) throws Exception {
        this(string, uRL, string2, null, bl);
    }

    public JNLP2Manager(String string, URL uRL, String string2, byte[] byArray, boolean bl) throws Exception {
        super(bl);
        this._initDocumentBaseURL = uRL;
        this._initJnlpFile = string2;
        this._initJnlpBytes = byArray;
        this._initialized = false;
        if (string == null) {
            this._codebase = URLUtil.getBase((URL)this._initDocumentBaseURL);
            if (DEBUG) {
                System.out.println("   JNLP Codebase (is documentbase): " + this._codebase);
            }
        } else {
            try {
                this._codebase = URLUtil.asPathURL((URL)new URL(string));
                if (DEBUG) {
                    System.out.println("   JNLP Codebase (absolute): " + this._codebase);
                }
            }
            catch (Exception exception) {
                this._codebase = null;
            }
            if (this._codebase == null) {
                try {
                    URL uRL2 = new URL(URLUtil.getBase((URL)this._initDocumentBaseURL), string);
                    if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this._initDocumentBaseURL), (URL)uRL2)) {
                        throw new SecurityException("Permission denied: " + uRL2);
                    }
                    this._codebase = URLUtil.asPathURL((URL)uRL2);
                    if (DEBUG) {
                        System.out.println("   JNLP Codebase (documentbase+codebase): " + this._codebase);
                    }
                }
                catch (Exception exception) {
                    this._codebase = null;
                }
            }
            if (DEBUG && this._codebase == null) {
                System.out.println("   JNLP Codebase (null)");
            }
        }
        if (DEBUG) {
            Trace.println((String)("new JNLP2Manager: " + this._initJnlpFile + ", codebase: " + this._codebase + ", documentBase: " + this._initDocumentBaseURL), (TraceLevel)TraceLevel.BASIC);
            if (this._initJnlpBytes != null) {
                Trace.println((String)("Embedded JNLP: " + new String(this._initJnlpBytes)), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    public AppInfo getAppInfo() {
        return this.getLaunchDesc().getAppInfo();
    }

    protected Plugin2ClassLoader newClassLoader() {
        if (null == this._codebase) {
            Exception exception = new Exception("newClassLoader - init failed: _codebase is null");
            Trace.ignoredException((Exception)exception);
            return null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        JNLPPreverifyClassLoader jNLPPreverifyClassLoader = new JNLPPreverifyClassLoader(classLoader);
        JNLP2ClassLoader jNLP2ClassLoader = new JNLP2ClassLoader(this._codebase, jNLPPreverifyClassLoader);
        if (Config.getMixcodeValue() != 3) {
            JNLP2ClassLoader jNLP2ClassLoader2 = new JNLP2ClassLoader(this._codebase, (ClassLoader)jNLP2ClassLoader);
            if (!Plugin2ClassLoader.setDeployURLClassPathCallbacks(jNLP2ClassLoader, jNLP2ClassLoader2)) {
                return jNLP2ClassLoader;
            }
            return jNLP2ClassLoader2;
        }
        return jNLP2ClassLoader;
    }

    public String getAppletUniqueKey() {
        String string = "|";
        if (this._initDocumentBaseURL != null) {
            string = string + this._initDocumentBaseURL.toString();
        }
        string = string + "|";
        if (this._initJnlpFile != null) {
            string = string + this._initJnlpFile;
        }
        string = string + "|";
        return string;
    }

    protected void collectJnlpProperties() {
    }

    public void initialize() throws Exception {
        LocalApplicationProperties localApplicationProperties;
        super.initialize();
        Plugin2ClassLoader plugin2ClassLoader = this.getAppletClassLoader();
        if (!(plugin2ClassLoader instanceof JNLP2ClassLoader)) {
            Exception exception = new Exception("ClassLoader not JNLP2ClassLoader (" + plugin2ClassLoader + ")");
            throw exception;
        }
        if (!this.isAppletRelaunched()) {
            Config.get().refreshIfNeeded();
        }
        this.homeJREInfo = JREInfo.getHomeJRE();
        if (DEBUG && VERBOSE) {
            Trace.println((String)("JNLP2Manager.initialize(): java.home:" + Environment.getJavaHome() + ", RUnning JRE: " + this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)"JREInfos");
            JREInfo.traceJREs();
        }
        if (this.homeJREInfo == null) {
            throw new ExitException((Throwable)new Exception("Internal Error: no running JRE"), 3);
        }
        LaunchDesc launchDesc = this.checkForEmbeddedJNLP();
        if (launchDesc == null) {
            DeployPerfUtil.put((String)"JNLP2Manager.initialize - before buildDescriptorFromCache()");
            launchDesc = LaunchDescFactory.buildDescriptorFromCache((String)this._initJnlpFile, (URL)this._codebase, (URL)this._initDocumentBaseURL);
            if (this._initJnlpFile.endsWith(".jarjnlp")) {
                this._launchDesc = launchDesc;
            }
            DeployPerfUtil.put((String)"JNLP2Manager.initialize - after buildDescriptorFromCache()");
        }
        if (this._launchDesc == null && launchDesc != null && launchDesc.getUpdate().isBackgroundCheck() && ((localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(launchDesc.getCanonicalHome(), null, true)) == null || !localApplicationProperties.forceUpdateCheck())) {
            if (this.redirectLaunchDesc(launchDesc, this._initJnlpFile, this._codebase, this._initDocumentBaseURL)) {
                this._lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
            } else {
                this._launchDesc = launchDesc;
                this._lap = localApplicationProperties;
            }
        }
        if (this._launchDesc == null) {
            this._launchDesc = LaunchDescFactory.buildDescriptor((String)this._initJnlpFile, (URL)this._codebase, (URL)this._initDocumentBaseURL, (boolean)DEBUG);
            if (null != this._launchDesc) {
                if (this.redirectLaunchDesc(this._launchDesc, this._initJnlpFile, this._codebase, this._initDocumentBaseURL) && DEBUG) {
                    Trace.println((String)("JNLP2Manager.initialize(): JNLP redirect Ref: " + this._launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
                }
            } else if (this._cachedJNLPFilePath != null && (launchDesc = LaunchDescFactory.buildDescriptor((File)new File(this._cachedJNLPFilePath), (URL)this._codebase, (URL)this._initDocumentBaseURL, null)) != null && (launchDesc.getLocation() == null || launchDesc.getInformation().supportsOfflineOperation())) {
                this._launchDesc = launchDesc;
            }
        }
        if (null == this._launchDesc) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP not available: " + this._initJnlpFile), (TraceLevel)TraceLevel.BASIC);
            return;
        }
        if (!this._launchDesc.isApplet() && !this._launchDesc.isFXApp()) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("JNLP2Manager.initialize(): JNLP not an applet nor JavaFX application: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            }
            return;
        }
        if (Environment.isImportMode()) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("JNLP2Manager.initialize(): JNLP import mode not supported: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            }
            return;
        }
        localApplicationProperties = this._launchDesc.getJavaFXAppDescriptor();
        AppletDesc appletDesc = this._launchDesc.getAppletDescriptor();
        if (null == appletDesc && null == localApplicationProperties) {
            throw new Exception("initialize - init failed: Both javafx-desc and AppletDesc are null.");
        }
        this._codebase = this._launchDesc.getCodebase();
        this._initialized = true;
        Applet2ExecutionContext applet2ExecutionContext = this.getAppletExecutionContext();
        if (null != localApplicationProperties) {
            applet2ExecutionContext.setAppletParameters(JNLP2Tag.addJnlpJfxParams(applet2ExecutionContext.getAppletParameters(), (JavaFXAppDesc)localApplicationProperties));
        } else {
            applet2ExecutionContext.setAppletParameters(JNLP2Tag.addJNLParams2Map(applet2ExecutionContext.getAppletParameters(), appletDesc));
        }
        this.prepareToLaunch();
        if (null == this._appPolicy) {
            Exception exception = new Exception("initialize - init failed: _appPolicy is null");
            throw exception;
        }
    }

    protected void performDesktopIntegration() {
        if (this._launchDesc != null && (this._launchDesc.isFXApp() || this.isDisconnectedExecutionContext())) {
            this.installShortcuts();
        }
    }

    /*
     * Loose catch block
     */
    protected void loadJarFiles() throws ExitException {
        block16: {
            try {
                this.getPreloaderDelegate().handleEvent((PreloaderEvent)new ConfigEvent(4, true));
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            if (!this._initialized) {
                if (null == this._launchDesc) {
                    ExitException exitException = new ExitException((Throwable)new FileNotFoundException("JNLP file error: " + this._initJnlpFile + ". Please make sure the file exists and check if " + "\"codebase\" and \"href\" in the JNLP file are correct."), 3);
                    throw exitException;
                }
                if (!this._launchDesc.isApplet() && !this._launchDesc.isFXApp()) {
                    ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP not an applet, nor a JavaFX application", new Exception("JNLP not an applet, nor a JavaFX application")), 3);
                    throw exitException;
                }
                if (Environment.isImportMode()) {
                    ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP import mode not supported", new Exception("JNLP import mode not supported")), 3);
                    throw exitException;
                }
                ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP2Manager not initialized", new Exception("JNLP2Manager not initialized")), 3);
                throw exitException;
            }
            Object object = new DownloadEvent(1, this._launchDesc.getLocation(), null, null, 1L, 1L, 100);
            this.prepareLaunchFile(this._launchDesc);
            this._launchDesc.getUpdater().startBackgroundUpdateOpt();
            Object var5_7 = null;
            try {
                if (object != null) {
                    this.getPreloaderDelegate().handleEvent((PreloaderEvent)object);
                }
                break block16;
            }
            catch (CancelException cancelException) {
                cancelException.printStackTrace();
            }
            break block16;
            {
                catch (Throwable throwable) {
                    ExitException exitException;
                    ExitException exitException2 = exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                    if (exitException.getReason() != 0) {
                        object = exitException.getReason() == 2 || exitException.isSilentException() ? null : JNLP2Manager.getErrorEvent(this._launchDesc.getLocation(), exitException);
                    }
                    throw exitException;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (object != null) {
                        this.getPreloaderDelegate().handleEvent((PreloaderEvent)object);
                    }
                }
                catch (CancelException cancelException) {
                    cancelException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public String getCode() {
        if (null == this._launchDesc) {
            return "<applet error>";
        }
        if (this._launchDesc.isFXApp()) {
            return this._launchDesc.getJavaFXAppDescriptor().getMainClass();
        }
        if (this._launchDesc.isApplet()) {
            return this._launchDesc.getAppletDescriptor().getAppletClass();
        }
        return "<applet error>";
    }

    protected String getAppletCode() {
        String string = this.getParameter("mainjavafxscript");
        if (string != null) {
            return string;
        }
        return this.getCode();
    }

    protected void destroyAppContext(AppContext appContext, Applet2StopListener applet2StopListener, long l) {
        Object object = appContext.get((Object)"deploy-launchdownloadthreadpoolinappcontext");
        if (object != null) {
            ExecutorService executorService = (ExecutorService)object;
            executorService.shutdown();
        }
        super.destroyAppContext(appContext, applet2StopListener, l);
    }

    protected void appletSSVRelaunch() throws JRESelectException {
        if (this._relaunchException != null) {
            throw this._relaunchException;
        }
    }

    protected void checkRunningJVMToolkitSatisfying() throws JRESelectException {
        boolean bl;
        boolean bl2 = !this._launchDesc.isFXApp() && ToolkitStore.isUsingPreferredToolkitType((int)10);
        boolean bl3 = bl = this._launchDesc.isFXApp() && ToolkitStore.isUsingPreferredToolkitType((int)11);
        if (bl2 || bl) {
            return;
        }
        JREInfo jREInfo = this._launchDesc.selectJRE((MatchJREIf)new SecureMatchJRE());
        if (jREInfo != null && jREInfo.getJfxRuntime() != null) {
            throw new JRESelectException(null, null);
        }
    }

    protected void checkRunningJVMArgsSatisfying() throws JRESelectException {
        MatchJREIf matchJREIf = this._launchDesc.getJREMatcher();
        if (!(matchJREIf.isRunningJVMArgsSatisfying(this._allSigned) && JVMHealthData.getCurrent().isHealthy() || this._relaunchException == null)) {
            throw new JRESelectException(null, this._relaunchException.getJVMArgs());
        }
    }

    public void clearRelaunchException() {
        this._relaunchException = null;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public String getDraggedTitle() {
        InformationDesc informationDesc;
        String string = super.getDraggedTitleParam();
        if (string == null && this._launchDesc != null && (informationDesc = this._launchDesc.getInformation()) != null) {
            string = informationDesc.getTitle();
        }
        return string;
    }

    public void setDraggedApplet() {
        if (this._launchDesc == null) {
            return;
        }
        LocalApplicationProperties localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
        if (localApplicationProperties != null) {
            localApplicationProperties.setDraggedApplet();
        }
    }

    boolean getDecoratedDefault() {
        if (this._launchDesc == null) {
            return true;
        }
        LocalApplicationProperties localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
        if (localApplicationProperties == null) {
            return true;
        }
        return !localApplicationProperties.isDraggedApplet();
    }

    String getDecoratedPreference() {
        String string;
        AppletDesc appletDesc;
        if (this._launchDesc != null && (appletDesc = this._launchDesc.getAppletDescriptor()) != null && (string = appletDesc.getParameters().getProperty("java_decorated_frame")) != null) {
            return string;
        }
        return this.getParameter("java_decorated_frame");
    }

    protected void setupProgress() {
    }

    private boolean redirectLaunchDesc(LaunchDesc launchDesc, String string, URL uRL, URL uRL2) throws ExitException {
        try {
            URL uRL3 = launchDesc.getLocation();
            if (uRL3 != null) {
                URL uRL4 = null;
                try {
                    uRL4 = new URL(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                    return false;
                }
                if (uRL != null) {
                    try {
                        uRL4 = new URL(uRL, string);
                        if (!URLUtil.checkTargetURL((URL)uRL, (URL)uRL4)) {
                            throw new SecurityException("Permission denied: " + uRL4);
                        }
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                        uRL4 = null;
                    }
                    if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                        return false;
                    }
                }
                if (uRL == null && uRL2 != null) {
                    try {
                        uRL4 = new URL(URLUtil.getBase((URL)uRL2), string);
                        if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)uRL2), (URL)uRL4)) {
                            throw new SecurityException("Permission denied: " + uRL4);
                        }
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                        uRL4 = null;
                    }
                    if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                        return false;
                    }
                }
                this._launchDesc = LaunchDescFactory.buildDescriptor((String)uRL3.toString(), (URL)uRL, (URL)uRL2, (boolean)DEBUG);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            throw new ExitException((Throwable)exception, 3);
        }
    }

    private void prepareToLaunch() throws ExitException {
        block6: {
            try {
                if (this._launchDesc == null) {
                    throw new ExitException("No launch descriptor to use", null);
                }
                this._lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
                URL uRL = this._launchDesc.getLocation();
                if (uRL != null) {
                    Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                }
                if (this._launchDesc.getResources() != null) {
                    Globals.getDebugOptionsFromProperties((Properties)this._launchDesc.getResources().getResourceProperties());
                }
                this._appPolicy = AppPolicy.createInstance((String)this._launchDesc.getCanonicalHome().getHost());
            }
            catch (Throwable throwable) {
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n = exitException.getReason();
                if (n == 3) {
                    this.setErrorOccurred(exitException.getException().getMessage(), exitException.getException());
                    this.showAppletException(exitException);
                }
                if (n == 0) break block6;
                throw exitException;
            }
        }
    }

    private URL validateLaunchDesc(LaunchDesc launchDesc) throws ExitException {
        Object object;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, (Exception)new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!launchDesc.isJRESpecified()) {
            object = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
            this.handleJnlpFileException(launchDesc, (Exception)object);
        }
        JNLPException.setDefaultLaunchDesc((LaunchDesc)launchDesc);
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException((Throwable)new OfflineLaunchException(1), 3);
        }
        object = launchDesc.getCanonicalHome();
        if (object == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException((Throwable)launchDescException, 3);
        }
        return object;
    }

    private boolean ensureAllJnlpFilesAreAvailable(LaunchDesc launchDesc, ArrayList arrayList) throws ExitException {
        boolean bl = false;
        LaunchDownload launchDownload = new LaunchDownload(launchDesc);
        if (launchDesc.getUpdate().isBackgroundCheck() && (this._lap == null || !this._lap.forceUpdateCheck())) {
            bl = launchDownload.isInCache();
        }
        if (!bl) {
            try {
                launchDownload.downloadExtensions(null, 0, arrayList);
            }
            catch (Exception exception) {
                if (launchDesc.getInformation().supportsOfflineOperation() && launchDownload.isInCache()) {
                    bl = true;
                }
                throw new ExitException((Throwable)exception, 3);
            }
        }
        return bl;
    }

    boolean isJfxSupportSatisfiedImpl(ClassLoader classLoader, LaunchDesc launchDesc) {
        if (!launchDesc.needFX()) {
            return true;
        }
        if (launchDesc.isFXApp() && !ToolkitStore.isUsingPreferredToolkit((int)11, (int)1)) {
            return false;
        }
        return JfxHelper.isJfxSupportSatisfied((ClassLoader)classLoader, (LaunchDesc)launchDesc);
    }

    private boolean isJfxSupportSatisfied(LaunchDesc launchDesc) {
        return this.isJfxSupportSatisfiedImpl(null, launchDesc);
    }

    private void prepareLaunchFile(LaunchDesc launchDesc) throws ExitException {
        boolean bl;
        JVMHealthData jVMHealthData;
        JnlpLaunchState jnlpLaunchState = new JnlpLaunchState(launchDesc);
        URL uRL = this.validateLaunchDesc(launchDesc);
        launchDesc.setPropsSet(true);
        JNLP2ClassLoader jNLP2ClassLoader = (JNLP2ClassLoader)this.getOrCreatePlugin2ClassLoader();
        ArrayList arrayList = new ArrayList();
        boolean bl2 = this.ensureAllJnlpFilesAreAvailable(launchDesc, arrayList);
        boolean bl3 = !launchDesc.getUpdate().isBackgroundCheck() && !launchDesc.getUpdate().isPromptPolicy() && !this.isAppletRelaunched();
        jNLP2ClassLoader.initialize(launchDesc, this._appPolicy);
        final JNLPSignedResourcesHelper jNLPSignedResourcesHelper = new JNLPSignedResourcesHelper(launchDesc);
        final PreloaderDelegate preloaderDelegate = this.getPreloaderDelegate();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    boolean bl = jNLPSignedResourcesHelper.checkSignedResources((Preloader)JNLP2Manager.this.getPreloaderDelegate(), true);
                    Trace.println((String)("Security check for progress jars: allSigned=" + bl), (TraceLevel)TraceLevel.SECURITY);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                preloaderDelegate.initPreloader((ClassLoader)JNLP2Manager.this.loader, JNLP2Manager.this.appletThreadGroup);
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                preloaderDelegate.setPreloaderClass(null);
                preloaderDelegate.initPreloader((ClassLoader)JNLP2Manager.this.loader, JNLP2Manager.this.appletThreadGroup);
            }
        };
        new LaunchDownload(launchDesc).prepareCustomProgress(preloaderDelegate, jNLPSignedResourcesHelper, runnable, runnable2, !bl2 || bl3);
        boolean bl4 = false;
        bl4 = this.downloadResources(jNLP2ClassLoader, launchDesc, arrayList, bl2, bl3, true);
        launchDesc.selectJRE();
        if (bl4) {
            this.resetForceUpdateCheck();
        }
        Trace.println((String)("LaunchDesc location: " + uRL), (TraceLevel)TraceLevel.BASIC);
        boolean bl5 = jnlpLaunchState.isHomeJvmMatch();
        try {
            jnlpLaunchState.doJvmSelection();
        }
        catch (LaunchDescException launchDescException) {
            throw new ExitException((Throwable)launchDescException, 2);
        }
        boolean bl6 = jnlpLaunchState.jreInfo == null;
        boolean bl7 = DeployOfflineManager.isGlobalOffline();
        if (bl6 && bl7) {
            throw new ExitException((Throwable)new OfflineLaunchException(0), 3);
        }
        boolean bl8 = bl6;
        if (!(bl6 || bl4 || launchDesc.getUpdate().isBackgroundCheck() || this.isAppletRelaunched() || bl7)) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                if (DEBUG) {
                    Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                }
                bl8 = true;
            } else {
                try {
                    bl8 = launchDesc.getUpdater().isUpdateAvailable();
                }
                catch (Exception exception) {
                    throw new ExitException((Throwable)exception, 3);
                }
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException((Throwable)new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        }
        if (DEBUG) {
            Trace.println((String)("\n\tisRelaunch: " + this.isAppletRelaunched() + "\n\tOffline mode: " + bl7 + "\n\tforceUpdate: " + bl6 + "\n\tneedUpdate: " + bl8 + "\n\tbgrUpdCheck: " + launchDesc.getUpdate().isBackgroundCheck() + "\n\tbgrUpdThread: " + launchDesc.getUpdater().isBackgroundUpdateRunning() + "\n\tRunning  JREInfo: " + this.homeJREInfo + "\n\t" + jnlpLaunchState.jreMatcher), (TraceLevel)TraceLevel.BASIC);
        }
        if (bl8 && !bl6) {
            bl6 = launchDesc.getUpdater().needUpdatePerPolicy();
        }
        if (bl6) {
            jnlpLaunchState.updateResources(jNLP2ClassLoader, arrayList, bl2, true);
        }
        PreloaderDelegate preloaderDelegate2 = this.getPreloaderDelegate();
        try {
            preloaderDelegate2.waitTillLoaded();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (IOException iOException) {
            if (launchDesc.getInformation().supportsOfflineOperation() && new LaunchDownload(launchDesc).isInCache(true)) {
                Trace.ignoredException((Exception)iOException);
            }
            throw new ExitException((Throwable)iOException, 3);
        }
        if (jnlpLaunchState.jreInstalled && bl5) {
            throw new ExitException((Throwable)new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
        }
        if (bl5) {
            jnlpLaunchState.doInstallers(arrayList);
        }
        if (!launchDesc.isValidSpecificationVersion()) {
            JNLPException.setDefaultLaunchDesc((LaunchDesc)launchDesc);
            this.handleJnlpFileException(launchDesc, (Exception)((Object)new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null)));
        }
        if (jnlpLaunchState.jreInstalled) {
            try {
                jnlpLaunchState.doJvmSelection();
            }
            catch (LaunchDescException launchDescException) {
                throw new ExitException((Throwable)launchDescException, 2);
            }
            if (jnlpLaunchState.jreInfo != null) {
                jnlpLaunchState.relaunchApplet(false);
                return;
            }
            jVMHealthData = null;
            if (bl7) {
                throw new ExitException((Throwable)new OfflineLaunchException(0), 3);
            }
            try {
                jVMHealthData = JfxHelper.installJfxRuntime((LaunchDesc)launchDesc, (Preloader)this.getPreloaderDelegate());
            }
            catch (DownloadException downloadException) {
                throw new ExitException(ResourceManager.getMessage((String)"launch.error.jfx.download"), (Throwable)downloadException);
            }
            catch (Throwable throwable) {
                throw new ExitException(throwable, 3);
            }
            this.setParameter("__jfx_installed", String.valueOf(true));
            try {
                jnlpLaunchState.doJvmSelection();
            }
            catch (LaunchDescException launchDescException) {
                throw new ExitException((Throwable)launchDescException, 2);
            }
            if (jnlpLaunchState.jreInfo != null) {
                jnlpLaunchState.relaunchApplet(false);
                return;
            }
        }
        jVMHealthData = JVMHealthData.getCurrent();
        if (DEBUG) {
            Trace.println((String)("Checking current JVM health: " + jVMHealthData), (TraceLevel)TraceLevel.BASIC);
        }
        boolean bl9 = bl = !ToolkitStore.isUsingPreferredToolkitType((int)(launchDesc.isFXApp() ? 11 : 10));
        if (launchDesc.isSecureJVMArgs() && (jnlpLaunchState.installerRelaunch || !bl5 || bl || !jVMHealthData.isHealthy())) {
            Trace.println((String)("Relaunch because: " + (jnlpLaunchState.installerRelaunch ? "[installer demands a relaunch] " : "") + (bl5 ? "" : "[currently running JRE doesn't satisfy (version/args)] ") + (bl ? "[current UI toolkit does not match] " : "") + (jVMHealthData.isHealthy() ? "" : "[unhealthy JVM state] ")), (TraceLevel)TraceLevel.BASIC);
            jnlpLaunchState.relaunchApplet(false);
        }
        boolean bl10 = false;
        try {
            bl10 = jNLPSignedResourcesHelper.checkSignedResources((Preloader)this.getPreloaderDelegate(), false);
            jNLPSignedResourcesHelper.checkSignedLaunchDesc(this._codebase, this._initDocumentBaseURL);
            this._allSigned = bl10 = bl10 && launchDesc.isSigned();
        }
        catch (JNLPException jNLPException) {
            if (DEBUG) {
                Trace.ignored((Throwable)jNLPException);
            }
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException((Throwable)iOException, 3);
        }
        catch (ExitException exitException) {
            throw exitException;
        }
        catch (Exception exception) {
            if (DEBUG) {
                Trace.ignored((Throwable)exception);
            }
            throw new ExitException((Throwable)exception, 3);
        }
        Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl10), (TraceLevel)TraceLevel.BASIC);
        bl5 = jnlpLaunchState.jreMatcher.isRunningJVMSatisfying(bl10);
        if (jnlpLaunchState.installerRelaunch || !bl5 || !jVMHealthData.isHealthy()) {
            jnlpLaunchState.relaunchApplet(bl10);
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
            for (int i = 0; i < jARDescArray.length; ++i) {
                this.storeJarVersionMapInAppContext(jARDescArray[i]);
            }
        }
    }

    private boolean downloadResources(JNLP2ClassLoader jNLP2ClassLoader, LaunchDesc launchDesc, ArrayList arrayList, boolean bl, boolean bl2, boolean bl3) throws ExitException {
        boolean bl4;
        boolean bl5 = false;
        boolean bl6 = bl4 = bl2 || !bl;
        if (DEBUG) {
            Trace.println((String)("JNLP2Manager.downloadResources(): updateCache " + bl2 + ", allInCache " + bl + ", doDownload " + bl4), (TraceLevel)TraceLevel.BASIC);
        }
        if (!bl4) {
            return bl5;
        }
        try {
            this.getPreloaderDelegate().handleEvent((PreloaderEvent)new ConfigEvent(3, this.getLaunchDesc().getAppInfo()));
            this.getPreloaderDelegate().handleEvent((PreloaderEvent)new InitEvent(4));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        LaunchDownload launchDownload = new LaunchDownload(launchDesc);
        try {
            if (!bl3) {
                launchDownload.downloadExtensions((Preloader)this.getPreloaderDelegate(), 0, arrayList);
            }
            jNLP2ClassLoader.updateJarDescriptors(launchDesc.getResources());
            launchDownload.downloadEagerorAll(false, (Preloader)this.getPreloaderDelegate(), false);
            bl5 = true;
        }
        catch (SecurityException securityException) {
            throw new ExitException((Throwable)securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (IOException iOException) {
            if (launchDesc.getInformation().supportsOfflineOperation() && bl) {
                Trace.ignoredException((Exception)iOException);
                return bl5;
            }
            throw new ExitException((Throwable)iOException, 3);
        }
        return bl5;
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        if (launchDesc == null) {
            return;
        }
        Resource resource = ResourceProvider.get().getCachedResource(launchDesc.getCanonicalHome(), null);
        if (resource != null) {
            ResourceProvider.get().markRetired(resource, true);
        }
        throw new ExitException((Throwable)exception, 3);
    }

    private void downloadJREResource(LaunchDesc launchDesc, JREDesc jREDesc, ArrayList arrayList, Preloader preloader) throws ExitException {
        Trace.println((String)"downloadJREResource ...", (TraceLevel)TraceLevel.BASIC);
        try {
            preloader.handleEvent((PreloaderEvent)new ConfigEvent(3, this.getLaunchDesc().getAppInfo()));
            preloader.handleEvent((PreloaderEvent)new InitEvent(0));
            preloader.handleEvent((PreloaderEvent)new ConfigEvent(4, true));
        }
        catch (CancelException cancelException) {
            throw new ExitException((Throwable)cancelException, 3);
        }
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload launchDownload = new LaunchDownload(launchDesc);
            launchDownload.downloadJRE(preloader, arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException((Throwable)securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            throw new ExitException((Throwable)new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 3);
        }
        Trace.println((String)"downloadJREResource fin", (TraceLevel)TraceLevel.BASIC);
    }

    private void storeJarVersionMapInAppContext(JARDesc jARDesc) {
        if (null == jARDesc) {
            return;
        }
        URL uRL = jARDesc.getLocation();
        if (uRL != null) {
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)jARDesc.getVersion());
        }
    }

    protected String getCodeSourceLocations() {
        if (!this._initialized) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this._launchDesc);
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        if (resourcesDesc != null) {
            arrayList.addAll(Arrays.asList(resourcesDesc.getEagerOrAllJarDescs(true)));
            arrayList.addAll(Arrays.asList(resourcesDesc.getExtensionDescs()));
        }
        return JNLP2Manager.buildJarList(arrayList.toArray(new Object[arrayList.size()]));
    }

    protected String getJarFiles() {
        if (!this._initialized) {
            return null;
        }
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        if (resourcesDesc != null) {
            return JNLP2Manager.buildJarList(resourcesDesc.getEagerOrAllJarDescs(true));
        }
        return null;
    }

    protected static String buildJarList(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = null;
            if (objectArray[i] instanceof LaunchDesc) {
                if (((LaunchDesc)objectArray[i]).getLocation() != null) {
                    string = ((LaunchDesc)objectArray[i]).getLocation().toString();
                }
            } else if (objectArray[i] instanceof JARDesc) {
                if (((JARDesc)objectArray[i]).getLocation() != null) {
                    string = ((JARDesc)objectArray[i]).getLocation().toString();
                }
            } else {
                if (!(objectArray[i] instanceof ExtensionDesc)) continue;
                if (((ExtensionDesc)objectArray[i]).getLocation() != null) {
                    string = ((ExtensionDesc)objectArray[i]).getLocation().toString();
                }
            }
            if (string == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            bl = true;
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static void initializeExecutionEnvironment() throws JNLPException {
        if (_environmentInitialized) {
            return;
        }
        long l = DeployPerfUtil.put((long)0L, (String)"JNLP2Manager - initializeExecutionEnvironment() - BEGIN");
        if (!Cache.canWrite()) {
            CacheAccessException cacheAccessException = new CacheAccessException(Environment.isSystemCacheMode());
            throw cacheAccessException;
        }
        Properties properties = System.getProperties();
        properties.setProperty("javawebstart.version", Globals.getComponentName());
        ServiceManager.setServiceManagerStub((ServiceManagerStub)new JnlpLookupStub());
        Config.setupPackageAccessRestriction();
        UIFactory.setDialogListener((DialogListener)new JavawsDialogListener());
        if (DeployOfflineManager.isGlobalOffline()) {
            DeployOfflineManager.setForcedOffline((boolean)true);
        }
        if (Environment.isSystemCacheMode()) {
            CacheUpdateHelper.systemUpdateCheck();
        } else if (Config.getBooleanProperty((String)"deployment.javaws.cache.update") && CacheUpdateHelper.updateCache()) {
            Config.setBooleanProperty((String)"deployment.javaws.cache.update", (boolean)false);
            Config.get().storeIfNeeded();
        }
        _environmentInitialized = true;
        DeployPerfUtil.put((long)l, (String)"JNLP2Manager - initializeExecutionEnvironment() - END");
    }

    protected boolean useGrayBoxProgressListener() {
        return false;
    }

    public void installShortcuts() {
        this.startWorkerThread("Shortcut Installer Thread", new Runnable(){

            public void run() {
                URL uRL = JNLP2Manager.this._launchDesc.getLocation();
                LocalApplicationProperties localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(uRL, null, true);
                if (localApplicationProperties != null) {
                    LocalInstallHandler localInstallHandler;
                    localApplicationProperties.setLastAccessed(new Date());
                    localApplicationProperties.incrementLaunchCount();
                    if (JNLP2Manager.this._initDocumentBaseURL != null) {
                        localApplicationProperties.setDocumentBase(JNLP2Manager.this._initDocumentBaseURL.toString());
                    }
                    if (JNLP2Manager.this._codebase != null) {
                        localApplicationProperties.setCodebase(JNLP2Manager.this._codebase.toString());
                    }
                    if ((localInstallHandler = LocalInstallHandler.getInstance()) != null && !localInstallHandler.isShortcutExists(localApplicationProperties)) {
                        if (!JNLP2Manager.this._launchDesc.isFXApp() && !JNLP2Manager.this.isDisconnectedExecutionContext()) {
                            localApplicationProperties.setAskedForInstall(false);
                        }
                        localInstallHandler.install(JNLP2Manager.this._launchDesc, localApplicationProperties, true, false, null);
                    }
                    try {
                        localApplicationProperties.store();
                    }
                    catch (IOException iOException) {
                        Trace.ignored((Throwable)iOException);
                    }
                }
            }
        });
    }

    private LaunchDesc checkForEmbeddedJNLP() {
        if (this._initJnlpBytes == null) {
            return null;
        }
        LaunchDesc launchDesc = null;
        try {
            URL uRL = this._codebase;
            if (this._initJnlpFile != null) {
                try {
                    uRL = new URL(this._initDocumentBaseURL, this._initJnlpFile);
                    uRL = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored((Throwable)malformedURLException);
                }
            }
            if (uRL == null) {
                uRL = this._codebase;
            }
            launchDesc = LaunchDescFactory.buildDescriptor((byte[])this._initJnlpBytes, (URL)uRL, (URL)this._initDocumentBaseURL);
            if (DEBUG) {
                System.out.println("buildDescriptor(embeddedJnlp) returns " + launchDesc);
            }
            if (launchDesc != null) {
                new EmbeddedJNLPValidation(launchDesc, uRL).validate();
                this._launchDesc = launchDesc = LaunchDownload.updateLaunchDescInCache((LaunchDesc)launchDesc, (URL)uRL, (URL)this._initDocumentBaseURL);
            }
        }
        catch (Exception exception) {
            launchDesc = null;
            Trace.println((String)"Ignore exception processing jnlp_embedded:", (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)new String(this._initJnlpBytes), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exception);
        }
        this._initJnlpBytes = null;
        return launchDesc;
    }

    private class JnlpLaunchState {
        LaunchDesc ld;
        boolean jreInstalled;
        boolean installerRelaunch;
        private MatchJREIf jreMatcher;
        private JREDesc jreDesc;
        private JREInfo jreInfo;
        private boolean homeJVMMatch;
        private boolean homeJVMVersionMatch;
        private String bestJREVersion = null;

        JnlpLaunchState(LaunchDesc launchDesc) {
            this.ld = launchDesc;
            this.jreInstalled = false;
            this.installerRelaunch = false;
        }

        boolean isHomeJvmMatch() {
            this.jreMatcher = this.ld.getJREMatcher();
            if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)"JnlpLaunchState.isHomeJvmMatch: JRE matcher:");
                Trace.println((String)this.jreMatcher.toString());
            }
            this.homeJVMMatch = this.jreMatcher.isRunningJVMSatisfying(true);
            return this.homeJVMMatch;
        }

        String findBestJreVersion() {
            if (null == this.bestJREVersion) {
                this.homeJVMVersionMatch = this.jreMatcher.isRunningJVMVersionSatisfying();
                if (!this.homeJVMVersionMatch) {
                    JavaFXRuntimeDesc javaFXRuntimeDesc = this.ld.getJavaFXRuntimeDescriptor();
                    this.bestJREVersion = JNLP2Manager.this.fireGetBestJREVersion(this.jreDesc.getVersion(), javaFXRuntimeDesc == null ? null : javaFXRuntimeDesc.getVersion());
                }
                if (this.bestJREVersion == null) {
                    this.bestJREVersion = this.jreDesc.getVersion();
                }
            }
            return this.bestJREVersion;
        }

        void doJvmSelection() throws ExitException, LaunchDescException {
            this.jreInfo = this.ld.getSelectedJRE();
            if (this.jreInfo == null) {
                Vector vector = Platform.get().getInstalledJREList();
                if (vector != null) {
                    Config.get().storeInstalledJREs(vector);
                }
                if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                    Trace.println((String)"JnlpLaunchState.doJvmSelection: Refreshed JREInfo list:");
                    JREInfo.traceJREs();
                }
                this.jreInfo = this.ld.selectJRE(true);
                if (this.jreInfo != null) {
                    if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                        Trace.println((String)"JnlpLaunchState.doJvmSelection: Found a new match JRE:");
                        Trace.println((String)this.jreInfo.toString());
                    }
                    this.jreInstalled = true;
                }
            }
            this.jreDesc = this.ld.getResources().getSelectedJRE();
            if (this.jreInfo == null && this.jreDesc == null) {
                Trace.println((String)this.jreMatcher.toString());
                throw new ExitException((Throwable)new Exception("Internal Error: Internal error, no JREDesc and no JREInfo"), 3);
            }
            if (this.jreInfo == null) {
                JNLP2Manager.this.setParameter("__applet_request_version", this.jreDesc.getVersion());
                this.jreInfo = this.ld.selectJRE((MatchJREIf)new SecureMatchJRE());
            }
            if (this.ld.needFX()) {
                if (this.jreInfo != null) {
                    JfxHelper.validateJfxRequest((LaunchDesc)this.ld, (JREInfo)this.jreInfo);
                } else {
                    JfxHelper.validateJfxRequest((LaunchDesc)this.ld, (JREDesc)this.jreDesc);
                }
            }
        }

        void updateResources(JNLP2ClassLoader jNLP2ClassLoader, ArrayList arrayList, boolean bl, boolean bl2) throws ExitException {
            if (!JNLP2Manager.this.isAppletRelaunched() && this.jreInfo == null) {
                JNLP2Manager.this.downloadJREResource(this.ld, this.jreDesc, arrayList, (Preloader)JNLP2Manager.this.getPreloaderDelegate());
                if (!arrayList.isEmpty()) {
                    try {
                        JnlpxArgs.executeInstallers((ArrayList)arrayList, (Preloader)JNLP2Manager.this.getPreloaderDelegate());
                    }
                    catch (ExitException exitException) {
                        boolean bl3 = this.installerRelaunch = exitException.getReason() == 1;
                        if (!this.installerRelaunch && exitException.isErrorException()) {
                            throw new ExitException(null, 0);
                        }
                        Trace.ignoredException((Exception)((Object)exitException));
                    }
                    if (!this.ld.isValidSpecificationVersion()) {
                        Platform.get().resetJavaHome();
                    }
                    String string = Environment.getJavaHome() + File.separator + "bin" + File.separator;
                    Platform.get().notifyJREInstalled(string);
                    this.jreInstalled = true;
                }
            } else {
                JNLP2Manager.this.downloadResources(jNLP2ClassLoader, this.ld, arrayList, bl, true, bl2);
            }
            JNLP2Manager.this.resetForceUpdateCheck();
        }

        void doInstallers(ArrayList arrayList) throws ExitException {
            if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)("JnlpLaunchState.doInstallers(): SingleInstanceManager ?: " + this.ld.getCanonicalHome().toString()));
            }
            if (SingleInstanceManager.isServerRunning((String)this.ld.getCanonicalHome().toString())) {
                Object object;
                String[] stringArray = Globals.getApplicationArgs();
                if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                    Trace.println((String)("JnlpLaunchState.doInstallers(): SingleInstanceManager: Running with appArgs: " + stringArray + ", thread: " + Thread.currentThread()));
                }
                if (stringArray != null && (object = this.ld.getApplicationDescriptor()) != null) {
                    object.setArguments(stringArray);
                }
                if (SingleInstanceManager.connectToServer((String)this.ld.toString())) {
                    if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                        Trace.println((String)"JnlpLaunchState.doInstallers(): SingleInstanceManager: OK from server");
                    }
                    object = "Single Instance already exist: " + this.ld.getCanonicalHome().toString();
                    Exception exception = new Exception((String)object);
                    JNLP2Manager.this.setErrorOccurred((String)object, exception);
                    throw new ExitException((Throwable)exception, 5);
                }
                if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                    Trace.println((String)"JnlpLaunchState.doInstallers(): SingleInstanceManager: NOK from server");
                }
            } else if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)("JnlpLaunchState.doInstallers(): No SingleInstanceManager, thread: " + Thread.currentThread()));
            }
            if (!arrayList.isEmpty()) {
                try {
                    JnlpxArgs.executeInstallers((ArrayList)arrayList, (Preloader)JNLP2Manager.this.getPreloaderDelegate());
                }
                catch (ExitException exitException) {
                    if (exitException.getReason() != 1) {
                        throw exitException;
                    }
                    this.installerRelaunch = true;
                }
            }
        }

        private void relaunchApplet(boolean bl) throws JRESelectException, ExitException {
            JavaFXRuntimeDesc javaFXRuntimeDesc;
            JREDesc jREDesc = null;
            this.findBestJreVersion();
            if (this.jreInstalled) {
                JNLP2Manager.this.setParameter("__jre_installed", String.valueOf(true));
            }
            if (!this.homeJVMVersionMatch) {
                if (JNLP2Manager.this.getParameter("__applet_request_version") == null) {
                    JNLP2Manager.this.setParameter("__applet_ssv_version", this.bestJREVersion);
                }
                jREDesc = new JREDesc(this.bestJREVersion, 0L, 0L, this.jreDesc.getVmArgs(), null, null);
            }
            if ((javaFXRuntimeDesc = this.ld.getJavaFXRuntimeDescriptor()) != null) {
                JNLP2Manager.this.setParameter("javafx_version", javaFXRuntimeDesc.getVersion());
                if (!this.ld.isFXApp()) {
                    JNLP2Manager.this.setParameter("__ui_tk", "awt");
                    if (Plugin2Manager.DEBUG) {
                        Trace.println((String)"Use AWT TK along with FX", (TraceLevel)TraceLevel.BASIC);
                    }
                }
            }
            if (Plugin2Manager.DEBUG) {
                Trace.println((String)("JRESelectException: installerRelaunch: " + this.installerRelaunch), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: jreInstalled: " + this.jreInstalled), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: running JREInfo: " + JNLP2Manager.this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: " + this.jreMatcher), (TraceLevel)TraceLevel.BASIC);
            }
            if (!JNLP2Manager.this.isAppletRelaunched()) {
                List list = this.jreMatcher.getSelectedJVMParameters().getCommandLineArguments(false, false, false, bl, false, Config.getMaxCommandLineLength());
                String string = StringQuoteUtil.getStringByCommandList((List)list);
                if (JNLP2Manager.this.fireAppletRelaunchSupported()) {
                    JRESelectException jRESelectException = new JRESelectException(jREDesc, string);
                    if (this.homeJVMVersionMatch) {
                        throw jRESelectException;
                    }
                    Trace.println((String)"jre version mismatch, delay relaunch to SSVValidation", (TraceLevel)TraceLevel.BASIC);
                    JNLP2Manager.this._relaunchException = jRESelectException;
                } else {
                    Trace.println((String)"JRESelectException: ignored - relaunch not supported", (TraceLevel)TraceLevel.BASIC);
                }
            } else {
                Trace.println((String)"JRESelectException: ignored - relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
    }
}

