/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.privateutil;

import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.RuntimePolicyUtilsException;
import com.sun.xml.internal.ws.policy.privateutil.ServiceFinder;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PolicyUtils {
    private PolicyUtils() {
    }

    public static class Collections {
        public static <E, T extends Collection<? extends E>, U extends Collection<? extends E>> Collection<Collection<E>> combine(U u, Collection<T> collection, boolean bl) {
            int n;
            ArrayList<Collection<AbstractList>> arrayList = null;
            if (collection == null || collection.isEmpty()) {
                if (u != null) {
                    arrayList = new ArrayList<Collection<AbstractList>>(1);
                    arrayList.add(new ArrayList(u));
                }
                return arrayList;
            }
            LinkedList linkedList = new LinkedList();
            if (u != null && !u.isEmpty()) {
                linkedList.addAll(u);
            }
            int n2 = 1;
            LinkedList<Collection> linkedList2 = new LinkedList<Collection>();
            Object object = collection.iterator();
            while (object.hasNext()) {
                Collection collection2 = (Collection)object.next();
                n = collection2.size();
                if (n == 0) {
                    if (bl) continue;
                    return null;
                }
                if (n == 1) {
                    linkedList.addAll(collection2);
                    continue;
                }
                linkedList2.offer(collection2);
                n2 *= n;
            }
            arrayList = new ArrayList(n2);
            arrayList.add(linkedList);
            if (n2 > 1) {
                while ((object = (Collection)linkedList2.poll()) != null) {
                    int n3 = arrayList.size();
                    n = n3 * object.size();
                    int n4 = 0;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        for (int i = 0; i < n3; ++i) {
                            Collection collection3 = (Collection)arrayList.get(n4);
                            if (n4 + n3 < n) {
                                arrayList.add(new LinkedList(collection3));
                            }
                            collection3.add(e);
                            ++n4;
                        }
                    }
                }
            }
            return arrayList;
        }
    }

    public static class Commons {
        public static String getStackMethodName(int n) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            String string = stackTraceElementArray.length > n + 1 ? stackTraceElementArray[n].getMethodName() : "UNKNOWN METHOD";
            return string;
        }

        public static String getCallerMethodName() {
            String string = Commons.getStackMethodName(5);
            if (string.equals("invoke0")) {
                string = Commons.getStackMethodName(4);
            }
            return string;
        }
    }

    public static class Comparison {
        public static final Comparator<QName> QNAME_COMPARATOR = new Comparator<QName>(){

            @Override
            public int compare(QName qName, QName qName2) {
                if (qName == qName2 || qName.equals(qName2)) {
                    return 0;
                }
                int n = qName.getNamespaceURI().compareTo(qName2.getNamespaceURI());
                if (n != 0) {
                    return n;
                }
                return qName.getLocalPart().compareTo(qName2.getLocalPart());
            }
        };

        public static int compareBoolean(boolean bl, boolean bl2) {
            int n = bl ? 1 : 0;
            int n2 = bl2 ? 1 : 0;
            return n - n2;
        }

        public static int compareNullableStrings(String string, String string2) {
            return string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
        }
    }

    public static class ConfigFile {
        public static String generateFullName(String string) throws PolicyException {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer("wsit-");
                stringBuffer.append(string).append(".xml");
                return stringBuffer.toString();
            }
            throw new PolicyException(LocalizationMessages.WSP_0080_IMPLEMENTATION_EXPECTED_NOT_NULL());
        }

        public static URL loadFromContext(String string, Object object) {
            return Reflection.invoke(object, "getResource", URL.class, string);
        }

        public static URL loadFromClasspath(String string) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                return ClassLoader.getSystemResource(string);
            }
            return classLoader.getResource(string);
        }
    }

    public static class IO {
        private static final PolicyLogger LOGGER = PolicyLogger.getLogger(IO.class);

        public static void closeResource(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    LOGGER.warning(LocalizationMessages.WSP_0023_UNEXPECTED_ERROR_WHILE_CLOSING_RESOURCE(closeable.toString()), iOException);
                }
            }
        }

        public static void closeResource(XMLStreamReader xMLStreamReader) {
            if (xMLStreamReader != null) {
                try {
                    xMLStreamReader.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    LOGGER.warning(LocalizationMessages.WSP_0023_UNEXPECTED_ERROR_WHILE_CLOSING_RESOURCE(xMLStreamReader.toString()), xMLStreamException);
                }
            }
        }
    }

    public static class Reflection {
        private static final PolicyLogger LOGGER = PolicyLogger.getLogger(Reflection.class);

        public static <T> T invoke(Object object, String string, Class<T> clazz, Object ... objectArray) throws RuntimePolicyUtilsException {
            Class[] classArray;
            if (objectArray != null && objectArray.length > 0) {
                classArray = new Class[objectArray.length];
                int n = 0;
                for (Object object2 : objectArray) {
                    classArray[n++] = object2.getClass();
                }
            } else {
                classArray = null;
            }
            return Reflection.invoke(object, string, clazz, objectArray, classArray);
        }

        public static <T> T invoke(Object object, String string, Class<T> clazz, Object[] objectArray, Class[] classArray) throws RuntimePolicyUtilsException {
            try {
                Method method = object.getClass().getMethod(string, classArray);
                Object object2 = method.invoke(object, objectArray);
                return clazz.cast(object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(Reflection.createExceptionMessage(object, objectArray, string), illegalArgumentException));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(Reflection.createExceptionMessage(object, objectArray, string), invocationTargetException));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(Reflection.createExceptionMessage(object, objectArray, string), illegalAccessException.getCause()));
            }
            catch (SecurityException securityException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(Reflection.createExceptionMessage(object, objectArray, string), securityException));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(Reflection.createExceptionMessage(object, objectArray, string), noSuchMethodException));
            }
        }

        private static String createExceptionMessage(Object object, Object[] objectArray, String string) {
            return LocalizationMessages.WSP_0061_METHOD_INVOCATION_FAILED(object.getClass().getName(), string, objectArray == null ? null : Arrays.asList(objectArray).toString());
        }
    }

    public static class Rfc2396 {
        private static final PolicyLogger LOGGER = PolicyLogger.getLogger(Reflection.class);

        public static String unquote(String string) {
            if (null == string) {
                return null;
            }
            byte[] byArray = new byte[string.length()];
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ('%' == c) {
                    if (i + 2 >= string.length()) {
                        throw LOGGER.logSevereException(new RuntimePolicyUtilsException(LocalizationMessages.WSP_0079_ERROR_WHILE_RFC_2396_UNESCAPING(string)), false);
                    }
                    int n2 = Character.digit(string.charAt(++i), 16);
                    int n3 = Character.digit(string.charAt(++i), 16);
                    if (0 > n2 || 0 > n3) {
                        throw LOGGER.logSevereException(new RuntimePolicyUtilsException(LocalizationMessages.WSP_0079_ERROR_WHILE_RFC_2396_UNESCAPING(string)), false);
                    }
                    byArray[n++] = (byte)(n2 * 16 + n3);
                    continue;
                }
                byArray[n++] = (byte)c;
            }
            try {
                return new String(byArray, 0, n, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw LOGGER.logSevereException(new RuntimePolicyUtilsException(LocalizationMessages.WSP_0079_ERROR_WHILE_RFC_2396_UNESCAPING(string), unsupportedEncodingException));
            }
        }
    }

    public static class ServiceProvider {
        public static <T> T[] load(Class<T> clazz, ClassLoader classLoader) {
            return ServiceFinder.find(clazz, classLoader).toArray();
        }

        public static <T> T[] load(Class<T> clazz) {
            return ServiceFinder.find(clazz).toArray();
        }
    }

    public static class Text {
        public static final String NEW_LINE = System.getProperty("line.separator");

        public static String createIndent(int n) {
            char[] cArray = new char[n * 4];
            Arrays.fill(cArray, ' ');
            return String.valueOf(cArray);
        }
    }
}

