/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceMXBean;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DriverConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolingDataSource;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;

public class BasicDataSource
implements DataSource,
BasicDataSourceMXBean,
MBeanRegistration,
AutoCloseable {
    private static final Log log = LogFactory.getLog(BasicDataSource.class);
    private volatile Boolean defaultAutoCommit = null;
    private transient Boolean defaultReadOnly = null;
    private volatile int defaultTransactionIsolation = -1;
    private Integer defaultQueryTimeout = null;
    private volatile String defaultCatalog = null;
    private boolean cacheState = true;
    private Driver driver = null;
    private String driverClassName = null;
    private ClassLoader driverClassLoader = null;
    private boolean lifo = true;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int initialSize = 0;
    private long maxWaitMillis = -1L;
    private boolean poolPreparedStatements = false;
    private int maxOpenPreparedStatements = -1;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    private String evictionPolicyClassName = "org.apache.tomcat.dbcp.pool2.impl.DefaultEvictionPolicy";
    private boolean testWhileIdle = false;
    private volatile String password = null;
    private String url = null;
    private String username = null;
    private volatile String validationQuery = null;
    private volatile int validationQueryTimeout = -1;
    private volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private long maxConnLifetimeMillis = -1L;
    private boolean logExpiredConnections = true;
    private String jmxName = null;
    private boolean enableAutoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private volatile Set<String> disconnectionSqlCodes;
    private boolean fastFailValidation;
    private volatile GenericObjectPool<PoolableConnection> connectionPool = null;
    private Properties connectionProperties = new Properties();
    private volatile DataSource dataSource = null;
    private volatile PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private AbandonedConfig abandonedConfig;
    private boolean closed;
    private ObjectName registeredJmxName = null;

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog != null && defaultCatalog.trim().length() > 0 ? defaultCatalog : null;
    }

    @Override
    public boolean getCacheState() {
        return this.cacheState;
    }

    public void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public synchronized Driver getDriver() {
        return this.driver;
    }

    public synchronized void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName != null && driverClassName.trim().length() > 0 ? driverClassName : null;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public synchronized void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    @Override
    public synchronized boolean getLifo() {
        return this.lifo;
    }

    public synchronized void setLifo(boolean lifo) {
        this.lifo = lifo;
        if (this.connectionPool != null) {
            this.connectionPool.setLifo(lifo);
        }
    }

    @Override
    public synchronized int getMaxTotal() {
        return this.maxTotal;
    }

    public synchronized void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxTotal(maxTotal);
        }
    }

    @Override
    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(maxIdle);
        }
    }

    @Override
    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(minIdle);
        }
    }

    @Override
    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public synchronized long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public synchronized void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWaitMillis(maxWaitMillis);
        }
    }

    @Override
    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean poolingStatements) {
        this.poolPreparedStatements = poolingStatements;
    }

    @Override
    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized void setMaxOpenPreparedStatements(int maxOpenStatements) {
        this.maxOpenPreparedStatements = maxOpenStatements;
    }

    @Override
    public synchronized boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public synchronized void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnCreate(testOnCreate);
        }
    }

    @Override
    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    @Override
    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        }
    }

    @Override
    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
    }

    @Override
    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        }
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
        }
    }

    @Override
    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    public synchronized void setEvictionPolicyClassName(String evictionPolicyClassName) {
        if (this.connectionPool != null) {
            this.connectionPool.setEvictionPolicyClassName(evictionPolicyClassName);
        }
        this.evictionPolicyClassName = evictionPolicyClassName;
    }

    @Override
    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    @Override
    public int getNumActive() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        if (pool != null) {
            return pool.getNumActive();
        }
        return 0;
    }

    @Override
    public int getNumIdle() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        if (pool != null) {
            return pool.getNumIdle();
        }
        return 0;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery != null && validationQuery.trim().length() > 0 ? validationQuery : null;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int timeout) {
        this.validationQueryTimeout = timeout;
    }

    public List<String> getConnectionInitSqls() {
        List<String> result = this.connectionInitSqls;
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public String[] getConnectionInitSqlsAsArray() {
        List<String> result = this.getConnectionInitSqls();
        return result.toArray(new String[result.size()]);
    }

    public void setConnectionInitSqls(Collection<String> connectionInitSqls) {
        if (connectionInitSqls != null && connectionInitSqls.size() > 0) {
            ArrayList<String> newVal = null;
            for (String s : connectionInitSqls) {
                if (s == null || s.trim().length() <= 0) continue;
                if (newVal == null) {
                    newVal = new ArrayList<String>();
                }
                newVal.add(s);
            }
            this.connectionInitSqls = newVal;
        } else {
            this.connectionInitSqls = null;
        }
    }

    @Override
    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    @Override
    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    @Override
    public boolean getLogExpiredConnections() {
        return this.logExpiredConnections;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public void setLogExpiredConnections(boolean logExpiredConnections) {
        this.logExpiredConnections = logExpiredConnections;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public void setJmxName(String jmxName) {
        this.jmxName = jmxName;
    }

    public boolean getEnableAutoCommitOnReturn() {
        return this.enableAutoCommitOnReturn;
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.enableAutoCommitOnReturn = enableAutoCommitOnReturn;
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public Set<String> getDisconnectionSqlCodes() {
        Set<String> result = this.disconnectionSqlCodes;
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public String[] getDisconnectionSqlCodesAsArray() {
        Set<String> result = this.getDisconnectionSqlCodes();
        return result.toArray(new String[result.size()]);
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        if (disconnectionSqlCodes != null && disconnectionSqlCodes.size() > 0) {
            HashSet<String> newVal = null;
            for (String s : disconnectionSqlCodes) {
                if (s == null || s.trim().length() <= 0) continue;
                if (newVal == null) {
                    newVal = new HashSet<String>();
                }
                newVal.add(s);
            }
            this.disconnectionSqlCodes = newVal;
        } else {
            this.disconnectionSqlCodes = null;
        }
    }

    @Override
    public boolean getFastFailValidation() {
        return this.fastFailValidation;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this.fastFailValidation = fastFailValidation;
    }

    protected GenericObjectPool<PoolableConnection> getConnectionPool() {
        return this.connectionPool;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (Utils.IS_SECURITY_ENABLED) {
            PaGetConnection action = new PaGetConnection();
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(e);
            }
        }
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedOnBorrow();
        }
        return false;
    }

    public void setRemoveAbandonedOnMaintenance(boolean removeAbandonedOnMaintenance) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(removeAbandonedOnMaintenance);
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedOnMaintenance();
        }
        return false;
    }

    public void setRemoveAbandonedOnBorrow(boolean removeAbandonedOnBorrow) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnBorrow(removeAbandonedOnBorrow);
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    @Override
    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(logAbandoned);
    }

    public PrintWriter getAbandonedLogWriter() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogWriter();
        }
        return null;
    }

    public void setAbandonedLogWriter(PrintWriter logWriter) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogWriter(logWriter);
    }

    @Override
    public boolean getAbandonedUsageTracking() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getUseUsageTracking();
        }
        return false;
    }

    public void setAbandonedUsageTracking(boolean usageTracking) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setUseUsageTracking(usageTracking);
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.connectionProperties.remove(name);
    }

    public void setConnectionProperties(String connectionProperties) {
        if (connectionProperties == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (String entry : entries) {
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.registeredJmxName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(this.registeredJmxName);
            }
            catch (JMException e) {
                log.warn((Object)("Failed to unregister the JMX name: " + this.registeredJmxName), (Throwable)e);
            }
            finally {
                this.registeredJmxName = null;
            }
        }
        this.closed = true;
        GenericObjectPool<PoolableConnection> oldpool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), e);
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void invalidateConnection(Connection connection) throws IllegalStateException {
        PoolableConnection poolableConnection;
        if (connection == null) {
            return;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("Cannot invalidate connection: ConnectionPool is null.");
        }
        try {
            poolableConnection = connection.unwrap(PoolableConnection.class);
            if (poolableConnection == null) {
                throw new IllegalStateException("Cannot invalidate connection: Connection is not a poolable connection.");
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot invalidate connection: Unwrapping poolable connection failed.", e);
        }
        try {
            this.connectionPool.invalidateObject(poolableConnection);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalidating connection threw unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            DataSource newDataSource;
            PoolableConnectionFactory poolableConnectionFactory;
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.jmxRegister();
            ConnectionFactory driverConnectionFactory = this.createConnectionFactory();
            boolean success = false;
            try {
                poolableConnectionFactory = this.createPoolableConnectionFactory(driverConnectionFactory);
                poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
                poolableConnectionFactory.setMaxOpenPrepatedStatements(this.maxOpenPreparedStatements);
                success = true;
            }
            catch (SQLException se) {
                throw se;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating connection factory", ex);
            }
            if (success) {
                this.createConnectionPool(poolableConnectionFactory);
            }
            success = false;
            try {
                newDataSource = this.createDataSourceInstance();
                newDataSource.setLogWriter(this.logWriter);
                success = true;
            }
            catch (SQLException se) {
                throw se;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating datasource", ex);
            }
            finally {
                if (!success) {
                    this.closeConnectionPool();
                }
            }
            try {
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionPool.addObject();
                }
            }
            catch (Exception e) {
                this.closeConnectionPool();
                throw new SQLException("Error preloading the connection pool", e);
            }
            this.startPoolMaintenance();
            this.dataSource = newDataSource;
            return this.dataSource;
        }
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String user;
        Driver driverToUse = this.driver;
        if (driverToUse == null) {
            Class<?> driverFromCCL;
            block16: {
                driverFromCCL = null;
                if (this.driverClassName != null) {
                    try {
                        try {
                            if (this.driverClassLoader == null) {
                                driverFromCCL = Class.forName(this.driverClassName);
                                break block16;
                            }
                            driverFromCCL = Class.forName(this.driverClassName, true, this.driverClassLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                        }
                    }
                    catch (Exception t) {
                        String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                        this.logWriter.println(message);
                        t.printStackTrace(this.logWriter);
                        throw new SQLException(message, t);
                    }
                }
            }
            try {
                if (driverFromCCL == null) {
                    driverToUse = DriverManager.getDriver(this.url);
                } else {
                    driverToUse = (Driver)driverFromCCL.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!driverToUse.acceptsURL(this.url)) {
                        throw new SQLException("No suitable driver", "08001");
                    }
                }
            }
            catch (Exception t) {
                String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
                this.logWriter.println(message);
                t.printStackTrace(this.logWriter);
                throw new SQLException(message, t);
            }
        }
        if ((user = this.username) != null) {
            this.connectionProperties.put("user", user);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String pwd = this.password;
        if (pwd != null) {
            this.connectionProperties.put("password", pwd);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driverToUse, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }

    protected void createConnectionPool(PoolableConnectionFactory factory) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        this.updateJmxName(config);
        config.setJmxEnabled(this.registeredJmxName != null);
        GenericObjectPool<PoolableConnection> gop = this.abandonedConfig != null && (this.abandonedConfig.getRemoveAbandonedOnBorrow() || this.abandonedConfig.getRemoveAbandonedOnMaintenance()) ? new GenericObjectPool<PoolableConnection>(factory, config, this.abandonedConfig) : new GenericObjectPool<PoolableConnection>(factory, config);
        gop.setMaxTotal(this.maxTotal);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWaitMillis(this.maxWaitMillis);
        gop.setTestOnCreate(this.testOnCreate);
        gop.setTestOnBorrow(this.testOnBorrow);
        gop.setTestOnReturn(this.testOnReturn);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        gop.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        gop.setTestWhileIdle(this.testWhileIdle);
        gop.setLifo(this.lifo);
        gop.setSwallowedExceptionListener(new SwallowedExceptionLogger(log, this.logExpiredConnections));
        gop.setEvictionPolicyClassName(this.evictionPolicyClassName);
        factory.setPool(gop);
        this.connectionPool = gop;
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> oldpool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.timeBetweenEvictionRunsMillis > 0L) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        }
    }

    protected DataSource createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> pds = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, this.registeredJmxName);
            connectionFactory.setValidationQuery(this.validationQuery);
            connectionFactory.setValidationQueryTimeout(this.validationQueryTimeout);
            connectionFactory.setConnectionInitSql(this.connectionInitSqls);
            connectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            connectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            connectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            connectionFactory.setDefaultCatalog(this.defaultCatalog);
            connectionFactory.setCacheState(this.cacheState);
            connectionFactory.setPoolStatements(this.poolPreparedStatements);
            connectionFactory.setMaxOpenPrepatedStatements(this.maxOpenPreparedStatements);
            connectionFactory.setMaxConnLifetimeMillis(this.maxConnLifetimeMillis);
            connectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            connectionFactory.setEnableAutoCommitOnReturn(this.getEnableAutoCommitOnReturn());
            connectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeout());
            connectionFactory.setFastFailValidation(this.fastFailValidation);
            connectionFactory.setDisconnectionSqlCodes(this.disconnectionSqlCodes);
            BasicDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }

    protected static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        PoolableConnection conn = null;
        PooledObject<PoolableConnection> p = null;
        try {
            p = connectionFactory.makeObject();
            conn = p.getObject();
            connectionFactory.activateObject(p);
            connectionFactory.validateConnection(conn);
            connectionFactory.passivateObject(p);
        }
        finally {
            if (p != null) {
                connectionFactory.destroyObject(p);
            }
        }
    }

    protected void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    private void jmxRegister() {
        ObjectName oname;
        if (this.registeredJmxName != null) {
            return;
        }
        String requestedName = this.getJmxName();
        if (requestedName == null) {
            return;
        }
        try {
            oname = new ObjectName(requestedName);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, oname);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            log.warn((Object)"Failed to complete JMX registration", (Throwable)e);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        String requestedName = this.getJmxName();
        if (requestedName != null) {
            try {
                this.registeredJmxName = new ObjectName(requestedName);
            }
            catch (MalformedObjectNameException e) {
                log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
            }
        }
        if (this.registeredJmxName == null) {
            this.registeredJmxName = name;
        }
        return this.registeredJmxName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private void updateJmxName(GenericObjectPoolConfig config) {
        if (this.registeredJmxName == null) {
            return;
        }
        StringBuilder base = new StringBuilder(this.registeredJmxName.toString());
        base.append(",connectionpool=");
        config.setJmxNameBase(base.toString());
        config.setJmxNamePrefix("connections");
    }

    protected ObjectName getRegisteredJmxName() {
        return this.registeredJmxName;
    }

    static {
        DriverManager.getDrivers();
        try {
            if (Utils.IS_SECURITY_ENABLED) {
                ClassLoader loader = BasicDataSource.class.getClassLoader();
                String dbcpPackageName = BasicDataSource.class.getPackage().getName();
                loader.loadClass(dbcpPackageName + ".BasicDataSource$PaGetConnection");
                loader.loadClass(dbcpPackageName + ".DelegatingCallableStatement");
                loader.loadClass(dbcpPackageName + ".DelegatingDatabaseMetaData");
                loader.loadClass(dbcpPackageName + ".DelegatingPreparedStatement");
                loader.loadClass(dbcpPackageName + ".DelegatingResultSet");
                loader.loadClass(dbcpPackageName + ".PoolableCallableStatement");
                loader.loadClass(dbcpPackageName + ".PoolablePreparedStatement");
                loader.loadClass(dbcpPackageName + ".PoolingConnection$StatementType");
                loader.loadClass(dbcpPackageName + ".PStmtKey");
                String poolPackageName = PooledObject.class.getPackage().getName();
                loader.loadClass(poolPackageName + ".impl.LinkedBlockingDeque$Node");
                loader.loadClass(poolPackageName + ".impl.GenericKeyedObjectPool$ObjectDeque");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Unable to pre-load classes", cnfe);
        }
    }

    private class PaGetConnection
    implements PrivilegedExceptionAction<Connection> {
        private PaGetConnection() {
        }

        @Override
        public Connection run() throws SQLException {
            return BasicDataSource.this.createDataSource().getConnection();
        }
    }
}

