/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Internal;

public abstract class RowShifter {
    protected final Sheet sheet;

    public RowShifter(Sheet sh) {
        this.sheet = sh;
    }

    public List<CellRangeAddress> shiftMergedRegions(int startRow, int endRow, int n) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int size = this.sheet.getNumMergedRegions();
        for (int i = 0; i < size; ++i) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i);
            if (startRow + n <= merged.getFirstRow() && endRow + n >= merged.getLastRow()) {
                removedIndices.add(i);
                continue;
            }
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || merged.containsRow(startRow - 1) || merged.containsRow(endRow + 1)) continue;
            merged.setFirstRow(merged.getFirstRow() + n);
            merged.setLastRow(merged.getLastRow() + n);
            shiftedRegions.add(merged);
            removedIndices.add(i);
        }
        if (!removedIndices.isEmpty()) {
            this.sheet.removeMergedRegions(removedIndices);
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    public abstract void updateNamedRanges(FormulaShifter var1);

    public abstract void updateFormulas(FormulaShifter var1);

    @Internal
    public abstract void updateRowFormulas(Row var1, FormulaShifter var2);

    public abstract void updateConditionalFormatting(FormulaShifter var1);

    public abstract void updateHyperlinks(FormulaShifter var1);
}

