/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumns;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleInfo;

public class CreateTable {
    public static void main(String[] args) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = (XSSFSheet)wb.createSheet();
        XSSFTable table = sheet.createTable();
        table.setDisplayName("Test");
        CTTable cttable = table.getCTTable();
        CTTableStyleInfo style = cttable.addNewTableStyleInfo();
        style.setName("TableStyleMedium2");
        style.setShowColumnStripes(false);
        style.setShowRowStripes(true);
        AreaReference reference = new AreaReference(new CellReference(0, 0), new CellReference(2, 2));
        cttable.setRef(reference.formatAsString());
        cttable.setId(1L);
        cttable.setName("Test");
        cttable.setTotalsRowCount(1L);
        CTTableColumns columns = cttable.addNewTableColumns();
        columns.setCount(3L);
        for (int i = 0; i < 3; ++i) {
            CTTableColumn column = columns.addNewTableColumn();
            column.setName("Column");
            column.setId((long)(i + 1));
            XSSFRow row = sheet.createRow(i);
            for (int j = 0; j < 3; ++j) {
                XSSFCell cell = row.createCell(j);
                if (i == 0) {
                    cell.setCellValue("Column" + j);
                    continue;
                }
                cell.setCellValue("0");
            }
        }
        FileOutputStream fileOut = new FileOutputStream("ooxml-table.xlsx");
        wb.write((OutputStream)fileOut);
        fileOut.close();
        wb.close();
    }
}

