/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For
 * more information on developing OnBoard C (including submission of
 * bug reports), see http://sourceforge.net/projects/onboardc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***********************************************************************/


typedef enum {
	NotACharacter,
	Whitespace,
	Operator,
	Digit,
	HexDigit,
	Letter,
	EndOfInput,
	Identifier,		//	0x07

	Token_Error,
	Token_EOF,

	Number,
	Dollar,
	AddressOf,
	LeftParen,
	RightParen,
	Plus,
	Comma,
	Minus,
	Period,			// 0x12
	Divide,
	SemiColon,

	DoubleQuote,

	Token_d0,		// 22 - 0x16
	Token_d1,
	Token_d2,
	Token_d3,
	Token_d4,
	Token_d5,
	Token_d6,
	Token_d7,
	Token_a0,
	Token_a1,
	Token_a2,
	Token_a3,
	Token_a4,
	Token_a5,
	Token_a6,
	Token_a7,
	Token_SP = Token_a7,
	Token_PC,

	Token_Get,
	Token_Prc,		// 40 - 0x28
	Token_Label,
	Token_Goto,

	Token_Systrap,
	Token_Dc,
	Token_Proc,		//		0x2D
	Token_BeginProc,
	Token_EndProc,
	Token_End,
	Token_Local,
	Token_Code,		// 50 - 0x32
	Token_Data,
	Token_Include,
	Token_Creator,

	ByteSpec,		// 0x36
	WordSpec,		// 0x37
	LongSpec,		// 0x38
	NoSpec,

	Token_Instruction_Start,				// 57
	Token_Add = Token_Instruction_Start,
	Token_Sub = Token_Add + 6,
	Token_Adda = Token_Sub + 6,
	Token_Addi = Token_Adda + 2,
	Token_Addq = Token_Addi + 3,
	Token_Suba = Token_Addq + 3,
	Token_Subi = Token_Suba + 2,
	Token_Subq = Token_Subi + 3,
	Token_And = Token_Subq + 3,
	Token_Move = Token_And + 6,
	Token_Cmpi = Token_Move + 3,
	Token_Beq = Token_Cmpi + 3,
	Token_Ble = Token_Beq + 1,
	Token_Bge = Token_Ble + 1,
	Token_Bgt = Token_Bge + 1,			// 100
	Token_Blt = Token_Bgt + 1,
	Token_Bne = Token_Blt + 1,
	Token_Movem = Token_Bne + 1,
	Token_Tst = Token_Movem + 12,
	Token_Unlk = Token_Tst + 3,
	Token_Link = Token_Unlk + 1,
	Token_Pea = Token_Link + 1,
	Token_Lea = Token_Pea + 1,
	Token_Jsr = Token_Lea + 1,
	Token_Rts = Token_Jsr + 1,
	Token_Mulu = Token_Rts + 1,
	Token_Muls = Token_Mulu + 1,
	Token_Neg = Token_Muls + 1,
	Token_Cmp = Token_Neg + 3,
	Token_Ext = Token_Cmp + 3,
	Token_Bra = Token_Ext + 2,
	Token_Andi = Token_Bra + 1,
	Token_Moveq = Token_Andi + 3,
	Token_Divu = Token_Moveq + 1,
	Token_Divs = Token_Divu + 1,
	Token_Swap = Token_Divs + 1,
	Token_Lsl = Token_Swap + 1,
	Token_Lsr = Token_Lsl + 6,
	Token_Asr = Token_Lsr + 6,
	Token_Seq = Token_Asr + 6,
	Token_Sle = Token_Seq + 1,
	Token_Sge = Token_Sle + 1,
	Token_Sgt = Token_Sge + 1,
	Token_Slt = Token_Sgt + 1,
	Token_Sne = Token_Slt + 1,
	Token_Or = Token_Sne + 1,
	Token_Ori = Token_Or + 6,
	Token_Clr = Token_Ori + 3,
	Token_Addx = Token_Clr + 3,
	Token_Bcs = Token_Addx + 6,
	Token_Bcc = Token_Bcs + 1,
	Token_Dbra = Token_Bcc + 1,
	Token_Eor = Token_Dbra + 1,
	Token_Eori = Token_Eor + 3,
	Token_Trap = Token_Eori + 3,
	Token_Btst = Token_Trap + 1,
	Token_Bchg = Token_Btst + 2,
	Token_Bclr = Token_Bchg + 2,
	Token_Bset = Token_Bclr + 2,
	Token_Bsr = Token_Bset + 2,
	Token_Not = Token_Bsr + 1,
	Token_Rte = Token_Not + 3,

	Token_Bls = Token_Rte + 1,
	Token_Bhi = Token_Bls + 1,

	Token_Sls = Token_Bhi + 1,
	Token_Scs = Token_Sls + 1,
	Token_Shi = Token_Scs + 1,
	Token_Scc = Token_Shi + 1,
	Token_Jmp = Token_Scc + 1,

	Token_Instruction_End = Token_Jmp + 1,

	PoolID,
	DefinePoolID,

	EA_d0,			// 0xD9
	EA_d1,
	EA_d2,
	EA_d3,
	EA_d4,
	EA_d5,
	EA_d6,
	EA_d7,
	EA_a0,
	EA_a1,
	EA_a2,
	EA_a3,
	EA_a4,
	EA_a5,
	EA_a6,
	EA_a7,

	EA_local,
	Token_Stmt,
	Token_Return,
	Zero,
	Extend,
	Token_Asm,
	Token_EndAsm,
	Token_Equ

} Token;

#define InstructionTableSize (Token_Instruction_End - Token_Instruction_Start)

typedef struct DOCHeader {
  //	unsigned long dontKnow1;
  int flag; // 1--> uncompressed, 2--> compressed
  int dontKnow1;
	unsigned long size;
  //	unsigned long dontKnow2;
  int count; // # records
  int recSize; // uncompressed size per record
	unsigned long dontKnow3;
} DOCHeader;

typedef struct {
	Boolean memoRecords;
	Boolean execute;
	Boolean saveASM;
	char sourceName[dmDBNameLength];
} PrefsData;

extern PrefsData gPrefs;

typedef struct {
	CharPtr start;
	CharPtr end;
	Handle h;
	long size;
	int index;
} SourceInfo;
#define MaxSourceIndex 32
extern SourceInfo sourceList[MaxSourceIndex];
extern int sourceIndex;
extern int sourceIndexTop;
extern CharPtr sourceEnd;

extern int gSourceIndex;
extern int gIncludeDepth;

extern CharPtr getSourceName();
extern CharPtr getSourceText(Boolean deleteFlag, LocalID dbID);
//extern void releaseSourceRecord(Boolean deleteFlag);
extern void collectAsmTextNamesFromQED();
extern void collectAsmTextNamesFromMemoDB();
extern void setListSelection(CharPtr sourceName);
extern void setFromTarget();
extern void gotoEditor(CharPtr sourcePtr, int length);
extern CharPtr prepareQEDSource(DmOpenRef sourceDB);

extern Boolean gMatchReservedWords;

typedef struct {
	char name[dmDBNameLength];
} QEDPrefsData;

void error(char *errMessage);

extern Boolean gInvokedFromCompiler;

CharPtr getNextToken(CharPtr curTextPtr, int *token, long *tValue, CharPtr *tStart, CharPtr hash);


extern LocalID gTargetDB;
extern int gTargetRecord;
extern DmOpenRef sourceCopyDB;
extern Handle copyDOCSource(DmOpenRef sourceDB, DmOpenRef theCopyDB, UIntPtr at, Handle *recordLengthList);
extern CharPtr getIncludeSource(CharPtr includeDBname, int includeNameLength, Boolean deleteFlag);

extern void closeSourceDB();
extern void closeAllDBs(Boolean deleteFlag);
extern CharPtr getExtendAsm(CharPtr includeDBname, int includeNameLength);
extern CharPtr getSourceAsm(LocalID dbID);

extern UInt gAsmTextListSize;
extern char **gAsmTextList;
extern long *gAsmTextListIndex;
