/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

#ifdef __GNUC__
#include <Event.h>
#endif

#define DEBUG_SUPPORT 0
#define DEBUG_BREAKPOINTS 0

#include "debugTypes.h"


void DebugInit(DebugData *dbgP);
void DebugEntry();
void DebugExit();
void DebugTerm(DebugData *dbgP);
void EndOfDebugCode();
void StartOfDebugCode();

#define SizeOfDebugCode ((char *)EndOfDebugCode - (char *)StartOfDebugCode)
#define OffsetOfDebugInit ((char *)DebugInit - (char *)StartOfDebugCode)
#define OffsetOfDebugExit ((char *)DebugExit - (char *)StartOfDebugCode)
#define OffsetOfDebugTerm ((char *)DebugTerm - (char *)StartOfDebugCode)
#define OffsetOfDebugEntry ((char *)DebugEntry - (char *)StartOfDebugCode)

#define NoAction 0x0
#define BreakAction 0x1
#define TraceAction 0x2

extern Handle gSymbolDataH;
extern SymbolData *gSymbolDataList;
extern int gMaxSymbolData;
extern int gSymbolDataListTop;
extern int gSymbolDataIndex;

extern Handle gSymbolStringH;
extern char *gSymbolString;
extern int gMaxSymbolString;
extern int gSymbolStringTop;
extern int gSymbolStringIndex;

extern char *DebugEntryName;
extern int DebugEntryNameLength;
extern int DebugEntryNameHash;
extern char *DebugInitName;
extern int DebugInitNameLength;
extern int DebugInitNameHash;
extern char *DebugExitName;
extern int DebugExitNameLength;
extern int DebugExitNameHash;
extern char *DebugTermName;
extern int DebugTermNameLength;
extern int DebugTermNameHash;

