/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/


#ifndef __DEBUGTYPES_H__
#define __DEBUGTYPES_H__

#include <PalmCompatibility.h>

typedef enum { SymBase, SymCode, SymLocal, SymReturn } SymFlag;
typedef enum { 
	DBG_CharPointer, 
	DBG_Pointer, 
	DBG_Signed, 
	DBG_Unsigned, 
	DBG_FormPointer,
	DBG_EventPointer,
	DBG_Unknown 
} DBG_TypeFlag;

typedef struct {
	ULong nullLink;
	long version;
	ULong ramSize;
	Handle symbH;		// Symb resource handle (or NULL)
	UInt traceID;
	ULong resBase;		// calculated base address of code resource
	ULong a6Prime;
	
	ULong oldHandler_BusErr;
	ULong oldHandler_AddrErr;
	ULong oldHandler_IllInstr;
	ULong oldHandler_Divz;

	Boolean (*oldNextEventHandler)(EventPtr eventP);
	void (*oldErrDisplayFileLineMsgEventHandler)(const Char * const filename, UInt lineNo, const Char * const msg);

} DebugData;

typedef struct {
	int nameOffset;
	int	offset;
	int size;
	SymFlag flag;		
	DBG_TypeFlag type;
	char debugAction;
} SymbolData;


#endif // __DEBUGTYPES_H__
