/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

#include "AsmToken.h"

#ifdef __GNUC__
#define SEG_1 __attribute__ ((section ("Seg1")))
#define SEG_2 __attribute__ ((section ("Seg2")))
#define SEG_3 __attribute__ ((section ("Seg3")))
#define SEG_4 __attribute__ ((section ("Seg4")))
#define SEG_5 __attribute__ ((section ("Seg5")))
#else
#define SEG_1
#define SEG_2
#define SEG_3
#define SEG_4
#define SEG_5
#endif

typedef enum {
	NotACharacter,
	HexDigit,
	Letter,
	Digit,
	Whitespace,
	Operator,
	EndOfInput,
	Identifier,	
	Token_Error,
	Token_EOF,	
	Number,
	Dollar,
	And,
	Or,
	Xor,
	Multiply,
	Divide,
	Remainder,
	Minus,
	Plus,				
	LeftShift,
	RightShift,
	AndEqual,
	OrEqual,
	XorEqual,
	MultiplyEqual,
	DivideEqual,
	RemainderEqual,
	MinusEqual,
	PlusEqual,
	LeftShiftEqual,
	RightShiftEqual,
	LeftParen,
	RightParen,
	LeftCurly,
	RightCurly,
	LeftBracket,
	RightBracket,
	Comma,
	Period,
	Question,
	Colon,
	SemiColon,
	Tilde,
	Not,
	DoubleQuote,
	Quote,
	Less,
	Greater,
	Equal,	
	UnaryMinus,
	UnaryPlus,
	Indirect,
	AddressOf,
	EqualEqual,
	PostIncrement,
	PostDecrement,
	PreIncrement,
	PreDecrement,
	Arrow,
	LessEqual,
	GreaterEqual,
	NotEqual,
	AndAnd,
	OrOr,
	Sizeof,
	Typedef,
	Convert,
	Decl,
	Asm,
	Auto,
	Break,
	Case,
	Char_Token,
	Continue,
	Default,
	Do,
	Double_Token,
	Else,
	Enum,
	Extern,
	Float_Token,
	For,
	Goto,
	If,
	Int_Token,
	Long_Token,
	Register,
	Return,
	Short_Token,
	Static,
	Struct,
	Switch,
	Union,
	Unsigned_Token,
	Void_Token,
	While,
	Const,
	FPDigit,
	Ifdef,
	Endif,
	Pragma,
	Backslash,
	TokenCount
} Token;

typedef struct {
	int token;
	long value;
	CharPtr start;
	unsigned char hash;
} ParseState;

#define MAX_SOURCE 20

typedef enum { DocSource, MemoSource, Resource, Pedit32Source, NoSource } SourceKind;

typedef struct {
	SourceKind sourceKind;
	char sourceDB[dmDBNameLength];
	LocalID sourceDBid;				// for Memo sources, this is the record number
	int includeIndex[16];
	int includeCount;
	char outputDB[dmDBNameLength];
	LocalID outputDBid;
} SourceFile;

typedef struct {
	SourceKind sourceKind;
	char sourceDB[dmDBNameLength];
	LocalID sourceDBid;				// for Memo sources, this is the record number
	int includeIndex[8];
	int includeCount;
	char outputDB[dmDBNameLength];
	LocalID outputDBid;
} SourceFile_Old;

typedef struct {
	SourceKind includeKind;
	char includeDB[dmDBNameLength];
	int includeNameLength;
} IncludeFile;

typedef struct {
	int version;
	int sourceDBCount;
	Boolean execute;
	Boolean alwaysRebuild;
	ULong creator;
	char appName[dmDBNameLength];
	char prcName[dmDBNameLength];
	SourceFile_Old source[MAX_SOURCE];
	int includeCount;
	IncludeFile include[MAX_SOURCE];
	ULong type;
} ProjectHeader;

typedef struct {
	int mVersion;
	int mSourceDBCount;
	int mIncludeCount;
	ULong mFlags;
	ULong mCreator;
	ULong mType;
	char mAppName[dmDBNameLength];
	char mPrcName[dmDBNameLength];
	char reserved[32];
} ProjectHeader_New;	// followed by sourceDBCount SourceFile records, then includeCount IncludeFile records.

typedef struct {
	ProjectHeader_New prj;
	SourceFile source[MAX_SOURCE];
	IncludeFile include[MAX_SOURCE];
} ProjectDetails;	

extern ProjectDetails gProjectHeader;
extern int gSourceIndex;

void error(char *errMessage) SEG_1;
void sourceError(char *errMessage, CharPtr sourcePtr) SEG_1;
void sourceErrorWithLength(char *errMessage, CharPtr sourcePtr, int length) SEG_1;
extern void addCodeStringConstant(CharPtr startPtr, int strLength, CharPtr tBuf, int *length) SEG_2;

extern Boolean compile(CharPtr sourceCode, Boolean forDebug) SEG_2;

extern void buildMemoSourceList() SEG_1;
extern void buildPedit32SourceList() SEG_1;
extern CharPtr getNextToken(CharPtr curTextPtr, ParseState *ps);// int *token, long *tValue, CharPtr *tStart, unsigned char *tHash);

extern Handle outputHandle;
extern CharPtr outputBuffer;
extern UInt outputRecordNumber;
extern ULong outputTop;
//extern ULong totalOutputSize;
extern ULong outputSize;
extern DmOpenRef gAsmDB;

extern Handle bodyContents;
extern CharPtr bodyBuffer;
extern ULong bodyTop;
extern ULong bodySize;

//extern Handle gDataContents;
//extern CharPtr gDataBuffer;
//extern UInt gDataContentIndex;
extern ULong gDataTop;

extern Handle gDataContentHStack[8];
extern CharPtr gDataContentStack[8];
extern UInt gDataContentIndexStack[8];
extern UInt gDataContentSizeStack[8];
extern int gDataContentStackTop;

extern Handle stringPoolContents;
extern CharPtr stringPoolBuffer;
extern ULong stringPoolTop;
extern ULong stringPoolSize;
extern int stringPoolIndex;
extern UInt stringPoolRecordIndex;

extern Handle codeStringPoolContents;
extern CharPtr codeStringPoolBuffer;
extern ULong codeStringPoolTop;
extern ULong codeStringPoolSize;
extern int codeStringPoolIndex;
extern UInt codeStringPoolRecordIndex;

extern int macroListTop;
extern int textStackTop;
extern CharPtr macroEndPtr;

enum { Base, Pointer, Function, Array, Enumeration, Structure };

typedef struct {
	int baseType;	// basetype of array & pointer, return type of function, BUT field count for structs 
	char flags;
	int size;		// size for everything except functions, for which it's the arg count 
	union {
		int index;		// base of arg or field list for functions or structs
		long value;		// constant value for enum constants, size of arrays (or - 1)
	} data;
} Type;

extern Boolean isPointer(int index) SEG_4;
extern int getBaseType(int index) SEG_4;

typedef struct Declaration {
	CharPtr name;
	char length;
	Boolean isTypedef;
	Boolean typeNameSpace;
	char isStatic;			// 0 - extern, 1 - static, -1 - forward extern
	unsigned char hash;
	char bitWidth;			// #bits in field for fields, #inline words for functions, 
							// 'true' for enum Constants, -1 for locals on stack, otherwise register #
	int depth;				// block level for globals & locals, offset in struct for fields
	int typeIndex;
	union {
		int nextField;			// index of next field in struct, or -1
								// index of start of inline code for functions, or -1
		long value;				// enum value, or frame offset for locals
	} data;
	struct Declaration *nextDecl;
} Declaration;

typedef struct NodeStruct Node;

struct NodeStruct {
	int op;
	int offset;
	long value;
	int typeIndex;
	char reg;
	char reg2;
	union {
		struct {
			Node *node1;
			Node *node2;			
		} children;
		struct {
			CharPtr name;
			unsigned char hash;
			int length;
		} identifier;
		struct {
			unsigned long d1;
			unsigned long d2;
		} dBits;
		double dValue;
		float fValue;
		Declaration *decl;
	} data;
};
#define MaxNodes 128

enum {
	 None = -2, Immediate = -1, D0, D1, D2, D3, D4, D5, D6, D7, A0, A1, A2, A3, A4, A5, A6, A7, PC
 };


extern int MaxTypeIndex;
extern Type *typeTable;
extern Handle typeHandle;
extern int typeIndex;
enum { IntTypeIndex, UnsignedIntTypeIndex, LongTypeIndex, UnsignedLongTypeIndex, 
		ShortTypeIndex, UnsignedShortTypeIndex, CharTypeIndex, UnsignedCharTypeIndex, 
		FloatTypeIndex, DoubleTypeIndex, VoidTypeIndex, HighScalarType = VoidTypeIndex,
		IntPtrTypeIndex, BaseScalarPtrTypeIndex = IntPtrTypeIndex, UnsignedIntPtrTypeIndex, LongTypePtrIndex, UnsignedLongPtrTypeIndex, 
		ShortPtrTypeIndex, UnsignedShortPtrTypeIndex, CharPtrTypeIndex, UnsignedCharPtrTypeIndex, 
		FloatPtrTypeIndex, DoublePtrTypeIndex, VoidPtrTypeIndex, CharPtrPtrTypeIndex, 
		NumberOfPredefinedTypes
};
		
extern void addStringConstant(CharPtr startPtr, int strLength, CharPtr name, int *length) SEG_2;
extern void writeDeclaration(Declaration *theDecl) SEG_2;

extern Handle argumentListData;
extern Declaration *argumentList;
extern int argumentListTop;
extern int argumentListMax;

extern Handle fieldListData;
extern Declaration *fieldList;
extern int fieldListTop;
extern int fieldListMax;

#define MaxInlines 512
extern int inlineList[MaxInlines];
extern int inlineListTop;

extern int nextLabel;

extern Boolean isInlineFunction(Declaration *d) SEG_4;
extern int getInlineCount(Declaration *d) SEG_4;
extern int getInlineWord(Declaration *d, int index) SEG_4;

extern Boolean loadIntoDReg(Node *operand) SEG_4;
extern Boolean genCodeForExpression(Node *node, int trueBranch, int falseBranch, Node **result) SEG_4;
extern Node *generateCode(Node *node, int trueBranch, int falseBranch) SEG_4;
extern void emitBinary(AsmToken token, AsmToken sizeSpec, Node *operand1, Node *operand2, Boolean addOperandSize) SEG_4;
extern void emitMove(Node *operand1, Node *operand2, Boolean addOperandSize) SEG_4;
extern Boolean emitConvert(Node *operand, int toTypeIndex) SEG_4;
extern void emitLabel(int label) SEG_4;
extern void emitBranch(AsmToken token, int target) SEG_4;
extern Boolean emitConditionalBranch(Node *result, int trueBranch, int falseBranch) SEG_4;
extern void freeRegister(Node *operand) SEG_4;
extern void emitMoveDouble(Node *operand2, Node *operand1) SEG_4;

extern void resetCompiler() SEG_2;

#define MaxGlobal 512

extern Handle globalTableH;
extern Declaration *globalTable;
extern int globalTop;
extern UInt globalRecordIndex;
extern int fullGlobalCount;
extern Declaration *fullGlobalTable[8];
extern Handle fullGlobalTableH[8];
extern UInt fullGlobalRecordIndex[8]; 

extern void deleteGlobalData() SEG_1;
extern void initGlobalData() SEG_1;
extern Declaration *findGlobalDeclBase(Declaration *theDecl) SEG_3;


#define MaxMacroParameters 4
typedef struct MacroStruct MacroDef;

/*
 * Used in the MacroStruct and when creating a macro using the
 * addSpecialMacro() function to tell what processing to apply to macro
 * contents.  This enumeration needs to be kept in sync with the macro lookup
 * table used by evalMacro().
 */

typedef enum {
    MFSimple = 0,
    MFLineNumber = 1,
    MFFileName = 2
} MacroFunctions;

struct MacroStruct {
	CharPtr name;
	int length;
	int parameterCount;
	unsigned char hash;
	CharPtr parameter[MaxMacroParameters];
	unsigned char parameterHash[MaxMacroParameters];
	int parameterLength[MaxMacroParameters];
	CharPtr macroStart;
	CharPtr macroEnd;
	int nextMacro;
    MacroFunctions function;
} ;

#define HeaderVersion '0107'
typedef struct HeaderBlock {
	ULong version;
	int macroCount;
	MacroDef *macroList;
	int macroHashTable[128];
	int globalCount;
	Declaration *globalList;
	int hashEntryIndex[128];
	int sysTrapCount;
	Declaration *sysTrapList;
	int argCount;
	Declaration *argList;
	int fieldCount;
	Declaration *fieldList;
	int inlineCount;
	int *inlineList;
	int typeCount;
	Type *typeList;
	char *base;
	char *stringBase;
	ULong stringSize;
} HeaderBlock;
extern HeaderBlock *gHB;

extern void setStatus(CharPtr message, CharPtr status, int length) SEG_1;

extern Boolean longMultiplyUsed;
extern Boolean longUnsignedDivideUsed;
extern Boolean longSignedDivideUsed;
extern Boolean longUnsignedRemainderUsed;
extern Boolean longSignedRemainderUsed;

extern UInt buildSysTrapData(DmOpenRef outputDB, CharPtr sysTrapSource) SEG_1;
extern int gSysTrapTop;
extern Declaration *gSysTrapList;
extern Handle gSysTrapHandle;

extern Boolean isFunction(int index) SEG_4; 
extern Boolean isPointer(int index) SEG_4;
extern Boolean isArray(int index) SEG_4;
extern Boolean isIntegral(int index) SEG_4;
extern Boolean isStruct(int index) SEG_4;
extern Boolean isEnum(int index) SEG_4;
extern Boolean isStructOrEnum(int index) SEG_4;
extern void fixTypeSizes(int index) SEG_4;
extern Boolean matchTypes(int index1, int index2) SEG_4;
extern void setDimension(int index, int dimension) SEG_4;
extern int getDimension(int index) SEG_4;
extern void setArguments(int index, int argStart, Boolean isVarArg) SEG_4;
extern void setFields(int index, int fieldStart, int theSize) SEG_4;
extern void setEnumBaseType(int index, int baseType) SEG_4;
extern int getTypeSize(int index) SEG_4;
extern int getArgTypeIndex(int index, int argIndex) SEG_4;
extern Declaration *getArg(int index, int argIndex) SEG_4;
extern Type *getType(int index) SEG_4;
extern int getBaseType(int index) SEG_4;
extern int *getBaseTypePtr(int index) SEG_4;
extern void setInlineFunction(Declaration *d, int inlineBase, int inlineSize) SEG_4;
extern Boolean isInlineFunction(Declaration *d) SEG_4;
extern int getInlineCount(Declaration *d) SEG_4;
extern int getInlineWord(Declaration *d, int index) SEG_4;
extern int addInline(int inlineValue) SEG_4;
extern int newStructType() SEG_4;
extern int newEnumType() SEG_4;
extern int newPointerType(int theType) SEG_4;
extern int newArrayType(int theType) SEG_4;
extern int newFunctionType(int theType) SEG_4;

extern void pushBack(ParseState *ps) SEG_1;//int tToken, long tValue, CharPtr tStart, unsigned char tHash);
extern int gHasPushBackToken;

extern Declaration *getFirstField(int index) SEG_4;
extern Declaration *getNextField(int index, Declaration *previousField) SEG_4;
extern Declaration *findField(int index, CharPtr name, int length) SEG_4;
extern int findEnum(CharPtr name, int length, int scope) SEG_4;

enum {
	GlobalScope, LocalScope, ArgumentScope, FieldScope
};

#define MaxLocals 64
extern Declaration localDeclaration[MaxLocals];
extern int localTop;

#define MaxBlocks 16
extern int blockTable[MaxBlocks];
extern int topBlock;
extern int blockIndex;

extern Declaration *findIdentifier(CharPtr name, int length, char *reg, unsigned char hash, Declaration *proxy) SEG_4;
extern int findStruct(CharPtr name, int length, int scope, unsigned char hash) SEG_4;

extern int currentFunctionType;

extern CharPtr constantExpression(CharPtr curTextPtr, long *theValue, Boolean expectFP, double *dValue) SEG_2;

extern CharPtr getNextLexeme(CharPtr curTextPtr, ParseState *ps); //int *token, long *tValue, CharPtr *tStart, unsigned char *hash) SEG_1;

typedef struct DOCHeader {
    int     flag;			// 1 --> uncompressed, 2 --> compressed
    int     dontKnow1;
    long    size;			// uncompressed total size
    int     count;			// # records
    int     recSize;		// uncompressed size per record
    long    dontKnow2;
} DOCHeader;

typedef struct {
	char name[dmDBNameLength];
	unsigned short dontknow1;
	unsigned short dontknow2;
	unsigned short dontknow3;
} QEDPrefsData;

typedef struct {
	char name[dmDBNameLength];
	unsigned char dontknow3[18];
} QEDPrefsData156;

typedef struct {
	char name[dmDBNameLength];
	unsigned char dontknow3[28];
} QEDPrefsData2;

typedef enum { SrcEdit, QED, ZDoc, SmartEdit, WordSmith_Doc, QuickWord, ProgED } DocEditor;
typedef enum { Pedit, MemoPad, WordSmith_Memo } MemoEditor;

typedef struct {
	DocEditor docEditor;
	MemoEditor memoEditor;
	SourceKind addSourceType;
	char projectName[dmDBNameLength];
} PrefsData;

extern PrefsData gPrefs;

#define MaxInclude 32
typedef struct {
	Handle includeHandle;
	CharPtr savedSourcePtr;
	CharPtr includePtr;
	Long includeLength;
	CharPtr includeTrigger;
	int includeIndex;
	Handle recordLengthList;	// used to mess with the cursor position when goto'ing an error for DOC
	LocalID includeDBid;		// used to mess with the cursor position when goto'ing an error for DOC
	CharPtr includeName;		// used to mess with the cursor position when goto'ing an error for DOC
	int includeNameLength;		// used to mess with the cursor position when goto'ing an error for DOC
	SourceKind includeKind;
	int savedLineCount;
} IncludeData;
extern IncludeData includeData[MaxInclude];
extern int gIncludeTop;

extern CharPtr gMainSourceBasePtr;
extern int *gMainSourceRecordLengthList;

extern DmOpenRef gExprDB;

extern DmOpenRef gOutputDB;
extern DmOpenRef gGlobalsDB;

extern CharPtr getIncludeRecord(CharPtr name, int nameLength) SEG_3;
extern void collectCTextNamesFromDOC() SEG_1;
extern void collectCTextNamesFromMemoDB() SEG_1;
extern Handle getSourceText(LocalID dbID) SEG_3;
extern char *getSourceName() SEG_1;
extern LocalID getSourceDBid() SEG_1;
extern void getAsmName(char *sourceName, char *asmName, int asmIndex) SEG_1;

extern void launchEditor(ULong edType, GoToParamsType *pBlock, Word cmd, char *editorName) SEG_3;
extern void gotoEditor(CharPtr sourcePtr, int length, LocalID selectedDBid, char *selectedDBname) SEG_3;
extern Handle copyDOCSource(DmOpenRef sourceDB, DmOpenRef theCopyDB, UIntPtr at, Handle *recordLengthList) SEG_3;
extern void releaseIncludeRecords() SEG_3;
extern void releaseSourceRecord() SEG_3;
extern Boolean gMatchReservedWords;

extern void assureOutput(ULong length) SEG_1;
extern void addToOutput(CharPtr contents, ULong length) SEG_1;

extern double gFPDigit;

extern void setBitWidth(Declaration *declPtr, int declScope, char value) SEG_4;
extern void setDataValue(Declaration *declPtr, int declScope, long value) SEG_4;
extern void setDataField(Declaration *declPtr, int declScope, int value) SEG_4;
extern void setDepth(Declaration *declPtr, int declScope, int value) SEG_4;
extern void setStatic(Declaration *declPtr, int declScope, char value) SEG_4;
extern void setTypeIndex(Declaration *declPtr, int declScope, int value) SEG_4;
extern void setTypeDef(Declaration *declPtr, int declScope, Boolean value) SEG_4;

extern void writeSize(int size) SEG_5;
extern int gFunctionCount;

extern Handle gSysTrapHandle;
extern Declaration *gSysTrapList;
extern int gSysTrapSize;
extern int gSysTrapTop;

extern Declaration *makeDeclaration(CharPtr startPtr, int value, int startType, CharPtr curTextPtr,
 													int declScope, unsigned char hash, Boolean isTypeName) SEG_3;

extern CharPtr handleLocalStatics(CharPtr curTextPtr, Declaration *theDecl, int baseType) SEG_5;
extern CharPtr localInitializer(CharPtr curTextPtr, Declaration *theDecl, int initTypeIndex, Boolean seenLeftCurly, Boolean isLocalStatic, Declaration *theBaseDecl, int offset) SEG_5;
extern void constructFPResult(Node *result, int typeIndex) SEG_5;
extern void constructStructResult(Node *result, int typeIndex) SEG_5;

extern Node initTarget[4];
extern Declaration *structResult;

extern CharPtr expression(CharPtr curTextPtr, int trueBranch, int falseBranch, Node **result, Boolean allowComma) SEG_3;
extern Node *newTemp(int typeIndex, int statementIndex) SEG_5;
extern Declaration *newGlobalTemp(int typeIndex) SEG_5;
extern CharPtr declaration(CharPtr curTextPtr, int *baseType, Declaration **theDecl, int declScope, Boolean allowAbstract) SEG_3;

#define TEMP_COUNT 8
#define TEMP_NAME_SIZE 5
typedef struct TempNamePool TempNamePool;
struct TempNamePool {
	TempNamePool *next;
	char statementIndex[TEMP_COUNT];
	int tempType[TEMP_COUNT];
	Declaration tempDecl[TEMP_COUNT];
	char tempNames[TEMP_COUNT][TEMP_NAME_SIZE];
};
extern int tempIndex;
extern int tempCount;

extern TempNamePool *tempNameSpace;
extern TempNamePool *tempNameBase;

extern void emitUserLabel(CharPtr uLabel, int length) SEG_4;
extern void emitUserBranch(CharPtr uLabel, int length) SEG_4;

extern Boolean gReturnWhitespace;

extern Handle gRecordLengthList;
extern Boolean gErrorInHeader;
extern LocalID gHeaderDBID;

extern char* HeaderName;

extern char buf[64];		// handy buffer for various things (not on the stack!)

extern void replaceType(int index, int oldType, int newType) SEG_4;
extern int newType() SEG_4;
extern Node *addIdentifierNode(CharPtr name, int length, unsigned char hash) SEG_3;
extern Node *resolveIdentifier(Node *operand) SEG_3;

extern void addIdentifierToOutput(CharPtr name, int length, int depth, Boolean isStatic) SEG_1;
extern void addTokenToOutput(AsmToken token) SEG_1;
extern void addNumberToOutput(long value) SEG_1;
extern void addStringToOutput(CharPtr str, int length) SEG_1;

extern void writeSize(int size) SEG_5;
extern void writeTokenToDataBuffer(AsmToken token) SEG_1;
extern void writeToDataBuffer(char *ptr, int length) SEG_1;

extern int gLocalPoolIndexList[MaxLocals];
extern Boolean getPoolIndex(Declaration *declPtr, int *poolIndex) SEG_4;
extern void resetPoolIndexList() SEG_4;

#define MAX_PUSHBACK 2
extern int gHasPushBackToken;
extern int gPushBackToken[MAX_PUSHBACK];
extern long gPushBackValue[MAX_PUSHBACK];
extern unsigned char gPushBackHash[MAX_PUSHBACK];
extern CharPtr gPushBackStart[MAX_PUSHBACK];

#define MaxTextStack 4
extern CharPtr macroEndPtrStack[MaxTextStack];
extern CharPtr curTextPtrStack[MaxTextStack];
extern int macroListTopStack[MaxTextStack];
extern CharPtr macroEndPtr;
extern int textStackTop;

extern CharPtr addSpecialMacro( CharPtr curTextPtr,
                                MacroFunctions function ) SEG_1;
extern CharPtr addMacro(CharPtr curTextPtr) SEG_1;

extern MacroDef *evalMacro(CharPtr macroName, int length, unsigned char hash) SEG_1;
extern MacroDef *findMacro(CharPtr macroName, int length, unsigned char hash) SEG_1;
extern int gMacroHashTable[128];
extern Handle macroH;
extern MacroDef *macroList;

#define DO_CODEGEN 1

extern Declaration *gLocalHashTable[128];
extern Declaration *gGlobalHashTable[128];

extern int gFrameSize;
extern LocalID openAsmFile(CharPtr asmName) SEG_1;
extern void closeAsmFile() SEG_1;
extern Boolean doCompile(Handle sourceH, char *sourceName, CharPtr appName, Boolean forDebug) SEG_1;
extern void startParser() SEG_1;
extern void stopParser() SEG_1;

extern int errorCount;
extern Boolean loadProject() SEG_1;
extern void reallocateOutputDBRecords() SEG_1;
extern void deleteHeader() SEG_1;
extern void gotoMemoPad(long sourceOffset, int length, int recordNum) SEG_3;
extern void gotoPedit32(long sourceOffset, int length, int recordNum) SEG_3;
extern Handle getMemoText(int recordNum) SEG_3;
extern Handle getPedit32Text(int recordNum) SEG_3;

extern char **memoSourceList;
extern long *memoSourceIndexList;
extern int memoSourceCount;
extern char **pedit32SourceList;
extern long *pedit32SourceIndexList;
extern int pedit32SourceCount;
extern Handle copyMemoSource(int recordNum, DmOpenRef theCopyDB, UIntPtr at, Handle *recordLengthList) SEG_3;
extern Handle copyPedit32Source(int recordNum, DmOpenRef theCopyDB, UIntPtr at, Handle *recordLengthList) SEG_3;
extern void markInclude(IncludeData *inc) SEG_1;

extern int gStatementIndex;
extern int gStaticIndex;

extern CharPtr handleInitializer(CharPtr curTextPtr, Declaration *theDecl, int initTypeIndex, Boolean seenLeftCurly) SEG_5;
extern Boolean gRegisterAllocated[13];
extern void emitLibCall(char *libname, int libNameLength) SEG_4;
extern void emitBozComment(char *comment, int commentLength) SEG_4;
extern void emitUnary(AsmToken token, AsmToken sizeSpec, Node *operand, Boolean addOperandSize) SEG_4;
extern void cleanStack(int stackDepth) SEG_4;
extern void emitDebugEntry() SEG_2;
extern void writeTokenToBuffer(AsmToken token) SEG_4;
extern void writeNumberToBuffer(long value) SEG_4;

extern int getSourceOffset(CharPtr sourcePtr) SEG_3;
extern int gLineCount;

extern Boolean isSigned(int index) SEG_4;
extern int gCurSegment;

Boolean isEmptyStruct(int index) SEG_4;

#define MAXSKIP 6
typedef enum { DontSkip, SkipToElse, SkipToEnd } SkipState;

extern SkipState gSkipState[MAXSKIP];
extern int gSkipTop;
extern Boolean gMatchReservedWords;

extern Token charTokenMap[256];
