#ifdef __GNUC__
#    include <PalmOS.h>    // for PRC Tool compatability
#endif

#define MainForm        1000

// *** PUT UI-DEFINITIONS HERE *** //

// Prototypes

static Boolean appHandleEvent (EventPtr pEvent);
static void    mainFormInit (FormPtr pForm);
static Boolean mainFormEventHandler (EventPtr pEvent);
static Boolean doMainMenu (FormPtr pForm, UInt16 command);

// Code

static void startApp() {return;}
static void stopApp()  {return;}


    UInt32
PilotMain
   (UInt16  cmd,
    void    *cmdPBP,
    UInt16  launchFlags)
{
    EventType    event;
    UInt16       error;

    if (cmd == sysAppLaunchCmdNormalLaunch)
    {
        startApp();
        FrmGotoForm(MainForm);

        do
        {
            // Wait for an event

            EvtGetEvent(&event, evtWaitForever);

            // ask event handlers, in turn, to deal with the event.

            if (!SysHandleEvent (&event))
            if (!MenuHandleEvent (0, &event, &error))
            if (!appHandleEvent (&event))
                FrmDispatchEvent (&event);
        } while (event.eType != appStopEvent);

        stopApp();
        FrmCloseAllForms();
    }
    return 0;
}

/*
 * top-level event handler for the application.
 */


    static Boolean
appHandleEvent (EventPtr pEvent)
{
    FormPtr pForm;
    Int16   formId;
    Boolean handled = false;

    if (pEvent->eType == frmLoadEvent)
    {
        // Load the resource for the form

        formId = pEvent->data.frmLoad.formID;
        pForm  = FrmInitForm(formId);

        FrmSetActiveForm(pForm);

        // install a form-specific event handler

        if (formId == MainForm)
            FrmSetEventHandler (pForm, mainFormEventHandler);

        // *** ADD NEW FORM HANDLING HERE *** //

        handled = true;
    }
    else if (pEvent->eType == menuEvent)
    {
        handled = doMainMenu(pForm, pEvent->data.menu.itemID);
    }
    return handled;
}


/*
 * Event handler for the main form.
 */


    static Boolean
mainFormEventHandler(EventPtr pEvent)
{
    Boolean handled = false;
    FormPtr pForm   = FrmGetActiveForm();

    switch (pEvent->eType)
    {
    case frmOpenEvent:    // Form's 1st event
        FrmDrawForm(pForm);
        mainFormInit(pForm);
        handled = true;
        break;

    // *** ADD EVENT HANDLING HERE *** //

    default:
        break;
    }
    return handled;
}

/*
 * This is the menu handler for the main form.
 */

    static Boolean
doMainMenu (FormPtr pForm, UInt16 command)
{
    Boolean    handled    = false;
    switch(command)
    {
    // *** ADD MENU HANDLING HERE *** //
    }
    return handled;
}

/*
 * Startup code for the form.
 */

    static void
mainFormInit (FormPtr pForm)
{
    static Char    foo[10]    = "Hello GUI";

    WinDrawChars (foo,StrLen(foo),20,18);

    // *** ADD FORM INITIALIZATION HERE *** //
}

    void    *
getObjectPtr (FormPtr pForm, Int16 resourceNo)
{
    UInt16 objIndex=FrmGetObjectIndex(pForm,resourceNo);
    return FrmGetObjectPtr(pForm,objIndex);
}

