#!/usr/bin/perl -w
#
# Quick script to turn OnBoard Asm files into human readable form
# Takes input from stdin or a specified file and output to stdout by default
#
# Files are output from OnBoardC in a binary "object" format. This script
# Attempts to decode them into a human readable form (mneumonic asm)
# for the purpose of debugging the codegeneration capabilties of the compiler
# or possibly in the future for hand-optimizing the asm code.
#
# Written as part of the OnBoardC project. http://onboardc.sourceforge.net
#
# This file is licensed under the GPL (http://www.gnu.org). You are free to 
# use and modify it under the terms of the GPL.
# This file comes with NO WARRANTY whatsoever.
#
# S. Little (boz_x@sourceforge.net)
# 29/07/03
# ver 0.1 - First release, not guaranteed to work very well, but achieves 
#           a basic starting point of functionality. 
#

use strict;

my @aAsmData;

# Set up a hash of what to print for each binary value found in the file

my %hTokenHash = (
#    "\x00" => '{*NotAChar*}', # Asm_NotACharacter
    "\x00" => '', # Asm_NotACharacter
    "\x01" => ' ', # Asm_Whitespace
    "\x02" => '{Operator}', # Asm_Operator
#    "\x03" => '{Digit}', # Asm_Digit
    "\x03" => '', # Asm_Digit
    "\x04" => '{HexDigit}', # Asm_HexDigit
    "\x05" => '{Letter}', # Asm_Letter
    "\x06" => '{EOI}', # Asm_EndOfInput
#    "\x07" => '{Identifier}', # Asm_Identifier
    "\x07" => '',
    "\x08" => '{TokenError}', # Asm_Token_Error
#    "\x09" => '{EOF}', # Asm_Token_EOF
    "\x09" => '', # Asm_Token_EOF
#    "\x0A" => '{Number}', # Asm_Number
    "\x0A" => '#', # Asm_Number
    "\x0B" => '{$}', # Asm_Dollar
    "\x0C" => '{AddressOf}', # Asm_AddressOf
    "\x0D" => "(", # Asm_LeftParen
    "\x0E" => ")", # Asm_RightParen
    "\x0F" => '+', # Asm_Plus

    "\x10" => ', ', # Asm_Comma
    "\x11" => '-', # Asm_Minus
    "\x12" => '.', # Asm_Period
    "\x13" => '/', # Asm_Divide
    "\x14" => ';', # Asm_SemiColon
    "\x15" => '"', # Asm_DoubleQuote
    "\x16" => 'd0 ', # Token_d0
    "\x17" => 'd1 ', #
    "\x18" => 'd2 ', #
    "\x19" => 'd3 ', #
    "\x1A" => 'd4 ', #
    "\x1B" => 'd5 ', #
    "\x1C" => 'd6 ', #
    "\x1D" => 'd7 ', #
    "\x1E" => 'a0 ', #
    "\x1F" => 'a1 ', #

    "\x20" => 'a2 ', #
    "\x21" => 'a3 ', #
    "\x22" => 'a4 ', #
    "\x23" => 'a5 ', #
    "\x24" => 'a6 ', #
    "\x25" => 'a7 ', # Token_a7 or Token_SP
    "\x26" => 'PC ', # Token_PC
    "\x27" => '{Get}', # Token_Get
    "\x28" => "\n{Prc}", # Token_Prc
    "\x29" => "\n{Label}", # Token_Label
    "\x2A" => '{Goto}', # Token_Goto
    "\x2B" => '{SysTrap}', # Token_Systrap
    "\x2C" => "\ndc", # Token_Dc
    "\x2D" => "\nproc ", # Token_Proc
    "\x2E" => "\nbeginproc\n", # Token_BeginProc
    "\x2F" => "\nendproc\n", # Token_EndProc

    "\x30" => "\n{End}\n", # Token_End
    "\x31" => "\nlocal ", # Token_Local
    "\x32" => "\ncode\n", # Token_Code
    "\x33" => "\ndata\n", # Token_Date
    "\x34" => '{Include}', # Token_Include
    "\x35" => '{Creator}', # Token_Creator
#    "\x36" => '{ByteSpec}', # ByteSpec
    "\x36" => '.b ', # ByteSpec
#    "\x37" => '{WordSpec}', # WordSpec
    "\x37" => '.w ', # WordSpec
#    "\x38" => '{LongSpec}', # LongSpec
    "\x38" => '.l ', # LongSpec
    "\x39" => '{Unsized}', # Unsized
    "\x3A" => '{InstructionStart}{/add}', # Token_Instruction_Start/Token_Add

    "\x40" => "\nsub ", #
    "\x46" => "\nadda ", #
    "\x48" => "\naddi ", #
    "\x4B" => "\naddq", #
    "\x4E" => "\nsuba ", #
    "\x50" => "\nsubi ", #
    "\x53" => "\nsubq ", #
    "\x56" => "\nand ", #
    "\x5C" => "\nmove", #
    "\x5F" => "\ncmpi", #
    "\x62" => "\nbeq ", #
    "\x63" => "\nble ", #
    "\x64" => "\nbge ", # 
    "\x65" => "\nbgt ", #
    "\x66" => "\nblt ", #
    "\x67" => "\nbne ", #
    "\x68" => "\nmovem ", #

    "\x74" => "\ntst ", #
    "\x77" => "\nunlk ", #
    "\x78" => "\nlink ", #
    "\x79" => "\npea ", #
    "\x7A" => "\nlea ", #
    "\x7B" => "\njsr ", #
    "\x7C" => "\nrts ", #
    "\x7D" => "\nmulu ", #
    "\x7E" => "\nmuls ", #
    "\x7F" => "\nneg ", #

    "\x82" => "\ncmp ", #
    "\x85" => "\next ", #
    "\x87" => "\nbra ", #
    "\x88" => "\nandi ", #
    "\x8B" => "\nmoveq ", #
    "\x8C" => "\ndivu ", #
    "\x8D" => "\ndivs ", #
    "\x8E" => "\nswap ", #
    "\x8F" => "\nlsl ", #
    "\x95" => "\nlsr ", #

    "\x9B" => "\nasr ", #
    "\xA1" => "\nseq ", #
    "\xA2" => "\nsle ", #
    "\xA3" => "\nsge ", #
    "\xA4" => "\nsgt ", #
    "\xA5" => "\nslt ", #
    "\xA6" => "\nsne ", #
    "\xA7" => "\nor ", #
    "\xAD" => "\nori ", #
    "\xB0" => "\nclr ", #

    "\xB3" => "\naddx ", #
    "\xB9" => "\nbcs ", #
    "\xBA" => "\nbcc ", #
    "\xBB" => "\ndbra ", #
    "\xBC" => "\neor ", #
    "\xBF" => "\neori ", #
    "\xC2" => "\ntrap ", #
    "\xC3" => "\nbtst ", #
    "\xC5" => "\nbchg ", #
    "\xC7" => "\nbclr ", #

    "\xC9" => "\nbset ", #
    "\xCB" => "\nbsr ", #
    "\xCC" => "\nnot ", #
    "\xCF" => "\nrte ", #
    "\xD0" => "\nbls ", #
    "\xD1" => "\nbhi ", #
    "\xD2" => "\nsls ", #
    "\xD3" => "\nscs ", #
    "\xD4" => "\nshi ", #
    "\xD5" => "\nscc ", #

    "\xD6" => '{InstructionEnd}', #
#    "\xD7" => '{PoolID}', #
    "\xD7" => '', # PoolID
#    "\xD8" => '{DefinePoolID}', #
    "\xD8" => '', # DefinePoolID
    "\xD9" => 'd0 ', # EA_d0
    "\xDA" => 'd1 ', # EA_d1
    "\xDB" => 'd2 ', # EA_d2
    "\xDC" => 'd3 ', # EA_d3
    "\xDD" => 'd4 ', # EA_d4
    "\xDE" => 'd5 ', # EA_d5
    "\xDF" => 'd6 ', # EA_d6

    "\xE0" => 'd7 ', # EA_d7
    "\xE1" => 'a0 ', # EA_a0
    "\xE2" => 'a1 ', # EA_a1
    "\xE3" => 'a2 ', # EA_a2
    "\xE4" => 'a3 ', # EA_a3
    "\xE5" => 'a4 ', # EA_a4
    "\xE6" => 'a5 ', # EA_a5
    "\xE7" => 'a6 ', # EA_a6
    "\xE8" => 'a7 ', # EA_a7
    "\xE9" => 'EA_local ', #

    "\xEA" => '{Stmt}', #
#    "\xEB" => "{Return}\n", #
    "\xEB" => '', # Return
    "\xEC" => '0', # Zero
    "\xED" => '{Extend}', #
    "\xEE" => '{Asm}', #
    "\xEF" => '{EndAsm}', #

);

# read the whole file into a string
while(<>){
    push @aAsmData, split '', $_;
}

#print join ',',@aAsmData;

# initialise a few flags
my $sAsmMode=1;
my $sIdCounter=0;
my $sIdText='';
my $sNumLen=0;
my $sNumCounter=0;
my $sNumber=0;
my $sIdLen=0;
my $sQuoteLen=0;


#loop through each byte (character) and convert it
foreach my $sChar (@aAsmData){

    if($sAsmMode == 1){ # normal mode of operation
	if(defined $hTokenHash{$sChar}){
	    print $hTokenHash{$sChar};
	}else{
	    printf "0x%02X ",ord($sChar);
	}
	if($sChar eq "\x07"){ # Identifier, 
	    $sAsmMode = 2;    # go read the 1 byte length
	}
	# these don't do much at the mo. All constants are 4 bytes it seems 
	if($sChar eq "\x36"){ # ByteSpec
	    $sNumLen = 4;
	}
	if($sChar eq "\x37"){ # WordSpec
	    $sNumLen = 4;
	}
	if($sChar eq "\x38"){ # LongSpec
	    $sNumLen = 4;
	}

	if($sChar eq "\x03"){ # AsmDigit
	    $sAsmMode = 3;
	    $sNumCounter = $sNumLen;
	}
	if($sChar eq "\x0A"){ # AsmNumber
	    $sNumLen = 4; # if it's an AsmNumber, ignore previous specification
	                  # of the size of the number (byte, word, long etc)
#	    $sAsmMode = 3;
	}
	if(($sChar eq "\xD8")||($sChar eq "\xD7")){ # DefinePoolID
	    $sIdLen = 2;
	    $sAsmMode = 4; # Go read the 2 byte length
	}
	if($sChar eq "\x15"){ # DoubleQuote
	    $sAsmMode = 5; # Go read the 2 byte length
	    $sQuoteLen = 2; 
	}
    }
    elsif($sAsmMode == 2){ # Get Identifier length
	$sIdCounter=ord($sChar)+0; # get the number of chars
	$sAsmMode = 0;
    }
    elsif($sAsmMode == 3){ # AsmNumber / AsmDigit
	$sNumber <<= 8;
	$sNumber += ord($sChar);
#	printf "0x%02X ", ord($sChar);
#	printf "(0x%X) ", $sNumber;
	$sNumCounter--;
	if($sNumCounter <= 0){
	    printf "\$%0X ", $sNumber;
	    $sAsmMode = 1;
	    $sNumber=0;
	}
    }
    elsif($sAsmMode == 4){ # PoolID or DefinePoolID
	$sIdLen--;
#	printf "0x%02X ", ord($sChar);
	if($sIdLen <= 0){
	    $sAsmMode = 1;
	}
    }
    elsif($sAsmMode == 5){ # read in 2 byte quote-length
	if($sQuoteLen==2){
	    $sIdCounter = ord($sChar)*0xFF;
	    $sQuoteLen = 1;
	} else {
	    $sIdCounter += ord($sChar);
	    $sQuoteLen = 0;
	    $sAsmMode = 6;
	}
    }
    elsif($sAsmMode == 6){ # Quoted Text
	print $sChar;
	$sIdCounter--;
	if($sIdCounter <= 0){
	    $sAsmMode = 1;
	    print "\"\n";
	}
    }
    elsif($sAsmMode == 0){ # Identifier Text
	$sIdText .= $sChar;
	$sIdCounter--;
	if($sIdCounter <= 0){
	    print $sIdText;
	    if($sIdText=~/^L_\d+$/){ # cheap attempt to seperate out labels
		print "\n";          # onto seperate lines
	    }
	    $sAsmMode = 1;
	    $sIdText = '';
#	    print ' ';
	}
    }
}
