/*
 * This is from the prc2rcp MS-Windows program graciously donated by Axel 
 * Ilenburg.  I've converted it from C++, removed the Windows stuff, and made
 * a few small mods to help it fit with the rest of the code.
 *
 * This file converts Palm-OS RSRC files to PilRC-compatible .RCP files.
 */

//---------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>	// for strchr
#include <errno.h>
#include "prc2rcp.h"
#include "debug.h"
#include "general.h"

//---------------------------------------------------------------------------

typedef struct tResHeader
{
	tInt8   Name [5];
	tIntU16 ID;
	tIntU32 Pos;
	tIntU32 Offset;
} tResHeader;

typedef struct tTitle
{
	tInt8 txt [80];
} tTitle;

// GUESS:
// struct TImage
// {
// 	struct _Picture
// 	{
// 		struct Bitmap {int _Width, _Height;} Bitmap;
// 		SaveToFile();
// 	} Picture;
// 	struct _Canvas
// 	{
// 		unsigned char (?) Pixels[x][y];
// 	} Canvas;
// };

//struct tBild
//  {
//    TImage *pImg;
//    tInt8   Name [80];
//    tIntU16 ID;
//  };

extern tIntU16 (*Swap16)(tIntU16 r);
extern tIntU32 (*Swap32)(tIntU32 r);

void			convertRsrc		(char		*nameOnPalm,
						 char		*nameOnHost);

static tResHeader	*AnalyzePRCFile		(char		*inFileName);
static void		AnalyzeRessources	(char		*nameOnPalm,
						 char		*nameOnHost,
	 					 tResHeader	*mpaResHeader);
static void		MenuBar			(FILE		*fp,
						 FILE		*fpOut,
						 tIntU32	Offset,
						 tIntU16	ID);
static void		Alert			(FILE		*fp,
						 FILE		*fpOut,
						 tIntU32	formOffset,
						 tIntU16	ID);
static void		GetFileString		(tInt8		*p,
						 FILE		*fp);
static void		SplitString		(FILE		*fpOut,
						 tInt8		*pBuf,
						 tInt8		*pSpaces);
static void		Bitmap			(FILE		*fp,
						 FILE		*fpOut,
						 tIntU32	Offset,
						 tIntU16	ID);
static void		AnalyzeFormRes		(FILE		*fp,
						 FILE		*fpOut,
						 tIntU32	Offset);
static void		GetFileSkipBytes	(tIntU16	Num,
						 FILE		*fp);
static tIntU16		GetFileIntU16		(FILE		*fp);
static tIntU8		GetFileIntU8		(FILE		*fp);
static void		GetFileBytes		(tInt8		*p,
						 tIntU16	Num,
						 FILE		*fp);
static void		AnalyzeFormObjects	(FILE		*fp,
						 FILE		*fpOut,
						 tIntU32	Offset,
						 tIntU16	numObj);

const tIntU16 cMaxStrLineLen = 40;

//tBild *mapBild = NULL;

static tIntU16 mVersion;
static tIntU16 mNoOfRes;
static tIntU16 mBMCount = 0;
static tIntU16 mCurrBM = 0;
static tInt8   Tmp [100];
static tInt8   Buf [20000];

	void 
convertRsrc(char *nameOnPalm, char *nameOnHost)
{
#	define	FUNCTION	"convertRsrc"
	tResHeader *mpaResHeader	= 0;

	if ((mpaResHeader = AnalyzePRCFile (nameOnPalm)) != 0)
	{
		AnalyzeRessources (nameOnPalm, nameOnHost, mpaResHeader);
		free (mpaResHeader);
	}
#	undef	FUNCTION
}

//---------------------------------------------------------------------------
//	static tIntU16
//Swap16 (tIntU16 Data)
//{
//#	define	FUNCTION	"Swap16"
//	Data = (tIntU16)(((Data & 0xff00) >> 8) + ((Data & 0xff) << 8));
//	return Data;
//#	undef	FUNCTION
//}
//---------------------------------------------------------------------------
//	static tIntU32
//Swap32 (tIntU32 Data)
//{
//#	define	FUNCTION	"Swap32"
//	tIntU32 Tmp = Data;
//	Data = ((Tmp & 0xff000000) >> 24) + ((Tmp & 0x00ff0000) >> 8) +
//		((Tmp & 0x0000ff00) << 8) + ((Tmp & 0x000000ff) << 24);
//	return Data;
//#	undef	FUNCTION
//}
//---------------------------------------------------------------------------
	static tIntU16 
GetFileIntU16 (FILE *fp)
{
#	define	FUNCTION	"GetFileIntU16"
	tIntU16 Data;
	if (fread (&Data, sizeof (tIntU16), 1, fp) != 1)
	{
		errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
			FUNCTION, strerror(errno));
		return 0xFFFF;
	}

	Data = Swap16 (Data);
	return Data;
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static tIntU8 
GetFileIntU8 (FILE *fp)
{
#	define	FUNCTION	"GetFileIntU8"
	tIntU8 Data;
	if (fread (&Data, sizeof (tInt8), 1, fp) != 1)
	{
		errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
			FUNCTION, strerror(errno));
		return 0xFF;
	}

	return Data;
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static void 
GetFileBytes (
    tInt8  *p,
    tIntU16 Num,
    FILE   *fp
  )
{
#	define	FUNCTION	"GetFileBytes"
	if (fread (p, sizeof (tInt8), Num, fp) != Num)
	{
		errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
			FUNCTION, strerror(errno));
		return;
	}

#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static void 
GetFileSkipBytes (
    tIntU16 Num,
    FILE   *fp
  )
{
#	define	FUNCTION	"GetFileSkipBytes"
	if (fread (Tmp, sizeof (tInt8), Num, fp) != Num)
	{
		errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
			FUNCTION, strerror(errno));
		return;
	}

#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static void 
GetFileString 
	(
	tInt8 *p,
	FILE  *fp
	)
{
#	define	FUNCTION	"GetFileString"
	tIntU16	j;

	for (j = 0;; j++)
	{
		if (fread (&p[j], sizeof (tIntU8), 1, fp) != 1)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		if (p[j] == 0)
			break;
	}
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static tResHeader	*
AnalyzePRCFile	(char	*inFileName)
{
#	define	FUNCTION "AnalyzePRCFile"
	tResHeader	*mpaResHeader	= 0;
	tIntU16		i;
	FILE		*fp	= 0;

	if (inFileName == 0)
	{
		errorPrintf ("** ERROR (%s): Null PRC filename\n",
			FUNCTION);
	}
	else if ((fp = fopen (inFileName, "rb")) == 0)
	{
		errorPrintf ("** ERROR (%s): Couldn't open file '%s', %s\n", 
			FUNCTION, inFileName, strerror(errno));
	}
	else
	{
		//    if (mapBild != NULL)
		//      {
		//        for (tIntU16 i = 0; i < mBMCount; i++)
		//          if (mapBild [i].pImg != NULL)
		//            {
		//              delete mapBild [i].pImg;
		//              mapBild [i].pImg = NULL;
		//            }
		//        delete [] mapBild;
		//        mapBild = NULL;
		//      }

		//    ListBoxImg -> Clear ();

		//tInt8 Buf [10];
		// Read Filename:
		if (fread (Tmp, sizeof (tInt8), 32, fp) != 32)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		//LabelFName -> Caption = Tmp;
		// Read Version:
		if (fseek (fp, 0x22, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		if (fread (&mVersion, sizeof (tIntU16), 1, fp) != 1)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		mVersion = Swap16 (mVersion);
		// LabelVersion -> Caption = IntToStr (mVersion);
		// Read File type:
		if (fseek (fp, 0x3c, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		if (fread (Buf, sizeof (tInt8), 4, fp) != 4)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		Buf [4] = 0;
		if ((strcmp (Buf, "appl") != 0) && (strcmp (Buf, "Rsrc") != 0))
		{
			errorPrintf (
				"** ERROR (%s): File isn't an application "
				"(buf=%s, not 'appl')\n", 
				FUNCTION,
				Buf);
			fclose (fp);
			return 0;
		}

		// Read Creator ID:
		if (fread (Buf, sizeof (tInt8), 4, fp) != 4)
		{
			errorPrintf(
				"** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		Buf [4] = 0;
		//TODO: gotta store this somewhere. . .
		//LabelID -> Caption = Buf;

		// Read number of Resources:
		if (fseek (fp, 0x4c, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}

		if (fread (&mNoOfRes, sizeof (tIntU16), 1, fp) != 1)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return 0;
		}
		mNoOfRes = Swap16 (mNoOfRes);
		//LabelNoOfRes -> Caption = IntToStr (mNoOfRes);

		//mpaResHeader = new tResHeader [mNoOfRes];	// okay
		mpaResHeader = (tResHeader *) malloc (sizeof (tResHeader) * mNoOfRes);

		mBMCount	= 0;
		mCurrBM		= 0;
		for (i = 0; i < mNoOfRes; i++)
		{
			mpaResHeader [i].Pos = (tIntU32)ftell (fp);
			if (fread (mpaResHeader[i].Name, sizeof (tInt8), 4, fp) 
					!= 4)
			{
				errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
					FUNCTION, strerror(errno));
				return 0;
			}

			mpaResHeader [i].Name [4] = 0;
			// ListBoxFound -> Items -> Add (mpaResHeader [i].Name);

			if (fread (&mpaResHeader [i].ID, sizeof (tIntU16), 1, fp) != 1)
			{
				errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
					FUNCTION, strerror(errno));
				return 0;
			}

			mpaResHeader[i].ID = Swap16 (mpaResHeader[i].ID);

			if (fread (&mpaResHeader [i].Offset, sizeof (tIntU32), 1, fp) != 1)
			{
				errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
					FUNCTION, strerror(errno));
				return 0;
			}

			mpaResHeader[i].Offset = Swap32 (mpaResHeader [i].Offset);

			if (strcmp (mpaResHeader [i].Name, "Tbmp") == 0 ||
			    strcmp (mpaResHeader [i].Name, "tAIB") == 0)
			{
				mBMCount++;
			}
		}

		//    mapBild = new tBild [mBMCount];

		fclose (fp);
	}

	return mpaResHeader;
#	undef FUNCTION
}
//---------------------------------------------------------------------------
	static void 
SplitString (
    FILE  *fpOut,
    tInt8 *pBuf,
    tInt8 *pSpaces
  )
{
#	define	FUNCTION	"SplitString"
	tIntU16	Len	= strlen (pBuf);
	tBool	First	= Yes;
	tInt8	*p	= 0;
	tInt8	Rett;
	tIntU16	i;

	if (Len < cMaxStrLineLen)
	{
		fprintf (fpOut, "\"%s\"\n", pBuf);
		return;
	}

	p = pBuf;

	if (strchr (pBuf, '\n') == NULL)
	{
		for (i = cMaxStrLineLen; i < Len; i += cMaxStrLineLen)
		{
			while (pBuf [i] != ' ')
				i++;

			Rett = pBuf [i+1];
			pBuf [i+1] = 0;

			if (!First)
				fprintf (fpOut, "%s", pSpaces);
			else
				First = No;
			fprintf (fpOut, "\"%s\" \\ \n", p);
			p = &pBuf [i+1];
			*p = Rett;
		}
		fprintf (fpOut, "%s\"%s\"\n", pSpaces, p);
	}
	else
	{
		for (i = 0; i < Len; )
		{
			while (pBuf [i] != '\n')
				i++;

			pBuf [i] = 0;

			if (!First)
				fprintf (fpOut, "%s", pSpaces);
			else
				First = No;
			fprintf (fpOut, "\"%s\\00d\" \\ \n", p);
			i++;
			p = &pBuf [i];
		}
		fprintf (fpOut, "%s\"%s\"\n", pSpaces, p);
	}
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
static void AnalyzeRessources 
	(char		*nameOnPalm,
	 char		*nameOnHost,
	 tResHeader	*mpaResHeader)
{
#define	FUNCTION	"AnalyzeRessources"
	FILE	*fp	= 0;
	FILE	*fpOut	= 0;
	//tInt8	*p	= 0;
	tIntU16	i;

	if (mpaResHeader == NULL)
	{
		errorPrintf ("** ERROR (%s): Null mpaResHeader argument\n", 
			FUNCTION);
		return;
	}
	else if ((fp = fopen (nameOnPalm, "rb")) == NULL)
	{
		errorPrintf ("** ERROR (%s): Couldn't open file '%s', %s\n", 
			FUNCTION, nameOnPalm, strerror(errno));
		return;
	}

	// Build the output file name

	//strcpy (Buf, nameOnPalm);
	//if ((p = strrchr (Buf, '.')) != NULL)
	//	strcpy (&p [1], "rcp");
	//else
	//	strcat (Buf, ".rcp");

	// Open the output file

	else if ((fpOut = openNewFile(nameOnHost, "w")) == NULL)
	{
		// 'openNewFile' already generated the error message
		//errorPrintf ("** ERROR (%s): Couldn't open file '%s', %s\n", 
		//	FUNCTION, nameOnHost, strerror(errno));
		fclose (fp);
		return;
	}

	for (i = 0; i < mNoOfRes; i++)
	{
		if (fseek (fp, mpaResHeader [i].Offset, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		if (strcmp (mpaResHeader [i].Name, "tFRM") == 0)
		{
			AnalyzeFormRes (fp, fpOut, mpaResHeader [i].Offset);
		}
		else if (strcmp (mpaResHeader [i].Name, "MBAR") == 0)
		{
			MenuBar	(fp, 
				fpOut, 
				mpaResHeader[i].Offset, 
				mpaResHeader [i].ID);
		}
		else if (strcmp (mpaResHeader [i].Name, "Talt") == 0)
		{
			Alert	(fp, 
				fpOut, 
				mpaResHeader[i].Offset, 
				mpaResHeader [i].ID);
		}
		else if (strcmp (mpaResHeader [i].Name, "tSTR") == 0)
		{
			GetFileString (Buf, fp);
			//fprintf (fpOut, "STRING ID %d \"%s\"\n\n", 
			//	mpaResHeader [i].ID, 
			//	Buf);
			fprintf (fpOut, "STRING ID %d ", mpaResHeader [i].ID);
			SplitString (fpOut, Buf, "             ");
			fprintf (fpOut, "\n");
		}
		else if (strcmp (mpaResHeader [i].Name, "tAIN") == 0)
		{
			GetFileString (Buf, fp);
			fprintf (fpOut, "APPLICATIONICONNAME ID %d \"%s\"\n", 
				    mpaResHeader [i].ID, Buf);
		}
		else if (strcmp (mpaResHeader [i].Name, "tver") == 0)
		{
			GetFileString (Buf, fp);
			fprintf (fpOut, "VERSION ID %d \"%s\"\n", 
				    mpaResHeader [i].ID, Buf);
		}
		else if (strcmp (mpaResHeader [i].Name, "APPL") == 0)
		{
			GetFileString (Buf, fp);
			fprintf (fpOut, "APPLICATION ID %d \"%s\"\n", 
				    mpaResHeader [i].ID, Buf);
		}
		else if (strcmp (mpaResHeader [i].Name, "Tbmp") == 0
				|| strcmp (mpaResHeader [i].Name, "tAIB") == 0)
		{
			Bitmap	(fp, 
				fpOut, 
				mpaResHeader[i].Offset, 
				mpaResHeader [i].ID);
		}
	}

	fclose (fp);
	fclose (fpOut);
#undef FUNCTION
}
//---------------------------------------------------------------------------
	static void 
AnalyzeFormRes (
    FILE   *fp,
    FILE   *fpOut,
    tIntU32 Offset
  )
{
#	define	FUNCTION	"AnalyzeFormRes"
	tIntU16	windowFlags;
	tIntU16	winBounds [4];
	tIntU16 formID;
	tIntU16 formAttr;
	tIntU16 defBtn;
	tIntU16 helpID;
	tIntU16 menuID;
	tIntU16 numObj;
	tIntU8	i;

	// -----

	// 8 Dummybytes lesen
	GetFileSkipBytes (8, fp);

	// WindowFlags ab Byte 8:
	windowFlags	= GetFileIntU16 (fp);

	// WindowBounds ab Byte 10:
	for (i = 0; i < 4; i++)
		winBounds [i] = GetFileIntU16 (fp);

	// 12 Dummybytes lesen
	GetFileSkipBytes (12, fp);

	// FrameType ab Byte 30:
	/*tIntU16 frameType =*/ GetFileIntU16 (fp);;

	// 8 Dummybytes lesen
	GetFileSkipBytes (8, fp);

	// FormID ab Byte 40:
	formID		= GetFileIntU16 (fp);;

	// FormAttr ab Byte 42:
	formAttr	= GetFileIntU16 (fp);;

	// 12 Dummybytes lesen
	GetFileSkipBytes (12, fp);

	// DefaultButtonID ab Byte 56:
	defBtn		= GetFileIntU16 (fp);;

	// HelpID ab Byte 58:
	helpID		= GetFileIntU16 (fp);;

	// MenuID ab Byte 60:
	menuID		= GetFileIntU16 (fp);;

	// NumObjects ab Byte 62:
	numObj		= GetFileIntU16 (fp);;

	// 4 Dummybytes lesen
	GetFileSkipBytes (4, fp);

	fprintf (fpOut, "FORM ID %d AT (%d %d %d %d)\n", formID, 
			     winBounds [0], winBounds [1],
			     winBounds [2], winBounds [3]);

	if ((windowFlags & 0x2000) != 0)
		fprintf (fpOut, "MODAL\n");

	//if ((formAttr & 0x0800) == 0)
	// default p.o.println("NoSaveBehind");
	if ((formAttr & 0x8000) == 0)
		fprintf (fpOut, "NONUSABLE\n");
	if (helpID != 0)
		fprintf (fpOut, "HELPID %d\n", helpID);
	if (defBtn != 0)
		fprintf (fpOut, "DEFAULTBTNID %d\n", defBtn);
	if (menuID != 0)
		fprintf (fpOut, "MENUID %d\n", menuID);

	fprintf (fpOut, "BEGIN\n");
	AnalyzeFormObjects (fp, fpOut, Offset, numObj);
	fprintf (fpOut, "END\n\n");
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static void 
AnalyzeFormObjects (
    FILE   *fp,
    FILE   *fpOut,
    tIntU32 Offset,
    tIntU16 numObj
  )
{
#	define	FUNCTION	"AnalyzeFormObjects"
	//tInt8 Buf [80];

	// tIntU16 *pTypes = new tIntU16 [numObj];	// okay
	tIntU16	*pTypes = (tIntU16 *) malloc (sizeof (tIntU16) * numObj);

	// tIntU16 *pFlags = new tIntU16 [numObj];	// okay
	tIntU16	*pFlags = (tIntU16 *) malloc (sizeof (tIntU16) *  numObj);

	// tIntU32 *pOffset = new tIntU32 [numObj];	// okay
	tIntU32	*pOffset = (tIntU32 *) malloc (sizeof (tIntU32) *  numObj);
	tIntU16 ID;
	tIntU16 rect [4];
	tIntU16 attr;
	tIntU8  font;
	tIntU16	i;

	for (i = 0; i < numObj; i++) 
	{
		pTypes [i] = GetFileIntU8 (fp);
		pFlags [i] = GetFileIntU8 (fp);

		if (fread (&pOffset [i], sizeof (tIntU32), 1, fp) != 1)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		pOffset[i] = Swap32 (pOffset [i]);
	}

	for (i = 0; i < numObj; i++)
	{
		if (fseek (fp, Offset+pOffset [i], SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		switch (pTypes [i])
		{
		case 0:
		{
			tIntU16 maxChars;
			tIntU16 just;
			tIntU8	j;

			ID		= GetFileIntU16 (fp);

			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);

			attr		= GetFileIntU16 (fp);
			GetFileSkipBytes (16, fp);
			maxChars	= GetFileIntU16 (fp);
			GetFileSkipBytes (8, fp);
			font		= GetFileIntU8 (fp);
			GetFileSkipBytes (1, fp);
			fprintf (fpOut, "  FIELD ID %d AT (%d %d %d %d) ", 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE ");
			just = (tIntU16)((attr & 0x0030) >> 4);
			switch (just) 
			{
			case 0:
				// default p.o.print(" LeftAlign");
				break;
			case 2:
				fprintf (fpOut, "RIGHTALIGN ");
				break;
			default:
				fprintf (fpOut, "Unknown alignment: %d", just);
				break;
			}
			fprintf (fpOut, "FONT %d ", font);
			if ((attr & 0x2000) == 0)
				fprintf (fpOut, "NONEDITABLE ");
			if (((attr & 0x00c0) >> 6) == 1)
				fprintf (fpOut, "UNDERLINED ");
			if ((attr & 0x1000) != 0)
				;// default p.o.print(" SingleLine");
			else
				fprintf (fpOut, "MULTIPLELINES ");
			if (maxChars > 0)
				fprintf (fpOut, "MAXCHARS %d ", maxChars);
			fprintf (fpOut, "\n");
		}
			break;

		case 1:
		{
			tIntU8	style;
			tIntU8	group;
			tIntU8	j;

			ID	= GetFileIntU16 (fp);

			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);

			GetFileSkipBytes (4, fp);
			attr	= GetFileIntU16 (fp);
			style	= GetFileIntU8 (fp);
			font	= GetFileIntU8 (fp);
			group	= GetFileIntU8 (fp);
			GetFileSkipBytes (1, fp);
			GetFileString (Buf, fp);

			switch (style) 
			{
			case 0:
				fprintf (fpOut, "  BUTTON ");
				break;
			case 1:
				fprintf (fpOut, "  PUSHBUTTON ");
				break;
			case 2:
				fprintf (fpOut, "  CHECKBOX ");
				break;
			case 3:
				fprintf (fpOut, "  POPUPTRIGGER ");
				break;
			case 4:
				fprintf (fpOut, "  SELECTORTRIGGER ");
				break;
			case 5:
				fprintf (fpOut, "  REPEATBUTTON ");
				break;
			default:
				fprintf (fpOut, "Unknown control style: %d", 
					style);
				break;
			}

			fprintf (fpOut, "\"%s\" ID %d AT (%d %d %d %d) ", 
				Buf, 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);

			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE ");
			if ((attr & 0x4000) == 0)
				fprintf (fpOut, "DISABLED ");
			if ((attr & 0x0800) != 0)
				fprintf (fpOut, "LEFTANCHOR ");
			else
				fprintf (fpOut, "RIGHTANCHOR ");

			if (style == 0 || style == 5)
				switch ((attr & 0x0700) >> 8) 
				{
				case 0:
					fprintf (fpOut, "NOFRAME ");
					break;
				case 1:
					// defaultp.o.print(" Frame");
					break;
				case 2:
					fprintf (fpOut, "BOLDFRAME ");
					break;
				}

			fprintf (fpOut, "FONT %d ", font);
			if (style == 1 || style == 2)
				if (group != 0)
					fprintf (fpOut, "GROUP %d ", group);
			if (style == 2)
				if ((attr & 0x1000) != 0)
					fprintf (fpOut, "CHECKED ");
			fprintf (fpOut, "\n");
		}
			break;


		case 2:
		{
			tIntU16	numItems;
			tIntU16 j;
			tIntU16 k;

			ID = GetFileIntU16 (fp);
			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);
			attr		= GetFileIntU16 (fp);
			GetFileSkipBytes (4, fp);
			numItems	= GetFileIntU16 (fp);
			GetFileSkipBytes (4, fp);
			font		= GetFileIntU8 (fp);
			GetFileSkipBytes (9, fp);
			GetFileSkipBytes ((tIntU16)(4*numItems), fp);

			fprintf (fpOut, "  LIST ");
			if (numItems == 0)
				fprintf (fpOut,"\"\"");
			else
			{
				for (j = 0; j < numItems; j++) 
				{
					for (k = 0;; k++)
					{
						if (fread (&Buf [k], 
							sizeof (tIntU8), 
							1, 
							fp) != 1)
						{
							errorPrintf(
								"** ERROR (%s): Problem "
								"reading from file, %s\n", 
								FUNCTION, strerror(errno));
							return;
						}

						if (Buf [k] == 0)
							break;
					}
					// WDG,was: fprintf (fpOut, "%s ", Buf);
					fprintf (fpOut, "\"%s\" ", Buf);
				}
			}
			fprintf (fpOut, "ID %d AT (%d %d %d %d) ", 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE ");
			if ((attr & 0x4000) == 0)
				fprintf (fpOut, "DISABLED ");
			fprintf (fpOut, "FONT %d\n", font);
		}
			break;

		case 3:
		{
			tIntU16 numCol;
			tIntU16 numRow;
			tIntU16 width;
			tIntU16	j;

			ID	= GetFileIntU16 (fp);

			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);

			attr	= GetFileIntU16 (fp);
			numCol	= GetFileIntU16 (fp);
			numRow	= GetFileIntU16 (fp);
			GetFileSkipBytes (58, fp);

			fprintf (fpOut, "  TABLE ID %d AT (%d %d %d %d) ", 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);
			if ((attr & 0x4000) == 0)
				fprintf (fpOut, "NONEDITABLE ");
			fprintf (fpOut, "ROWS %d COLUMNS %d COLUMNWIDTHS ", 
				numRow, 
				numCol);

			for (j = 0; j < numCol; j++)
			{
				width = GetFileIntU16 (fp);
				GetFileSkipBytes (16, fp);
				fprintf (fpOut, "%d ", width);
			}
			fprintf (fpOut, "\n");
		}
			break;

		case 4:
		{
			tIntU16 point [2];

			attr		= GetFileIntU16 (fp);
			point [0]	= GetFileIntU16 (fp);
			point [1]	= GetFileIntU16 (fp);
			ID		= GetFileIntU16 (fp);

			fprintf (fpOut, "  FORMBITMAP AT (%d %d) BITMAP %d ", 
				point [0], 
				point [1], 
				ID);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE");
			fprintf (fpOut, "\n");
		}
			break;

		case 8:
		{
			tIntU16 point [2];

			ID		= GetFileIntU16 (fp);	// 0
			point [0]	= GetFileIntU16 (fp);
			point [1]	= GetFileIntU16 (fp);
			attr		= GetFileIntU16 (fp);	// 6
			font		= GetFileIntU8 (fp);	// 8
			GetFileSkipBytes (5, fp);
			GetFileString (Buf, fp);

			fprintf (fpOut, "  LABEL \"%s\" ID %d AT (%d %d) ", 
				Buf, 
				ID, 
				point [0], 
				point [1]);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE ");
			fprintf (fpOut, "FONT %d\n", font);
		}
			break;

		case 9:
			GetFileSkipBytes (12, fp);
			GetFileString (Buf, fp);
			fprintf (fpOut, "  TITLE \"%s\"\n", Buf);
			break;

		case 10:
		{
			tIntU16 ID2;

			ID	= GetFileIntU16 (fp);	// 0
			ID2	= GetFileIntU16 (fp);	// 2
			fprintf (fpOut, "  POPUPLIST ID %d %d\n", ID, ID2);
		}
			break;

		case 11:
		{
			tIntU16 point [2];

			point [0] = GetFileIntU16 (fp);
			point [1] = GetFileIntU16 (fp);
			fprintf (fpOut, "  GRAFFITISTATEINDICATOR AT (%d %d)\n",
				point [0], 
				point [1]);
		}
			break;

		case 12:
		{
			tIntU8	j;

			ID	= GetFileIntU16 (fp);	// 0
			attr	= GetFileIntU16 (fp);	// 2
			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);
			GetFileSkipBytes (4, fp);	// 12
			fprintf (fpOut, "  GADGET ID %d AT (%d %d %d %d) ", 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE");
			fprintf (fpOut, "\n");
		}
			break;

		case 13:
		{
			tIntU16 value;
			tIntU16 minValue;
			tIntU16 maxValue;
			tIntU16 pageSize;
			tIntU8	j;

			for (j = 0; j < 4; j++)
				rect [j] = GetFileIntU16 (fp);
			ID		= GetFileIntU16 (fp);	// 0
			attr		= GetFileIntU16 (fp);	// 2
			value		= GetFileIntU16 (fp);
			minValue	= GetFileIntU16 (fp);
			maxValue	= GetFileIntU16 (fp);
			pageSize	= GetFileIntU16 (fp);
			/*tIntU16 penPosInCar =*/	GetFileIntU16 (fp);
			/*tIntU16 savePos =*/		GetFileIntU16 (fp);
			fprintf (fpOut, "  SCROLLBAR ID %d AT (%d %d %d %d) ", 
				ID, 
				rect [0], 
				rect [1], 
				rect [2], 
				rect [3]);
			if ((attr & 0x8000) == 0)
				fprintf (fpOut, "NONUSABLE ");
			fprintf (fpOut, "VALUE %d MIN %d MAX %d PAGESIZE %d\n",
				value, 
				minValue, 
				maxValue, 
				pageSize);
		}
			break;

		default:
			fprintf (fpOut, "Unknown form object: %d\n", 
				pTypes [i]);
			break;
		}
	}

	free (pTypes);
	free (pFlags);
	free (pOffset);
#	undef	FUNCTION
}
//---------------------------------------------------------------------------

	static void 
MenuBar (
    FILE   *fp,
    FILE   *fpOut,
    tIntU32 Offset,
    tIntU16 ID
  )
{
#	define	FUNCTION	"MenuBar"
	tTitle	*titles		= 0;
	tIntU16	*numItems	= 0;

	tIntU32	iString;
	tIntU32	pos;

	tIntU16	id;
	tIntU16	numMenus;
	tIntU16	nMen;
	tIntU16	i;

	tInt8	command [2];
	tInt8	text [80];

	// -----

	if (fseek (fp, Offset, SEEK_SET) != 0)
	{
		errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
			FUNCTION, strerror(errno));
		return;
	}

	GetFileSkipBytes (26, fp);
	numMenus = GetFileIntU16 (fp);
	GetFileSkipBytes (4, fp);

	//tTitle *titles = new tTitle [numMenus];	// okay
	if ((titles = (tTitle *) malloc (sizeof (tTitle) * numMenus)) == 0)
	{
		errorPrintf ("** ERROR (%s): couldn't allocate space\n", FUNCTION);
		return;
	}

	//tIntU16 *numItems = new tIntU16 [numMenus];	// okay
	if ((numItems = (tIntU16 *) malloc (sizeof (tIntU16) * numMenus)) == 0)
	{
		errorPrintf ("** ERROR (%s): couldn't allocate space\n", FUNCTION);
		return;
	}

	fprintf(fpOut, "MENU ID %d\n", ID);
	fprintf(fpOut, "BEGIN\n");

	for (nMen = 0; nMen < numMenus; nMen++) 
	{
		GetFileSkipBytes (24, fp);

		if (fread (&iString, sizeof (tIntU32), 1, fp) != 1)
		{
			errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		iString	= Swap32 (iString);

		pos	= ftell (fp);
		if (fseek (fp, Offset+iString, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		GetFileString (titles [nMen].txt, fp);

		if (fseek (fp, pos, SEEK_SET) != 0)
		{
			errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
				FUNCTION, strerror(errno));
			return;
		}

		numItems [nMen] = GetFileIntU16 (fp);
		GetFileSkipBytes (4, fp);
	}

	for (nMen = 0; nMen < numMenus; nMen++)
	{
		fprintf (fpOut, "  PULLDOWN \"%s\"\n", titles [nMen].txt);
		fprintf (fpOut, "  BEGIN\n");
		for (i = 0; i < numItems [nMen]; i++)
		{
			id = GetFileIntU16 (fp);
			GetFileBytes (command, 2, fp);

			if (fread (&iString, sizeof (tIntU32), 1, fp) != 1)
			{
				errorPrintf("** ERROR (%s): Problem reading from file, %s\n", 
					FUNCTION, strerror(errno));
				return;
			}

			iString = Swap32 (iString);

			pos = ftell (fp);
			if (fseek (fp, Offset+iString, SEEK_SET) != 0)
			{
				errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
					FUNCTION, strerror(errno));
				return;
			}

			GetFileString (text, fp);

			if (fseek (fp, pos, SEEK_SET) != 0)
			{
				errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
					FUNCTION, strerror(errno));
				return;
			}

			if (strcmp (text, "-") == 0 /*&& id == 0*/)
				fprintf (fpOut, "    MENUITEM SEPARATOR");
			else
				fprintf (fpOut, "    MENUITEM \"%s\" ID %d", 
					text, id);
			if (command [0] != 0)
				fprintf (fpOut, " \"%c\"", command [0]);
			fprintf (fpOut, "\n");
		}
		fprintf (fpOut, "  END\n");
	}
	fprintf (fpOut, "END\n\n");

	free (titles);
	free (numItems);
#	undef	FUNCTION
}
//---------------------------------------------------------------------------
	static void 
Alert (
    FILE   *fp,
    FILE   *fpOut,
    tIntU32 formOffset,
    tIntU16 ID
  )
{
#	define	FUNCTION	"Alert"
	tIntU16	type;
	tIntU16	helpId;
	tIntU16	numButtons;
	tInt8	title [120];
	tInt8	mess [800];
	tIntU16	i;
	tInt8	button [80];

	if (fseek (fp, formOffset, SEEK_SET) != 0)
	{
		errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
			FUNCTION, strerror(errno));
		return;
	}

	type		= GetFileIntU16 (fp);
	helpId		= GetFileIntU16 (fp);
	numButtons	= GetFileIntU16 (fp);
	/*tIntU16 defButton =*/ GetFileIntU16 (fp);

	GetFileString (title, fp);
	GetFileString (mess, fp);

	fprintf (fpOut, "ALERT ID %d\n", ID);
	if (helpId != 0 )
		fprintf (fpOut, "HELPID %d\n", helpId);

	switch (type) 
	{
	case 0:
		fprintf (fpOut, "INFORMATION\n");
		break;
	case 1:
		fprintf (fpOut, "CONFIRMATION\n");
		break;
	case 2:
		fprintf (fpOut, "WARNING\n");
		break;
	case 3:
		fprintf (fpOut, "ERROR\n");
		break;
	default:
		fprintf (fpOut, "Unknown alert type: %d\n", type);
		break;
	}

	fprintf (fpOut, "BEGIN\n");
	fprintf (fpOut, "  TITLE \"%s\"\n", title);
	fprintf (fpOut, "  MESSAGE \"%s\"\n", mess);
	if (numButtons > 0)
	{
		fprintf (fpOut, "  BUTTONS");
		for (i = 0; i < numButtons; i++)
		{
			GetFileString (button, fp);
			fprintf (fpOut, " \"%s\"", button);
		}
		fprintf (fpOut, "\n");
	}
	fprintf (fpOut, "END\n\n");
#	undef	FUNCTION
}

//---------------------------------------------------------------------------
	static void 
Bitmap (
    FILE   *fp,
    FILE   *fpOut,
    tIntU32 Offset,
    tIntU16 ID
  )
{
#	define	FUNCTION	"Bitmap"
	tIntU16	w;
	tIntU16	h;
	tIntU16	nBpR;
	tIntU16	attr;
	tInt8	*bitmap	= 0;
	tIntU16	i;
	tIntU16	flag;
	tIntU16	j;

	if (fseek (fp, Offset, SEEK_SET) != 0)
	{
		errorPrintf("** ERROR (%s): Problem with fseek, %s\n", 
			FUNCTION, strerror(errno));
		return;
	}

	w	= GetFileIntU16 (fp);
	h	= GetFileIntU16 (fp);
	nBpR	= GetFileIntU16 (fp);
	attr	= GetFileIntU16 (fp);

	GetFileSkipBytes (8, fp);

	// tInt8  bitmapFileName [80];
	//TODO: how do I do this?
	//tInt8 *p = strrchr (OpenDialog1 -> FileName.c_str (), '\\');
	//if (p != NULL)
	// strcpy (bitmapFileName, p+1);
	//else
	//{
	// TODO: how do I do this?
	//strcpy (bitmapFileName, OpenDialog1 -> FileName.c_str ());
	//}

	// TODO: rewrite this
	//char *ASt; //AnsiString ASt;
	//ASt = bitmapFileName;
	//int Pos = ASt.AnsiPos (".");
	//ASt.Delete (Pos, ASt.Length () - (Pos-1));
	//ASt += IntToStr (ID) + AnsiString (".bmp");

	//strcpy (bitmapFileName, "BM");
	//itoa (ID, &bitmapFileName [2], 10);
	//strcat (bitmapFileName, ".bmp");

	//fprintf (fpOut, "BITMAP ID %d \"%s\"\n", ID, ASt.c_str ());

	//    mapBild [mCurrBM].pImg = new TImage (this);
	//    strcpy (mapBild [mCurrBM].Name , ASt.c_str ());
	//    mapBild [mCurrBM].ID = ID;
	//    ListBoxImg -> Items -> Add (ASt);

	// tInt8 *bitmap = new tInt8 [nBpR*h];	// okay
	if ((bitmap = (tInt8 *) malloc (sizeof (tInt8) *nBpR*h)) == 0)
	{
		errorPrintf ("** ERROR (%s): couldn't allocate space\n", FUNCTION);
		return;
	}

	if ((attr & 0x8000) == 0)
		GetFileBytes (bitmap, (tIntU16)(nBpR * h), fp);
	else
	{
		GetFileSkipBytes (2, fp);
		for (i = 0; i < h; ++i)
		{
			flag = 0;
			for (j = 0; j < nBpR; ++j)
			{
				if ((j & 0x07) == 0)
					flag = (tIntU16)(GetFileIntU8 (fp) & 0xff);
				if ( i > 0 )
					bitmap [i * nBpR + j] 
						= bitmap [(i - 1) * nBpR + j];
				if (((flag <<= 1) & 0x100) != 0)
					bitmap [i * nBpR + j] 
						= GetFileIntU8 (fp);
			}
		}
	}

	//    mapBild [mCurrBM].pImg -> Picture -> Bitmap -> Width = w;
	//    mapBild [mCurrBM].pImg -> Picture -> Bitmap -> Height = h;
	//
	//    for (tIntU16 y = 0; y < h; y++)
	//      for (tIntU16 x = 0; x < w; x++)
	//        {
	//         	tIntU8 d = bitmap [y * nBpR + (x >> 3)];
	//         	if ((d & (1 << (7 - (x & 7)))) != 0)
	//            mapBild [mCurrBM].pImg -> Canvas -> Pixels [x][y] = clBlack;
	//         	else
	//            mapBild [mCurrBM].pImg -> Canvas -> Pixels [x][y] = clWhite;
	//        }

	free (bitmap);
	mCurrBM++;
#	undef	FUNCTION
}

//---------------------------------------------------------------------------
//void __fastcall TForm1::ListBoxImgClick(TObject *Sender)
//  {
//    if (mBMCount == 0 || ListBoxImg -> ItemIndex < 0)
//      return;
//    ImageMain -> Picture -> Assign (mapBild [ListBoxImg -> ItemIndex].pImg -> Picture);
//  }
//---------------------------------------------------------------------------
//void __fastcall TForm1::ButtonSaveBMPClick(/*TObject *Sender*/)
//  {
//    for (tIntU16 i = 0; i < mBMCount; i++)
//      if (mapBild [i].pImg != NULL)
//        mapBild [i].pImg -> Picture -> SaveToFile (mapBild [i].Name);
//  }
//---------------------------------------------------------------------------

	char	*
RsrcHostName (char *nameOnPalm, char *databaseName)
{
#	define	FUNCTION	"RsrcHostName"
	static char	localBuf[FILE_NAME_SIZE];
	char		*p	= 0;

	ignore (databaseName);

	if (nameOnPalm == 0)
	{
		localBuf[0]	= '\0';
	}
	else
	{
		strcpy (localBuf, nameOnPalm);
		if ((p = strrchr (localBuf, '.')) != NULL)
			strcpy (&p [1], "rcp");
		else
			strcat (localBuf, ".rcp");
	}

	return &localBuf[0];
#	undef	FUNCTION
}
