/* **********************************************************************
 *
 *   LED/SrcEdit is free software as specified in the GNU General public License
 *   listed in the file COPYING or http://www.gnu.org/licenses/gpl.txt
 *
 ********************************************************************** */

#ifndef __OBC__
#include <PalmOS.h>
#include <PalmCompatibility.h>
#endif

#include "LedGlobals.h"
#include "SrcEditKeyboardSupport.c"

/******************************************************************************
 * Function Prototypes for Exported Functions
 ******************************************************************************/
void DeleteFileFromMRU(char* dbName) INCODE4; // S056 File Delete
Boolean DeleteFormHandleEvent(EventPtr eventP) INCODE4; // S056 File Delete
Boolean FileInfoFormHandleEvent(EventPtr eventP) INCODE4; // S055 File Info and Attributes
Boolean GotoLineFormHandleEvent(EventPtr eventP) INCODE4; // S041 Show and GotoLine
Boolean KeyboardSupportFormHandleEvent(EventPtr eventP) INCODE4; // #846728 (S016) External Keyboard Support
/******************************************************************************
 * Function Prototypes for static Functions
 ******************************************************************************/
UInt8 compressHardKeysScrollValues(void) INCODE4;  // #846292 (S051) Use hard buttons to scroll
Boolean doCommentSelection() INCODE4;  // #846291 (S053) Comment-out selected region
Boolean doFindReplace(void) INCODE4; // S013 Replace
void doPreKeyboard() INCODE4; // S040: On Screen Keyboard
Boolean doPostKeyboard(FieldPtr fldP) INCODE4; // S040: On Screen Keyboard
void doSelectAll(void) INCODE4;   // #891109: Select All
Boolean doUncommentSelection() INCODE4;  // #846291 (S053) Comment-out selected region
static Boolean getFileInfo(UInt8 toggle) INCODE4; // S055 File Info and Attributes
void getKeyRates(void)INCODE4; // BUGfix: Scrolling is BUGGY with 5-way keys
static Boolean gotoLineNumber(void) INCODE4; // S041 Show and Goto Line
static UInt32 numWordsInDoc(DmOpenRef tempOpenRef) INCODE4; // S055 File Info and Attributes
void resizeMainForm (FormPtr frmP)INCODE4;  // Support for the Alphasmart Dana Screen
static Boolean setFileInfo(void) INCODE4; // S055 File Info And Attributes
void setHardKeysScrollingValues(UInt8 compressedValue) INCODE4;  // #846292 (S051) Use hard buttons to scroll
void setHighlightMode(char* dbName) INCODE4; // #846293 (S046) pick highlight mode based on file extension
static void showCurrentLine(void) INCODE4; // S041 Show and Goto Line
Boolean doCaseShifts(UInt8 choice) INCODE4; // #846288 (S058) (Extended) Popup Tools Menu
/***********************************************************************
 *
 * FUNCTION:    buildSelection
 *
 * DESCRIPTION: this routine set newSelection from startPoint,startLine,
 *              startCharacter to the supplied x,y adjusting for relative
 *              positions between the two.  The selection is document
 *              relative
 *
 * PARAMETERS:  x                -
 *
 *              y                -
 *
 *              newSelection     -
 *
 *
 * RETURNED:    Boolean
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
Boolean buildSelection(Word x, Word y, SelectionRange *newSelection)
{
    Boolean result = false;
    convertScreenXYToDocumentXY((int*)&x, (int*)&y);
    unsigned int line = y / FontHeight;
    if (line > startLine) {
        newSelection->startLine = startLine;
        newSelection->startOffset = startOffset;
        newSelection->startCharacter = startCharacter;
        newSelection->endLine = line;
        newSelection->endCharacter = getCharacterForX(line, (int*)&x);
        newSelection->endOffset = x;
    }
    else {
        if (line == startLine) {
            newSelection->endLine = line;
            newSelection->startLine = line;
            int ch = getCharacterForX(line, (int*)&x);
            if (x < startOffset) {
                newSelection->startOffset = x;
                newSelection->startCharacter = ch;
                newSelection->endOffset = startOffset;
                newSelection->endCharacter = startCharacter;
            }
            else {
                newSelection->startOffset = startOffset;
                newSelection->startCharacter = startCharacter;
                newSelection->endOffset = x;
                newSelection->endCharacter = ch;
                result = (x == startOffset);
            }
        }
        else {
            newSelection->endLine = startLine;
            newSelection->endOffset = startOffset;
            newSelection->endCharacter = startCharacter;
            newSelection->startLine = line;
            newSelection->startCharacter = getCharacterForX(line, (int*)&x);
            newSelection->startOffset = x;
        }
    }
    TEXT_ASSERT((newSelection->startLine <= newSelection->endLine), "bad line range");
    TEXT_ASSERT(((newSelection->startLine < newSelection->endLine) || (newSelection->startOffset <= newSelection->endOffset)), "bad offset range");
    return result;
}

/***********************************************************************
 *
 * FUNCTION:    calculateSelectionDifference
 *
 * DESCRIPTION: this routine build a selection that is the difference
 *              between the given aSelection and the given 'otherSelection'.
 *              Assumes that the selections have at least one end-point
 *              in common.
 *
 * PARAMETERS:  aSelection     - original selection
 *
 *              otherSelection - new selection
 *
 *
 * RETURNED:    none
 *
 * REVISION HISTORY:
 *
 ***********************************************************************/
void calculateSelectionDifference(SelectionRange *aSelection,
	SelectionRange *otherSelection, SelectionRange *result)
{
    if ((aSelection->startLine == otherSelection->startLine)
            && (aSelection->startOffset == otherSelection->startOffset)) {
        if (aSelection->endLine > otherSelection->endLine) {
            result->startLine = otherSelection->endLine;
            result->startOffset = otherSelection->endOffset;
            result->startCharacter = otherSelection->endCharacter;
            result->endLine = aSelection->endLine;
            result->endOffset = aSelection->endOffset;
            result->endCharacter = aSelection->endCharacter;
        }
        else {
            if (aSelection->endLine == otherSelection->endLine) {
                result->startLine = otherSelection->endLine;
                result->endLine = otherSelection->endLine;
                if (aSelection->endOffset > otherSelection->endOffset) {
                    result->startOffset = otherSelection->endOffset;
                    result->startCharacter = otherSelection->endCharacter;
                    result->endOffset = aSelection->endOffset;
                    result->endCharacter = aSelection->endCharacter;
                }
                else {
                    result->startOffset = aSelection->endOffset;
                    result->startCharacter = aSelection->endCharacter;
                    result->endOffset = otherSelection->endOffset;
                    result->endCharacter = otherSelection->endCharacter;
                }
            }
            else {
                result->startLine = aSelection->endLine;
                result->startOffset = aSelection->endOffset;
                result->startCharacter = aSelection->endCharacter;
                result->endLine = otherSelection->endLine;
                result->endOffset = otherSelection->endOffset;
                result->endCharacter = otherSelection->endCharacter;
            }
        }
    }
    else {
        TEXT_ASSERT(((aSelection->endLine == otherSelection->endLine) && (aSelection->endOffset == otherSelection->endOffset)), "Selections too different");
        if (aSelection->startLine > otherSelection->startLine) {
            result->startLine = otherSelection->startLine;
            result->startOffset = otherSelection->startOffset;
            result->startCharacter = otherSelection->startCharacter;
            result->endLine = aSelection->startLine;
            result->endOffset = aSelection->startOffset;
            result->endCharacter = aSelection->startCharacter;
        }
        else {
            if (aSelection->startLine == otherSelection->startLine) {
                result->startLine = otherSelection->startLine;
                result->endLine = otherSelection->startLine;
                if (aSelection->startOffset > otherSelection->startOffset) {
                    result->startOffset = otherSelection->startOffset;
                    result->startCharacter = otherSelection->startCharacter;
                    result->endOffset = aSelection->startOffset;
                    result->endCharacter = aSelection->startCharacter;
                }
                else {
                    result->startOffset = aSelection->startOffset;
                    result->startCharacter = aSelection->startCharacter;
                    result->endOffset = otherSelection->startOffset;
                    result->endCharacter = otherSelection->startCharacter;
                }
            }
            else {
                result->startLine = aSelection->startLine;
                result->startOffset = aSelection->startOffset;
                result->startCharacter = aSelection->startCharacter;
                result->endLine = otherSelection->startLine;
                result->endOffset = otherSelection->startOffset;
                result->endCharacter = otherSelection->startCharacter;
            }
        }
    }
    TEXT_ASSERT((result->startLine <= result->endLine), "bad line range");
    TEXT_ASSERT(((result->startLine < result->endLine) || (result->startOffset <= result->endOffset)), "bad offset range");
}

Boolean ConfigureFormHandleEvent(EventPtr eventP)
{
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();

    switch (eventP->eType) {
        case frmOpenEvent: {
            FrmDrawForm(frmP);
            for (int i = 0; i < ToolbarEntries; i++) {
                gSavedToolbar[i] = gToolbar[i];
//              ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureButton0Button + i);
//              ctlP->font = gToolbar[i].font;
//              CtlSetLabel(ctlP, gToolbar[i].key);  No more text labels on buttons 05/17/2002
            }
            gSelectedButton = -1;
            handled = true;
        }
        break;

    /*  case keyDownEvent : {     No more text labels on buttons 05/17/2002
                if ((gSelectedButton != -1) && (FrmGetFocus(frmP) != noFocus)) {
                    if (FrmGetObjectId(frmP, FrmGetFocus(frmP)) == ConfigureLabelField) {
                        FieldPtr fldP = (FieldPtr)getObjectPtr(frmP, ConfigureLabelField);
                        FldHandleEvent(fldP, eventP);
                        setTextFromHandle(frmP, ConfigureLabelField, gToolbar[gSelectedButton].key);
                        ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureButton0Button + gSelectedButton);
                        CtlSetLabel(ctlP, gToolbar[gSelectedButton].key);
                        FrmDrawForm(frmP);
                        handled = true;
                    }
                }
            }
            break;
    */
        case popSelectEvent : {
                if (gSelectedButton != -1) {
                //  switch (eventP->data.popSelect.listID) {
                    /*  case ConfigureFontListList: {       No more text labels on buttons 05/17/2002
                                gToolbar[gSelectedButton].font = (FontID)eventP->data.popSelect.selection;
                                ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureButton0Button + gSelectedButton);
//                              ctlP->font = gToolbar[gSelectedButton].font;
                                ListPtr lstP = (ListPtr)getObjectPtr(frmP, ConfigureFontListList);
                                LstSetSelection(lstP, gToolbar[gSelectedButton].font);
                                ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureFontTriggerPopTrigger);
                                CtlSetLabel(ctlP, LstGetSelectionText(lstP, gToolbar[gSelectedButton].font));
                                FrmDrawForm(frmP);
                                handled = false;
                            }
                            break;
                            */
                //      case ConfigureFunctionListList: {
                                gToolbar[gSelectedButton].handlerIndex = (FontID)eventP->data.popSelect.selection;
                                handled = false;
                //          }
                //          break;
                //  }
                }
            }
            break;

        case ctlSelectEvent : {
                switch (eventP->data.ctlSelect.controlID) {
                    case ConfigureButton0Button:
                    case ConfigureButton1Button:
                    case ConfigureButton2Button:
                    case ConfigureButton3Button:
                    case ConfigureButton4Button:
                    case ConfigureButton5Button:
                    case ConfigureButton6Button:
                    case ConfigureButton7Button:
                    case ConfigureButton8Button:
                    case ConfigureButton9Button:
                    case ConfigureButton10Button:
                /*  case ConfigureButton11Button:   **new interface**
                    case ConfigureButton12Button:
                    case ConfigureButton13Button:
                    case ConfigureButton14Button:
                    case ConfigureButton15Button:
                    case ConfigureButton16Button:
                    case ConfigureButton17Button:  */
                        {
                            gSelectedButton = eventP->data.ctlSelect.controlID - ConfigureButton0Button;
                        //  setHandleFromText(frmP, ConfigureLabelField, gToolbar[gSelectedButton].key, true);  No more text labels on buttons 05/17/2002

                        /*  ListPtr lstP = (ListPtr)getObjectPtr(frmP, ConfigureFontListList);      No more text labels on buttons 05/17/2002
                            LstSetSelection(lstP, gToolbar[gSelectedButton].font);
                            ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureFontTriggerPopTrigger);
                            CtlSetLabel(ctlP, LstGetSelectionText(lstP, gToolbar[gSelectedButton].font));
                        */
                            ListPtr lstP = (ListPtr)getObjectPtr(frmP, ConfigureFunctionListList);
                            LstSetSelection(lstP, gToolbar[gSelectedButton].handlerIndex);
                            ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ConfigureFunctionTriggerPopTrigger);
                            CtlSetLabel(ctlP, LstGetSelectionText(lstP, gToolbar[gSelectedButton].handlerIndex));

                            FrmDrawForm(frmP);
                        }
                        handled = true;
                        break;
                    case ConfigureOKButton :
                        //FrmGotoForm(MainForm);
                        FrmReturnToForm(0);
                        handled = true;
                        break;
                    case ConfigureCancelButton :
                        for (int i = 0; i < ToolbarEntries; i++)
                            gToolbar[i] = gSavedToolbar[i];
                        //FrmGotoForm(MainForm);
                        FrmReturnToForm(0);
                        handled = true;
                        break;
                }
            }
            break;

        default:
            break;
    }

    return handled;
}


Boolean isLower(UInt8 c){
    return ((c>=97 && c<=122) || ((c>=224 && c <=254) && c!=247)); // a->z + ->Icelandic "th"
}

Boolean isUpper(UInt8 c){
    return ((c >= 65 && c <= 90) || ((c >= 192 && c <= 222) && c != 215)); // A->Z, ->Icelandic "Th"
}

void toLower(char* p){
    // Int16 len = StrLen(p);
    for (Int16 x =0; p[x]; x++){
        if (isUpper(p[x]))
            p[x] +=('a'-'A');
    }
}

void toUpper(char*p){
    // Int16 len =StrLen(p);
    for (Int16 x =0; p[x]; x++){
        if (isLower(p[x]))
            p[x] -=('a'-'A');
    }
}

void shiftCase(char* p){
    UInt16 len = StrLen(p);
    UInt16 x = 0;
    do{
        if (isLower(p[x])){
            p[x] -=('a'-'A');
            goto nextChar;
        }
        if (isUpper(p[x]))
            p[x] +=('a'-'A');
        nextChar:
        x++;
    } while(p[x] && x<len);
}

Boolean doCaseShifts(UInt8 choice){
    if (!hasSelection())
        return false; // There is No selection to deal with!
    if (isEmptySelection())
        return false; // There is only the cursor!


    //  Copy Selection to enable Undo
    if (!copySelection())
        return false; // This should NOT happen!

    // We need to include this, before we do any changes, to make the screen update work
    resetBufferToSelection();

    // Use a local copy
    SelectionRange currentSelection = gCurrentSelection;

    // Fill the a string with the previously copied selection
    UInt16 len;
    char* text = getClipboard(&len);
    UInt16 lastLineLen = 0;  // used with 'Reverse'
    // do choosen action
    switch(choice){
        case doToLower:
            toLower(text);
            for (UInt16 x=0; x<len; x++){
                if (text[x] == '\n')
                    insertNewLine();
                else
                    insertCharacters(&text[x], 1, true);
            }
            currentSelection.endOffset = getXForCharacter(currentSelection.endLine, currentSelection.endCharacter, true);
            break;
        case doToUpper:
            toUpper(text);
            for (UInt16 x=0; x<len; x++){
                if (text[x] == '\n')
                    insertNewLine();
                else
                    insertCharacters(&text[x], 1, true);
            }
            currentSelection.endOffset = getXForCharacter(currentSelection.endLine, currentSelection.endCharacter, true);
            break;
        case doShiftCase:
            shiftCase(text);
            for (UInt16 x=0; x<len; x++){
                if (text[x] == '\n')
                    insertNewLine();
                else
                    insertCharacters(&text[x], 1, true);
            }
            currentSelection.endOffset = getXForCharacter(currentSelection.endLine, currentSelection.endCharacter, true);
            break;
        case doRevers:
            for (UInt16 x=len; x>0; x--){
                if (text[x-1] == '\n'){
                    if (x != len){
                        insertNewLine();
                        lastLineLen = 0;
                    }
                }
                else{
                    insertCharacters(&text[x-1], 1, true);
                    lastLineLen++;
                }
            }
            if(text[len -1]== '\n'){
                insertNewLine();
                lastLineLen = 0;
            }
            // We have to make sure the selection matches the changed text..
            // If the reversed text included more than one lines
            if (currentSelection.startLine != currentSelection.endLine)
                currentSelection.endCharacter = lastLineLen;
            break;
        default:
            break;
    }

    // Reselect
    gCurrentSelection = currentSelection;
    markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter, gCurrentSelection.endLine, gCurrentSelection.endCharacter);

    // Update the Screen to File....
    redrawPage();

    // Free the string Ptr
    MemPtrFree(text);
    return true;
}

void DeleteFileFromMRU(char* dbName){
        // S056 File Delete
    // Check to see if the file excists on the MRU
    for (int i = 0; i < MAX_FILES; i++) {
        if (StrCompare(gFileList[i], dbName) == 0 ){
            // The File was found
            loop:
            if(i == MAX_FILES){
                // Assign "" to the last possition
                // Empty the last string
                StrCopy(gFileList[i], "");
                break;
            }
            // Move the excisting files 'upwards'
            StrCopy(gFileList[i], gFileList[i+1]);
            i++;
            goto loop;
        }
    }
}

Boolean DeleteFormHandleEvent(EventPtr eventP)
{
    /* S056 File Delete
    *
    * Will delete the Database from the Handheld and from the MRU-list
    *
    */

    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    ListPtr lst = (ListPtr)getObjectPtr(frmP, DeleteFileList);
    UInt16 card = 0;
    LocalID dbID = NULL;
    Int16 selection = -1;
    switch (eventP->eType) {

        case frmOpenEvent:
            FrmDrawForm(frmP);
                case frmUpdateEvent:
            char dbName[dmDBNameLength];
            if (gFilenameList != NULL) {
                for (int i = 0; i < gFilenameCount; i++){
                    MemPtrFree(gFilenameList[i]);
                }
                MemPtrFree(gFilenameList);
            }

            gFilenameList = (char **)MemPtrNew(sizeof(char *) * DmNumDatabases(card));
            gFilenameCount = 0;
            DmSearchStateType state;
            UInt16 strLength;

            if(DmGetNextDatabaseByTypeCreator(true,&state,'TEXt','REAd',false,&card,&dbID)==errNone) {
                DmDatabaseInfo(0, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                if(StrCompare(dbName, gCurrentFile) && (MemLocalIDKind(dbID) == memIDHandle)){
                    strLength = StrLen(dbName);
                    gFilenameList[gFilenameCount] = (char *)MemPtrNew(strLength + 1);
                    StrCopy(gFilenameList[gFilenameCount], dbName);
                    gFilenameCount++;
                }
                while(DmGetNextDatabaseByTypeCreator(false,&state,'TEXt','REAd',false,&card,&dbID)==errNone) {
                    DmDatabaseInfo(0, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                    if(StrCompare(dbName, gCurrentFile) && (MemLocalIDKind(dbID) == memIDHandle)){
                       strLength = StrLen(dbName);
                       gFilenameList[gFilenameCount] = (char *)MemPtrNew(strLength + 1);
                       StrCopy(gFilenameList[gFilenameCount], dbName);
                       gFilenameCount++;
                    }
                }
            }

            if(gFilenameCount !=0){
                SysQSort(gFilenameList, gFilenameCount, sizeof(char *), sortFn, 0);
                LstSetListChoices(lst, gFilenameList, gFilenameCount);
                LstSetSelection(lst, -1);
                LstMakeItemVisible(lst, 0); // For PalmOS <3.5
                LstDrawList(lst);
            }

            if(gFilenameCount ==0){
                error("Unable to delete the currently open file");
                FrmReturnToForm(MainForm);
            }
            handled = true;
            break;
        case keyDownEvent:
            handled = scrollList(frmP, lst, eventP->data.keyDown.chr, gFilenameList, gFilenameCount);
            break;
        case ctlSelectEvent:
            switch (eventP->data.ctlSelect.controlID) {
                case DeleteDeleteButton:
                    selection = LstGetSelection(lst);
                    if (selection != -1) {
                        if(FrmCustomAlert(DeleteAlert, gFilenameList[selection], NULL, NULL) == DeleteAlertOK){
                                dbID = DmFindDatabase(card, gFilenameList[selection]);
                            DmDeleteDatabase(card, dbID);
                            // Alert: File deleted
                            DeleteFileFromMRU(gFilenameList[selection]);
                            if (gFilenameCount !=1)
                                FrmUpdateForm(DeleteForm, frmRedrawUpdateCode);
                            else{  // Special case: User deleted the only available file
                                 MemPtrFree(gFilenameList[0]);
                                 MemPtrFree(gFilenameList);
                                 gFilenameList = NULL;
                                 FrmReturnToForm(MainForm);
                                 break;
                           }
                        }
                     }
                     else{
                        // Alert: Please make a selection.
                     }
                     break;
                case DeleteCancelButton:
                     if (gFilenameList != NULL) {
                        for (int i = 0; i < gFilenameCount; i++)
                            MemPtrFree(gFilenameList[i]);
                       MemPtrFree(gFilenameList);
                       gFilenameList = NULL;
                     }
                     FrmReturnToForm(MainForm);
                     break;
            }
            handled = true;
            break;
        default:
            break;
    }
    return handled;
}

Boolean FileInfoFormHandleEvent(EventPtr eventP)
{
    /*
    *  S055 File Info and Attributes
    *
    */

    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    ListPtr dbDatesLstP = (ListPtr)getObjectPtr(frmP, FileInfoDBDatesOptionsList);
        ControlPtr ctlDBDatesOptionsListP = (ControlPtr)getObjectPtr(frmP, FileInfoDBDatesPopupTrigger);

    switch (eventP->eType) {

        case frmOpenEvent:
            FrmDrawForm(frmP);  // Draw the Form
                    LstSetSelection(dbDatesLstP, 0);
                    CtlSetLabel(ctlDBDatesOptionsListP, LstGetSelectionText(dbDatesLstP, 0));
                        if(!getFileInfo(0))  // Popualte the Form
                          error("Output may be incorrect");
            handled = true;
            break;
        case ctlSelectEvent:
            switch (eventP->data.ctlSelect.controlID) {
                case FileInfoOKButton:
                                        // read and change
                                        if (StrCompare("Set", CtlGetLabel((ControlPtr)getObjectPtr(frmP, FileInfoOKButton)))==0)
                      if(!setFileInfo())
                                                error("An error occurred during setFileInfo. The settings may NOT have been done");
                case FileInfoCancelButton:
                    FrmReturnToForm(0);
                                        setGUISelection(false);
                    getSelectionForDB();
                    resetBufferToSelection();
                    redrawPage();
                                        handled = true;
                    break;
                                case FileInfoBackupCheckbox:
                                case FileInfoBeamPrvntCheckbox:
                case FileInfoReadOnlyCheckbox:
                                        CtlSetLabel((ControlPtr)getObjectPtr(frmP, FileInfoOKButton), "Set");
                                        break;   // do NOT set handled to true!
            }
            break;
                    case popSelectEvent:
              switch (eventP->data.popSelect.listID) {
                case FileInfoCategoryNumberList:
                    if (eventP->data.popSelect.selection != eventP->data.popSelect.priorSelection)
                                          CtlSetLabel((ControlPtr)getObjectPtr(frmP, FileInfoOKButton), "Set");
                                        break;   // do NOT set handled to true!
                                case FileInfoDBDatesOptionsList:
                                        getFileInfo(eventP->data.popSelect.selection+1);
                                        break;
                            }
                            break;
        default:
            break;
    }
    return handled;
}

Boolean GotoLineFormHandleEvent(EventPtr eventP)
{
    /* S041 Show and Goto Line */
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();

    switch (eventP->eType) {
        case frmOpenEvent:
            // Clear cursor
            clearBlinkingCursor();
            showCurrentLine();
            FrmDrawForm(frmP);
            break;
        case ctlSelectEvent:
            switch (eventP->data.ctlSelect.controlID){
                case GotoLineOKButton:
                    if (gotoLineNumber()){
                        FrmReturnToForm(0);
                        setGUISelection(false);
                        getSelectionForDB();
                        resetBufferToSelection();
                        redrawPage();
                        }
                    handled = true;
                    break;
                case GotoLineCancelButton:
                    FrmReturnToForm(0);
                    handled = true;
                    break;
            }
        default:
            break;
    }
    return handled;
}

UInt8 compressHardKeysScrollValues(void)
{
    // #846292 (S051) Use hard buttons to scroll
    UInt8 returnValue = gUseHardKeysForScrolling & 0x01;
    // vchrHard1 = 0x10;
    // vchrHard2 = 0x20;
    // vchrHard3 = 0x40;
    // vchrHard4 = 0x80;
    if (hardLeftKey == vchrHard1)
        returnValue |= 0x10;
    if (hardLeftKey == vchrHard2 || hardRightKey == vchrHard2)
        returnValue |= 0x20;
    if (hardLeftKey == vchrHard3 || hardRightKey == vchrHard3)
        returnValue |= 0x40;
    if (hardLeftKey == vchrHard4 || hardRightKey == vchrHard4)
        returnValue |= 0x80;
    return returnValue;
}

Boolean doCommentSelection()
{
    // #846291 (S053) Comment-out selected region
    if (hasSelection() && !isEmptySelection()) {
        resetBufferToSelection();
        if(commentSelection()){
            redrawPage();
            return true;
        }
    }
    return false;
}

Boolean doFindReplace()
{
    FormPtr frmP = FrmInitForm(ReplaceForm);
    FieldPtr fldFindP = (FieldPtr)getObjectPtr(frmP, ReplaceFindTextField);
    FieldPtr fldReplaceP = (FieldPtr)getObjectPtr(frmP, ReplaceReplaceTextField);

    UInt16 numFoundsAndReplaced = 0;    // Number of sucessfully replaced items

    //if the user has highlighted a bit of text, that is less than one line, put that data into the search field
    if ((hasSelection()) && (!isEmptySelection()) &&
        (gCurrentSelection.startLine == gCurrentSelection.endLine)) {
        char curLine[MAX_CHARS_PER_LINE];
        unsigned int lineLength;
        loadLine(gCurrentSelection.startLine, curLine, &lineLength);
        Int16 searchTextLength = gCurrentSelection.endCharacter - gCurrentSelection.startCharacter;
        MemHandle h = (MemHandle)FldGetTextHandle(fldFindP);
        MemHandle textH = (MemHandle)MemHandleNew(searchTextLength + 1);
        char *p = (char *)MemHandleLock(textH);
        for (Word x = gCurrentSelection.startCharacter; x < gCurrentSelection.endCharacter; x++) {
            *p++ = curLine[x]; //loop through the selection and dump it into the search string
        }
        *p = '\0'; //add a terminator to the search string
        MemHandleUnlock(textH);
        FldSetTextHandle(fldFindP, textH);
        FldSetSelection(fldFindP, 0, searchTextLength);
        if (h) {
            MemHandleFree(h);
        }
    }

    else
        if (gSearchTextH != NULL) {
            MemHandle h = (Handle)FldGetTextHandle(fldFindP);
            char *searchText = (char*)MemHandleLock(gSearchTextH); //grab the text...
            int searchTextLength = StrLen(searchText);
            MemHandle textH = MemHandleNew(searchTextLength + 1);
            char *p = (char *)MemHandleLock(textH);
            StrCopy(p, searchText);
            MemHandleUnlock(textH);
            MemHandleUnlock(gSearchTextH);
            FldSetTextHandle(fldFindP, textH);
            FldSetSelection(fldFindP, 0, searchTextLength);
            if (h) {
                MemHandleFree(h);
            }
        }

    ControlPtr ctlP = (ControlPtr)getObjectPtr(frmP, ReplaceIgnoreCaseCheckbox);
    CtlSetValue(ctlP, gSearchIgnoreCase); // gReplaceIgnoreCase
    ControlPtr ctlFrTopP = (ControlPtr)getObjectPtr(frmP, ReplaceSearchFromTopCheckbox);
    CtlSetValue(ctlFrTopP, gSearchFromTop);

    if (gSearchTextH)
        FrmSetFocus(frmP, FrmGetObjectIndex(frmP, ReplaceReplaceTextField));
    else
        FrmSetFocus(frmP, FrmGetObjectIndex(frmP, ReplaceFindTextField));

    // Clear cursor
    clearBlinkingCursor();

    newtry:
    UInt16 buttonSelection = FrmDoDialog(frmP);
    if (buttonSelection == ReplaceNextButton || buttonSelection == ReplaceReplaceAllButton || buttonSelection == ReplaceFindButton){
        gSearchIgnoreCase = CtlGetValue(ctlP);
        gSearchFromTop = CtlGetValue(ctlFrTopP);
        if (gSearchTextH != NULL)
            MemHandleFree(gSearchTextH);
        gSearchTextH = NULL;
        MemHandle h = (MemHandle)FldGetTextHandle(fldFindP);
        if (h) {
            char *p = (char*)MemHandleLock(h);
            gSearchTextH = (MemHandle)MemHandleNew(StrLen(p) + 1);
            char *searchText = (char*)MemHandleLock(gSearchTextH);
            StrCopy(searchText, p);
            MemHandleUnlock(h);

            // Search From Top?
            UInt16 searchStartLine = gCurrentSelection.endLine;
            UInt16 searchStartCharacter = gCurrentSelection.endCharacter;
            if (gSearchFromTop){
                searchStartLine = 0;
                searchStartCharacter = 0;
                }

            // get the Replace String
            MemHandle replaceTxtH = (MemHandle)FldGetTextHandle(fldReplaceP);
            char* replaceTxtP = "";
            UInt8 txtLen = 0;
            if (replaceTxtH){
                replaceTxtP = (char*)MemHandleLock(replaceTxtH);
                txtLen = StrLen(replaceTxtP);
            }

            Boolean cont = true;
            Boolean beep = true;
            while(cont){
                if (numFoundsAndReplaced != 0)
                    beep = false;

                cont = search(searchStartLine, searchStartCharacter, searchText, gSearchIgnoreCase, beep);

                if (cont){
                    setGUISelection(false);
                    resetBufferToSelection();

                    searchStartLine = gCurrentSelection.endLine;
                    searchStartCharacter = gCurrentSelection.startCharacter+txtLen; // Keep away from the last inserted text
                    if (txtLen == 0)
                        searchStartCharacter = gCurrentSelection.endCharacter;

                    if(buttonSelection == ReplaceNextButton || buttonSelection == ReplaceReplaceAllButton){
                        // Replace upon found
                        if (hasSelection()) {
                            // since there can be an empty selection here, we make sure the blink is off
                            if (isEmptySelection() && isBlinkOnScreen())
                                clearBlinkingCursor();
                            if (txtLen !=0){
                                insertCharacters(replaceTxtP, txtLen, true);
                            }
                            else{
                                // if txtLen == 0 then we have to delete instead
                                deleteSelection();
                            }
                            numFoundsAndReplaced++;
                        }
                    }
                }
                if (buttonSelection == ReplaceNextButton || buttonSelection == ReplaceFindButton)
                   cont = false;
            }

            setGUISelection(false);
            resetBufferToSelection();
            redrawPage();
            if(replaceTxtH)
                MemHandleUnlock(replaceTxtH);
            MemHandleUnlock(gSearchTextH);
            MemHandleUnlock(h);
        }
        else{
            error("Not a valid search string");
            FrmSetFocus(frmP, FrmGetObjectIndex(frmP, ReplaceFindTextField));
            goto newtry;
        }
    }
    FrmDeleteForm(frmP);
    return true;
    //return numFoundsAndReplaced;
}

void doPreKeyboard(void)
{
    /* S040 On screen keyboard: This function does the following things:
    *
    *  Shows & Focusing the hidden Field, thus letting the UIKeybord to open.
    *  Pastes the current line to that field.
    *  Enabling the InsertionPoint at the Right Location
    *  Make sure that hasSelection == true before running this function!
    */

    MemHandle txtH;
    MemHandle oldTxtH;
    FieldPtr fldP;

    FormPtr frmP = FrmGetActiveForm();
    UInt16 objIndex = FrmGetObjectIndex(frmP, MainDummyField);

    // Hide The Cursor
    clearBlinkingCursor();

    // Show the hidden MainDummyField
    FrmShowObject(frmP, objIndex);

    // get some space in which to stash the string
    UInt16 txtLen = StrLen(bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text);
    txtH = MemHandleNew(txtLen+1);
    gPreKeyboardTxtLen = MemHandleSize(txtH);
    if (!txtH)
        error("Not enough Memory to execute the UIKeyboard");

    // copy the string
    StrCopy ((char*)MemHandleLock(txtH), bufferedLineContents[gCurrentSelection.startLine - screenTopLine].text);

    // unlock the string handle
    MemHandleUnlock(txtH);

    // get the field and the field's current text handle
    fldP = (FieldPtr)getObjectPtr(frmP, MainDummyField);
    ErrNonFatalDisplayIf(!fldP, "missing field");
    oldTxtH = FldGetTextHandle(fldP);
    // set the field's text to the new text thus pasting the current line to MainDummyField
    FldSetTextHandle(fldP, txtH);

    // free the handle AFTER we call FldSetTextHandle()
    if (oldTxtH)
     MemHandleFree(oldTxtH);

    if (isEmptySelection()){
        // Insert the InsPt at the right location in the field's text
        FldSetInsPtPosition(fldP,gCurrentSelection.startCharacter);
    }
    else{
        // Mimic the Current Selection
        UInt16 endSelectionPos = gCurrentSelection.endCharacter;
        if (gCurrentSelection.startLine != gCurrentSelection.endLine)
            endSelectionPos = txtLen;
        FldSetSelection(fldP, gCurrentSelection.startCharacter, endSelectionPos);
    }

    // Give the MainDummyField the Focus
    FrmSetFocus(FrmGetActiveForm(), objIndex);
}

Boolean doPostKeyboard(FieldPtr fldP)
{
    /*  S040 On screen keyboard: This function does the following things:
    *
    *   Hides the MainDummyField.
    *   Pastes the contents of that field to the Doc
    *   Places the InsPt at the right location in the updated screen
        *
    */

    Handle oldTxtH;
    char* txtP;                    // The string from the UIKeyboard
    unsigned int txtLen = 0;       // The Length of the string
    UInt16 x = 0;
    UInt16 insPtNewLine = 0;        // The Line were to put the InsPt
    UInt16 insPtNewPos = 0;         // The Pos were to put the InsPt


    // Grab the text
    txtP = FldGetTextPtr(fldP);
    // Grab the InsPt
    insPtNewPos = FldGetInsPtPosition(fldP);

    // Hide the Field
    FrmHideObject(FrmGetActiveForm(), FrmGetObjectIndex(FrmGetActiveForm(), MainDummyField));

    if (txtP !=NULL){
        txtLen = StrLen(txtP);

        resetBufferToSelection();

        // Marking the old line
        gCurrentSelection.startCharacter = 0;
        gCurrentSelection.endCharacter = gPreKeyboardTxtLen-1;
        gCurrentSelection.endLine = gCurrentSelection.startLine;
        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter, gCurrentSelection.endLine, gCurrentSelection.endCharacter);

        // Erasing the old line's previous contence is done with insertCharacters...
        // insertCharacters(&txtP, len, true);
        //
        // Checking for NewLineChar(s) in the string
        // Inserting the new line(s) in the .pdb is done with insertNewLine();

        insPtNewLine = gCurrentSelection.startLine;
        UInt8 posCount = 0;

        x = 0;
        while (x<txtLen){
            while (txtP[x] != '\n' && x<txtLen){
                posCount++;
                x++;
            }
            if (posCount)
                insertCharacters(&txtP[x-posCount], posCount, true);
            if (txtP[x] == '\n'){
                if (FldGetInsPtPosition(fldP) > x){    // If the InsPt is left NOT on the first line
                    insPtNewPos -= posCount+1;           // skipping the '/n'
                    posCount = 0;
                    insPtNewLine++;
                }
                insertNewLine();
            }
            x++;
        }


        /* This is to slow!!!
        for (x=0; x<txtLen; x++){
            posCount++;
            if (txtP[x] == '\n'){
                if (FldGetInsPtPosition(fldP) > x){    // If the InsPt is left NOT on the first line
                    insPtNewPos -= posCount;           // skipping the '/n'
                    posCount = 0;
                    insPtNewLine++;
                }
                insertNewLine();
            }
            else {
                insertCharacters(&txtP[x], 1, true);
            }
        }
        */

        if (txtLen == 0)
            deleteSelection();

        // This is a guardiwn
        if (insPtNewPos<0)
            insPtNewPos = 0;

        gCurrentSelection.startCharacter = insPtNewPos;
        gCurrentSelection.startLine = insPtNewLine;
        gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
        gCurrentSelection.endLine = gCurrentSelection.startLine;

        markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter, gCurrentSelection.endLine, gCurrentSelection.endCharacter);

        // Update the Screen to File....
        redrawPage();
    }
    // get the field and the field's currennt text handle
    oldTxtH = FldGetTextHandle(fldP);

    // set the field's text Handle to NULL thus clearing the field
    FldSetTextHandle(fldP, NULL);

    // free the handle AFTER we call FldSetHandle()
    if (oldTxtH)
        MemHandleFree(oldTxtH);

    FrmGotoForm(MainForm);      // we're already in the MainForm, but we need to restart it
                                // in order to dhow the buttons....
    return true;
}

void doSelectAll(void)
{
        // #891109: Select All
        unsigned int len = 0;
        MemHandle h = MemHandleNew(MAX_CHARS_PER_LINE);
        char *p = (char*)MemHandleLock(h);
        loadLine(gMaxLines-1, p, &len);
        MemHandleFree(h);
        int offset = getXForCharacter(gMaxLines-1, len, false);

        gCurrentSelection.startCharacter = 0;
        gCurrentSelection.startOffset = 0;
        gCurrentSelection.endCharacter = len;
        gCurrentSelection.endOffset = offset;

        markSelection(0, 0, gMaxLines-1, len);

        redrawPage();
}

Boolean doUncommentSelection()
{
    // #846291 (S053) Comment-out selected region
    if (hasSelection() && !isEmptySelection()) {
        resetBufferToSelection();
        uncommentSelectionStart();
        // uncommentSelectionEnd();
        redrawPage();
        return true;
    }
    return false;
}

static Boolean getFileInfo(UInt8 toggle)
{
  /*
  *  S055 File Info and Attributes - Get
  *
  *  this is NOT prepared for Compressed files.
  *  But When SrcEdit is capable of compressing the compressed size should be checked
  *
  *  Currently SrcEdit only works with files in card # 0 (default card number)
    *  But when SrcEdit is capable of Opening Files in VFS this has to be checked
  *
  */
    if (gCurFile != -1) {
    saveDocFile(gCurrentFile, false);
    setSelectionForDB();
  }
    else
    return false;

  FormPtr frmP = FrmGetActiveForm();
  ControlPtr ctlBackupP = (ControlPtr)getObjectPtr(frmP, FileInfoBackupCheckbox);
  ControlPtr ctlBeamPrvntP = (ControlPtr)getObjectPtr(frmP, FileInfoBeamPrvntCheckbox);
  ControlPtr ctlReadOnlyP = (ControlPtr)getObjectPtr(frmP, FileInfoReadOnlyCheckbox);
  ControlPtr ctlPopupCatListP = (ControlPtr)getObjectPtr(frmP, FileInfoCategoryNumberPopupTrigger);
    ListPtr lstCategoriesP = (ListPtr)getObjectPtr(frmP, FileInfoCategoryNumberList);
  // ListPtr dbDatesLstP = (ListPtr)getObjectPtr(frmP, FileInfoDBDatesOptionsList);

    UInt16 cardNo;
    LocalID dbID = 0;
    MemHandle h = MemHandleNew(100);
    char* p;

    FontID oldFont = FntSetFont(stdFont); // We have to make sure that the output is made with stdFont
    // FileName - gCurrentFile

    // Find Database
    for (cardNo = 0; cardNo<0xffff; cardNo++){
      dbID = DmFindDatabase(cardNo, gCurrentFile);
        if (dbID !=0)
      break;
  }
    if (dbID == 0)
    return false;       // File Not found!

  UInt8 reside = 0;
  UInt32 numRec = 0;
  UInt32 dataSize = 0;
  UInt32 DBsize = 0;
  if (!toggle){
      // Place of Reside
        /*
      *  0 - RAM
      *  1 - ROM (flash)
      *  2 - VFS   NOT IMPLEMENTED
      */
        // if (MemHeapFlags(MemPtrHeapID(MemLocalIDToLockedPtr(dbID, cardNo))) & memHeapFlagReadOnly)
      if (MemLocalIDKind( dbID ) != memIDHandle)
          reside = 1;


      // Check if found DB is the current DB
      /*
      // DmOpenRef dbR,
        LocalID dbIDtest;
        UInt16 openCount;
        UInt16 mode;
        UInt16 cardNo;
        Boolean resDB;

      if (DmOpenDatabaseInfo (gCurrentDB, &dbIDtest, &openCount, &mode, &cardNo, &resDB))
        return false;
        if (dbID != dbIDtest)
            return false;
        */

        // number of Records, total DBSize and dataSize
        if (DmDatabaseSize(cardNo, dbID, &numRec, &DBsize, &dataSize))
            return false;  // dmErrMemError
  }


    // Attributes, version, crDate, modDate, bckUpDate, modNumP, appInfoID, sortInfoID, type, creator
    char dbName[dmDBNameLength];
    UInt16 attributes;
    UInt16 version;
    UInt32 crDate;
    UInt32 modDate;
    UInt32 bckUpDate;
    UInt32 modNum;
    LocalID appInfoID;
    LocalID sortInfoID;
    char type[4];
    char creator[4];


  if(DmDatabaseInfo (cardNo, dbID, dbName, &attributes, &version, &crDate, &modDate,
    &bckUpDate, &modNum, &appInfoID, &sortInfoID, (UInt32*)type, (UInt32*)creator))
    return false;  // dmErrInvalidParam

  UInt32 numWords = NULL;
  UInt16 category = NULL;
    if (toggle==0){
      // Category
        UInt16 recAttr = NULL;
      DmOpenRef tempOpenRef;
      tempOpenRef = DmOpenDatabase(cardNo, dbID, dmModeReadOnly);
        if (tempOpenRef){
            // Check if this is a match
            LocalID dbIDtest;

      if (DmOpenDatabaseInfo (tempOpenRef, &dbIDtest, NULL, NULL, NULL, NULL))
        return false;
        if (dbID != dbIDtest)
            return false;

          if(DmRecordInfo(tempOpenRef, 0, &recAttr, NULL, NULL))
          return false;
      }
      else
        return false;
      category = recAttr & dmRecAttrCategoryMask;

      // Words
      /*
      *  Any combination of letters and/or numbers that are followed by
      *  a spaceChr, crChar, lfChr or a tabChr)
      */
        numWords = numWordsInDoc(tempOpenRef);

      DmCloseDatabase(tempOpenRef);
  }

    //if (outToScreen)
  p = (char*)MemHandleLock(h);
    if (!p)
        return false;

  if (!toggle){
      // FileName - gCurrentFile
        // ToDo: check the pixelLength
        StrCopy(p, gCurrentFile);
        WinDrawChars(p, StrLen(p), 45, 15);
  }

    // date + time (output)
    UInt32 seconds = 0;
    RectangleType* rt = (RectangleType*)MemPtrNew(sizeof(RectangleType));
    rt->topLeft.x = 59;
    rt->topLeft.y = 28;
    rt->extent.x = 100;
  rt->extent.y = 11;
    WinEraseRectangle(rt, 0);
  MemPtrFree(rt);
    switch (toggle){
      case 2:
          seconds = modDate;
      break;
      case 3:
      seconds = bckUpDate;
      break;
    default:
      seconds = crDate;
      break;
  }
  // Date
  DateTimeType* dateTime = (DateTimeType*)MemPtrNew(sizeof(DateTimeType));
  DateFormatType df = (DateFormatType)PrefGetPreference(prefDateFormat);
    TimSecondsToDateTime(seconds, dateTime);
  DateToAscii ((UInt8)dateTime->month, (UInt8)dateTime->day, (UInt16)dateTime->year, df, p);
    WinDrawChars(p, StrLen(p), 60, 28);
  UInt16 formerPixelLen = FntCharsWidth(p, StrLen(p));
  // Time
  TimeFormatType tf = (TimeFormatType)PrefGetPreference(prefTimeFormat);
    TimeToAscii ((UInt8)dateTime->hour, (UInt8)dateTime->minute, tf, p);
  WinDrawChars(p, StrLen(p), 60+formerPixelLen+5, 28);
    MemPtrFree(dateTime);

  if (!toggle){
      // Resides on
        switch (reside){
            case 1:
              StrCopy(p, "ROM (flash)");
                break;
            case 2:
                StrCopy(p, "VFS card");
          break;
            default:
                StrCopy(p, "RAM");
                break;
        }
        WinDrawChars(p, StrLen(p), 60, 41);

        // version
        StrIToA(p, version);
        WinDrawChars(p, StrLen(p), 40, 54);

      // Category
      LstSetSelection(lstCategoriesP, category);
      CtlSetLabel(ctlPopupCatListP, LstGetSelectionText(lstCategoriesP, category));

        // DBsize
        StrPrintF(p, "%lu", DBsize);
        WinDrawChars(p, StrLen(p), 40, 67);

        // numRec
        StrIToA(p, numRec);
        WinDrawChars(p, StrLen(p), 110, 67);

      // DOC size = dataSize - sizeof(DOCHeader) found in TextContents.cpp
        StrPrintF(p, "%lu", (dataSize-16));
        WinDrawChars(p, StrLen(p), 40, 80);

        // Compressed size
        StrCopy(p, "-");
        WinDrawChars(p, StrLen(p), 136, 80);

      // # Lines
        StrIToA(p, gMaxLines);
        WinDrawChars(p, StrLen(p), 40, 93);

      // # Words
        StrIToA(p, numWords);
        WinDrawChars(p, StrLen(p), 120, 93);

      // Attributes - Backup
        if (attributes & dmHdrAttrBackup)
        CtlSetValue(ctlBackupP, true);

      // Attributes - Beam Prvnt
        if (attributes & dmHdrAttrCopyPrevention)
        CtlSetValue(ctlBeamPrvntP ,true);

      // Attributes - ReadOnly
        if (attributes & dmHdrAttrReadOnly)
        CtlSetValue(ctlReadOnlyP ,true);

        // if this is a ROM file
      if (reside == 1){
            CtlSetUsable(ctlBackupP, false);
        CtlSetUsable(ctlBeamPrvntP, false);
        CtlSetUsable(ctlReadOnlyP, false);
        CtlSetUsable(ctlPopupCatListP, false);
      }
  }
    MemHandleUnlock(h);
    MemHandleFree(h);
    FntSetFont(oldFont);
    return true;
}

void getKeyRates(void)
{
    KeyRates(false, &gOldRepeatDelay, &gOldPeriod, &gDoubleTapDelay, &gQueueAhead);
}

static Boolean gotoLineNumber(void)
{
    /* S041 Show and Goto Line: This function does the following:
    *
    * Read the line number from the Field
    * Check if it is a valid line number (1->gMaxLines
    * Place the blinking cursor at start of that line
    *
    * Returns true upon success! false otherwise: thus giving the user another try!
    * Doesn't do the Screen update
    *
    */
    UInt16 lineNumber = 0;
    FormPtr frmP = FrmGetActiveForm();

    setIntFromHandle(frmP, GotoLineField, (char*)(&lineNumber), 0, false);

    if (lineNumber<1){
        error("Line Number has to be >0");
        setHandleFromInt(frmP, GotoLineField, 1, true, true);
        return false; // give the user a try!
        }
    if (lineNumber>gMaxLines){
        MemHandle h = MemHandleNew(40);
        char* txt = (char*)MemHandleLock(h);
        StrPrintF(txt, "This DOC has only %i lines.", gMaxLines);
        error(txt);
        MemHandleFree(h);
        setHandleFromInt(frmP, GotoLineField, gMaxLines, true, true);
        return false; // give the user a new try!
        }

    gCurrentSelection.startLine = lineNumber-1;
    gCurrentSelection.endLine = gCurrentSelection.startLine;
    gCurrentSelection.startCharacter = 0;
    gCurrentSelection.endCharacter = gCurrentSelection.startCharacter;
    gCurrentSelection.startOffset = getXForCharacter(gCurrentSelection.startLine, gCurrentSelection.startCharacter, true);
    gCurrentSelection.endOffset = gCurrentSelection.startOffset;

    markSelection(gCurrentSelection.startLine, gCurrentSelection.startCharacter,
                  gCurrentSelection.endLine, gCurrentSelection.endCharacter);
    setSelectionForDB();
    return true;
}

static UInt32 numWordsInDoc(DmOpenRef tempOpenRef)
{
  /*
  *  S055 this works only with unCompressed Docs
  */
  UInt16 numberOfRecords = DmNumRecords(tempOpenRef);
  UInt32 numWords = 0;
    UInt16 recNum = 1; // Record #0 is the DOC Header
    UInt16 x = 0;
    MemHandle recH;
  char* recP;
  UInt32 ptrSize = 0;

    for (recNum = 1; recNum<numberOfRecords; recNum++){
    recH = (MemHandle)DmQueryRecord(tempOpenRef, recNum);
    recP = (char*)MemHandleLock(recH);
        ptrSize = MemPtrSize(recP);
      for (x = 0; x<ptrSize; x++){
        if (x>0 && ((isWhitespace((char)recP[x]) == true) && (isWhitespace((char)recP[x-1]) == false)))
          numWords++;
      }
    MemHandleUnlock(recH);
  }
    return numWords;
}

Boolean PreferencesFormHandleEvent(EventPtr eventP) // New code 04/29/2002 // #846292 (S051) Use hard buttons to scroll
{
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    UInt8 fontIndex=FrmGetObjectIndex( frmP, PreferencesSmFontPushButton );

    ControlPtr ctlHardKeysP = (ControlPtr)getObjectPtr( frmP, PreferencesHardKeyScrollingCheckbox );
    ControlPtr ctlHardKeysLeftPopTriP = (ControlPtr)getObjectPtr( frmP, PreferencesHardKeyLeftPopTrigger );
    ListPtr lstLeftKeyP = (ListPtr)getObjectPtr( frmP, PreferencesHardKeyLeftList );
    ControlPtr ctlHardKeysRightPopTriP = (ControlPtr)getObjectPtr( frmP, PreferencesHardKeyRightPopTrigger );
    ListPtr lstRightKeyP = (ListPtr)getObjectPtr( frmP, PreferencesHardKeyRightList );

    ControlPtr ctlColorP = (ControlPtr)getObjectPtr( frmP, PreferencesColorModeCheckbox );
    //    ControlPtr ctlHtmlP = (ControlPtr)getObjectPtr( frmP, PreferencesHTMLmodeCheckbox );
    UInt CModeIndex=FrmGetObjectIndex( frmP, PreferencesCModePushButton );
    UInt HTMLModeIndex=FrmGetObjectIndex( frmP, PreferencesHTMLModePushButton );
    UInt ASMModeIndex=FrmGetObjectIndex( frmP, PreferencesASMModePushButton );
    // UInt8 oldMode = gHighlightMode;  // #846293 (S046) pick highlight mode based on file extension

    ControlPtr ctlPopupP = (ControlPtr)getObjectPtr( frmP, PreferencesCommentColorPopTrigger );
    ListPtr lstP = (ListPtr)getObjectPtr( frmP, PreferencesCommentColorList );

    ControlPtr ctlPopupKP = (ControlPtr)getObjectPtr( frmP, PreferencesKeywordColorPopTrigger );
    ListPtr lstKP = (ListPtr)getObjectPtr( frmP, PreferencesKeywordColorList );

    UInt32 nd;
    /*if (gRomVersion < version35) { //added this to give screen depth support for pre-3.5 monochrome Palms 05/16/02
        ScrDisplayMode(scrDisplayModeGetSupportedDepths,NULL,NULL,&nd,NULL);
    } else {*/
        WinScreenMode(winScreenModeGetSupportedDepths,NULL,NULL,&nd,NULL);
   // }

    static char ListItem0[7];
    static char ListItem1[7];
    static char ListItem2[7];
    static char *ColorList[3] = {ListItem0,ListItem1,ListItem2};

    static char KeyItem0[7];
    static char KeyItem1[7];
    static char KeyItem2[7];
    static char KeyItem3[7];
    static char *KeyColorList[4] = {KeyItem0,KeyItem1,KeyItem2,KeyItem3};

    switch (eventP->eType) {
        case frmOpenEvent: {
            if(nd==0x0B) { //populate the color list
                StrCopy(ListItem0,"Light ");
                StrCopy(ListItem1,"Medium");
                StrCopy(ListItem2,"Dark  ");

                StrCopy(KeyItem0,"Off   ");
                StrCopy(KeyItem1,"Light ");
                StrCopy(KeyItem2,"Medium");
                StrCopy(KeyItem3,"Dark  ");
           } else {
                StrCopy(ListItem0,"Red   ");
                StrCopy(ListItem1,"Green ");
                StrCopy(ListItem2,"Blue  ");

                StrCopy(KeyItem0,"Off   ");
                StrCopy(KeyItem1,"Red   ");
                StrCopy(KeyItem2,"Green ");
                StrCopy(KeyItem3,"Blue  ");
            }
            // set pushbuttons and checkboxes to reflect saved values
            if ( gCurrentFont==(FontID)129 ) {
                FrmSetControlGroupSelection( frmP, 200, PreferencesSmFontPushButton );
            } else {
                FrmSetControlGroupSelection( frmP, 200, PreferencesStdFontPushButton );
            }
        switch ( gHighlightMode ) {
            case HTMLMODE:
              FrmSetControlGroupSelection( frmP, 201, PreferencesHTMLModePushButton );
               ;
            case ASMMODE:
              FrmSetControlGroupSelection( frmP, 201, PreferencesASMModePushButton );
              break;
            case CMODE:
            default:
              FrmSetControlGroupSelection( frmP, 201, PreferencesCModePushButton );
            }
            /*            if ( gHTMLmode ) {
                    CtlSetValue( ctlHtmlP, 1 );
                } else {
                    CtlSetValue( ctlHtmlP, 0 );
                }
            */
            if (gUseHardKeysForScrolling){  // #846292 (S051) Use hard buttons to scroll
                CtlSetValue( ctlHardKeysP, 1 );
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftLabel ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftPopTrigger ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightLabel ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightPopTrigger ));
            } else {
                CtlSetValue(ctlHardKeysP, 0 );
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftLabel ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftPopTrigger ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightLabel ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightPopTrigger ));
            }
            UInt16 index = 0;
            switch (hardLeftKey) {
                case vchrHard1:
                    index = 0;
                    break;
                case vchrHard2:
                    index = 1;
                    break;
                case vchrHard3:
                    index = 2;
                    break;
            }
            LstSetSelection( lstLeftKeyP, index );
            CtlSetLabel( ctlHardKeysLeftPopTriP, LstGetSelectionText( lstLeftKeyP, index ));
            switch (hardRightKey) {
                case vchrHard2:
                    index = 0;
                    break;
                case vchrHard3:
                    index = 1;
                    break;
                case vchrHard4:
                    index = 2;
                    break;
            }
            LstSetSelection( lstRightKeyP, index );
            CtlSetLabel( ctlHardKeysRightPopTriP, LstGetSelectionText( lstRightKeyP, index ));

            if ( gColorMode ) { //set check box and color control show/hide properties
                CtlSetValue( ctlColorP, 1 );
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorLabel ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorPopTrigger ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorLabel ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorPopTrigger ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesLabel ));
                FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesField ));
            } else {
                CtlSetValue( ctlColorP, 0 );
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorLabel ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorPopTrigger ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorLabel ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorPopTrigger ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesLabel ));
                FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesField ));
            }
            LstSetListChoices(lstP,(char **)ColorList,3);
            LstSetListChoices(lstKP,(char **)KeyColorList,4);
            // UInt16 index = 0;
            index = 0;
            switch (ictCommentsSaved) {
                case 0x6:  //light gray
                    index=0;
                    break;
                case 0x9:  //medium gray
                    index=1;
                    break;
                case 0xB:  //dark gray
                    index=2;
                    break;
                case 0x77:  //red
                    index=0;
                    break;
                case 0xD4:  //green
                    index=1;
                    break;
                case 0x5F:  //blue
                    index=2;
                    break;
            }
            LstSetSelection( lstP, index );
            //Char *popLbl = CtlGetLabel( ctlPopupP );
            //StrCopy( popLbl, LstGetSelectionText(lstP, index));
            CtlSetLabel( ctlPopupP, LstGetSelectionText( lstP, index ));

            switch (ictKeywordsSaved) {
                case 0x6:  //light gray
                    index=1;
                    break;
                case 0x9:  //medium gray
                    index=2;
                    break;
                case 0xB:  //dark gray
                    index=3;
                    break;
                case 0x77:  //red
                    index=1;
                    break;
                case 0xD4:  //green
                    index=2;
                    break;
                case 0x5F:  //blue
                    index=3;
                    break;
                default:
                    index=0;
                    break;
            }
            LstSetSelection( lstKP, index );
            //Char *popLbl = CtlGetLabel( ctlPopupP );
            //StrCopy( popLbl, LstGetSelectionText(lstP, index));
            CtlSetLabel( ctlPopupKP, LstGetSelectionText( lstKP, index ));

            setHandleFromInt(frmP, PreferencesCommentLinesField, gCommentLines, true,false);

            FrmDrawForm(frmP);
            handled=true;
        }
        break;

        case ctlSelectEvent : {
            switch (eventP->data.ctlSelect.controlID) {
                case PreferencesHardKeyScrollingCheckbox:  // #846292 (S051) Use hard buttons to scroll
                    if (CtlGetValue(ctlHardKeysP) == 1){
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftLabel ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftPopTrigger ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightLabel ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightPopTrigger ));
                    } else {
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftLabel ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyLeftPopTrigger ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightLabel ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesHardKeyRightPopTrigger ));
                    }
                    break;
                case PreferencesColorModeCheckbox: {
                    if (CtlGetValue( ctlColorP )==1) {
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorLabel ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorPopTrigger ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorLabel ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorPopTrigger ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesLabel ));
                        FrmShowObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesField ));
                    } else {
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorLabel ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentColorPopTrigger ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorLabel ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesKeywordColorPopTrigger ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesLabel ));
                        FrmHideObject( frmP, FrmGetObjectIndex( frmP, PreferencesCommentLinesField ));
                   }
                break;
                }
                case PreferencesOKButton: {
                    UInt8 ModeSelection;
                    // Handle font selection
                    if( FrmGetControlGroupSelection( frmP, 200 ) == fontIndex ) {
                        gCurrentFont=(FontID)129;
                    } else {
                        gCurrentFont=(FontID)0;
                    }
                    // Handle HTML mode selection

                    ModeSelection = FrmGetControlGroupSelection( frmP, 201 );
                    if(ModeSelection==ASMModeIndex){
                        gHighlightMode = ASMMODE;
                    } else if(ModeSelection==HTMLModeIndex){
                        gHighlightMode = HTMLMODE;
                    } else if(ModeSelection==CModeIndex){
                        gHighlightMode = CMODE;
                    } else { // set default mode to be C
                        gHighlightMode = CMODE;
                    }
/*
                    // #846293 (S046) pick highlight mode based on file extension
                    if (oldMode != gHighlightMode){
                        gSetHighlightMode = true;
                        loadKeywords();
                    }
                    gSetHighlightMode = false;
*/
              /*                    if(CtlGetValue(ctlHtmlP)) {
                        gHTMLmode = true;
                    } else {
                        gHTMLmode = false;
            } */

                    // #846292 (S051) Use hard buttons to scroll
                    gUseHardKeysForScrolling = CtlGetValue(ctlHardKeysP);
                    switch (LstGetSelection(lstLeftKeyP)) {
                        case 0:
                            hardLeftKey = vchrHard1;
                            break;
                        case 2:
                            hardLeftKey = vchrHard3;
                            break;
                        case 1:
                        default:
                            hardLeftKey = vchrHard2;
                            break;
                    }
                    switch (LstGetSelection(lstRightKeyP)) {
                        case 0:
                            hardRightKey = vchrHard2;
                            break;
                        case 2:
                            hardRightKey = vchrHard4;
                            break;
                        case 1:
                        default:
                            hardRightKey = vchrHard3;
                            break;
                    }
                    if (hardLeftKey == hardRightKey){
                        error("Can't use the same hard Key for both left and right scrolling.");
                        return false;
                    }


                    // Handle color mode selection
                    if(CtlGetValue(ctlColorP)) {
                        gColorMode = true;
                    } else {
                        gColorMode = false;
                    }
                    // Handle comment color selection
                    switch (LstGetSelection( lstP )) {
                        case 0: {
                            // nd==0x0B means you're using a grayscale Palm, not color
                            if(nd==0x0B) {  // light gray
                                ictComments = 0x6;
                                ictCommentsSaved = 0x6;
                                ictText = 0xF;
                            } else {            //red
                                ictComments = 0x77;
                                ictCommentsSaved = 0x77;
                                ictText = 0xFF;
                            }
                            break;
                        }
                        case 1: {
                            if(nd==0x0B) {  //medium gray
                                ictComments = 0x9;
                                ictCommentsSaved = 0x9;
                                ictText = 0xF;
                            } else {            //green
                                ictComments = 0xD4;
                                ictCommentsSaved = 0xD4;
                                ictText = 0xFF;
                            }
                            break;
                        }
                        case 2: {
                            if(nd==0x0B) {   //dark gray
                                ictComments = 0xB;
                                ictCommentsSaved = 0xB;
                                ictText = 0xF;
                            } else {            //blue
                                ictComments = 0x5F;
                                ictCommentsSaved = 0x5F;
                                ictText = 0xFF;
                            }
                            break;
                        }
                    }
                    switch (LstGetSelection( lstKP )) {
                        case 1: {
                            // nd==0x0B means you're using a grayscale Palm, not color
                            if(nd==0x0B) {  // light gray
                                ictKeywords = 0x6;
                                ictKeywordsSaved = 0x6;
                            } else {            //red
                                ictKeywords = 0x77;
                                ictKeywordsSaved = 0x77;
                            }
                            break;
                        }
                        case 2: {
                            if(nd==0x0B) {  //medium gray
                                ictKeywords = 0x9;
                                ictKeywordsSaved = 0x9;
                            } else {            //green
                                ictKeywords = 0xD4;
                                ictKeywordsSaved = 0xD4;
                            }
                            break;
                        }
                        case 3: {
                            if(nd==0x0B) {   //dark gray
                                ictKeywords = 0xB;
                                ictKeywordsSaved = 0xB;
                            } else {            //blue
                                ictKeywords = 0x5F;
                                ictKeywordsSaved = 0x5F;
                            }
                            break;
                        case 0:
                            ictKeywordsSaved=255;       // To indicate no keyword coloring
                            ictKeywords=255;
                            break;
                        }
                    }
                    setIntFromHandle(frmP, PreferencesCommentLinesField, (char*)&gCommentLines, 0,false);
                    //we have to relaunch for the new preferences to take effect
                    AppLaunchWithCommand( (LocalID)'LedX', sysAppLaunchCmdNormalLaunch, NULL );
                    break;
                }
                case PreferencesCancelButton: {
                    FrmReturnToForm(0);
                    //FrmGotoForm( MainForm );
                    handled = true;
                    break;
                }
            break;
            }
        }
        default:
            break;
    }
    return handled;
}
/*
void FreeKeyboardTablMem(void){
    MemHandle h;
    if (gKbSup_KeyboardTable) {
        MemPtrFree(gKbSup_KeyboardTable);

        h = (Handle)MemPtrRecoverHandle(gKbSup_KeyboardTable);
        MemHandleUnlock(h);
        MemHandleFree(h);

        gKbSup_KeyboardTable = NULL;
    }
    switch(gKbSup_SupportedKeyboard){
        case KbSup_PalmPortableKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * PPK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_PPK_Table;
            break;
        case KbSup_PalmWirelessKeyboard:
        case KbSup_UltraThinKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * PWK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_PWK_Table;
            break;
        case KbSup_Treo600InternalKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * TR6_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_TR6_Table;
            break;
        case KbSup_SonyNxInternalKeyboard:
        case KbSup_SonyUxInternalKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * SNX_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_SNX_Table;
            break;
        case KbSup_AlphasmartDanaKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * ADK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_ADK_Table;
            break;
        case KbSup_BelkinWirelessKeyboard:
            h = (MemHandle)MemHandleNew(sizeof(KbSup_Type) * BWK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(h);
            gKbSup_KeyboardTable = KbSup_BWK_Table;
            break;
        case KbSup_NoKeyboard:
        default:
            if (gKbSup_KeyboardTable) {
                MemPtrFree(gKbSup_KeyboardTable);

                h = (MemHandle)MemPtrRecoverHandle(gKbSup_KeyboardTable);
                MemHandleUnlock(h);
                MemHandleFree(h);

            }
            gKbSup_KeyboardTable = NULL;
            break;
    }
}
*/

void AllocateTheKeyboardTable(void){
    if (gKbSup_KeyboardTableH)
        MemHandleUnlock(gKbSup_KeyboardTableH);
    else if (gKbSup_KeyboardTableH == NULL)
        gKbSup_KeyboardTableH = MemHandleNew(100);
    gKbSup_KeyboardTable = NULL;
    switch(gKbSup_SupportedKeyboard){
        case KbSup_PalmPortableKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * PPK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_PPK_Table;
            break;
        case KbSup_PalmWirelessKeyboard:
        case KbSup_UltraThinKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * PWK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_PWK_Table;
            break;

        case KbSup_ClieNR70InternalKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * C70_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_C70_Table;
            break;
        case KbSup_Treo90InternalKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * T90_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_T90_Table;
            break;
        case KbSup_Treo600InternalKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * TR6_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_TR6_Table;
            break;
        case KbSup_SonyNxInternalKeyboard:
        case KbSup_SonyUxInternalKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * SNX_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_SNX_Table;
            break;
        case KbSup_AlphasmartDanaKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * ADK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_ADK_Table;
            break;
        case KbSup_BelkinWirelessKeyboard:
            MemHandleResize(gKbSup_KeyboardTableH, sizeof(KbSup_Type) * BWK_KeysInTable);
            gKbSup_KeyboardTable = (KbSup_Type *)MemHandleLock(gKbSup_KeyboardTableH);
            gKbSup_KeyboardTable = KbSup_BWK_Table;
            break;
        case KbSup_NoKeyboard:
        default:
            gKbSup_KeyboardTableH = NULL;
            break;
    }
}

Boolean KeyboardSupportFormHandleEvent(EventPtr eventP)
{
    Boolean handled = false;
    FormPtr frmP = FrmGetActiveForm();
    int index = gKbSup_SupportedKeyboard;
    ControlPtr ctlP = (ControlPtr)getObjectPtr( frmP, KeyboardSupportListPopupTrigger );
    ListPtr lstP = (ListPtr)getObjectPtr(frmP, KeyboardSupportList);
    switch (eventP->eType) {
        case frmOpenEvent:
            LstSetSelection( lstP, index );
            LstMakeItemVisible(lstP, index);
            CtlSetLabel( ctlP, LstGetSelectionText( lstP, index ));
            FrmDrawForm(frmP);
            handled=true;
            break;
        case ctlSelectEvent :
            switch (eventP->data.ctlSelect.controlID) {
                case KeyboardSupportOKButton:
                        index = LstGetSelection(lstP);
                        if (index>=0)
                            gKbSup_SupportedKeyboard = (KbSup_SupportedKeyboardType)index;
                        else
                            gKbSup_SupportedKeyboard = KbSup_NoKeyboard;
                        AllocateTheKeyboardTable();
                        FrmReturnToForm(0);
                        handled = true;
                        break;
                case KeyboardSupportCancelButton:
                        FrmReturnToForm(0);
                        handled = true;
                        break;
            }
            break;
        default:
            break;
        }
    return handled;
}

void resizeMainForm (FormPtr frmP)
{
    RectangleType bounds;
    UInt16 objectIndex;
    WinHandle winH;

    winH = FrmGetWindowHandle(frmP);
    WinSetBounds (winH, &gFullScreen);
    // Move the scrollbar 400 pixels to the right.
    objectIndex = FrmGetObjectIndex (frmP, MainDocumentScrollBar);
    FrmGetObjectBounds (frmP, objectIndex, &bounds);
    bounds.topLeft.x += 400;
    FrmSetObjectBounds (frmP, objectIndex, &bounds);
}

void scrollUp(SelectionRange *currentSelection)
{
    if (screenTopLine >0){ // To avoid scrolling beyond top
        char *saveCP = bufferedLineContents[LinesPerPage - 1].text;
        // shift the buffer down, (so start at the top to avoid overwriting)
        for (int i = (LinesPerPage - 1) - 1; i >= 0; i--) {
            bufferedLineContents[i + 1] = bufferedLineContents[i];
        }
        bufferedLineContents[0].text = saveCP;

        eraseBlinkingCursor();

        WinHandle onscreen = WinSetDrawWindow(gOffscreenPage);
        RectangleType offR = { {0, 0}, {DocumentWidth, PageHeight} };
        RectangleType fillRect;
        WinScrollRectangle(&offR, winDown, FontHeight, &fillRect);
        WinSetDrawWindow(onscreen);

        screenTopLine--;
        screenYOrigin -= FontHeight;

        getLineIntoBuffer(screenTopLine);
        drawLine(screenTopLine, false);

        if (currentSelection != NULL) invertSelectionOnPage(currentSelection, true);

        RectangleType r = { {screenXOrigin, 0}, {PageWidth, PageHeight} };
        WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin, scrCopy);
        // gBlinkDrawn = 0;

        if (currentSelection != NULL) invertSelectionOnPage(currentSelection, true);
    }

    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage /*+1*/ : 0;
    SclSetScrollBar(bar, ((screenTopLine) > 0 ? screenTopLine : 0), 0, sclMax, LinesPerPage);
}

void scrollDown(SelectionRange *currentSelection)
{
    if (screenTopLine< gMaxLines -1){ // To avoid scrolling beyond end
        char *saveCP = bufferedLineContents[0].text;
        for (int i = 1; i < LinesPerPage; i++) {
            bufferedLineContents[i - 1] = bufferedLineContents[i];
        }
        bufferedLineContents[LinesPerPage - 1].text = saveCP;

        eraseBlinkingCursor();

        WinHandle onscreen = WinSetDrawWindow(gOffscreenPage);
        RectangleType offR = { {0, 0}, {DocumentWidth, PageHeight} };
        RectangleType fillRect;
        WinScrollRectangle(&offR, winUp, FontHeight, &fillRect);
        WinSetDrawWindow(onscreen);

        screenTopLine++;
        screenYOrigin += FontHeight;

        getLineIntoBuffer(screenTopLine + LinesPerPage - 1);
        drawLine(screenTopLine + LinesPerPage - 1, false);

        if (currentSelection != NULL) invertSelectionOnPage(currentSelection, true);

        RectangleType r = { {screenXOrigin, 0}, {PageWidth, PageHeight} };
        WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin, scrCopy);
        // gBlinkDrawn = 0;

        if (currentSelection != NULL) invertSelectionOnPage(currentSelection, true);
    }

    FormPtr frmP = FrmGetActiveForm();
    ScrollBarPtr bar = (ScrollBarPtr)getObjectPtr(frmP, MainDocumentScrollBar);
    int sclMax = (gMaxLines > LinesPerPage) ? gMaxLines - LinesPerPage /*+ 1*/ : 0;
    SclSetScrollBar(bar, (screenTopLine /*+ 1*/), 0, sclMax, LinesPerPage);

}

void scrollLeft(SelectionRange *currentSelection, Word offset)
{
    if (currentSelection != NULL)
        invertSelectionOnPage(currentSelection, true);

    if (screenXOrigin < offset) {
        screenXOrigin = 0;
    }
    else {
        screenXOrigin -= offset;
    }

    RectangleType r = { {screenXOrigin, screenYOrigin - (screenTopLine * FontHeight)},
                        {PageWidth, PageHeight } };
    WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin, scrCopy);

    checkScreenXState(); // #895637 grey out Left/Right arrows

    //gBlinkDrawn = 0;
    eraseBlinkingCursor();

    if (currentSelection != NULL)
        invertSelectionOnPage(currentSelection, true);

}

Boolean scrollList(FormPtr frmP, ListPtr lst, char c, char **listContents, int count)
{
    Boolean result = false;
    // new code 05/29/2002, 06/01/2002
//  int listSize = lst->bounds.extent.y / FntLineHeight();  <-- use LstGetVisibleItems(lst) instead
    switch (c) {
        case pageDownChr :
/*            newTop = LstGetTopItem(lst) + LstGetVisibleItems(lst); //page down a full page
        //  newTop = lst->topItem + listSize;
            if (newTop >= LstGetNumberOfItems(lst)) {
                newTop = LstGetNumberOfItems(lst) - LstGetVisibleItems(lst);
            }
        //  if (newTop >= lst->numItems) newTop = lst->numItems - listSize;
            if (newTop <0) {
                newTop = -1;  // handle case where number of items is < listSize -- 06/01/2002
            }*/
            LstScrollList(lst,winDown,LstGetVisibleItems(lst));
            result = true;
            break;
        case pageUpChr :
/*            newTop = LstGetTopItem(lst) - LstGetVisibleItems(lst);
        //  newTop = lst->topItem - listSize;
            if (newTop < 0) {
                newTop = 0;
            }*/
            LstScrollList(lst,winUp,LstGetVisibleItems(lst));
            result = true;
            break;
        default : {
                char cc = c;
                int i;
                if ((c >= 'a') && (c <= 'z')) {
                    cc = c - ('a' - 'A');
                }
                if(LstGetSelection(lst)!=-1 && LstGetSelectionText(lst,LstGetSelection(lst))[0]!=c && LstGetSelectionText(lst,LstGetSelection(lst))[0]!=cc) {
r:                  for (i = 0; i < count; i++) {
                        char x = listContents[i][0];
                        if ((x == c) || (x == cc)) {
                            if(LstGetSelection(lst)!=i)
                                LstMakeItemVisible(lst,i);
                                LstSetSelection(lst, i);
                                LstEraseList(lst);
                                LstDrawList(lst);
                                result = true;
                                break;
                            }
                    }
                } else {
                    for (i = LstGetSelection(lst)+1; i < count; i++) {
                        char x = listContents[i][0];
                        if ((x == c) || (x == cc)) {
                            LstMakeItemVisible(lst,i);
                            LstSetSelection(lst, i);
                            LstEraseList(lst);
                            LstDrawList(lst);
                            result = true;
                            break;
                        }
                    }
                    if(!result)
                        goto r;
                }
            }
            break;
    }
    /*if (newTop != -1) {
        LstSetTopItem(lst, newTop);
        LstEraseList(lst);
        LstDrawList(lst);
    }*/
    return result;
}

void scrollRight(SelectionRange *currentSelection, int offset)
{
    if (currentSelection != NULL)
        invertSelectionOnPage(currentSelection, true);

    if ((screenXOrigin + offset) >= (UInt16)(DocumentWidth - PageWidth)) {
        screenXOrigin = (DocumentWidth - PageWidth);

        while(screenXOrigin%10)
            screenXOrigin--;        // WinCopyRectangle is significantly faster when blitting
    }                               // on an X multiple of 10... Don't ask why I don't know !
    else {
        screenXOrigin += offset;
    }



    RectangleType r = { {screenXOrigin, screenYOrigin - (screenTopLine * FontHeight)},
                        {PageWidth, PageHeight} };
    WinCopyRectangle(gOffscreenPage, 0, &r, PageXOrigin, PageYOrigin, scrCopy);

    checkScreenXState();  // #895637 grey out Left/Right arrows

    // gBlinkDrawn = 0;
    eraseBlinkingCursor();
    if (currentSelection != NULL)
        invertSelectionOnPage(currentSelection, true);
}

void scrollScreen(UInt8 screenScrollDirection)
{
    switch (screenScrollDirection) {
        case screenScrollDirectionRight :
            // if ((screenXOrigin + PageWidth) < DocumentWidth) {
            if (screenXOrigin < (UInt16)((DocumentWidth - PageWidth) - 5)){
                if (hasSelection() && !isEmptySelection()) {
                    scrollRight(&gCurrentSelection, 5);
                }
                else {
                    scrollRight(NULL, 5);
                }
            }
            break;
        case screenScrollDirectionLeft :
            if (screenXOrigin > 0) {
                if (hasSelection() && !isEmptySelection()) {
                    scrollLeft(&gCurrentSelection, 5);
                }
                else {
                    scrollLeft(NULL, 5);
                }
            }
            break;
    }
}

static Boolean setFileInfo(void)
{
    /*
    *  S055 File Info and Attrubiutes - Set
    *  Since SrcEdit 2.3 does NOT support compression on decompression
    *  there is no checkbox for compression.
    */

  FormPtr frmP = FrmGetActiveForm();
  ControlPtr ctlBackupP = (ControlPtr)getObjectPtr(frmP, FileInfoBackupCheckbox);
  ControlPtr ctlBeamPrvntP = (ControlPtr)getObjectPtr(frmP, FileInfoBeamPrvntCheckbox);
  ControlPtr ctlReadOnlyP = (ControlPtr)getObjectPtr(frmP, FileInfoReadOnlyCheckbox);
  ListPtr lstCategoriesP = (ListPtr)getObjectPtr(frmP, FileInfoCategoryNumberList);

    // Find Database
  UInt16 cardNo;
    LocalID dbID = 0;
    for (cardNo = 0; cardNo<0xffff; cardNo++){
      dbID = DmFindDatabase(cardNo, gCurrentFile);
        if (dbID !=0)
      break;
  }
    if (dbID == 0)
    return false;       // File Not found!

  if (MemLocalIDKind( dbID ) != memIDHandle){
        error("This file resides on ROM. NO changes can be made.");
    return false;
  }

  // The Attributes
  UInt16 attributes;
    if(DmDatabaseInfo (cardNo, dbID, NULL, &attributes, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL))
    return false;  // dmErrInvalidParam

    // The Attributes - Backup
    if(CtlGetValue(ctlBackupP))
        if ((attributes & dmHdrAttrBackup) == false)
        attributes |= dmHdrAttrBackup;
    else
        if (attributes & dmHdrAttrBackup)
            attributes &= dmHdrAttrBackup;

    // The Attributes - Beam Prvnt
    if (CtlGetValue(ctlBeamPrvntP))
    if ((attributes & dmHdrAttrCopyPrevention) == false)
        attributes |= dmHdrAttrCopyPrevention;
    else
    if (attributes & dmHdrAttrCopyPrevention)
      attributes &= dmHdrAttrCopyPrevention;

    // Attributes - ReadOnly
    Boolean setReadOnlyBit = false;
    if (CtlGetValue(ctlReadOnlyP))
        if ((attributes & dmHdrAttrReadOnly)== false){
            attributes |= dmHdrAttrReadOnly;
            setReadOnlyBit = true;
            }
  else
    if (attributes & dmHdrAttrReadOnly)
          attributes &= dmHdrAttrReadOnly;

    // Set the Attributes
    if (setReadOnlyBit == false)
          DmSetDatabaseInfo (cardNo, dbID, NULL, &attributes, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

    // Category
    UInt16 category = LstGetSelection(lstCategoriesP);
    if ((Int16)category == -1)
        return false;   // No Selection

    // Get Record #0 attributes
    UInt16 recAttr = NULL;
    DmOpenRef tempOpenRef;
    tempOpenRef = DmOpenDatabase(cardNo, dbID, dmModeReadWrite);
    if (tempOpenRef){
      if(DmRecordInfo(tempOpenRef, 0, &recAttr, NULL, NULL))
      return false;  // Coudn't find record #0
    }
    if (tempOpenRef == 0) {
        Err err;
        err = DmGetLastErr();
        if (err){
          if(err == dmErrROMBased){
            error("This File resides in ROM! No changes can be made.");
            return false;
         }
        if(err == dmErrReadOnly)
            error("This file is 'Read Only'! No Changes can be made.");
        return false;
        }
    }

    if (category != (recAttr & dmRecAttrCategoryMask)){
        category &= dmRecAttrCategoryMask;
        recAttr = recAttr>>8;
        recAttr = recAttr<<8;
        recAttr |= category;

        // Set Record #0 attributes
        Err err;
        err = DmSetRecordInfo (tempOpenRef, 0, &recAttr, NULL);

        if (err){
            DmCloseDatabase(tempOpenRef);
            return false;  // Could NOT set the Category
        }
    }
    if (DmCloseDatabase(tempOpenRef))
        return false;  // Coudn't close Database

    // Set the Attributes
    if (setReadOnlyBit)
        DmSetDatabaseInfo (cardNo, dbID, NULL, &attributes, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
    return true;
}

void setHardKeysScrollingValues(UInt8 compressedValue)
{
    // #846292 (S051) Use hard buttons to scroll
    hardLeftKey = 0;
    hardRightKey = 0;
    gUseHardKeysForScrolling = compressedValue & 0x01;
    // vchrHard1 = 0x10;
    // vchrHard2 = 0x20;
    // vchrHard3 = 0x40;
    // vchrHard4 = 0x80;
    if (compressedValue & 0x10)
        hardLeftKey = vchrHard1;

    if ((compressedValue & 0x20) && (hardLeftKey != 0))
        hardRightKey = vchrHard2;
    else if ((compressedValue & 0x20) && hardLeftKey == 0)
        hardLeftKey = vchrHard2;

    if ((compressedValue & 0x40) && (hardLeftKey != 0))
        hardRightKey = vchrHard3;
    else if ((compressedValue & 0x40) && hardLeftKey == 0)
        hardLeftKey = vchrHard3;

    if (compressedValue & 0x80)
        hardRightKey = vchrHard4;
    // Check the values
    if (hardLeftKey && hardRightKey)
        return;
    // if something is wrong: set to default vaules
    hardLeftKey = vchrHard2;
    hardRightKey = vchrHard3;
}

void setHighlightMode(char* dbName)
{
    // #846293(S046) pick highlight mode based on file extension
    if (gSetHighlightMode == false){
        return;
        }
    UInt8 oldMode = gHighlightMode;
    UInt8 len = StrLen(dbName);
    if (len>3){
        if (StrCaselessCompare(".asm", &dbName[len -4]) == 0 ||
        StrCaselessCompare(".inc", &dbName[len -4])== 0)
          gHighlightMode = ASMMODE;  // .asm, .inc, .ASM, .INC
        else if (StrCaselessCompare(".html", &dbName[len -5])== 0 ||
        StrCaselessCompare(".htm", &dbName[len -4])== 0)
          gHighlightMode = HTMLMODE; // .html, .htm, .HTML, .HTM
        else
          gHighlightMode = CMODE;  // .c, .h, .cpp
    }
    else {
        gHighlightMode = CMODE;
    }
    if (gHighlightMode != oldMode)
        loadKeywords();
    gSetHighlightMode = false;
}

static void showCurrentLine(void)
{
    /* S041 Show and Goto Line: This functione does the following:
    *
    * Get the current line number to the Field
    * Focusing that feild
    *
    */

    FormPtr frmP = FrmGetActiveForm();
    UInt16 objIndex = FrmGetObjectIndex(frmP, GotoLineField);

    // set the field to current Line
    setHandleFromInt(frmP, GotoLineField, (gCurrentSelection.startLine+1), true, false);

    // Give the gotoLineField the Focus
    FrmSetFocus(frmP, objIndex);
}
/*
static void useWholeScreen(void){

    RectangleType	winRect;
	// FrmGetFormBounds(frmP, &originalFormRect)
		// INCREASE THE SIZE OF THE FORM TO MATCH SCREEN SIZE
	winRect.topLeft.x = 0;
	winRect.topLeft.y = 0;
		// get the current screen size
	WinGetDisplayExtent(&winRect.extent.x, &winRect.extent.y);

		// change the size of the form to match the screen size
	WinSetWindowBounds(FrmGetWindowHandle(frmP), &winRect);

    // FrmGetFormBounds(frmP, &resizedFormRect);
}
*/
