/* **********************************************************************
 *
 *   LED/SrcEdit is free software as specified in the GNU General public License
 *   listed in the file COPYING or http://www.gnu.org/licenses/gpl.txt
 *
 ********************************************************************** */
// SrcEditKeyboardSupport.c

/*  #846728 (S016) External Keyboard Support: 15 April 2004, John Wilund */

/*
    As there are a great number (still growing) of external and internal keyboards this is a quest without an end.
    A good thing, as is seams, is that many keyboard uses the same keyboard driver. this makes things a bit more
    comprehensive, and not so massive a task as it first looked like.

    Though I'm not 100% on this the resaerch tells that the same driver produces the same data.

    The driver for the:             Also support the following keyboards:
    -----------------------------------------------------------------
    Palm Portable Keyboard(*)

    Palm Wireless Keyboard(*)       Ultra-Thin Keyboard(*)
                                    Palm Mini Keyboard(!)

    Stowaway Portable Keyboard(!)   Stowaway Wireless Keyboard(!)
                                    Stowaway XT(!)

    Pocket Keyboard(!)

    Type 'N Go Keyboard(!)

    GoType! Keyboard(!)

    Belkin Wireless Keyboard (*)

    SonyNX Internal Keyboard(*)     SonyUX Internal Keyboard(*)

    Sony Cli PEG-NR70 Internal Keyboard(*)

    Treo90 Internal Keyboard(*)

    Treo600 Internal Keyboard(*)

    Alphasmart Dana Internal Keyboard(*)

    * = tested. != Not tested. o = tested only on Emulator/Simulator

*/

#ifndef __OBC__
    #include <PalmOS.h>
    #include <PalmCompatibility.h>
#endif

#include "LedGlobals.h"

//****************************************************************************************

#define PPK_KeysInTable 30
// #define isPalmPortableKeyboard (KeyCurrentState() == 0x00000100)

KbSup_Type KbSup_PPK_Table[PPK_KeysInTable]={
    // Palm Portable Keyboard
    {0x001e, 0x0000, 0x0000, KbSup_Up},            // PPK Up
    {0x001f, 0x0000, 0x0000, KbSup_Down},          // PPK Down
    {0x001c, 0x0000, 0x0000, KbSup_Left},          // PPK Left
    {0x001d, 0x0000, 0x0000, KbSup_Right},         // PPK Right
    {0x001e, 0x0000, 0x0001, KbSup_ShiftUp},       // PPK Shift Up
    {0x001f, 0x0000, 0x0001, KbSup_ShiftDown},     // PPK Shift Down
    {0x001c, 0x0000, 0x0001, KbSup_ShiftLeft},     // PPK Shift Left
    {0x001d, 0x0000, 0x0001, KbSup_ShiftRight},    // PPK Shift Right
    {0x000b, 0x0000, 0x0028, KbSup_CtrlUp},        // PPK Ctrl Up
    {0x000c, 0x0000, 0x0028, KbSup_CtrlDown},      // PPK Ctrl Down
    {0x001c, 0x0000, 0x0020, KbSup_CtrlLeft},      // PPK Ctrl Left
    {0x001d, 0x0000, 0x0020, KbSup_CtrlRight},     // PPK Ctrl  Right
    {0x000b, 0x0000, 0x8008, KbSup_CmdUp},         // PPK Cmd Up (driver 1.5 w. m505)
    {0x000c, 0x0000, 0x8008, KbSup_CmdDown},       // PPK Cmd Down (driver 1.5 w. m505)
    {0x000b, 0x0101, 0x0008, KbSup_CmdUp},         // PPK Cmd Up (driver 1.92P w. Tungsten |T)
    {0x000c, 0x0202, 0x0008, KbSup_CmdDown},       // PPK Cmd Down (driver 1.92P w. Tungsten |T)
    {0x0503, 0x0404, 0x0008, KbSup_CmdLeft},       // PPK Cmd Left (driver 1.92P w. Tungsten |T)
    {0x0503, 0x0808, 0x0008, KbSup_CmdRight},      // PPK Cmd Right (driver 1.92P w. Tungsten |T)
    {0x1700, 0x0000, 0x8008, KbSup_CmdUp},         // PPK Cmd Up (i705) KeyCurrentState() == 0x00000100
    {0x1701, 0x0000, 0x8008, KbSup_CmdDown},       // PPK Cmd Down (i705) KeyCurrentState() == 0x00000100
    {0x001c, 0x0000, 0x8008, KbSup_CmdLeft},       // PPK Cmd Left (i705)
    {0x001d, 0x0000, 0x8008, KbSup_CmdRight},      // PPK Cmd Right (i705)
    {0x000b, 0x0000, 0x0018, KbSup_PageUp},        // PPK Fn Up
    {0x000c, 0x0000, 0x0018, KbSup_PageDown},      // PPK Fn Down
    {0x007f, 0x0000, 0x0000, KbSup_Del},           // PPK Del
    {0x007f, 0x0000, 0x0002, KbSup_Del},           // PPK CapsLock Del
    {0x0103, 0x0000, 0x0008, KbSup_Tab},           // PPK Tab
    {0x010C, 0x0000, 0x0009, KbSup_ShiftTab},      // PPK Shift Tab
    {0x0009, 0x0000, 0x0001, KbSup_ShiftTab},      // PPK Shift Tab (driver 1.92P w. Tungsten |T: 'Insert Tab')
    {0x0000, 0x0000, 0x0000, KbSup_None}
 };

#define PWK_KeysInTable 38

KbSup_Type KbSup_PWK_Table[PWK_KeysInTable]={
     // Palm Wireless Keyboard
     // Ultra Thin Keyboard
    {0x001e, 0x0000, 0x0000, KbSup_Up},            // PWK Up / Alt Up
    {0x001f, 0x0000, 0x0000, KbSup_Down},          // PWK Down / Alt Down
    {0x001c, 0x0000, 0x0000, KbSup_Left},          // PWK Left / Alt Left
    {0x001d, 0x0000, 0x0000, KbSup_Right},         // PWK Right / Alt Right
//    {0x003f, 0x0000, 0x0001, KbSup_None},          // PWK "?" (Produced with Shift Up)
    {0x001e, 0x0000, 0x0011, KbSup_ShiftUp},       // PWK BlueFn Up
    {0x001f, 0x0000, 0x0011, KbSup_ShiftDown},     // PWK BlueFn Down
    {0x001c, 0x0000, 0x0011, KbSup_ShiftLeft},     // PWK BlueFn Left
    {0x001d, 0x0000, 0x0011, KbSup_ShiftRight},    // PWK BlueFn Right
    {0x000b, 0x0000, 0x0028, KbSup_CtrlUp},        // PWK Ctrl Up
    {0x000c, 0x0000, 0x0028, KbSup_CtrlDown},      // PWK Ctrl Down
    {0x001c, 0x0000, 0x0020, KbSup_CtrlLeft},      // PWK Ctrl Left
    {0x001d, 0x0000, 0x0020, KbSup_CtrlRight},     // PWK Ctrl Right
    {0x000b, 0x0000, 0x8008, KbSup_CmdUp},         // PWK Cmd Up
    {0x000c, 0x0000, 0x8008, KbSup_CmdDown},       // PWK Cmd Down
    {0x001c, 0x0000, 0x8008, KbSup_CmdLeft},       // PWK Cmd Left
    {0x001d, 0x0000, 0x8008, KbSup_CmdRight},      // PWK Cmd Right

    // These UTK key data are exactly the same codes as the Tungsten |T generates with 5way-nav,
    // but for the keyState which is all 0x00000000L here
    {0x000b, 0x0101, 0x0008, KbSup_CmdUp},          // UTK Cmd Up
    {0x000c, 0x0202, 0x0008, KbSup_CmdDown},        // UTK Cmd Down
    {0x0503, 0x0404, 0x0008, KbSup_PageLeft},       // UTK Cmd Left      // 'PageLeft'
    {0x0503, 0x0808, 0x0008, KbSup_PageRight},      // UTK Cmd Right     // 'PageRight'

    {0x000b, 0x0000, 0x4008, KbSup_PageUp},         // PWK GreenFn Up    // PageUp
    {0x000c, 0x0000, 0x4008, KbSup_PageDown},       // PWK GreenFn Down  // PageDown
    {0x0002, 0x0000, 0x4000, KbSup_CmdLeft},        // PWK GreenFn Left  // 'Home'
    {0x0003, 0x0000, 0x4000, KbSup_CmdRight},       // PWK GreenFn Right // 'End'

    {0x000b, 0x0000, 0x4009, KbSup_ShiftCmdUp},     // UTK Shift GreenFn Up
    {0x000c, 0x0000, 0x4009, KbSup_ShiftCmdDown},   // UTK Shift GreenFn Down
    {0x0002, 0x0000, 0x4001, KbSup_ShiftCmdLeft},   // UTK Shift GreenFn Left
    {0x0003, 0x0000, 0x4001, KbSup_ShiftCmdRight},  // UTK Shift GreenFn Right
    {0x001e, 0x0000, 0x0021, KbSup_ShiftCtrlUp},    // UTK Shift Ctrl Up
    {0x001f, 0x0000, 0x0021, KbSup_ShiftCtrlDown},  // UTK Shift Ctrl Down
    {0x001c, 0x0000, 0x0021, KbSup_ShiftCtrlLeft},  // UTK Shift Ctrl Left
    {0x001d, 0x0000, 0x0021, KbSup_ShiftCtrlRight}, // UTK Shift Ctrl Right
    {0x007f, 0x0000, 0x0000, KbSup_Del},            // PWK Del
    {0x007f, 0x0000, 0x0002, KbSup_Del},            // PWK CapsLock Del
    {0x0103, 0x0000, 0x0008, KbSup_Tab},            // PWK Tab
    {0x010C, 0x0000, 0x0009, KbSup_ShiftTab},       // PWK Shift Tab
/*
    {0x0009, 0x0000, 0x0000, KbSup_Tab},            // UTK Tab
*/
    {0x0009, 0x0000, 0x0001, KbSup_ShiftTab},       // UTK Shift Tab
    {0x0000, 0x0000, 0x0000, KbSup_None}
 };

#define BWK_KeysInTable 8

KbSup_Type KbSup_BWK_Table[BWK_KeysInTable]={
     // Belkin Wireless Keyboard
    {0x001e, 0x001e, 0x0000, KbSup_Up},            // BWK Up
    {0x001f, 0x001f, 0x0000, KbSup_Down},          // BWK Down
    {0x001c, 0x001c, 0x0000, KbSup_Left},          // BWK Left
    {0x001d, 0x001d, 0x0000, KbSup_Right},         // BWK Right
    {0x000b, 0x0000, 0x0008, KbSup_PageUp},        // BWK Fn Up     // 'PageUp'
    {0x000c, 0x0000, 0x0008, KbSup_PageDown},      // BWK Fn Down   // 'PageDown'
    {0x0004, 0x0000, 0x0000, KbSup_Del},           // BWK Del
    {0x0000, 0x0000, 0x0000, KbSup_None}
};

#define C70_KeysInTable 9

KbSup_Type KbSup_C70_Table[C70_KeysInTable] ={
	{0x001E, 0x0000, 0x0000, KbSup_Up},         // C70 UpArrow
	{0x001F, 0x0000, 0x0000, KbSup_Down},       // C70 DownArrow
	{0x001C, 0x0000, 0x0000, KbSup_Left},	    // C70 LeftArrow
	{0x001D, 0x0000, 0x0000, KbSup_Right},      // C70 RightArrow
/*
    Since the NR70 has Jog-Dial and these data maches the Jog-Dial data
    We let the HandleJogDial() deal with them ...
	{0x1700, 0x0000, 0x0008, KbSup_PageUp},	    // C70 Ctrl Up KeyCurrentState() = 0x00000000
	{0x1701, 0x0000, 0x0008, KbSup_PageDown},   // C70 Ctrl Down KeyCurrentState() == 0x00000000
*/
	{0x000B, 0x0000, 0x0008, KbSup_CmdUp},	    // C70 Fn Up
	{0x000C, 0x0000, 0x0008, KbSup_CmdDown},	// C70 Fn Down

	// {0x0009, 0x0000, 0x0000, KbSup_Tab},	    // C70 Tab
	{0x0103, 0x0000, 0x0008, KbSup_ShiftTab},   // C70 Ctrl Tab

	// {0x0008, 0x0000, 0x0000, KbSup_BS},	    // C70 Backspace
	{0x007F, 0x0000, 0x0000, KbSup_None},       // C70 Del  The NR70 produces 3 events for this key:
	                                            // Right, Backspace and Delete so this is the solution
	                                            // recognize the chrDel making sure SrcEdit doesn't try
	                                            // insert a 0x7F char...
    {0x0000, 0x0000, 0x0000, KbSup_None}
};


#define SNX_KeysInTable 23
// #define isSonyInternalKeyboard chr == 0x1720

KbSup_Type KbSup_SNX_Table[SNX_KeysInTable]={
     // SonyNX Internal Keyboard
     // SonyUX Interna Keyboard
     // Since this is all vchrSonyKeyPuch we have to make sure these keys are tested before FrmHandleEvent.
    {0x1720, 0x001e, 0x0008, KbSup_Up},            // SNX Up
    {0x1720, 0x001f, 0x0008, KbSup_Down},          // SNX Down
    {0x1720, 0x001c, 0x0008, KbSup_Left},          // SNX Left
    {0x1720, 0x001d, 0x0008, KbSup_Right},         // SNX Right
    {0x1720, 0x841e, 0x0008, KbSup_ShiftUp},       // SNX Shift Up
    {0x1720, 0x841f, 0x0008, KbSup_ShiftDown},     // SNX Shift Down
    {0x1720, 0x841c, 0x0008, KbSup_ShiftLeft},     // SNX Shift Left
    {0x1720, 0x841d, 0x0008, KbSup_ShiftRight},    // SNX Shift Right
    {0x1720, 0xa01e, 0x0008, KbSup_CtrlUp},        // SNX Ctrl Up
    {0x1720, 0xa01f, 0x0008, KbSup_CtrlDown},      // SNX Ctrl Down
    {0x1720, 0xa01c, 0x0008, KbSup_CtrlLeft},      // SNX Ctrl Left
    {0x1720, 0xa01d, 0x0008, KbSup_CtrlRight},     // SNX Ctrl Right
    {0x1720, 0x901e, 0x0008, KbSup_PageUp},        // SNX Fn Up
    {0x1720, 0x901f, 0x0008, KbSup_PageDown},      // SNX Fn Down
    {0x1720, 0x901c, 0x0008, KbSup_CmdLeft},       // SNX Fn Left
    {0x1720, 0x901d, 0x0008, KbSup_CmdRight},      // SNX Fn Right
    {0x1720, 0xc01e, 0x0008, KbSup_CmdUp},         // SNX Alt Up
    {0x1720, 0xc01f, 0x0008, KbSup_CmdDown},       // SNX Alt Down
    {0x1720, 0xc01c, 0x0008, KbSup_CmdLeft},       // SNX Alt Left
    {0x1720, 0xc01d, 0x0008, KbSup_CmdRight},      // SNX Alt Right
    {0x1720, 0x9008, 0x0008, KbSup_Del},           // SNX Del
//    {0x1720, 0x0009, 0x0008, KbSup_Tab},           // SNX Tab
//  leaving: 0x0009 0x0000 0x0000 0x00000000 to the HandleKeyDown.
    {0x1720, 0x8409, 0x0008, KbSup_ShiftTab},      // SNX Shift Tab
    {0x0000, 0x0000, 0x0000, KbSup_None}
};

#define T90_KeysInTable 9

KbSup_Type KbSup_T90_Table[T90_KeysInTable]={
    {0x000b, 0x0000, 0x0008, KbSup_Up},	           // TR90 Up  (KeyState = 0x00000002)
	{0x000c, 0x0000, 0x0008, KbSup_Down},	       // TR90 Down (KeyState = 0x00000004)
	// We need to catch these two kb_events (above) before PageUp/Down is checked
	// mainly because these match exactly the default up/down hardware button key Signatures
	{0x160e, 0x0000, 0x0009, KbSup_ShiftUp},	   // TR90 shift up (KeyState = 0x00000002)
	{0x160f, 0x0000, 0x0009, KbSup_ShiftDown},     // TR90 shift down (KeyState = 0x00000004)
	{0x001c, 0x0000, 0x0010, KbSup_PageUp},        // TR90 Blue up (KeyState = 0x00000002)
	{0x001d, 0x0000, 0x0010, KbSup_PageDown},      // TR90 Blue down (KeyState = 0x00000004)
//	{0x0008, 0x0000, 0x0000}	                   // TR90 Backspace
	{0x161a, 0x0000, 0x0009, KbSup_Del},           // TR90 Shift Backspace
	{0x0008, 0x0000, 0x0010, KbSup_Del},	       // TR90 Blue Backspace
	{0x0000, 0x0000, 0x0000, KbSup_None}
};

#define TR6_KeysInTable 18
// #define isTreo600Keyboard

KbSup_Type KbSup_TR6_Table[TR6_KeysInTable]={
    // TREO600 Internal Keyboard
    {0x000b, 0x000b, 0x0808, KbSup_Up},            // TR6 Up (5way-nav)
    {0x000c, 0x000c, 0x0808, KbSup_Down},          // TR6 Down (5way-nav)
    {0x0134, 0x0134, 0x0808, KbSup_Left},          // TR6 Left (5way-nav)
    {0x0135, 0x0135, 0x0808, KbSup_Right},         // TR6 Right (5way-nav)
    {0x0136, 0x0136, 0x0808, KbSup_Tab},           // TR6 Center (5way-nav)         The Treo600 has No Tab
    {0x000b, 0x000b, 0x0809, KbSup_ShiftUp},       // TR6 Shift Up (5way-nav)
    {0x000c, 0x000c, 0x0809, KbSup_ShiftDown},     // TR6 Shift Down (5way-nav)
    {0x0134, 0x0134, 0x0809, KbSup_ShiftLeft},     // TR6 Shift Left (5way-nav)
    {0x0135, 0x0135, 0x0809, KbSup_ShiftRight},    // TR6 Shift Right (5way-nav)
    {0x0136, 0x0136, 0x0809, KbSup_ShiftTab},      // TR6 Shift Center (5way-nav)   The Treo600 has No Tab
    {0x000b, 0x000b, 0x0818, KbSup_PageUp},        // TR6 Silver Up (5way-nav)
    {0x000c, 0x000c, 0x0818, KbSup_PageDown},      // TR6 Silver Down (5way-nav)
    {0x0134, 0x0134, 0x0818, KbSup_CtrlLeft},      // TR6 Silver Left (5way-nav)
    {0x0135, 0x0135, 0x0818, KbSup_CtrlRight},     // TR6 Silver Right (5way-nav)
    {0x0008, 0x0008, 0x0810, KbSup_Del},           // TR6 Silver Backspace        The Treo600 has No Del
//    {0x0136, 0x0136, 0x0808, KbSup_None},          // TR6 Silver Center
    {0x0008, 0x0008, 0x0801, KbSup_Del},            // TR6 Shift Backspace          The Treo600 has No Del
    {0x0009, 0x0020, 0x0801, KbSup_ShiftTab},       // TR6 Shift Tab
    {0x0000, 0x0000, 0x0000, KbSup_None}
};

#define ADK_KeysInTable 25

KbSup_Type KbSup_ADK_Table[ADK_KeysInTable]={
    // Palm Portable Keyboard
    {0x001e, 0x0000, 0x0000, KbSup_Up},            // ADK Up
    {0x001f, 0x0000, 0x0000, KbSup_Down},          // ADK Down
    {0x001c, 0x0000, 0x0000, KbSup_Left},          // ADK Left
    {0x001d, 0x0000, 0x0000, KbSup_Right},         // ADK Right
    {0x001e, 0x0000, 0x0001, KbSup_ShiftUp},       // ADK Shift Up
    {0x001f, 0x0000, 0x0001, KbSup_ShiftDown},     // ADK Shift Down
    {0x001c, 0x0000, 0x0001, KbSup_ShiftLeft},     // ADK Shift Left
    {0x001d, 0x0000, 0x0001, KbSup_ShiftRight},    // ADK Shift Right
    {0x001e, 0x0000, 0x0020, KbSup_CtrlUp},        // ADK Ctrl Up
    {0x001f, 0x0000, 0x0020, KbSup_CtrlDown},      // ADK Ctrl Down
    {0x001c, 0x0000, 0x0020, KbSup_CtrlLeft},      // ADK Ctrl Left
    {0x001d, 0x0000, 0x0020, KbSup_CtrlRight},     // ADK Ctrl  Right
    {0x001e, 0x0000, 0x0008, KbSup_CmdUp},         // ADK Cmd Up
    {0x001f, 0x0000, 0x0008, KbSup_CmdDown},       // ADK Cmd Down
    {0x001c, 0x0000, 0x0008, KbSup_CmdLeft},       // ADK Cmd Left
    {0x001d, 0x0000, 0x0008, KbSup_CmdRight},      // ADK Cmd Right
    {0x000b, 0x0000, 0x0008, KbSup_PageUp},        // ADK Alt Up
    {0x000c, 0x0000, 0x0008, KbSup_PageDown},      // ADK Alt Down
    {0x2000, 0x2049, 0x0008, KbSup_PageLeft},      // ADK Alt Left
    {0x2000, 0x204a, 0x0008, KbSup_PageRight},     // ADK Alt Right
    {0x007f, 0x0000, 0x0000, KbSup_Del},           // ADK Del
    {0x007f, 0x0000, 0x0002, KbSup_Del},           // ADK CapsLock Del
    {0x0103, 0x0000, 0x0008, KbSup_Tab},           // ADK Tab
    {0x010C, 0x0000, 0x0008, KbSup_ShiftTab},      // ADK ShiftTab
    {0x0000, 0x0000, 0x0000, KbSup_None}
};

