/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.SystemInfo;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class ResizableWindow
extends JWindow
implements ResizableSupport {
    private ResizablePanel _resizablePanel;

    public ResizableWindow() {
        this.initComponents();
    }

    public ResizableWindow(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public ResizableWindow(GraphicsConfiguration gc) {
        super(gc);
        this.initComponents();
    }

    public ResizableWindow(Window owner) {
        super(owner);
        this.initComponents();
    }

    public ResizableWindow(Window owner, GraphicsConfiguration gc) {
        super(owner, gc);
        this.initComponents();
    }

    protected void initComponents() {
        this._resizablePanel = new ResizablePanel(){

            @Override
            protected Resizable createResizable() {
                return new Resizable(this){

                    @Override
                    public void resizing(int resizeDir, int newX, int newY, int newW, int newH) {
                        Container container = ResizableWindow.this.getContentPane();
                        if (SystemInfo.isJdk15Above()) {
                            container.setPreferredSize(new Dimension(newW, newH));
                        } else if (container instanceof JComponent) {
                            ((JComponent)container).setPreferredSize(new Dimension(newW, newH));
                        }
                        ResizableWindow.this.setBounds(newX, newY, newW, newH);
                        ResizableWindow.this.resizing();
                    }

                    @Override
                    public void beginResizing(int resizeCorner) {
                        super.beginResizing(resizeCorner);
                        ResizableWindow.this.beginResizing();
                    }

                    @Override
                    public void endResizing(int resizeCorner) {
                        super.endResizing(resizeCorner);
                        ResizableWindow.this.endResizing();
                    }

                    @Override
                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ResizableWindow.this._resizablePanel.setSize(ResizableWindow.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    @Override
    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    @Override
    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    @Override
    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }
}

