/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public abstract class AbstractActivator
extends Plugin {
    private static AbstractActivator fgInstance;
    protected boolean fIsDebugging;

    public static AbstractActivator getInstance() {
        return fgInstance;
    }

    public abstract String getBundleId();

    public AbstractActivator() {
        fgInstance = this;
        this.fIsDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(this.getBundleId()) + "/debug")));
    }

    public void start(BundleContext context) throws Exception {
        if (this.isDebugging()) {
            System.out.println(String.valueOf(this.getBundleId()) + ".start()");
        }
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.isDebugging()) {
            System.out.println(String.valueOf(this.getBundleId()) + ".stop()");
        }
    }

    public boolean isDebugging() {
        return this.fIsDebugging;
    }

    public static void log(IStatus status) {
        AbstractActivator.getInstance().getLog().log(status);
    }

    public static void log(Throwable e) {
        AbstractActivator.log((IStatus)new Status(4, AbstractActivator.getInstance().getBundleId(), 1, "Internal Error", e));
    }

    public static void log(String message) {
        AbstractActivator.log((IStatus)new Status(4, AbstractActivator.getInstance().getBundleId(), 1, message, null));
    }
}

