/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core.preferences;

import ilg.gnuarmeclipse.core.Activator;
import ilg.gnuarmeclipse.core.AltWindowsRegistry;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class Discoverer {
    private static final String REG_PREFIX = "SOFTWARE";
    private static final String REG32_PREFIX = "SOFTWARE\\Wow6432Node";

    public static String searchInstallFolder(String executableName, String searchPath, String binFolder) {
        String[] paths;
        String value = null;
        if (searchPath == null || searchPath.isEmpty()) {
            return null;
        }
        String resolvedPath = searchPath;
        if (resolvedPath.indexOf("${user.home}") >= 0) {
            String userHome = new Path(System.getProperty("user.home")).toString();
            resolvedPath = resolvedPath.replaceAll("\\$\\{user.home\\}", userHome);
        }
        if (resolvedPath.indexOf("${") >= 0) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                resolvedPath = variableManager.performStringSubstitution(resolvedPath, false);
            }
            catch (CoreException coreException) {
                resolvedPath = null;
            }
        }
        if (resolvedPath == null || resolvedPath.isEmpty()) {
            return null;
        }
        if (EclipseUtils.isWindows()) {
            resolvedPath = StringUtils.duplicateBackslashes(resolvedPath);
        }
        if ((paths = resolvedPath.split(EclipseUtils.getPathSeparator())).length == 0) {
            return null;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.searchInstallFolder() resolved path " + resolvedPath);
        }
        int i = 0;
        while (i < paths.length) {
            value = Discoverer.getLastExecutable(paths[i], binFolder, executableName);
            if (value != null && !value.isEmpty()) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public static String getRegistryInstallFolder(String executableName, String binFolder, String registrySubKey, String registryName) {
        WindowsRegistry registry;
        String value = null;
        if (EclipseUtils.isWindows() && (registry = WindowsRegistry.getRegistry()) != null) {
            value = Discoverer.getRegistryValue(registry, REG_PREFIX, registrySubKey, registryName);
            if (value == null) {
                value = Discoverer.getRegistryValue(registry, REG32_PREFIX, registrySubKey, registryName);
            }
            if (binFolder != null && value != null && !value.endsWith("\\" + binFolder)) {
                value = String.valueOf(value) + "\\" + binFolder;
            }
            if (value != null) {
                File folder;
                Path path = new Path(value);
                value = path.toString();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Discoverer.getRegistryInstallFolder() " + registryName + " " + value);
                }
                if ((folder = path.append(executableName).toFile()).isFile()) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("Discoverer.getRegistryInstallFolder()=" + value);
                    }
                    return value;
                }
            }
        }
        return null;
    }

    private static String getRegistryValue(WindowsRegistry registry, String prefix, String registrySubKey, String registryName) {
        String value = !registrySubKey.startsWith("\\SEGGER") ? registry.getCurrentUserValue(String.valueOf(prefix) + registrySubKey, registryName) : AltWindowsRegistry.query("HKEY_CURRENT_USER\\" + prefix + registrySubKey, registryName);
        if (value == null) {
            value = registry.getLocalMachineValue(String.valueOf(prefix) + registrySubKey, registryName);
        }
        return value;
    }

    public static String getLastExecutable(String folderName, final String binFolder, final String executableName) {
        Path folderPath = new Path(folderName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.getLastExecutable(" + folderPath + ", " + executableName + ")");
        }
        ArrayList<String> list = new ArrayList<String>();
        File folder = folderPath.toFile();
        if (!folder.isDirectory()) {
            return null;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath path = new Path(dir.getAbsolutePath()).append(name);
                path = binFolder != null ? path.append(binFolder).append(executableName) : path.append(executableName);
                return path.toFile().isFile();
            }
        });
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                list.add(files[i].getName());
                ++i;
            }
            Collections.sort(list);
            String last = (String)list.get(list.size() - 1);
            IPath path = new Path(folderName).append(last);
            if (binFolder != null) {
                path = path.append(binFolder);
            }
            return path.toString();
        }
        Path path = new Path(folderName);
        path = binFolder != null ? path.append(binFolder).append(executableName) : path.append(executableName);
        folder = path.toFile();
        if (folder.isFile()) {
            path = new Path(folderName);
            if (binFolder != null) {
                path = path.append(binFolder);
            }
            return path.toString();
        }
        return null;
    }
}

