/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.properties;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.ScopedPreferenceStoreWithoutDefaults;
import ilg.gnuarmeclipse.core.preferences.LabelFakeFieldEditor;
import ilg.gnuarmeclipse.core.ui.FieldEditorPropertyPage;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import ilg.gnuarmeclipse.managedbuild.cross.ui.Messages;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectToolsPathPropertyPage
extends FieldEditorPropertyPage {
    public static final String ID = "ilg.gnuarmeclipse.managedbuild.cross.properties.toolsPage";

    public ProjectToolsPathPropertyPage() {
        super(1);
        this.setDescription(Messages.ProjectToolsPathsPropertyPage_description);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return new ScopedPreferenceStoreWithoutDefaults((IScopeContext)new ProjectScope((IProject)element), "ilg.gnuarmeclipse.managedbuild.cross");
        }
        return null;
    }

    protected void createFieldEditors() {
        IProject project;
        IConfiguration[] configs;
        DirectoryFieldEditor buildToolsPathField = new DirectoryFieldEditor("buildTools.path", Messages.ToolsPaths_label, this.getFieldEditorParent());
        this.addField((FieldEditor)buildToolsPathField);
        HashSet<String> toolchainNames = new HashSet<String>();
        IAdaptable element = this.getElement();
        if (element instanceof IProject && (configs = EclipseUtils.getConfigurationsForProject((IProject)(project = (IProject)element))) != null) {
            int i = 0;
            while (i < configs.length) {
                IOption option;
                IToolChain toolchain = configs[i].getToolChain();
                if (toolchain != null && (option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME)) != null) {
                    try {
                        String name = option.getStringValue();
                        if (!name.isEmpty()) {
                            toolchainNames.add(name);
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        if (toolchainNames.isEmpty()) {
            toolchainNames.add(PersistentPreferences.getToolchainName());
        }
        for (String toolchainName : toolchainNames) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchainName, Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            String key = PersistentPreferences.getToolchainKey(toolchainName);
            DirectoryFieldEditor toolchainPathField = new DirectoryFieldEditor(key, Messages.ToolchainPaths_label, this.getFieldEditorParent());
            this.addField((FieldEditor)toolchainPathField);
        }
    }
}

