/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.ui;

import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;

public class ProjectStorage {
    private static String TOOLCHAIN_PATH = "toolchain.path";
    private static String IS_TOOLCHAIN_PATH_PER_PROJECT = "is.toolchain.path.per.project";

    public static boolean isToolchainPathPerProject(IConfiguration config) {
        String value;
        IProject project = (IProject)config.getManagedProject().getOwner();
        try {
            value = project.getPersistentProperty(new QualifiedName(config.getId(), IS_TOOLCHAIN_PATH_PER_PROJECT));
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return false;
        }
        if (value == null) {
            value = "";
        }
        return "true".equalsIgnoreCase(value.trim());
    }

    public static boolean putToolchainPathPerProject(IConfiguration config, boolean value) {
        IProject project = (IProject)config.getManagedProject().getOwner();
        try {
            project.setPersistentProperty(new QualifiedName(config.getId(), IS_TOOLCHAIN_PATH_PER_PROJECT), String.valueOf(value));
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public static String getToolchainPath(IConfiguration config) {
        String value;
        IProject project = (IProject)config.getManagedProject().getOwner();
        try {
            value = project.getPersistentProperty(new QualifiedName(config.getId(), TOOLCHAIN_PATH));
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return "";
        }
        if (value == null) {
            value = "";
        }
        return value.trim();
    }

    public static boolean putToolchainPath(IConfiguration config, String value) {
        IProject project = (IProject)config.getManagedProject().getOwner();
        try {
            project.setPersistentProperty(new QualifiedName(config.getId(), TOOLCHAIN_PATH), value.trim());
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
            return false;
        }
        return true;
    }
}

