/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.ui;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import ilg.gnuarmeclipse.managedbuild.cross.IDs;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import ilg.gnuarmeclipse.managedbuild.cross.ToolchainDefinition;
import ilg.gnuarmeclipse.managedbuild.cross.Utils;
import ilg.gnuarmeclipse.managedbuild.cross.ui.Messages;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.Page_BuildSettings;
import org.eclipse.cdt.ui.newui.ICPropertyProvider2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabToolchains
extends AbstractCBuildPropertyTab {
    private IConfiguration fConfig;
    private IConfiguration fLastUpdatedConfig = null;
    private Combo fToolchainCombo;
    private int fSelectedToolchainIndex;
    private String fSelectedToolchainName;
    private Combo fArchitectureCombo;
    private Text fPrefixText;
    private Text fSuffixText;
    private Text fCommandCText;
    private Text fCommandCppText;
    private Text fCommandArText;
    private Text fCommandObjcopyText;
    private Text fCommandObjdumpText;
    private Text fCommandSizeText;
    private Text fCommandMakeText;
    private Text fCommandRmText;
    private Text fPathLabel;
    private Button fFlashButton;
    private Button fListingButton;
    private Button fSizeButton;
    private static int WIDTH_HINT = 120;
    public static final String TYPE_PREFIX = "ilg.gnuarmeclipse.managedbuild.cross.target.";

    protected IProject getProject() {
        assert (this.fConfig != null);
        return (IProject)this.fConfig.getManagedProject().getOwner();
    }

    protected String getSelectedToolchainName() {
        int index;
        assert (this.fToolchainCombo != null);
        try {
            String sSelectedCombo = this.fToolchainCombo.getText();
            index = ToolchainDefinition.findToolchainByFullName(sSelectedCombo);
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        ToolchainDefinition td = ToolchainDefinition.getToolchain(index);
        return td.getName();
    }

    public void createControls(final Composite parent) {
        Label link;
        Label label;
        if (EclipseUtils.isLinux()) {
            WIDTH_HINT = 150;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabToolchains.createControls()");
        }
        if (!this.page.isForProject()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("not this project");
            }
            return;
        }
        super.createControls(parent);
        this.fConfig = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("createControls() fConfig=" + this.fConfig);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.usercomp.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        this.usercomp.setLayoutData((Object)layoutData);
        Label toolchainLbl = new Label(this.usercomp, 0);
        toolchainLbl.setLayoutData((Object)new GridData(1));
        toolchainLbl.setText(Messages.ToolChainSettingsTab_name);
        this.fToolchainCombo = new Combo(this.usercomp, 4);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.fToolchainCombo.setLayoutData((Object)layoutData);
        this.fToolchainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabToolchains.this.updateInterfaceAfterToolchainChange();
            }
        });
        Label architectureLbl = new Label(this.usercomp, 0);
        architectureLbl.setLayoutData((Object)new GridData(1));
        architectureLbl.setText(Messages.ToolChainSettingsTab_architecture);
        this.fArchitectureCombo = new Combo(this.usercomp, 4);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fArchitectureCombo.setLayoutData((Object)layoutData);
        Label prefixLabel = new Label(this.usercomp, 0);
        prefixLabel.setText(Messages.ToolChainSettingsTab_prefix);
        this.fPrefixText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fPrefixText.setLayoutData((Object)layoutData);
        Label suffixLabel = new Label(this.usercomp, 0);
        suffixLabel.setText(Messages.ToolChainSettingsTab_suffix);
        this.fSuffixText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fSuffixText.setLayoutData((Object)layoutData);
        Label commandCLabel = new Label(this.usercomp, 0);
        commandCLabel.setText(Messages.ToolChainSettingsTab_cCmd);
        this.fCommandCText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fCommandCText.setLayoutData((Object)layoutData);
        Label commandCppLabel = new Label(this.usercomp, 0);
        commandCppLabel.setText(Messages.ToolChainSettingsTab_cppCmd);
        this.fCommandCppText = new Text(this.usercomp, 2052);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.widthHint = WIDTH_HINT;
        this.fCommandCppText.setLayoutData((Object)layoutData);
        if (this.isManaged()) {
            Label commandArLabel = new Label(this.usercomp, 0);
            commandArLabel.setText(Messages.ToolChainSettingsTab_arCmd);
            this.fCommandArText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandArText.setLayoutData((Object)layoutData);
            Label commandObjcopyLabel = new Label(this.usercomp, 0);
            commandObjcopyLabel.setText(Messages.ToolChainSettingsTab_objcopyCmd);
            this.fCommandObjcopyText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandObjcopyText.setLayoutData((Object)layoutData);
            Label commandObjdumpLabel = new Label(this.usercomp, 0);
            commandObjdumpLabel.setText(Messages.ToolChainSettingsTab_objdumpCmd);
            this.fCommandObjdumpText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandObjdumpText.setLayoutData((Object)layoutData);
            Label commandSizeLabel = new Label(this.usercomp, 0);
            commandSizeLabel.setText(Messages.ToolChainSettingsTab_sizeCmd);
            this.fCommandSizeText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandSizeText.setLayoutData((Object)layoutData);
            Label commandMakeLabel = new Label(this.usercomp, 0);
            commandMakeLabel.setText(Messages.ToolChainSettingsTab_makeCmd);
            this.fCommandMakeText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandMakeText.setLayoutData((Object)layoutData);
            Label commandRmLabel = new Label(this.usercomp, 0);
            commandRmLabel.setText(Messages.ToolChainSettingsTab_rmCmd);
            this.fCommandRmText = new Text(this.usercomp, 2052);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            layoutData.widthHint = WIDTH_HINT;
            this.fCommandRmText.setLayoutData((Object)layoutData);
            this.fCommandRmText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
        } else {
            label = new Label(this.usercomp, 0);
            label.setText("");
            link = new Label(this.usercomp, 0);
            link.setText(Messages.ToolChainSettingsTab_warning_link);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            link.setLayoutData((Object)layoutData);
        }
        Label empty = new Label(this.usercomp, 0);
        empty.setText("");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        empty.setLayoutData((Object)layoutData);
        label = new Label(this.usercomp, 0);
        label.setText(Messages.ToolChainSettingsTab_path_label);
        this.fPathLabel = new Text(this.usercomp, 2052);
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalSpan = 2;
        this.fPathLabel.setLayoutData((Object)layoutData);
        this.fPathLabel.setEnabled(true);
        this.fPathLabel.setEditable(false);
        label = new Label(this.usercomp, 0);
        label.setText("");
        link = new Link(this.usercomp, 0);
        link.setText(Messages.ToolChainSettingsTab_path_link);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        link.setLayoutData((Object)layoutData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnuarmeclipse.managedbuild.cross.preferencePage.globalToolsPaths", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"ilg.gnuarmeclipse.managedbuild.cross.preferencePage.workspaceToolsPaths", null, null).open();
                } else if ("project".equals(text)) {
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)TabToolchains.this.getProject(), (String)"ilg.gnuarmeclipse.managedbuild.cross.properties.toolsPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabToolchains.this.updateToolchainPath(TabToolchains.this.getSelectedToolchainName());
                }
            }
        });
        empty = new Label(this.usercomp, 0);
        empty.setText("");
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        empty.setLayoutData((Object)layoutData);
        if (this.isManaged()) {
            this.fFlashButton = new Button(this.usercomp, 32);
            this.fFlashButton.setText(Messages.ToolChainSettingsTab_flash);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fFlashButton.setLayoutData((Object)layoutData);
            this.fListingButton = new Button(this.usercomp, 32);
            this.fListingButton.setText(Messages.ToolChainSettingsTab_listing);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fListingButton.setLayoutData((Object)layoutData);
            this.fSizeButton = new Button(this.usercomp, 32);
            this.fSizeButton.setText(Messages.ToolChainSettingsTab_size);
            layoutData = new GridData(16384, 128, false, false, 3, 1);
            this.fSizeButton.setLayoutData((Object)layoutData);
        }
        this.updateControlsForConfig(this.fConfig);
    }

    private void updateInterfaceAfterToolchainChange() {
        int index;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabToolchains.updateInterfaceAfterToolchainChange()");
        }
        try {
            String sSelectedCombo = this.fToolchainCombo.getText();
            index = ToolchainDefinition.findToolchainByFullName(sSelectedCombo);
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        ToolchainDefinition td = ToolchainDefinition.getToolchain(index);
        String sArchitecture = td.getArchitecture();
        index = "arm".equals(sArchitecture) ? 0 : ("aarch64".equals(sArchitecture) ? 1 : 0);
        this.fArchitectureCombo.setText(ToolchainDefinition.getArchitecture(index));
        this.fPrefixText.setText(td.getPrefix());
        this.fSuffixText.setText(td.getSuffix());
        this.fCommandCText.setText(td.getCmdC());
        this.fCommandCppText.setText(td.getCmdCpp());
        if (this.isManaged()) {
            this.fCommandArText.setText(td.getCmdAr());
            this.fCommandObjcopyText.setText(td.getCmdObjcopy());
            this.fCommandObjdumpText.setText(td.getCmdObjdump());
            this.fCommandSizeText.setText(td.getCmdSize());
            this.fCommandMakeText.setText(td.getCmdMake());
            String oldCommandRm = this.fCommandRmText.getText();
            String newCommandRm = td.getCmdRm();
            if (oldCommandRm == null || !oldCommandRm.equals(newCommandRm)) {
                this.fCommandRmText.setText(newCommandRm);
            }
        }
        this.updateToolchainPath(td.getName());
    }

    protected void updateToolchainPath(String toolchainName) {
        assert (this.fConfig != null);
        IProject project = (IProject)this.fConfig.getManagedProject().getOwner();
        String toolchainPath = PersistentPreferences.getToolchainPath(toolchainName, project);
        this.fPathLabel.setText(toolchainPath);
    }

    public void updateData(ICResourceDescription cfgd) {
        boolean isStaticLibrary;
        boolean isExecutable;
        IBuildPropertyValue propertyValue;
        if (cfgd == null) {
            return;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabToolchains.updateData() " + this.getCfg().getName());
        }
        if ((propertyValue = this.fConfig.getBuildArtefactType()) != null) {
            String artefactId = propertyValue.getId();
            isExecutable = Utils.BUILD_ARTEFACT_TYPE_EXE.equals(artefactId) || artefactId.endsWith(".exe");
            isStaticLibrary = Utils.BUILD_ARTEFACT_TYPE_STATICLIB.equals(artefactId) || artefactId.endsWith("Lib");
        } else {
            isExecutable = true;
            isStaticLibrary = false;
        }
        IConfiguration config = TabToolchains.getCfg((ICConfigurationDescription)cfgd.getConfiguration());
        if (config instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            config = (IConfiguration)multi.getItems()[0];
        }
        this.updateControlsForConfig(config);
        if (this.isManaged()) {
            this.fCommandArText.setEnabled(isStaticLibrary);
            this.fCommandObjcopyText.setEnabled(isExecutable);
            this.fCommandObjdumpText.setEnabled(isExecutable);
            this.fCommandSizeText.setEnabled(isExecutable);
            this.fFlashButton.setEnabled(isExecutable);
            this.fListingButton.setEnabled(isExecutable);
            this.fSizeButton.setEnabled(isExecutable);
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("TabToolchains.performApply() " + src.getName());
        }
        IConfiguration config1 = TabToolchains.getCfg((ICConfigurationDescription)src.getConfiguration());
        IConfiguration config2 = TabToolchains.getCfg((ICConfigurationDescription)dst.getConfiguration());
        this.updateOptions(config1);
        this.updateOptions(config2);
    }

    protected void performOK() {
        IConfiguration config = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Toolchains.performOK() " + config);
        }
        if (this.fLastUpdatedConfig != null && this.fLastUpdatedConfig.equals(config)) {
            this.updateOptions(config);
        } else if (Activator.getInstance().isDebugging()) {
            System.out.println("skipped " + this.fConfig);
        }
    }

    private void updateControlsForConfig(IConfiguration config) {
        int index;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Toolchains.updateControlsForConfig() " + config.getName());
        }
        if (!this.isThisPlugin()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("not this plugin");
            }
            return;
        }
        String[] toolchains = new String[ToolchainDefinition.getSize()];
        int i = 0;
        while (i < ToolchainDefinition.getSize()) {
            toolchains[i] = ToolchainDefinition.getToolchain(i).getFullName();
            ++i;
        }
        this.fToolchainCombo.setItems(toolchains);
        this.fSelectedToolchainName = Option.getOptionStringValue(config, Option.OPTION_TOOLCHAIN_NAME);
        if (this.fSelectedToolchainName != null && this.fSelectedToolchainName.length() > 0) {
            try {
                this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName(this.fSelectedToolchainName);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.fSelectedToolchainIndex = ToolchainDefinition.getDefault();
            }
        } else {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("No toolchain selected");
            }
            this.fSelectedToolchainName = PersistentPreferences.getToolchainName();
            this.fSelectedToolchainIndex = ToolchainDefinition.findToolchainByName(this.fSelectedToolchainName);
            try {
                TabToolchains.setOptionsForToolchain(config, this.fSelectedToolchainIndex);
            }
            catch (BuildException e1) {
                Activator.log((Throwable)e1);
            }
        }
        String toolchainSel = toolchains[this.fSelectedToolchainIndex];
        this.fToolchainCombo.setText(toolchainSel);
        ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain(this.fSelectedToolchainIndex);
        this.fArchitectureCombo.setItems(ToolchainDefinition.getArchitectures());
        String sSelectedArchitecture = Option.getOptionStringValue(config, Option.OPTION_ARCHITECTURE);
        try {
            index = sSelectedArchitecture.endsWith(".arm") ? 0 : (sSelectedArchitecture.endsWith(".aarch64") ? 1 : 0);
        }
        catch (NullPointerException nullPointerException) {
            index = 0;
        }
        this.fArchitectureCombo.setText(ToolchainDefinition.getArchitecture(index));
        String prefix = Option.getOptionStringValue(config, Option.OPTION_COMMAND_PREFIX);
        if (prefix != null) {
            this.fPrefixText.setText(prefix);
        } else {
            this.fPrefixText.setText(toolchainDefinition.getPrefix());
        }
        String suffix = Option.getOptionStringValue(config, Option.OPTION_COMMAND_SUFFIX);
        if (suffix != null) {
            this.fSuffixText.setText(suffix);
        } else {
            this.fSuffixText.setText(toolchainDefinition.getSuffix());
        }
        String commandC = Option.getOptionStringValue(config, Option.OPTION_COMMAND_C);
        if (commandC != null) {
            this.fCommandCText.setText(commandC);
        } else {
            this.fCommandCText.setText(toolchainDefinition.getCmdC());
        }
        String commandCpp = Option.getOptionStringValue(config, Option.OPTION_COMMAND_CPP);
        if (commandCpp != null) {
            this.fCommandCppText.setText(commandCpp);
        } else {
            this.fCommandCppText.setText(toolchainDefinition.getCmdCpp());
        }
        if (this.isManaged()) {
            String commandAr = Option.getOptionStringValue(config, Option.OPTION_COMMAND_AR);
            if (commandAr != null) {
                this.fCommandArText.setText(commandAr);
            } else {
                this.fCommandArText.setText(toolchainDefinition.getCmdAr());
            }
            String commandObjcopy = Option.getOptionStringValue(config, Option.OPTION_COMMAND_OBJCOPY);
            if (commandObjcopy != null) {
                this.fCommandObjcopyText.setText(commandObjcopy);
            } else {
                this.fCommandObjcopyText.setText(toolchainDefinition.getCmdObjcopy());
            }
            String commandObjdump = Option.getOptionStringValue(config, Option.OPTION_COMMAND_OBJDUMP);
            if (commandObjdump != null) {
                this.fCommandObjdumpText.setText(commandObjdump);
            } else {
                this.fCommandObjdumpText.setText(toolchainDefinition.getCmdObjdump());
            }
            String commandSize = Option.getOptionStringValue(config, Option.OPTION_COMMAND_SIZE);
            if (commandSize != null) {
                this.fCommandSizeText.setText(commandSize);
            } else {
                this.fCommandSizeText.setText(toolchainDefinition.getCmdSize());
            }
            String commandMake = Option.getOptionStringValue(config, Option.OPTION_COMMAND_MAKE);
            if (commandMake != null) {
                this.fCommandMakeText.setText(commandMake);
            } else {
                this.fCommandMakeText.setText(toolchainDefinition.getCmdMake());
            }
            String commandRm = Option.getOptionStringValue(config, Option.OPTION_COMMAND_RM);
            if (commandRm != null) {
                this.fCommandRmText.setText(commandRm);
            } else {
                this.fCommandRmText.setText(toolchainDefinition.getCmdRm());
            }
            Boolean isCreateFlash = Option.getOptionBooleanValue(config, Option.OPTION_ADDTOOLS_CREATEFLASH);
            if (isCreateFlash != null) {
                this.fFlashButton.setSelection(isCreateFlash.booleanValue());
            } else {
                this.fFlashButton.setSelection(true);
            }
            Boolean isCreateListing = Option.getOptionBooleanValue(config, Option.OPTION_ADDTOOLS_CREATELISTING);
            if (isCreateListing != null) {
                this.fListingButton.setSelection(isCreateListing.booleanValue());
            } else {
                this.fListingButton.setSelection(false);
            }
            Boolean isPrintSize = Option.getOptionBooleanValue(config, Option.OPTION_ADDTOOLS_PRINTSIZE);
            if (isPrintSize != null) {
                this.fSizeButton.setSelection(isPrintSize.booleanValue());
            } else {
                this.fSizeButton.setSelection(true);
            }
        }
        this.fConfig = config;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("updateControlsForConfig() fConfig=" + this.fConfig);
        }
        this.fLastUpdatedConfig = config;
        this.updateToolchainPath(toolchainDefinition.getName());
    }

    private void updateOptions(IConfiguration config) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Toolchains.updateOptions() " + config.getName());
        }
        if (config instanceof MultiConfiguration) {
            MultiConfiguration multi = (MultiConfiguration)config;
            Object[] objectArray = multi.getItems();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IConfiguration cfg = (IConfiguration)obj;
                this.updateOptions(cfg);
                ++n2;
            }
            return;
        }
        IToolChain toolchain = config.getToolChain();
        try {
            String sSelectedArchitecture = this.fArchitectureCombo.getText();
            String val = ToolchainDefinition.getArchitecture(0).equals(sSelectedArchitecture) ? Option.OPTION_ARCHITECTURE_ARM : (ToolchainDefinition.getArchitecture(1).equals(sSelectedArchitecture) ? Option.OPTION_ARCHITECTURE_AARCH64 : Option.OPTION_ARCHITECTURE_ARM);
            IOption option = toolchain.getOptionBySuperClassId(Option.OPTION_ARCHITECTURE);
            config.setOption((IHoldsOptions)toolchain, option, val);
            String sSelectedCombo = this.fToolchainCombo.getText();
            int index = ToolchainDefinition.findToolchainByFullName(sSelectedCombo);
            ToolchainDefinition td = ToolchainDefinition.getToolchain(index);
            option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME);
            config.setOption((IHoldsOptions)toolchain, option, td.getName());
            option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_PREFIX);
            config.setOption((IHoldsOptions)toolchain, option, this.fPrefixText.getText().trim());
            option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_SUFFIX);
            config.setOption((IHoldsOptions)toolchain, option, this.fSuffixText.getText().trim());
            option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_C);
            config.setOption((IHoldsOptions)toolchain, option, this.fCommandCText.getText().trim());
            option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_CPP);
            config.setOption((IHoldsOptions)toolchain, option, this.fCommandCppText.getText().trim());
            if (this.isManaged()) {
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_AR);
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandArText.getText().trim());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_OBJCOPY);
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandObjcopyText.getText().trim());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_OBJDUMP);
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandObjdumpText.getText().trim());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_SIZE);
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandSizeText.getText().trim());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_MAKE);
                config.setOption((IHoldsOptions)toolchain, option, this.fCommandMakeText.getText().trim());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_RM);
                String oldValue = option.getStringValue();
                String newValue = this.fCommandRmText.getText().trim();
                if (newValue != null && !newValue.equals(oldValue)) {
                    config.setOption((IHoldsOptions)toolchain, option, newValue);
                    this.propagateCommandRmUpdate(config);
                }
                option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_CREATEFLASH);
                config.setOption((IHoldsOptions)toolchain, option, this.fFlashButton.getSelection());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_CREATELISTING);
                config.setOption((IHoldsOptions)toolchain, option, this.fListingButton.getSelection());
                option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_PRINTSIZE);
                config.setOption((IHoldsOptions)toolchain, option, this.fSizeButton.getSelection());
            }
        }
        catch (NullPointerException e) {
            Activator.log((Throwable)e);
        }
        catch (BuildException e) {
            Activator.log((Throwable)e);
        }
    }

    public static void setOptionsForToolchain(IConfiguration config, int toolchainIndex) throws BuildException {
        IToolChain toolchain = config.getToolChain();
        ToolchainDefinition td = ToolchainDefinition.getToolchain(toolchainIndex);
        IOption option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME);
        config.setOption((IHoldsOptions)toolchain, option, td.getName());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_ARCHITECTURE);
        String sArchitecture = td.getArchitecture();
        String val = String.valueOf(Option.OPTION_ARCHITECTURE) + "." + sArchitecture;
        Utils.setOptionForced(config, toolchain, option, val);
        if ("arm".equals(sArchitecture)) {
            option = toolchain.getOptionBySuperClassId(Option.OPTION_ARM_TARGET_FAMILY);
            Utils.forceOptionRewrite(config, toolchain, option);
            option = toolchain.getOptionBySuperClassId(Option.OPTION_ARM_TARGET_INSTRUCTIONSET);
            Utils.forceOptionRewrite(config, toolchain, option);
        } else if ("aarch64".equals(sArchitecture)) {
            option = toolchain.getOptionBySuperClassId(Option.OPTION_AARCH64_TARGET_FAMILY);
            Utils.setOptionForced(config, toolchain, option, Option.OPTION_AARCH64_MCPU_GENERIC);
            option = toolchain.getOptionBySuperClassId(Option.OPTION_AARCH64_FEATURE_SIMD);
            Utils.setOptionForced(config, toolchain, option, Option.OPTION_AARCH64_FEATURE_SIMD_ENABLED);
            option = toolchain.getOptionBySuperClassId(Option.OPTION_AARCH64_CMODEL);
            Utils.setOptionForced(config, toolchain, option, Option.OPTION_AARCH64_CMODEL_SMALL);
        }
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_PREFIX);
        config.setOption((IHoldsOptions)toolchain, option, td.getPrefix());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_SUFFIX);
        config.setOption((IHoldsOptions)toolchain, option, td.getSuffix());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_C);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdC());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_CPP);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdCpp());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_AR);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdAr());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_OBJCOPY);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdObjcopy());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_OBJDUMP);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdObjdump());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_SIZE);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdSize());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_MAKE);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdMake());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_COMMAND_RM);
        config.setOption((IHoldsOptions)toolchain, option, td.getCmdRm());
        option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_CREATEFLASH);
        config.setOption((IHoldsOptions)toolchain, option, true);
        option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_CREATELISTING);
        config.setOption((IHoldsOptions)toolchain, option, false);
        option = toolchain.getOptionBySuperClassId(Option.OPTION_ADDTOOLS_PRINTSIZE);
        config.setOption((IHoldsOptions)toolchain, option, true);
    }

    private void propagateCommandRmUpdate(IConfiguration config) {
        IPath makefilePath;
        IProject project = (IProject)config.getOwner();
        IResource makefileResource = project.findMember((makefilePath = project.getFullPath().append(config.getName()).append("makefile")).removeFirstSegments(1));
        if (makefileResource != null && makefileResource.exists()) {
            try {
                makefileResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                GnuMakefileGenerator makefileGenerator = new GnuMakefileGenerator();
                makefileGenerator.initialize(0, config, config.getBuilder(), (IProgressMonitor)new NullProgressMonitor());
                makefileGenerator.regenerateMakefiles();
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
    }

    protected void performDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Toolchains.performDefaults()");
        }
        this.updateInterfaceAfterToolchainChange();
        if (this.isManaged()) {
            this.fFlashButton.setSelection(true);
            this.fListingButton.setSelection(false);
            this.fSizeButton.setSelection(true);
        }
    }

    public boolean canBeVisible() {
        if (!this.isThisPlugin()) {
            return false;
        }
        return this.page.isForProject();
    }

    public boolean canSupportMultiCfg() {
        return true;
    }

    protected void updateButtons() {
    }

    private boolean isThisPlugin() {
        IToolChain toolchain;
        String sToolchainId;
        this.fConfig = this.getCfg();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("isThisPlugin() fConfig=" + this.fConfig);
        }
        return (sToolchainId = (toolchain = this.fConfig.getToolChain()).getBaseId()).startsWith(String.valueOf(IDs.TOOLCHAIN_ID) + ".");
    }

    private boolean isManaged() {
        this.fConfig = this.getCfg();
        IManagedProject managedProject = this.fConfig.getManagedProject();
        IProjectType projectType = managedProject.getProjectType();
        return projectType != null && projectType.getId().startsWith(TYPE_PREFIX);
    }

    public void handleTabEvent(int kind, Object data) {
        super.handleTabEvent(kind, data);
        switch (kind) {
            case 4: {
                Page_BuildSettings pageConcrete = (Page_BuildSettings)((ICPropertyProvider2)this.page);
                pageConcrete.handleMessage(101, null);
                break;
            }
        }
    }
}

