/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.packs.ui.views;

import ilg.gnuarmeclipse.core.CProjectPacksStorage;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.managedbuild.cross.IDs;
import ilg.gnuarmeclipse.managedbuild.packs.Activator;
import ilg.gnuarmeclipse.packs.core.data.PacksStorage;
import ilg.gnuarmeclipse.packs.core.tree.AbstractTreePreOrderIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.NodeViewContentProvider;
import ilg.gnuarmeclipse.packs.data.DataManager;
import ilg.gnuarmeclipse.packs.data.DataManagerEvent;
import ilg.gnuarmeclipse.packs.data.IDataManagerListener;
import ilg.gnuarmeclipse.packs.ui.IconUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.ViewPart;

public class DocsView
extends ViewPart
implements IDataManagerListener,
IPropertyChangeListener {
    public static final String ID = "ilg.gnuarmeclipse.managedbuild.packs.ui.views.DocsView";
    public static final int AUTOEXPAND_LEVEL = 2;
    private TreeViewer fViewer;
    private ISelectionListener fPostSelectionListener;
    private IPartListener fPartListener;
    private ViewContentProvider fContentProvider;
    private DataManager fDataManager = DataManager.getInstance();
    private Action fDoubleClickAction;
    private Action fRightClickOpen;
    private IConfiguration fConfig = null;
    private IConfiguration fLatestSelectedConfig = null;

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 66306);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
        this.fContentProvider = new ViewContentProvider();
        this.fDataManager.addListener((IDataManagerListener)this);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new NameSorter());
        this.fViewer.setAutoExpandLevel(2);
        this.fLatestSelectedConfig = this.getConfigurationForProject(EclipseUtils.getSelectedProject());
        this.setInputForConfig(this.fLatestSelectedConfig, true);
        this.addProviders();
        this.addListners();
        this.hookPostSelectionListener();
        this.hookPartListener();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void dispose() {
        super.dispose();
        this.fDataManager.removeListener((IDataManagerListener)this);
        if (this.fPostSelectionListener != null) {
            this.getSite().getPage().removePostSelectionListener(this.fPostSelectionListener);
        }
        if (this.fPartListener != null) {
            this.getSite().getPage().removePartListener(this.fPartListener);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DocsView.dispose()");
        }
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof IProject && EclipseUtils.getSelectedProject() == (IProject)source) {
            this.fLatestSelectedConfig = this.getConfigurationForProject(EclipseUtils.getSelectedProject());
            this.setInputForConfig(this.fLatestSelectedConfig, false);
        }
    }

    private void hookPostSelectionListener() {
        this.fPostSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                IStructuredSelection structSel;
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && part instanceof ProjectExplorer && (structSel = (IStructuredSelection)selection).size() == 1) {
                    Object firstSel = structSel.getFirstElement();
                    IProject project = null;
                    if (firstSel instanceof IProject) {
                        project = (IProject)firstSel;
                    } else if (firstSel instanceof IncludeRefContainer) {
                        project = ((IncludeRefContainer)firstSel).getCProject().getProject();
                    } else if (firstSel instanceof CElement) {
                        project = ((CElement)firstSel).getCProject().getProject();
                    } else if (firstSel instanceof File) {
                        project = ((File)firstSel).getProject();
                    } else if (firstSel instanceof Folder) {
                        project = ((Folder)firstSel).getProject();
                    } else {
                        Activator.log((String)(firstSel + " ignored"));
                    }
                    DocsView.this.fLatestSelectedConfig = DocsView.this.getConfigurationForProject(project);
                    DocsView.this.setInputForConfig(DocsView.this.fLatestSelectedConfig, false);
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.fPostSelectionListener);
    }

    private void hookPartListener() {
        this.fPartListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof DocsView) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("partActivated() " + part);
                    }
                    DocsView.this.setInputForConfig(DocsView.this.fLatestSelectedConfig, false);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.getSite().getPage().addPartListener(this.fPartListener);
    }

    private IConfiguration getConfigurationForProject(IProject project) {
        IConfiguration newConfig = null;
        try {
            IManagedBuildInfo info;
            IConfiguration config;
            IToolChain toolchain;
            String sToolchainId;
            if (project != null && project.hasNature("org.eclipse.cdt.core.cnature") && (sToolchainId = (toolchain = (config = (info = ManagedBuildManager.getBuildInfo((IResource)project)).getDefaultConfiguration()).getToolChain()).getBaseId()).startsWith(String.valueOf(IDs.TOOLCHAIN_ID) + ".")) {
                newConfig = config;
            }
        }
        catch (CoreException coreException) {}
        return newConfig;
    }

    private void setInputForConfig(IConfiguration newConfig, boolean force) {
        if (this.getSite().getPage().isPartVisible((IWorkbenchPart)this) && (force || newConfig != null && !newConfig.equals(this.fConfig) || this.fConfig != null && !this.fConfig.equals(newConfig))) {
            this.fConfig = newConfig;
            this.fViewer.setInput((Object)this.getDocsTree());
        }
    }

    private void makeActions() {
        this.fDoubleClickAction = new Action(){

            public void run() {
                ISelection selection = DocsView.this.fViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof Leaf) {
                    try {
                        DocsView.this.doubleClickAction((Leaf)obj);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.fRightClickOpen = new Action(){

            public void run() {
                ISelection selection = DocsView.this.fViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof Leaf) {
                    try {
                        DocsView.this.rightClickAction((Leaf)obj);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.fRightClickOpen.setText("Open");
        this.fRightClickOpen.setEnabled(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DocsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fRightClickOpen);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocsView.this.fDoubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void refresh(Object obj) {
        if (obj instanceof Collection) {
            for (Object node : (Collection)obj) {
                this.fViewer.refresh(node);
            }
        } else {
            this.fViewer.refresh(obj);
        }
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    public void update(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object node : list) {
                this.fViewer.update(node, null);
            }
        } else {
            this.fViewer.update(obj, null);
        }
    }

    public String toString() {
        return "DocsView";
    }

    private void doubleClickAction(Leaf node) throws PartInitException, IOException {
        this.openBook(node);
    }

    private void rightClickAction(Leaf node) throws PartInitException, IOException {
        this.openBook(node);
    }

    private void openBook(Leaf node) throws PartInitException, IOException {
        if (node.isType("book")) {
            String url = node.getProperty("url");
            String absoluteFile = node.getProperty("file.absolute");
            if (url.length() > 0) {
                EclipseUtils.openExternalBrowser((URL)new URL(url));
            } else if (absoluteFile.length() > 0) {
                IPath path = PacksStorage.getFolderPath().append(absoluteFile);
                EclipseUtils.openExternalFile((IPath)path);
            }
        }
    }

    public void packsChanged(DataManagerEvent event) {
        String type = event.getType();
        if ("new.input".equals(type)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocsView.this.fViewer.setInput((Object)DocsView.this.getDocsTree());
                }
            });
        } else if ("update.versions".equals(type)) {
            final HashMap updatedMap = new HashMap();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocsView.this.refresh(updatedMap.values());
                }
            });
        }
    }

    private Node getDocsTree() {
        Node tree = DataManager.getInstance().getInstalledObjectsForBuild();
        Node devicesRoot = new Node("root");
        devicesRoot.setName("Docs");
        try {
            CProjectPacksStorage st = new CProjectPacksStorage(this.fConfig);
            String deviceVendorId = st.getOption("cmsis.device.vendor.id");
            String deviceName = st.getOption("cmsis.device.name");
            String boardVendorName = st.getOption("cmsis.board.vendor.name");
            String boardName = st.getOption("cmsis.board.name");
            if (deviceName != null) {
                Node deviceDocsNode = Node.addNewChild((Node)devicesRoot, (String)"folder");
                deviceDocsNode.setName(String.valueOf(deviceName) + " device docs");
                Node devicesSubtree = (Node)tree.findChild("devices");
                if (devicesSubtree != null) {
                    this.copyDeviceDocs(devicesSubtree, deviceVendorId, deviceName, deviceDocsNode);
                }
            }
            if (boardName != null) {
                Node boardDocsNode = Node.addNewChild((Node)devicesRoot, (String)"folder");
                boardDocsNode.setName(String.valueOf(boardName) + " board docs");
                Node boardsSubtree = (Node)tree.findChild("boards");
                if (boardsSubtree != null) {
                    this.copyBoardDocs(boardsSubtree, boardVendorName, boardName, boardDocsNode);
                }
            }
        }
        catch (CoreException coreException) {}
        if (!devicesRoot.hasChildren()) {
            Node emptyNode = Node.addNewChild((Node)devicesRoot, (String)"none");
            emptyNode.setName("No documents are available.");
        }
        return devicesRoot;
    }

    private void copyBoardDocs(Node boards, String boardVendorName, String boardName, Node parent) {
        Node vendor = (Node)boards.findChild("vendor", boardVendorName);
        if (vendor != null && vendor.hasChildren()) {
            for (Leaf board : vendor.getChildren()) {
                if (!board.isType("board") || !boardName.equals(board.getName())) continue;
                String destFolder = this.fDataManager.getDestinationFolder(board);
                if (board == null || !board.hasChildren()) continue;
                for (Leaf bookNode : ((Node)board).getChildren()) {
                    if (!bookNode.isType("book")) continue;
                    Leaf newBook = Leaf.addNewChild((Node)parent, (String)"book");
                    newBook.copyProperties(bookNode);
                    if (!newBook.hasProperty("file")) continue;
                    IPath path = new Path(destFolder).append(newBook.getProperty("file"));
                    newBook.putProperty("file.absolute", path.toString());
                }
            }
        }
    }

    private void copyDeviceDocs(Node devicesSubtree, String deviceVendorId, String deviceName, Node parent) {
        for (Leaf vendor : devicesSubtree.getChildren()) {
            if (!vendor.isType("vendor") || !deviceVendorId.equals(vendor.getProperty("vendor.id"))) continue;
            AbstractTreePreOrderIterator deviceNodes = new AbstractTreePreOrderIterator(){

                public boolean isIterable(Leaf node) {
                    return node.isType("device");
                }

                public boolean isLeaf(Leaf node) {
                    return node.isType("device");
                }
            };
            deviceNodes.setTreeNode(vendor);
            for (Leaf deviceNode : deviceNodes) {
                if (!deviceName.equals(deviceNode.getName())) continue;
                Leaf node = deviceNode;
                String destFolder = this.fDataManager.getDestinationFolder(node);
                do {
                    if (!node.hasChildren()) continue;
                    for (Leaf bookNode : ((Node)node).getChildren()) {
                        if (!bookNode.isType("book")) continue;
                        Leaf newBook = Leaf.addNewChild((Node)parent, (String)"book");
                        newBook.copyProperties(bookNode);
                        if (!newBook.hasProperty("file")) continue;
                        IPath path = new Path(destFolder).append(newBook.getProperty("file"));
                        newBook.putProperty("file.absolute", path.toString());
                    }
                } while ((node = node.getParent()) != null && !node.isType("devices"));
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return " " + ((Leaf)obj).getName();
        }

        public Image getImage(Object obj) {
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("folder".equals(type)) {
                String imageKey = "IMG_OBJ_FOLDER";
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
            }
            if ("book".equals(type)) {
                return IconUtils.getBookIcon((Leaf)node);
            }
            return null;
        }

        public String getToolTipText(Object obj) {
            Leaf node = (Leaf)obj;
            String description = null;
            if (node.isType("book")) {
                String url;
                String file;
                description = "Document: " + node.getName();
                String category = node.getProperty("category");
                if (category.length() > 0) {
                    description = String.valueOf(description) + "\ncategory: " + category;
                }
                if ((file = node.getProperty("file.absolute")).length() > 0) {
                    description = String.valueOf(description) + "\nfile: " + file;
                }
                if ((url = node.getProperty("url")).length() > 0) {
                    description = String.valueOf(description) + "\nurl: " + url;
                }
            }
            return description;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }
}

