/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.data;

import ilg.gnuarmeclipse.core.Activator;
import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.packs.cmsis.PdscGenericParser;
import ilg.gnuarmeclipse.packs.cmsis.PdscTreeParserForBuild;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.data.DurationMonitor;
import ilg.gnuarmeclipse.packs.core.data.IPacksDataManager;
import ilg.gnuarmeclipse.packs.core.data.PacksStorage;
import ilg.gnuarmeclipse.packs.core.tree.AbstractTreePreOrderIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.PackNode;
import ilg.gnuarmeclipse.packs.core.tree.Selector;
import ilg.gnuarmeclipse.packs.data.DataManagerEvent;
import ilg.gnuarmeclipse.packs.data.IDataManagerListener;
import ilg.gnuarmeclipse.packs.data.Repos;
import ilg.gnuarmeclipse.packs.data.Utils;
import ilg.gnuarmeclipse.packs.xcdl.GenericParser;
import ilg.gnuarmeclipse.packs.xcdl.GenericSerialiser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;

public class DataManager
implements IPacksDataManager {
    private static final DataManager fgInstance = new DataManager();
    private Node fRepositoriesTree = null;
    private List<PackNode> fPacksVersionsList = null;
    private Map<String, Map<String, PackNode>> fPacksVersionsMap;
    private Map<String, PackNode> fPacksMap;
    private Map<String, Node> fParsedPdsc = null;
    private List<PackNode> fInstalledPacksLatestVersionsList = null;
    private Node fInstalledObjectsForBuild = null;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    private List<IDataManagerListener> fListeners = new ArrayList<IDataManagerListener>();
    private Map<String, Leaf> fInstalledDevicesMap;
    private Map<String, Leaf> fInstalledBoardsMap;

    public static DataManager getInstance() {
        return fgInstance;
    }

    public DataManager() {
        this.fPacksVersionsMap = new TreeMap<String, Map<String, PackNode>>();
        this.fPacksMap = new TreeMap<String, PackNode>();
        this.fInstalledDevicesMap = new TreeMap<String, Leaf>();
        this.fInstalledBoardsMap = new TreeMap<String, Leaf>();
    }

    public void addListener(IDataManagerListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IDataManagerListener listener) {
        this.fListeners.remove(listener);
    }

    public void notifyNewInput() {
        this.clearSummaryData();
        this.clearInstalledPacksLatestVersionsList();
        this.clearCachedInstalledObjectsForBuild();
        DataManagerEvent event = new DataManagerEvent(this, "new.input");
        this.notifyListener(event);
    }

    public void notifyInstallRemove() {
        this.clearSummaryData();
        this.clearInstalledPacksLatestVersionsList();
        this.clearCachedInstalledObjectsForBuild();
        DataManagerEvent event = new DataManagerEvent(this, "update.packs");
        this.notifyListener(event);
    }

    public void notifyUpdateView(String type, List<Leaf> list) {
        DataManagerEvent event = new DataManagerEvent(this, type, list);
        this.notifyListener(event);
    }

    public void notifyListener(DataManagerEvent event) {
        for (IDataManagerListener listener : this.fListeners) {
            listener.packsChanged(event);
        }
    }

    public void clearSummaryData() {
        this.fRepositoriesTree = null;
        this.fPacksVersionsList = null;
        this.fInstalledPacksLatestVersionsList = null;
    }

    public Node getRepositoriesTree() {
        return this.getRepositoriesTree(new DurationMonitor());
    }

    private Node getRepositoriesTree(final DurationMonitor dm) {
        if (this.fRepositoriesTree != null) {
            return this.fRepositoriesTree;
        }
        assert (dm != null);
        dm.displayTimeAndRun(new Runnable(){

            @Override
            public void run() {
                DataManager.this.loadCachedReposContent(dm);
            }
        });
        return this.fRepositoriesTree;
    }

    private List<PackNode> getPacksVersionsList(DurationMonitor dm) {
        if (this.fPacksVersionsList != null) {
            return this.fPacksVersionsList;
        }
        this.getRepositoriesTree(dm);
        return this.fPacksVersionsList;
    }

    public PackNode findPackVersion(String vendorName, String packName, String version) {
        return this.findPackVersion(vendorName, packName, version, new DurationMonitor());
    }

    private PackNode findPackVersion(String vendorName, String packName, String version, DurationMonitor dm) {
        this.getRepositoriesTree(dm);
        String key = this.makeMapKey(vendorName, packName);
        Map<String, PackNode> versionsMap = this.fPacksVersionsMap.get(key);
        if (versionsMap == null) {
            return null;
        }
        return versionsMap.get(version);
    }

    public PackNode findPackLatest(String vendorName, String packName) {
        return this.findPackLatest(vendorName, packName, new DurationMonitor());
    }

    private PackNode findPackLatest(String vendorName, String packName, DurationMonitor dm) {
        this.getRepositoriesTree(dm);
        String key = this.makeMapKey(vendorName, packName);
        Map<String, PackNode> versionsMap = this.fPacksVersionsMap.get(key);
        if (versionsMap == null) {
            return null;
        }
        PackNode node = null;
        for (String versionName : versionsMap.keySet()) {
            node = versionsMap.get(versionName);
        }
        return node;
    }

    public String makeMapKey(String vendorName, String packName) {
        String key = String.valueOf(vendorName) + "::" + packName;
        return key;
    }

    public void loadCachedReposContent() {
        this.loadCachedReposContent(null);
    }

    private void loadCachedReposContent(DurationMonitor dm) {
        Node node = new Node("root");
        this.fPacksVersionsList = Repos.getInstance().loadCachedReposContent(node);
        this.fRepositoriesTree = node;
        this.preparePacksMaps();
        this.addSelectors();
        this.updateInstalledVersions();
    }

    private void preparePacksMaps() {
        TreeMap<String, Map<String, PackNode>> packsVersionsMap = new TreeMap<String, Map<String, PackNode>>();
        for (PackNode versionNode : this.fPacksVersionsList) {
            String packName;
            String vendorName = versionNode.getProperty("vendor.name");
            String key = this.makeMapKey(vendorName, packName = versionNode.getProperty("pack.name"));
            TreeMap<String, PackNode> versionMap = (TreeMap<String, PackNode>)packsVersionsMap.get(key);
            if (versionMap == null) {
                versionMap = new TreeMap<String, PackNode>();
                packsVersionsMap.put(key, versionMap);
            }
            versionMap.put(versionNode.getName(), versionNode);
        }
        this.fPacksVersionsMap = packsVersionsMap;
        TreeMap<String, PackNode> packsMap = new TreeMap<String, PackNode>();
        for (PackNode versionNode : this.fPacksVersionsList) {
            String packName;
            String vendorName = versionNode.getProperty("vendor.name");
            String key = this.makeMapKey(vendorName, packName = versionNode.getProperty("pack.name"));
            if (packsMap.containsKey(key)) continue;
            PackNode parent = (PackNode)versionNode.getParent();
            packsMap.put(key, parent);
        }
        this.fPacksMap = packsMap;
    }

    private void addSelectors() {
        for (PackNode packNode : this.fPacksMap.values()) {
            Node versionNode = (Node)packNode.getFirstChild();
            if (!versionNode.hasChildren()) continue;
            for (Leaf child : versionNode.getChildren()) {
                if (!child.isType("outline") && !child.isType("external") || !child.hasChildren()) continue;
                for (Leaf node : ((Node)child).getChildren()) {
                    Selector selector = null;
                    String type = node.getType();
                    if ("family".equals(type)) {
                        selector = new Selector("devicefamily");
                        selector.setValue(node.getName());
                        selector.setVendorId(node.getProperty("vendor.id"));
                    } else if ("board".equals(type)) {
                        selector = new Selector("board");
                        selector.setValue(node.getName());
                        selector.setVendor(node.getProperty("vendor.name"));
                    } else if ("keyword".equals(type)) {
                        selector = new Selector("keyword");
                        selector.setValue(node.getName());
                    }
                    if (selector == null) continue;
                    packNode.addSelector(selector);
                }
            }
        }
    }

    private void updateInstalledVersions() {
        this.fOut.println("Identifying installed packages...");
        int count = 0;
        for (Leaf leaf : this.fPacksVersionsList) {
            String unpackFolder = leaf.getProperty("dest.folder");
            String pdscName = leaf.getProperty("pdsc.name");
            String pdscRelativePath = String.valueOf(unpackFolder) + '/' + pdscName;
            try {
                File file = PacksStorage.getFileObject((String)pdscRelativePath);
                if (!file.exists()) continue;
                leaf.setBooleanProperty("installed", true);
                if (leaf.getParent().isType("package")) {
                    leaf.getParent().setBooleanProperty("installed", true);
                }
                ++count;
            }
            catch (Exception exception) {}
        }
        if (count == 0) {
            this.fOut.println("Found no installed packages.");
        } else {
            this.fOut.println("Found " + count + " installed packages.");
        }
    }

    private void clearInstalledPacksLatestVersionsList() {
        this.fInstalledPacksLatestVersionsList = null;
    }

    public List<PackNode> getInstalledPacksLatestVersionsList() {
        return this.getInstalledPacksLatestVersionsList(new DurationMonitor());
    }

    private List<PackNode> getInstalledPacksLatestVersionsList(DurationMonitor dm) {
        if (this.fInstalledPacksLatestVersionsList != null) {
            return this.fInstalledPacksLatestVersionsList;
        }
        LinkedList<PackNode> installedPackages = new LinkedList<PackNode>();
        List<PackNode> packsVersionsList = this.getPacksVersionsList(dm);
        if (packsVersionsList != null) {
            for (PackNode versionNode : this.getPacksVersionsList(dm)) {
                if (!versionNode.isBooleanProperty("installed")) continue;
                installedPackages.add((PackNode)versionNode.getParent());
            }
            LinkedList<PackNode> installedLatestVersions = new LinkedList<PackNode>();
            block1: for (PackNode packNode : installedPackages) {
                List children = packNode.getChildren();
                for (Leaf node : children) {
                    if (!node.isBooleanProperty("installed")) continue;
                    installedLatestVersions.add((PackNode)node);
                    continue block1;
                }
            }
            this.fInstalledPacksLatestVersionsList = installedLatestVersions;
        }
        return this.fInstalledPacksLatestVersionsList;
    }

    public Node getParsedPdscTree(String pdscName, String version) {
        return this.getParsedPdscTree(pdscName, version, new DurationMonitor());
    }

    private Node getParsedPdscTree(String pdscName, String version, final DurationMonitor dm) {
        final String fileName = PacksStorage.makeCachedPdscName((String)pdscName, (String)version);
        if (this.fParsedPdsc != null) {
            Node node = this.fParsedPdsc.get(fileName);
            if (node != null) {
                return node;
            }
        } else {
            this.fParsedPdsc = new HashMap<String, Node>();
        }
        assert (dm != null);
        dm.displayTimeAndRun(new Runnable(){

            @Override
            public void run() {
                DataManager.this.loadPdscTree(fileName, dm);
            }
        });
        return this.fParsedPdsc.get(fileName);
    }

    private void loadPdscTree(String fileName, DurationMonitor dm) {
        try {
            File file = PacksStorage.getCachedFileObject((String)fileName);
            this.fOut.println("Parsing cached PDSC file \"" + file.getPath() + "\"...");
            Document document = Xml.parseFile((File)file);
            PdscGenericParser parser = new PdscGenericParser();
            Node node = parser.parse(document);
            if (node != null) {
                this.fParsedPdsc.put(fileName, node);
            }
        }
        catch (Exception e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + fileName;
            this.fOut.println("Error: " + msg);
            Utils.reportError(msg);
            Activator.log((Throwable)e);
        }
    }

    private void clearCachedInstalledObjectsForBuild() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("clearCachedInstalledObjectsForBuild()");
        }
        this.fInstalledObjectsForBuild = null;
        try {
            File devicesFile = PacksStorage.getCachedFileObject((String)".installed_devices_boards_books.xml");
            if (devicesFile != null) {
                devicesFile.delete();
            }
        }
        catch (IOException iOException) {}
        this.fInstalledDevicesMap.clear();
    }

    public Node getInstalledObjectsForBuild() {
        return this.getInstalledObjectsForBuild(new DurationMonitor());
    }

    private Node getInstalledObjectsForBuild(final DurationMonitor dm) {
        if (this.fInstalledObjectsForBuild != null) {
            return this.fInstalledObjectsForBuild;
        }
        assert (dm != null);
        dm.displayTimeAndRun(new Runnable(){

            @Override
            public void run() {
                DataManager.this.fInstalledObjectsForBuild = DataManager.this.loadInstalledObjectsForBuild(dm);
            }
        });
        return this.fInstalledObjectsForBuild;
    }

    private Node loadInstalledObjectsForBuild(DurationMonitor dm) {
        this.fOut.println("Extracting devices & boards... ");
        Node rootNode = null;
        File devicesFile = null;
        try {
            devicesFile = PacksStorage.getCachedFileObject((String)".installed_devices_boards_books.xml");
            if (devicesFile.exists()) {
                rootNode = this.loadCachedInstalledObjectsForBuild(devicesFile);
            }
        }
        catch (IOException iOException) {}
        if (rootNode == null && (rootNode = this.parseInstalledPackagesForBuild(dm)) != null) {
            this.fOut.println("Writing cache file \"" + devicesFile + "\".");
            GenericSerialiser serialiser = new GenericSerialiser();
            try {
                serialiser.serialise(rootNode, devicesFile);
            }
            catch (IOException e) {
                String msg = String.valueOf(e.getMessage()) + ", file: " + devicesFile.getName();
                this.fOut.println("Error: " + msg);
                Utils.reportError(msg);
                Activator.log((Throwable)e);
            }
        }
        if (rootNode == null) {
            rootNode = new Node("root");
            Node emptyNode = Node.addNewChild((Node)rootNode, (String)"none");
            emptyNode.setName("No devices available, install packs first.");
        }
        return rootNode;
    }

    private Node loadCachedInstalledObjectsForBuild(File file) {
        this.fOut.println("Parsing cached file \"" + file.getPath() + "\".");
        Node node = null;
        try {
            Document document = Xml.parseFile((File)file);
            GenericParser parser = new GenericParser();
            node = parser.parse(document);
        }
        catch (Exception e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + file.getName();
            this.fOut.println("Error: " + msg);
            Utils.reportError(msg);
            Activator.log((Throwable)e);
        }
        return node;
    }

    private Node parseInstalledPackagesForBuild(DurationMonitor dm) {
        List<PackNode> versionsList = this.getInstalledPacksLatestVersionsList(dm);
        PdscTreeParserForBuild pdsc = new PdscTreeParserForBuild();
        Node boardsNode = new Node("boards");
        boardsNode.setName("Boards");
        Node devicesNode = new Node("devices");
        devicesNode.setName("Devices");
        int countPackages = 0;
        int totalCountDevices = 0;
        int totalCountBoards = 0;
        for (PackNode node : versionsList) {
            String pdscName = node.getProperty("pdsc.name");
            String version = node.getName();
            Node tree = this.getParsedPdscTree(pdscName, version, dm);
            int countDevices = pdsc.parseDevices(tree, devicesNode);
            totalCountDevices += countDevices;
            int countBoards = pdsc.parseBoards(tree, boardsNode);
            totalCountBoards += countBoards;
            ++countPackages;
        }
        if (countPackages == 0) {
            this.fOut.println("No installed packages.");
        } else {
            if (countPackages == 1) {
                this.fOut.print("Processed 1 package, found ");
            } else {
                this.fOut.print("Processed " + countPackages + " packages, found ");
            }
            if (totalCountDevices == 0) {
                this.fOut.print("no devices, ");
            } else if (totalCountDevices == 1) {
                this.fOut.print("1 device, ");
            } else {
                this.fOut.print(String.valueOf(totalCountDevices) + " devices, ");
            }
            if (totalCountBoards == 0) {
                this.fOut.print("no boards.");
            } else if (totalCountBoards == 1) {
                this.fOut.print("1 board.");
            } else {
                this.fOut.print(String.valueOf(totalCountBoards) + " boards.");
            }
            this.fOut.println();
        }
        if (boardsNode.hasChildren() || devicesNode.hasChildren()) {
            Node rootNode = new Node("root");
            rootNode.addChild((Leaf)boardsNode);
            rootNode.addChild((Leaf)devicesNode);
            return rootNode;
        }
        return null;
    }

    public Leaf findInstalledDevice(String deviceVendorId, String deviceName) {
        return this.findInstalledDevice(deviceVendorId, deviceName, new DurationMonitor());
    }

    private Leaf findInstalledDevice(String deviceVendorId, String deviceName, DurationMonitor dm) {
        String key = this.makeMapKey(deviceVendorId, deviceName);
        if (this.fInstalledDevicesMap.containsKey(key)) {
            return this.fInstalledDevicesMap.get(key);
        }
        Node tree = this.getInstalledObjectsForBuild(dm);
        AbstractTreePreOrderIterator installedDevices = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                return node.isType("device");
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("device") || node.isType("boards");
            }
        };
        installedDevices.setTreeNode((Leaf)tree);
        for (Leaf installedDevice : installedDevices) {
            String installedDeviceName = installedDevice.getName();
            if (!deviceName.equals(installedDeviceName)) continue;
            String installedDeviceVendorId = "";
            Leaf node = installedDevice;
            while (node != null && !node.isType("vendor")) {
                if (node.hasProperty("vendor.id")) {
                    installedDeviceVendorId = node.getProperty("vendor.id");
                    break;
                }
                node = node.getParent();
            }
            if (!deviceVendorId.equals(installedDeviceVendorId)) continue;
            this.fInstalledDevicesMap.put(key, installedDevice);
            return installedDevice;
        }
        this.fInstalledDevicesMap.put(key, null);
        return null;
    }

    public Leaf findInstalledBoard(String boardVendorName, String boardName) {
        return this.findInstalledBoard(boardVendorName, boardName, new DurationMonitor());
    }

    private Leaf findInstalledBoard(String boardVendorName, String boardName, DurationMonitor dm) {
        String key = this.makeMapKey(boardVendorName, boardName);
        if (this.fInstalledBoardsMap.containsKey(key)) {
            return this.fInstalledBoardsMap.get(key);
        }
        Node tree = this.getInstalledObjectsForBuild(dm);
        AbstractTreePreOrderIterator installedBoards = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                return node.isType("board");
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("board") || node.isType("devices");
            }
        };
        installedBoards.setTreeNode((Leaf)tree);
        for (Leaf installedBoard : installedBoards) {
            String installedBoardVendorName;
            String installedBoardName = installedBoard.getName();
            if (!boardName.equals(installedBoardName) || !boardVendorName.equals(installedBoardVendorName = installedBoard.getProperty("vendor.name"))) continue;
            this.fInstalledBoardsMap.put(key, installedBoard);
            return installedBoard;
        }
        this.fInstalledBoardsMap.put(key, null);
        return null;
    }

    public static String collectProperty(Leaf node, String name, String type) {
        while (node != null && !node.isType(type)) {
            if (node.hasProperty(name)) {
                return node.getProperty(name);
            }
            node = node.getParent();
        }
        return "";
    }

    public String getDestinationFolder(Leaf node) {
        return this.getDestinationFolder(node, new DurationMonitor());
    }

    public String getDestinationFolder(Leaf node, DurationMonitor dm) {
        String vendorName = DataManager.collectProperty(node, "pack.vendor", "devices");
        String packName = DataManager.collectProperty(node, "pack.name", "devices");
        String version = DataManager.collectProperty(node, "pack.version", "devices");
        PackNode summaryVersionNode = this.findPackVersion(vendorName, packName, version, dm);
        String destFolder = "";
        if (summaryVersionNode != null) {
            destFolder = summaryVersionNode.getProperty("dest.folder");
        }
        return destFolder;
    }

    public IPath getSVDAbsolutePath(String deviceVendorId, String deviceName) {
        IPath path;
        Leaf installedDeviceNode = this.findInstalledDevice(deviceVendorId, deviceName);
        if (installedDeviceNode == null) {
            return null;
        }
        String svdFile = installedDeviceNode.getPropertyWithParent("svd.file", null);
        if (svdFile == null) {
            return null;
        }
        String destFolder = this.getDestinationFolder(installedDeviceNode);
        try {
            path = PacksStorage.getFolderPath().append(destFolder).append(svdFile);
        }
        catch (IOException iOException) {
            return null;
        }
        return path;
    }

    public Node getCmsisCoreFiles(String deviceName, String compiler) {
        return null;
    }

    public Node getRegisterDetailsForDebug(String deviceName) {
        return null;
    }
}

