/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.xcdl;

import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.PackNode;
import ilg.gnuarmeclipse.packs.data.DocumentParseException;
import ilg.gnuarmeclipse.packs.xcdl.GenericParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ContentParser
extends GenericParser {
    Set<String> fLeafNodes;
    Set<String> fPackNodes = new HashSet<String>();
    String[] fGroupsToIgnore;
    Map<String, String> fReplaceMap;

    public ContentParser() {
        this.fPackNodes.add("package");
        this.fPackNodes.add("version");
        this.fLeafNodes = new HashSet<String>();
        this.fLeafNodes.add("devicefamily");
        this.fLeafNodes.add("board");
        this.fLeafNodes.add("component");
        this.fLeafNodes.add("bundle");
        this.fLeafNodes.add("example");
        this.fLeafNodes.add("keyword");
        this.fGroupsToIgnore = new String[]{"packages", "versions"};
        this.fReplaceMap = new HashMap<String, String>();
        this.fReplaceMap.put("devicefamily", "family");
    }

    @Override
    public String[] getGroupsToIgnore() {
        return this.fGroupsToIgnore;
    }

    @Override
    public Leaf addNewChild(Node parent, String type) {
        Object node = this.fPackNodes.contains(type) ? PackNode.addNewChild((Node)parent, (String)type) : (this.fLeafNodes.contains(type) ? Leaf.addNewChild((Node)parent, (String)type) : Node.addNewChild((Node)parent, (String)type));
        return node;
    }

    @Override
    public Map<String, String> getReplacements() {
        return this.fReplaceMap;
    }

    @Override
    public void checkSchemaVersion(String schemaVersion) throws DocumentParseException {
        if (!"1.1".equals(schemaVersion)) {
            throw new DocumentParseException("Unrecognised schema version " + schemaVersion + ", refresh");
        }
    }
}

