/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.xcdl;

import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.DocumentParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericParser {
    protected MessageConsoleStream fOut = ConsoleStream.getConsoleOut();

    public String[] getGroupsToIgnore() {
        return null;
    }

    public Leaf addNewChild(Node parent, String type) {
        Node node = Node.addNewChild((Node)parent, (String)type);
        return node;
    }

    public Map<String, String> getReplacements() {
        return null;
    }

    public Set<String> getPropertyNames() {
        return null;
    }

    public void checkSchemaVersion(String schemaVersion) throws DocumentParseException {
        if (!"1.1".equals(schemaVersion)) {
            throw new DocumentParseException("Unrecognised schema version " + schemaVersion);
        }
    }

    public Node parse(Document document) throws DocumentParseException {
        Node node = new Node("root");
        Element firstElement = document.getDocumentElement();
        String firstElementName = firstElement.getNodeName();
        if (!"root".equals(firstElementName)) {
            throw new DocumentParseException("Missing <root>, <" + firstElementName + "> encountered");
        }
        String schemaVersion = firstElement.getAttribute("version").trim();
        this.checkSchemaVersion(schemaVersion);
        node.putProperty("schema.version", schemaVersion);
        List childElements = Xml.getChildrenElementsList((Element)firstElement);
        for (Element childElement : childElements) {
            this.processChildrenElements(childElement, (Leaf)node);
        }
        return node;
    }

    private void processChildrenElements(Element el, Leaf parent) {
        String elementName = el.getNodeName();
        if ("description".equals(elementName)) {
            this.processDescriptionElement(el, parent);
        } else if ("properties".equals(elementName)) {
            this.processPropertiesElement(el, parent);
        } else if ("property".equals(elementName)) {
            this.processPropertyElement(el, parent);
        } else if ("nodes".equals(elementName) && parent instanceof Node) {
            this.processNodesElement(el, (Node)parent);
        } else if ("node".equals(elementName) && parent instanceof Node) {
            this.processGenericNode(el, (Node)parent, this.getTypeAttribute(el));
        } else if (parent instanceof Node) {
            Set<String> propertyNames;
            boolean processed = false;
            String[] groupsToIgnore = this.getGroupsToIgnore();
            if (groupsToIgnore != null) {
                int i = 0;
                while (i < groupsToIgnore.length) {
                    if (groupsToIgnore[i].equals(elementName)) {
                        this.processNodesElement(el, (Node)parent);
                        processed = true;
                        break;
                    }
                    ++i;
                }
            }
            if ((propertyNames = this.getPropertyNames()) != null && propertyNames.contains(elementName)) {
                this.processPropertyElement(el, parent);
                processed = true;
            }
            if (!processed) {
                this.processGenericNode(el, (Node)parent, elementName);
            }
        } else {
            Set<String> propertyNames = this.getPropertyNames();
            if (propertyNames != null && propertyNames.contains(elementName)) {
                this.processPropertyElement(el, parent);
            } else {
                this.notProcessed(el);
            }
        }
    }

    private void processDescriptionElement(Element el, Leaf node) {
        String description = Xml.getElementContent((Element)el);
        node.setDescription(description);
    }

    private void processPropertiesElement(Element el, Leaf node) {
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("property".equals(elementName)) {
                this.processPropertyElement(childElement, node);
                continue;
            }
            Set<String> propertyNames = this.getPropertyNames();
            if (propertyNames != null && propertyNames.contains(elementName)) {
                this.processPropertyElement(childElement, node);
                continue;
            }
            this.notProcessed(childElement);
        }
    }

    private void processPropertyElement(Element el, Leaf node) {
        String name = "property".equals(el.getNodeName()) ? this.getNameAttribute(el) : el.getNodeName();
        String value = Xml.getElementContent((Element)el);
        node.putProperty(name, value);
    }

    private String getNameAttribute(Element el) {
        return el.getAttribute("name").trim();
    }

    private String getTypeAttribute(Element el) {
        return el.getAttribute("type").trim();
    }

    private void processNodesElement(Element el, Node node) {
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            String elementName = childElement.getNodeName();
            if ("node".equals(elementName)) {
                this.processGenericNode(childElement, node, this.getTypeAttribute(el));
                continue;
            }
            this.processGenericNode(childElement, node, elementName);
        }
    }

    private void processGenericNode(Element el, Node parent, String type) {
        String actualType = type;
        Map<String, String> replacements = this.getReplacements();
        if (replacements != null && replacements.containsKey(type)) {
            actualType = replacements.get(type);
        }
        Leaf node = this.addNewChild(parent, actualType);
        assert (node != null);
        String name = this.getNameAttribute(el);
        if (name.length() > 0) {
            node.setName(name);
        }
        List childElements = Xml.getChildrenElementsList((Element)el);
        for (Element childElement : childElements) {
            this.processChildrenElements(childElement, node);
        }
    }

    private void notProcessed(Element el) {
        Element parentElement = Xml.getParentElement((Element)el);
        this.fOut.print("Element <" + el.getNodeName() + "> ");
        if (parentElement != null) {
            this.fOut.print(" below <" + parentElement.getNodeName() + "> ");
        }
        this.fOut.println("not processed.");
    }
}

