/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.xcdl;

import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.Activator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

public class GenericSerialiser {
    PrintWriter fWriter = null;
    ElementOptions fDefaultOptions = new ElementOptions();

    public String getSchemaVersion() {
        return "1.1";
    }

    public ElementOptions getElementOptions(String type) {
        return null;
    }

    public Set<String> getPropertyNames() {
        return null;
    }

    public void serialise(Node tree, File file) throws IOException {
        file.getParentFile().mkdir();
        if (!file.exists()) {
            file.createNewFile();
        }
        if (file.exists()) {
            this.serialise(tree, new PrintWriter(file, "UTF-8"));
        }
    }

    public void serialise(Node tree, PrintWriter writer) throws IOException {
        if (writer != null) {
            this.fWriter = writer;
            this.fWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fWriter.println();
            this.fWriter.println("<root version=\"" + this.getSchemaVersion() + "\">");
            if (tree.isType("root") && tree.hasChildren()) {
                for (Leaf child : tree.getChildren()) {
                    this.serialiseRecursive(child, 0);
                }
            } else {
                this.serialiseRecursive((Leaf)tree, 0);
            }
            this.fWriter.println("</root>");
            this.fWriter.close();
        }
    }

    private void serialiseRecursive(Leaf node, int depth) {
        String nodeName;
        this.putIndentation(depth);
        String nodeType = node.getType();
        ElementOptions eo = this.getElementOptions(nodeType);
        if (eo == null) {
            eo = this.fDefaultOptions;
        }
        if (eo.fNodeElementName.length() > 0) {
            this.fWriter.print("<" + eo.fNodeElementName);
        } else {
            this.fWriter.print("<node type=\"" + nodeType + "\"");
        }
        if (eo.fDoOutputName && ((nodeName = node.getName()).length() > 0 || !eo.fIsNameOptional)) {
            this.fWriter.print(" name=\"" + node.getName() + "\"");
        }
        if (eo.fHasNoChildrenElements) {
            this.fWriter.println(" />");
        } else {
            int newDepth;
            this.fWriter.println(">");
            String description = node.getDescription();
            if (description != null && description.length() > 0) {
                this.putIndentation(depth + 1);
                this.fWriter.println("<description>" + Xml.xmlEscape((String)node.getDescription()) + "</description>");
            }
            if (node.hasRelevantProperties()) {
                if (eo.fDoOutputProperties) {
                    this.putIndentation(depth + 1);
                    this.fWriter.println("<properties>");
                }
                newDepth = eo.fDoOutputProperties ? depth + 2 : depth + 1;
                Map properties = node.getProperties();
                for (Object key : properties.keySet()) {
                    if ("NAME".equals(key) || "DESC".equals(key)) continue;
                    this.putIndentation(newDepth);
                    String propertyName = key.toString();
                    Set<String> propertyNames = this.getPropertyNames();
                    if (propertyNames != null && propertyNames.contains(propertyName)) {
                        this.fWriter.println("<" + propertyName + ">" + Xml.xmlEscape((String)((String)properties.get(key)).toString()) + "</" + propertyName + ">");
                        continue;
                    }
                    this.fWriter.println("<property name=\"" + propertyName + "\">" + Xml.xmlEscape((String)((String)properties.get(key)).toString()) + "</property>");
                }
                if (eo.fDoOutputProperties) {
                    this.putIndentation(depth + 1);
                    this.fWriter.println("</properties>");
                }
            }
            if (node.hasChildren()) {
                if (eo.doIgnoreChildren) {
                    Activator.log((String)("Ignoring children of " + node));
                } else {
                    if (eo.fDoOutputNodes) {
                        this.putIndentation(depth + 1);
                        if (eo.fNodesElementName.length() > 0) {
                            this.fWriter.println("<" + eo.fNodesElementName + ">");
                        } else {
                            this.fWriter.println("<nodes>");
                        }
                    }
                    newDepth = eo.fDoOutputNodes ? depth + 2 : depth + 1;
                    for (Leaf child : ((Node)node).getChildren()) {
                        this.serialiseRecursive(child, newDepth);
                    }
                    if (eo.fDoOutputNodes) {
                        this.putIndentation(depth + 1);
                        if (eo.fNodesElementName.length() > 0) {
                            this.fWriter.println("</" + eo.fNodesElementName + ">");
                        } else {
                            this.fWriter.println("</nodes>");
                        }
                    }
                }
            }
            this.putIndentation(depth);
            if (eo.fNodeElementName.length() > 0) {
                this.fWriter.println("</" + eo.fNodeElementName + ">");
            } else {
                this.fWriter.println("</node>");
            }
        }
    }

    private void putIndentation(int depth) {
        ++depth;
        int i = 0;
        while (i < depth) {
            this.fWriter.print("  ");
            ++i;
        }
    }

    protected class ElementOptions {
        public String fNodeElementName = "";
        public String fNodesElementName = "";
        public boolean fDoOutputNodes = false;
        public boolean fDoOutputName = true;
        public boolean fIsNameOptional = true;
        public boolean fDoOutputProperties = false;
        public boolean fHasNoChildrenElements = false;
        public boolean doIgnoreChildren = false;
    }
}

