/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupParticipant;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBSourceLookup;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

@ThreadSafe
public class GdbSourceLookupParticipant
extends DsfSourceLookupParticipant {
    private DsfExecutor fExecutor;
    private String fSessionId;
    private DsfServicesTracker fServicesTracker;

    public GdbSourceLookupParticipant(DsfSession session) {
        super(session);
        this.fSessionId = session.getId();
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSessionId);
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
    }

    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    public void sourceContainersChanged(final ISourceLookupDirector director) {
        super.sourceContainersChanged(director);
        if (this.fExecutor.isInExecutorThread()) {
            this.sourceContainersChangedOnDispatchThread(director, new RequestMonitor((Executor)this.fExecutor, null));
        } else {
            Query<Object> query = new Query<Object>(){

                protected void execute(DataRequestMonitor<Object> rm) {
                    GdbSourceLookupParticipant.this.sourceContainersChangedOnDispatchThread(director, (RequestMonitor)rm);
                }
            };
            this.fExecutor.execute((Runnable)query);
            try {
                query.get(5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                GdbPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "There was a timeout completing the operation. This is probably due to terminating two launches at the same time. Please consider terminating one launch at a time to avoid the UI lockup. See Bug 494650 for details.", (Throwable)e));
            }
            catch (InterruptedException | ExecutionException e) {
                GdbPlugin.log(e);
            }
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void sourceContainersChangedOnDispatchThread(ISourceLookupDirector director, RequestMonitor rm) {
        IGDBSourceLookup lookup = (IGDBSourceLookup)this.fServicesTracker.getService(IGDBSourceLookup.class);
        if (lookup != null) {
            ICommandControlService command = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
            ISourceLookup.ISourceLookupDMContext context = (ISourceLookup.ISourceLookupDMContext)command.getContext();
            lookup.sourceContainersChanged(context, new DataRequestMonitor<Boolean>((Executor)this.fExecutor, rm){

                protected void handleCompleted() {
                    IStack stackService;
                    if (this.isSuccess() && ((Boolean)this.getData()).booleanValue() && (stackService = (IStack)GdbSourceLookupParticipant.this.fServicesTracker.getService(IStack.class)) instanceof ICachingService) {
                        ICachingService cachingStackService = (ICachingService)stackService;
                        cachingStackService.flushCache(null);
                    }
                    super.handleCompleted();
                }
            });
        } else {
            rm.done();
        }
    }
}

