/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractconstant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ClassMemberInserter;
import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantInfo;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractConstantRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.ui.refactoring.extractconstant.ExtractConstantRefactoring";
    private IASTLiteralExpression target;
    private final ExtractConstantInfo info;
    private final ArrayList<IASTExpression> literalsToReplace = new ArrayList();

    public ExtractConstantRefactoring(ICElement element, ISelection selection, ICProject project) {
        super(element, selection, project);
        this.info = new ExtractConstantInfo();
        this.name = Messages.ExtractConstantRefactoring_ExtractConst;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            boolean oneMarked;
            RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(8));
            if (status.hasError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            Collection<IASTLiteralExpression> literalExpressionCollection = this.findAllLiterals((IProgressMonitor)sm.newChild(1));
            if (literalExpressionCollection.isEmpty()) {
                this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_LiteralMustBeSelected);
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            boolean bl = oneMarked = this.selectedRegion != null && this.isOneMarked(literalExpressionCollection, this.selectedRegion);
            if (!oneMarked) {
                if (this.target == null) {
                    this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_NoLiteralSelected);
                } else {
                    this.initStatus.addFatalError(Messages.ExtractConstantRefactoring_TooManyLiteralSelected);
                }
                RefactoringStatus refactoringStatus = this.initStatus;
                return refactoringStatus;
            }
            this.findAllNodesForReplacement(literalExpressionCollection);
            this.info.addNamesToUsedNames(this.findAllDeclaredNames());
            if (this.info.getName().isEmpty()) {
                this.info.setName(this.getDefaultName(this.target));
            }
            this.info.setMethodContext(NodeHelper.findMethodContext((IASTNode)this.target, this.refactoringContext, (IProgressMonitor)sm.newChild(1)));
            RefactoringStatus refactoringStatus = this.initStatus;
            return refactoringStatus;
        }
        finally {
            sm.done();
        }
    }

    private String getDefaultName(IASTLiteralExpression literal) {
        String nameString = literal.toString();
        switch (literal.getKind()) {
            case 2: 
            case 3: {
                int len;
                int beginIndex = 1;
                if (nameString.startsWith("L")) {
                    beginIndex = 2;
                }
                if (beginIndex >= (len = nameString.length()) || len <= 0) break;
                nameString = nameString.substring(beginIndex, len - 1);
                break;
            }
        }
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.constant.capitalization", 1, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.wordDelimiter", "_", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.constant.suffix", "", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return composer.compose(nameString);
    }

    private ArrayList<String> findAllDeclaredNames() {
        ArrayList<String> names = new ArrayList<String>();
        IASTFunctionDefinition funcDef = (IASTFunctionDefinition)ASTQueries.findAncestorWithType((IASTNode)this.target, IASTFunctionDefinition.class);
        ICPPASTCompositeTypeSpecifier comTypeSpec = this.getCompositeTypeSpecifier(funcDef);
        if (comTypeSpec != null) {
            IASTDeclaration[] iASTDeclarationArray = comTypeSpec.getMembers();
            int n = iASTDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration dec = iASTDeclarationArray[n2];
                if (dec instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpDec = (IASTSimpleDeclaration)dec;
                    IASTDeclarator[] iASTDeclaratorArray = simpDec.getDeclarators();
                    int n3 = iASTDeclaratorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator decor = iASTDeclaratorArray[n4];
                        names.add(decor.getName().getRawSignature());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return names;
    }

    private ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTFunctionDefinition funcDef) {
        CPPMethod methode;
        IASTDeclarator[] declarations;
        Object decl;
        IASTNode spec;
        IBinding binding;
        if (funcDef != null && (binding = funcDef.getDeclarator().getName().resolveBinding()) instanceof CPPMethod && (spec = (decl = (declarations = (methode = (CPPMethod)binding).getDeclarations()) != null ? declarations[0] : methode.getDefinition()).getParent().getParent()) instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)spec;
            return compTypeSpec;
        }
        return null;
    }

    private void findAllNodesForReplacement(Collection<IASTLiteralExpression> literalExpressionCollection) {
        if (this.target.getParent() instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)this.target.getParent();
            for (IASTLiteralExpression expression : literalExpressionCollection) {
                if (this.target.getKind() != expression.getKind() || !this.target.toString().equals(expression.toString()) || !(expression.getParent() instanceof IASTUnaryExpression) || unary.getOperator() != ((IASTUnaryExpression)expression.getParent()).getOperator()) continue;
                this.literalsToReplace.add((IASTExpression)((IASTUnaryExpression)expression.getParent()));
            }
        } else {
            for (IASTLiteralExpression expression : literalExpressionCollection) {
                if (this.target.getKind() != expression.getKind() || !this.target.toString().equals(expression.toString())) continue;
                this.literalsToReplace.add((IASTExpression)expression);
            }
        }
    }

    private boolean isOneMarked(Collection<IASTLiteralExpression> selectedNodes, Region textSelection) {
        boolean oneMarked = false;
        for (IASTLiteralExpression expression : selectedNodes) {
            if (!expression.isPartOfTranslationUnitFile() || !ExtractConstantRefactoring.isExpressionInSelection((IASTExpression)expression, textSelection)) continue;
            if (this.target == null) {
                this.target = expression;
                oneMarked = true;
                continue;
            }
            if (this.isTargetChild((IASTExpression)expression)) continue;
            oneMarked = false;
        }
        return oneMarked;
    }

    private static boolean isExpressionInSelection(IASTExpression expression, Region selection) {
        IASTFileLocation location = expression.getFileLocation();
        int expressionStart = location.getNodeOffset();
        int expressionEnd = expressionStart + location.getNodeLength();
        int selectionStart = selection.getOffset();
        int selectionEnd = selectionStart + selection.getLength();
        return expressionStart >= selectionStart && expressionEnd <= selectionEnd;
    }

    private boolean isTargetChild(IASTExpression child) {
        if (this.target == null) {
            return false;
        }
        IASTExpression node = child;
        while (node != null) {
            if (node.getParent() == this.target) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private Collection<IASTLiteralExpression> findAllLiterals(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        final ArrayList<IASTLiteralExpression> result = new ArrayList<IASTLiteralExpression>();
        IASTTranslationUnit ast = this.getAST(this.tu, pm);
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (expression instanceof IASTLiteralExpression && (expression.getNodeLocations().length != 1 || !(expression.getNodeLocations()[0] instanceof IASTMacroExpansionLocation))) {
                    IASTLiteralExpression literal = (IASTLiteralExpression)expression;
                    result.add(literal);
                }
                return super.visit(expression);
            }
        });
        return result;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        MethodContext context = this.info.getMethodContext();
        ArrayList<IASTExpression> locLiteralsToReplace = new ArrayList<IASTExpression>();
        IASTTranslationUnit ast = this.getAST(this.tu, (IProgressMonitor)progress.newChild(9));
        if (context.getType() == MethodContext.ContextType.METHOD) {
            SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(this.literalsToReplace.size());
            for (IASTExpression expression : this.literalsToReplace) {
                MethodContext exprContext = NodeHelper.findMethodContext((IASTNode)expression, this.refactoringContext, (IProgressMonitor)loopProgress.newChild(1));
                if (exprContext.getType() != MethodContext.ContextType.METHOD) continue;
                if (context.getMethodQName() != null) {
                    if (!MethodContext.isSameClass(exprContext.getMethodQName(), context.getMethodQName())) continue;
                    locLiteralsToReplace.add(expression);
                    continue;
                }
                if (!MethodContext.isSameClass(exprContext.getMethodDeclarationName(), context.getMethodDeclarationName())) continue;
                locLiteralsToReplace.add(expression);
            }
        } else {
            for (IASTExpression expression : this.literalsToReplace) {
                ITranslationUnit expressionTu = expression.getTranslationUnit().getOriginatingTranslationUnit();
                if (expressionTu.getResource() == null) continue;
                locLiteralsToReplace.add(expression);
            }
        }
        String constName = this.info.getName();
        this.createLiteralToConstantChanges(constName, locLiteralsToReplace, collector);
        if (context.getType() == MethodContext.ContextType.METHOD) {
            ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)context.getMethodDeclaration().getParent();
            ClassMemberInserter.createChange(classDefinition, this.info.getVisibility(), (IASTNode)this.getConstNodesClass(constName), true, collector);
        } else {
            IASTDeclaration nodes = this.getConstNodesGlobal(constName, ast.getASTNodeFactory());
            ASTRewrite rewriter = collector.rewriterForTranslationUnit(ast);
            rewriter.insertBefore((IASTNode)ast, ExtractConstantRefactoring.getFirstNode(ast), (IASTNode)nodes, new TextEditGroup(Messages.ExtractConstantRefactoring_CreateConstant));
        }
    }

    private static IASTNode getFirstNode(IASTTranslationUnit ast) {
        IASTDeclaration firstNode = null;
        IASTDeclaration[] iASTDeclarationArray = ast.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration each = iASTDeclarationArray[n2];
            if (firstNode == null) {
                firstNode = each;
            } else if (each.getNodeLocations() != null && each.getNodeLocations()[0].getNodeOffset() < firstNode.getNodeLocations()[0].getNodeOffset()) {
                firstNode = each;
            }
            ++n2;
        }
        return firstNode;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractConstantRefactoringDescriptor desc = new ExtractConstantRefactoringDescriptor(this.project.getProject().getName(), "Extract Constant Refactoring", "Create constant for " + this.target.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.tu.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.selectedRegion.getOffset()) + "," + this.selectedRegion.getLength());
        arguments.put("name", this.info.getName());
        arguments.put("visibility", this.info.getVisibility().toString());
        return arguments;
    }

    private void createLiteralToConstantChanges(String constName, Iterable<? extends IASTExpression> literals, ModificationCollector collector) {
        for (IASTExpression iASTExpression : literals) {
            ASTRewrite rewrite = collector.rewriterForTranslationUnit(iASTExpression.getTranslationUnit());
            CPPASTIdExpression idExpression = new CPPASTIdExpression((IASTName)new CPPASTName(constName.toCharArray()));
            rewrite.replace((IASTNode)iASTExpression, (IASTNode)idExpression, new TextEditGroup(Messages.ExtractConstantRefactoring_ReplaceLiteral));
        }
    }

    private IASTSimpleDeclaration getConstNodes(String newName) {
        ICPPNodeFactory factory = ASTNodeFactoryFactory.getDefaultCPPNodeFactory();
        DeclarationGenerator generator = DeclarationGenerator.create((INodeFactory)factory);
        IType type = this.target.getExpressionType();
        IASTDeclSpecifier declSpec = generator.createDeclSpecFromType(type);
        declSpec.setConst(true);
        IASTDeclarator declarator = generator.createDeclaratorFromType(type, newName.toCharArray());
        CPPASTSimpleDeclaration simple = new CPPASTSimpleDeclaration();
        simple.setDeclSpecifier(declSpec);
        CPPASTEqualsInitializer init = new CPPASTEqualsInitializer();
        if (this.target.getParent() instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)this.target.getParent();
            init.setInitializerClause((IASTInitializerClause)unary);
        } else {
            CPPASTLiteralExpression expression = new CPPASTLiteralExpression(this.target.getKind(), this.target.getValue());
            init.setInitializerClause((IASTInitializerClause)expression);
        }
        declarator.setInitializer((IASTInitializer)init);
        simple.addDeclarator(declarator);
        return simple;
    }

    private IASTDeclaration getConstNodesGlobal(String newName, INodeFactory nodeFactory) {
        IASTSimpleDeclaration simple = this.getConstNodes(newName);
        if (nodeFactory instanceof ICPPNodeFactory) {
            ICPPASTNamespaceDefinition namespace = ((ICPPNodeFactory)nodeFactory).newNamespaceDefinition((IASTName)new CPPASTName());
            namespace.addDeclaration((IASTDeclaration)simple);
            return namespace;
        }
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }

    private IASTDeclaration getConstNodesClass(String newName) {
        IASTSimpleDeclaration simple = this.getConstNodes(newName);
        simple.getDeclSpecifier().setStorageClass(3);
        return simple;
    }

    public ExtractConstantInfo getRefactoringInfo() {
        return this.info;
    }
}

